/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.locale;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.services.locale.LocaleDataSource;
import org.javarosa.core.util.OrderedMap;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapMap;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class TableLocaleSource
implements LocaleDataSource {
    private OrderedMap<String, String> localeData;

    public TableLocaleSource() {
        this.localeData = new OrderedMap();
    }

    public TableLocaleSource(OrderedMap<String, String> localeData) {
        this.localeData = localeData;
    }

    public void setLocaleMapping(String textID, String text) {
        if (textID == null) {
            throw new NullPointerException("Null textID when attempting to register " + text + " in locale table");
        }
        if (text == null) {
            this.localeData.remove(textID);
        } else {
            this.localeData.put(textID, text);
        }
    }

    public boolean hasMapping(String textID) {
        return textID == null ? false : this.localeData.get(textID) != null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TableLocaleSource)) {
            return false;
        }
        TableLocaleSource l = (TableLocaleSource)o;
        return ExtUtil.equals(this.localeData, l.localeData);
    }

    @Override
    public OrderedMap<String, String> getLocalizedText() {
        return this.localeData;
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.localeData = (OrderedMap)ExtUtil.read(in, new ExtWrapMap(String.class, String.class, 1), pf);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.write(out, new ExtWrapMap(this.localeData));
    }
}

