/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.locale;

import java.util.HashMap;
import org.javarosa.core.reference.ReferenceDataSource;
import org.javarosa.core.services.locale.LocaleTextException;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.core.services.locale.ResourceFileDataSource;

public class Localization {
    private static Localizer globalLocalizer;

    public static String get(String key) {
        return Localization.get(key, new String[0]);
    }

    public static String get(String key, String[] args) {
        Localization.checkRep();
        return globalLocalizer.getText(key, args);
    }

    public static String get(String key, HashMap<String, String> args) {
        Localization.checkRep();
        return globalLocalizer.getText(key, args);
    }

    public static void registerLanguageFile(String localeName, String resourceFileURI) {
        Localization.init(false);
        if (!globalLocalizer.hasLocale(localeName)) {
            globalLocalizer.addAvailableLocale(localeName);
        }
        globalLocalizer.registerLocaleResource(localeName, new ResourceFileDataSource(resourceFileURI));
        if (globalLocalizer.getDefaultLocale() == null) {
            globalLocalizer.setDefaultLocale(localeName);
        }
    }

    public static void registerLanguageReference(String localeName, String referenceUri) {
        Localization.init(false);
        if (!globalLocalizer.hasLocale(localeName)) {
            globalLocalizer.addAvailableLocale(localeName);
        }
        globalLocalizer.registerLocaleResource(localeName, new ReferenceDataSource(referenceUri));
        if (globalLocalizer.getDefaultLocale() == null) {
            globalLocalizer.setDefaultLocale(localeName);
        }
    }

    public static Localizer getGlobalLocalizerAdvanced() {
        Localization.init(false);
        return globalLocalizer;
    }

    public static void setLocale(String locale) {
        Localization.checkRep();
        globalLocalizer.setLocale(locale);
    }

    public static void setDefaultLocale(String defaultLocale) {
        Localization.checkRep();
        globalLocalizer.setDefaultLocale(defaultLocale);
    }

    public static void init(boolean force) {
        if (globalLocalizer == null || force) {
            globalLocalizer = new Localizer(true, true);
        }
    }

    public static void setLocalizationData(Localizer localizer) {
        globalLocalizer = localizer;
    }

    private static void checkRep() {
        Localization.init(false);
        if (globalLocalizer.getAvailableLocales().length == 0) {
            throw new LocaleTextException("There are no locales defined for the application. Please make sure to register locale text using the Locale.register() method");
        }
    }
}

