/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapMap;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class SubmissionProfile
implements Externalizable {
    IDataReference ref;
    String method;
    String action;
    String mediaType;
    HashMap<String, String> attributeMap;

    public SubmissionProfile() {
    }

    public SubmissionProfile(IDataReference ref, String method, String action, String mediatype) {
        this(ref, method, action, mediatype, new HashMap<String, String>());
    }

    public SubmissionProfile(IDataReference ref, String method, String action, String mediatype, HashMap<String, String> attributeMap) {
        this.method = method;
        this.ref = ref;
        this.action = action;
        this.mediaType = mediatype;
        this.attributeMap = attributeMap;
    }

    public IDataReference getRef() {
        return this.ref;
    }

    public String getMethod() {
        return this.method;
    }

    public String getAction() {
        return this.action;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.ref = (IDataReference)ExtUtil.read(in, new ExtWrapTagged(IDataReference.class));
        this.method = ExtUtil.nullIfEmpty(ExtUtil.readString(in));
        this.action = ExtUtil.nullIfEmpty(ExtUtil.readString(in));
        this.mediaType = ExtUtil.nullIfEmpty(ExtUtil.readString(in));
        this.attributeMap = (HashMap)ExtUtil.read(in, new ExtWrapMap(String.class, String.class));
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.write(out, new ExtWrapTagged(this.ref));
        ExtUtil.writeString(out, ExtUtil.emptyIfNull(this.method));
        ExtUtil.writeString(out, ExtUtil.emptyIfNull(this.action));
        ExtUtil.writeString(out, ExtUtil.emptyIfNull(this.mediaType));
        ExtUtil.write(out, new ExtWrapMap(this.attributeMap));
    }
}

