/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.javarosa.core.model.DataType;
import org.javarosa.core.model.data.BooleanData;
import org.javarosa.core.model.data.DateData;
import org.javarosa.core.model.data.DateTimeData;
import org.javarosa.core.model.data.DecimalData;
import org.javarosa.core.model.data.GeoPointData;
import org.javarosa.core.model.data.GeoShapeData;
import org.javarosa.core.model.data.GeoTraceData;
import org.javarosa.core.model.data.IntegerData;
import org.javarosa.core.model.data.LongData;
import org.javarosa.core.model.data.SelectMultiData;
import org.javarosa.core.model.data.SelectOneData;
import org.javarosa.core.model.data.StringData;
import org.javarosa.core.model.data.TimeData;

public class DataTypeClasses {
    private static final Object[][] typesAndClasses = new Object[][]{{DataType.NULL, StringData.class}, {DataType.TEXT, StringData.class}, {DataType.INTEGER, IntegerData.class}, {DataType.LONG, LongData.class}, {DataType.DECIMAL, DecimalData.class}, {DataType.BOOLEAN, BooleanData.class}, {DataType.DATE, DateData.class}, {DataType.TIME, TimeData.class}, {DataType.DATE_TIME, DateTimeData.class}, {DataType.CHOICE, SelectOneData.class}, {DataType.MULTIPLE_ITEMS, SelectMultiData.class}, {DataType.GEOPOINT, GeoPointData.class}, {DataType.GEOSHAPE, GeoShapeData.class}, {DataType.GEOTRACE, GeoTraceData.class}};
    private static final Map<DataType, Class> classesByType = DataTypeClasses.createMap();

    public static Class classForType(DataType dataType) {
        return classesByType.get((Object)dataType);
    }

    private static Map<DataType, Class> createMap() {
        HashMap<DataType, Class> m = new HashMap<DataType, Class>();
        for (Object[] typeAndClass : typesAndClasses) {
            m.put((DataType)((Object)typeAndClass[0]), (Class)typeAndClass[1]);
        }
        return Collections.unmodifiableMap(m);
    }
}

