# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = ['StudioSessionMappingArgs', 'StudioSessionMapping']

@pulumi.input_type
class StudioSessionMappingArgs:
    def __init__(__self__, *,
                 identity_name: pulumi.Input[str],
                 identity_type: pulumi.Input['StudioSessionMappingIdentityType'],
                 session_policy_arn: pulumi.Input[str],
                 studio_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a StudioSessionMapping resource.
        :param pulumi.Input[str] identity_name: The name of the user or group. For more information, see UserName and DisplayName in the AWS SSO Identity Store API Reference. Either IdentityName or IdentityId must be specified.
        :param pulumi.Input['StudioSessionMappingIdentityType'] identity_type: Specifies whether the identity to map to the Studio is a user or a group.
        :param pulumi.Input[str] session_policy_arn: The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. Session policies refine Studio user permissions without the need to use multiple IAM user roles.
        :param pulumi.Input[str] studio_id: The ID of the Amazon EMR Studio to which the user or group will be mapped.
        """
        pulumi.set(__self__, "identity_name", identity_name)
        pulumi.set(__self__, "identity_type", identity_type)
        pulumi.set(__self__, "session_policy_arn", session_policy_arn)
        pulumi.set(__self__, "studio_id", studio_id)

    @property
    @pulumi.getter(name="identityName")
    def identity_name(self) -> pulumi.Input[str]:
        """
        The name of the user or group. For more information, see UserName and DisplayName in the AWS SSO Identity Store API Reference. Either IdentityName or IdentityId must be specified.
        """
        return pulumi.get(self, "identity_name")

    @identity_name.setter
    def identity_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "identity_name", value)

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> pulumi.Input['StudioSessionMappingIdentityType']:
        """
        Specifies whether the identity to map to the Studio is a user or a group.
        """
        return pulumi.get(self, "identity_type")

    @identity_type.setter
    def identity_type(self, value: pulumi.Input['StudioSessionMappingIdentityType']):
        pulumi.set(self, "identity_type", value)

    @property
    @pulumi.getter(name="sessionPolicyArn")
    def session_policy_arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. Session policies refine Studio user permissions without the need to use multiple IAM user roles.
        """
        return pulumi.get(self, "session_policy_arn")

    @session_policy_arn.setter
    def session_policy_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "session_policy_arn", value)

    @property
    @pulumi.getter(name="studioId")
    def studio_id(self) -> pulumi.Input[str]:
        """
        The ID of the Amazon EMR Studio to which the user or group will be mapped.
        """
        return pulumi.get(self, "studio_id")

    @studio_id.setter
    def studio_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "studio_id", value)


class StudioSessionMapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity_name: Optional[pulumi.Input[str]] = None,
                 identity_type: Optional[pulumi.Input['StudioSessionMappingIdentityType']] = None,
                 session_policy_arn: Optional[pulumi.Input[str]] = None,
                 studio_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        An example resource schema demonstrating some basic constructs and validation rules.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] identity_name: The name of the user or group. For more information, see UserName and DisplayName in the AWS SSO Identity Store API Reference. Either IdentityName or IdentityId must be specified.
        :param pulumi.Input['StudioSessionMappingIdentityType'] identity_type: Specifies whether the identity to map to the Studio is a user or a group.
        :param pulumi.Input[str] session_policy_arn: The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. Session policies refine Studio user permissions without the need to use multiple IAM user roles.
        :param pulumi.Input[str] studio_id: The ID of the Amazon EMR Studio to which the user or group will be mapped.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StudioSessionMappingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An example resource schema demonstrating some basic constructs and validation rules.

        :param str resource_name: The name of the resource.
        :param StudioSessionMappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StudioSessionMappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity_name: Optional[pulumi.Input[str]] = None,
                 identity_type: Optional[pulumi.Input['StudioSessionMappingIdentityType']] = None,
                 session_policy_arn: Optional[pulumi.Input[str]] = None,
                 studio_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StudioSessionMappingArgs.__new__(StudioSessionMappingArgs)

            if identity_name is None and not opts.urn:
                raise TypeError("Missing required property 'identity_name'")
            __props__.__dict__["identity_name"] = identity_name
            if identity_type is None and not opts.urn:
                raise TypeError("Missing required property 'identity_type'")
            __props__.__dict__["identity_type"] = identity_type
            if session_policy_arn is None and not opts.urn:
                raise TypeError("Missing required property 'session_policy_arn'")
            __props__.__dict__["session_policy_arn"] = session_policy_arn
            if studio_id is None and not opts.urn:
                raise TypeError("Missing required property 'studio_id'")
            __props__.__dict__["studio_id"] = studio_id
        super(StudioSessionMapping, __self__).__init__(
            'aws-native:emr:StudioSessionMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'StudioSessionMapping':
        """
        Get an existing StudioSessionMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = StudioSessionMappingArgs.__new__(StudioSessionMappingArgs)

        __props__.__dict__["identity_name"] = None
        __props__.__dict__["identity_type"] = None
        __props__.__dict__["session_policy_arn"] = None
        __props__.__dict__["studio_id"] = None
        return StudioSessionMapping(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="identityName")
    def identity_name(self) -> pulumi.Output[str]:
        """
        The name of the user or group. For more information, see UserName and DisplayName in the AWS SSO Identity Store API Reference. Either IdentityName or IdentityId must be specified.
        """
        return pulumi.get(self, "identity_name")

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> pulumi.Output['StudioSessionMappingIdentityType']:
        """
        Specifies whether the identity to map to the Studio is a user or a group.
        """
        return pulumi.get(self, "identity_type")

    @property
    @pulumi.getter(name="sessionPolicyArn")
    def session_policy_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. Session policies refine Studio user permissions without the need to use multiple IAM user roles.
        """
        return pulumi.get(self, "session_policy_arn")

    @property
    @pulumi.getter(name="studioId")
    def studio_id(self) -> pulumi.Output[str]:
        """
        The ID of the Amazon EMR Studio to which the user or group will be mapped.
        """
        return pulumi.get(self, "studio_id")

