import { HttpRouteAuthorizerBindOptions, HttpRouteAuthorizerConfig, IHttpRouteAuthorizer } from '@aws-cdk/aws-apigatewayv2-alpha';
import { IUserPool, IUserPoolClient } from 'aws-cdk-lib/aws-cognito';
/**
 * (experimental) Properties to initialize HttpUserPoolAuthorizer.
 *
 * @experimental
 */
export interface HttpUserPoolAuthorizerProps {
    /**
     * (experimental) The user pool clients that should be used to authorize requests with the user pool.
     *
     * @default - a new client will be created for the given user pool
     * @experimental
     */
    readonly userPoolClients?: IUserPoolClient[];
    /**
     * (experimental) The AWS region in which the user pool is present.
     *
     * @default - same region as the Route the authorizer is attached to.
     * @experimental
     */
    readonly userPoolRegion?: string;
    /**
     * (experimental) Friendly name of the authorizer.
     *
     * @default - same value as `id` passed in the constructor
     * @experimental
     */
    readonly authorizerName?: string;
    /**
     * (experimental) The identity source for which authorization is requested.
     *
     * @default ['$request.header.Authorization']
     * @experimental
     */
    readonly identitySource?: string[];
}
/**
 * (experimental) Authorize Http Api routes on whether the requester is registered as part of an AWS Cognito user pool.
 *
 * @experimental
 */
export declare class HttpUserPoolAuthorizer implements IHttpRouteAuthorizer {
    private readonly id;
    private readonly pool;
    private readonly props;
    private authorizer?;
    /**
     * (experimental) Initialize a Cognito user pool authorizer to be bound with HTTP route.
     *
     * @param id The id of the underlying construct.
     * @param pool The user pool to use for authorization.
     * @param props Properties to configure the authorizer.
     * @experimental
     */
    constructor(id: string, pool: IUserPool, props?: HttpUserPoolAuthorizerProps);
    /**
     * (experimental) (experimental) Bind this authorizer to a specified Http route.
     *
     * @experimental
     */
    bind(options: HttpRouteAuthorizerBindOptions): HttpRouteAuthorizerConfig;
}
