#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['yaqc_cmds',
 'yaqc_cmds.autonomic',
 'yaqc_cmds.hardware',
 'yaqc_cmds.project',
 'yaqc_cmds.project.slack',
 'yaqc_cmds.sensors',
 'yaqc_cmds.somatic',
 'yaqc_cmds.somatic.order']

package_data = \
{'': ['*'],
 'yaqc_cmds.project': ['widget files/*'],
 'yaqc_cmds.somatic': ['modules/*']}

install_requires = \
['appdirs',
 'attune',
 'click',
 'numexpr',
 'pyqtgraph',
 'pyside2',
 'pyserial',
 'qtpy',
 'slackclient<2',
 'slacker',
 'sympy',
 'toml',
 'wrighttools',
 'yaqc']

entry_points = \
{'console_scripts': ['yaqc-cmds = yaqc_cmds.__main__:main']}

setup(name='yaqc-cmds',
      version='2021.7.0',
      description='Unified software for controlling hardware and collecting data in the Wright group.',
      author='Blaise Thompson',
      author_email='blaise@untzag.com',
      url='https://github.com/wright-group/yaqc-cmds',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      entry_points=entry_points,
      python_requires='>=3.7',
     )
