# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetZoneResult',
    'AwaitableGetZoneResult',
    'get_zone',
    'get_zone_output',
]

@pulumi.output_type
class GetZoneResult:
    """
    A collection of values returned by getZone.
    """
    def __init__(__self__, description=None, dns_servers=None, id=None, name=None, region_id=None, region_name=None, zone_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dns_servers and not isinstance(dns_servers, list):
            raise TypeError("Expected argument 'dns_servers' to be a list")
        pulumi.set(__self__, "dns_servers", dns_servers)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region_id and not isinstance(region_id, str):
            raise TypeError("Expected argument 'region_id' to be a str")
        pulumi.set(__self__, "region_id", region_id)
        if region_name and not isinstance(region_name, str):
            raise TypeError("Expected argument 'region_name' to be a str")
        pulumi.set(__self__, "region_name", region_name)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the zone.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Sequence[str]:
        """
        A list of IP address of DNS server in the zone.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        The id of the region that the zone belongs.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> str:
        """
        The name of the region that the zone belongs.
        """
        return pulumi.get(self, "region_name")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The id of the zone.
        """
        return pulumi.get(self, "zone_id")


class AwaitableGetZoneResult(GetZoneResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetZoneResult(
            description=self.description,
            dns_servers=self.dns_servers,
            id=self.id,
            name=self.name,
            region_id=self.region_id,
            region_name=self.region_name,
            zone_id=self.zone_id)


def get_zone(name: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetZoneResult:
    """
    Get information about an existing Zone.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    current = sakuracloud.get_zone()
    is1a = sakuracloud.get_zone(name="is1a")
    ```


    :param str name: The name of the zone (e.g. `is1a`,`tk1a`).
    """
    __args__ = dict()
    __args__['name'] = name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('sakuracloud:index/getZone:getZone', __args__, opts=opts, typ=GetZoneResult).value

    return AwaitableGetZoneResult(
        description=__ret__.description,
        dns_servers=__ret__.dns_servers,
        id=__ret__.id,
        name=__ret__.name,
        region_id=__ret__.region_id,
        region_name=__ret__.region_name,
        zone_id=__ret__.zone_id)


@_utilities.lift_output_func(get_zone)
def get_zone_output(name: Optional[pulumi.Input[Optional[str]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetZoneResult]:
    """
    Get information about an existing Zone.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    current = sakuracloud.get_zone()
    is1a = sakuracloud.get_zone(name="is1a")
    ```


    :param str name: The name of the zone (e.g. `is1a`,`tk1a`).
    """
    ...
