# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVPCRouterResult',
    'AwaitableGetVPCRouterResult',
    'get_vpc_router',
    'get_vpc_router_output',
]

@pulumi.output_type
class GetVPCRouterResult:
    """
    A collection of values returned by getVPCRouter.
    """
    def __init__(__self__, description=None, dhcp_servers=None, dhcp_static_mappings=None, filter=None, firewalls=None, icon_id=None, id=None, internet_connection=None, l2tps=None, name=None, plan=None, port_forwardings=None, pptps=None, private_network_interfaces=None, public_ip=None, public_netmask=None, public_network_interfaces=None, site_to_site_vpns=None, static_nats=None, static_routes=None, syslog_host=None, tags=None, users=None, version=None, wire_guards=None, zone=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dhcp_servers and not isinstance(dhcp_servers, list):
            raise TypeError("Expected argument 'dhcp_servers' to be a list")
        pulumi.set(__self__, "dhcp_servers", dhcp_servers)
        if dhcp_static_mappings and not isinstance(dhcp_static_mappings, list):
            raise TypeError("Expected argument 'dhcp_static_mappings' to be a list")
        pulumi.set(__self__, "dhcp_static_mappings", dhcp_static_mappings)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if firewalls and not isinstance(firewalls, list):
            raise TypeError("Expected argument 'firewalls' to be a list")
        pulumi.set(__self__, "firewalls", firewalls)
        if icon_id and not isinstance(icon_id, str):
            raise TypeError("Expected argument 'icon_id' to be a str")
        pulumi.set(__self__, "icon_id", icon_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internet_connection and not isinstance(internet_connection, bool):
            raise TypeError("Expected argument 'internet_connection' to be a bool")
        pulumi.set(__self__, "internet_connection", internet_connection)
        if l2tps and not isinstance(l2tps, list):
            raise TypeError("Expected argument 'l2tps' to be a list")
        pulumi.set(__self__, "l2tps", l2tps)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if plan and not isinstance(plan, str):
            raise TypeError("Expected argument 'plan' to be a str")
        pulumi.set(__self__, "plan", plan)
        if port_forwardings and not isinstance(port_forwardings, list):
            raise TypeError("Expected argument 'port_forwardings' to be a list")
        pulumi.set(__self__, "port_forwardings", port_forwardings)
        if pptps and not isinstance(pptps, list):
            raise TypeError("Expected argument 'pptps' to be a list")
        pulumi.set(__self__, "pptps", pptps)
        if private_network_interfaces and not isinstance(private_network_interfaces, list):
            raise TypeError("Expected argument 'private_network_interfaces' to be a list")
        pulumi.set(__self__, "private_network_interfaces", private_network_interfaces)
        if public_ip and not isinstance(public_ip, str):
            raise TypeError("Expected argument 'public_ip' to be a str")
        pulumi.set(__self__, "public_ip", public_ip)
        if public_netmask and not isinstance(public_netmask, int):
            raise TypeError("Expected argument 'public_netmask' to be a int")
        pulumi.set(__self__, "public_netmask", public_netmask)
        if public_network_interfaces and not isinstance(public_network_interfaces, list):
            raise TypeError("Expected argument 'public_network_interfaces' to be a list")
        pulumi.set(__self__, "public_network_interfaces", public_network_interfaces)
        if site_to_site_vpns and not isinstance(site_to_site_vpns, list):
            raise TypeError("Expected argument 'site_to_site_vpns' to be a list")
        pulumi.set(__self__, "site_to_site_vpns", site_to_site_vpns)
        if static_nats and not isinstance(static_nats, list):
            raise TypeError("Expected argument 'static_nats' to be a list")
        pulumi.set(__self__, "static_nats", static_nats)
        if static_routes and not isinstance(static_routes, list):
            raise TypeError("Expected argument 'static_routes' to be a list")
        pulumi.set(__self__, "static_routes", static_routes)
        if syslog_host and not isinstance(syslog_host, str):
            raise TypeError("Expected argument 'syslog_host' to be a str")
        pulumi.set(__self__, "syslog_host", syslog_host)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)
        if wire_guards and not isinstance(wire_guards, list):
            raise TypeError("Expected argument 'wire_guards' to be a list")
        pulumi.set(__self__, "wire_guards", wire_guards)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the static NAT.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dhcpServers")
    def dhcp_servers(self) -> Sequence['outputs.GetVPCRouterDhcpServerResult']:
        """
        A list of `dhcp_server` blocks as defined below.
        """
        return pulumi.get(self, "dhcp_servers")

    @property
    @pulumi.getter(name="dhcpStaticMappings")
    def dhcp_static_mappings(self) -> Sequence['outputs.GetVPCRouterDhcpStaticMappingResult']:
        """
        A list of `dhcp_static_mapping` blocks as defined below.
        """
        return pulumi.get(self, "dhcp_static_mappings")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetVPCRouterFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def firewalls(self) -> Sequence['outputs.GetVPCRouterFirewallResult']:
        """
        A list of `firewall` blocks as defined below.
        """
        return pulumi.get(self, "firewalls")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> str:
        """
        The icon id attached to the VPCRouter.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internetConnection")
    def internet_connection(self) -> bool:
        """
        The flag to enable connecting to the Internet from the VPC Router.
        """
        return pulumi.get(self, "internet_connection")

    @property
    @pulumi.getter
    def l2tps(self) -> Sequence['outputs.GetVPCRouterL2tpResult']:
        """
        A list of `l2tp` blocks as defined below.
        """
        return pulumi.get(self, "l2tps")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        the name of the peer.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def plan(self) -> str:
        """
        The plan name of the VPCRouter. This will be one of [`standard`/`premium`/`highspec`/`highspec4000`].
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="portForwardings")
    def port_forwardings(self) -> Sequence['outputs.GetVPCRouterPortForwardingResult']:
        """
        A list of `port_forwarding` blocks as defined below. This represents a `Reverse NAT`.
        """
        return pulumi.get(self, "port_forwardings")

    @property
    @pulumi.getter
    def pptps(self) -> Sequence['outputs.GetVPCRouterPptpResult']:
        """
        A list of `pptp` blocks as defined below.
        """
        return pulumi.get(self, "pptps")

    @property
    @pulumi.getter(name="privateNetworkInterfaces")
    def private_network_interfaces(self) -> Sequence['outputs.GetVPCRouterPrivateNetworkInterfaceResult']:
        """
        A list of additional network interface setting. This doesn't include primary network interface setting.
        """
        return pulumi.get(self, "private_network_interfaces")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> str:
        """
        The public IP address used for the static NAT.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="publicNetmask")
    def public_netmask(self) -> int:
        """
        The bit length of the subnet to assign to the public network interface.
        """
        return pulumi.get(self, "public_netmask")

    @property
    @pulumi.getter(name="publicNetworkInterfaces")
    def public_network_interfaces(self) -> Sequence['outputs.GetVPCRouterPublicNetworkInterfaceResult']:
        """
        A list of additional network interface setting. This doesn't include primary network interface setting.
        """
        return pulumi.get(self, "public_network_interfaces")

    @property
    @pulumi.getter(name="siteToSiteVpns")
    def site_to_site_vpns(self) -> Sequence['outputs.GetVPCRouterSiteToSiteVpnResult']:
        """
        A list of `site_to_site_vpn` blocks as defined below.
        """
        return pulumi.get(self, "site_to_site_vpns")

    @property
    @pulumi.getter(name="staticNats")
    def static_nats(self) -> Sequence['outputs.GetVPCRouterStaticNatResult']:
        """
        A list of `static_nat` blocks as defined below. This represents a `1:1 NAT`, doing static mapping to both send/receive to/from the Internet. This is only used when `plan` is not `standard`.
        """
        return pulumi.get(self, "static_nats")

    @property
    @pulumi.getter(name="staticRoutes")
    def static_routes(self) -> Sequence['outputs.GetVPCRouterStaticRouteResult']:
        """
        A list of `static_route` blocks as defined below.
        """
        return pulumi.get(self, "static_routes")

    @property
    @pulumi.getter(name="syslogHost")
    def syslog_host(self) -> str:
        """
        The ip address of the syslog host to which the VPC Router sends logs.
        """
        return pulumi.get(self, "syslog_host")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Any tags assigned to the VPCRouter.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetVPCRouterUserResult']:
        """
        A list of `user` blocks as defined below.
        """
        return pulumi.get(self, "users")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        The version of the VPC Router.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="wireGuards")
    def wire_guards(self) -> Sequence['outputs.GetVPCRouterWireGuardResult']:
        """
        A list of `wire_guard` blocks as defined below.
        """
        return pulumi.get(self, "wire_guards")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


class AwaitableGetVPCRouterResult(GetVPCRouterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVPCRouterResult(
            description=self.description,
            dhcp_servers=self.dhcp_servers,
            dhcp_static_mappings=self.dhcp_static_mappings,
            filter=self.filter,
            firewalls=self.firewalls,
            icon_id=self.icon_id,
            id=self.id,
            internet_connection=self.internet_connection,
            l2tps=self.l2tps,
            name=self.name,
            plan=self.plan,
            port_forwardings=self.port_forwardings,
            pptps=self.pptps,
            private_network_interfaces=self.private_network_interfaces,
            public_ip=self.public_ip,
            public_netmask=self.public_netmask,
            public_network_interfaces=self.public_network_interfaces,
            site_to_site_vpns=self.site_to_site_vpns,
            static_nats=self.static_nats,
            static_routes=self.static_routes,
            syslog_host=self.syslog_host,
            tags=self.tags,
            users=self.users,
            version=self.version,
            wire_guards=self.wire_guards,
            zone=self.zone)


def get_vpc_router(filter: Optional[pulumi.InputType['GetVPCRouterFilterArgs']] = None,
                   zone: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVPCRouterResult:
    """
    Get information about an existing VPC Router.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_vpc_router(filter=sakuracloud.GetVPCRouterFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetVPCRouterFilterArgs'] filter: One or more values used for filtering, as defined below.
    :param str zone: The name of zone that the VPC Router is in (e.g. `is1a`, `tk1a`).
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['zone'] = zone
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('sakuracloud:index/getVPCRouter:getVPCRouter', __args__, opts=opts, typ=GetVPCRouterResult).value

    return AwaitableGetVPCRouterResult(
        description=__ret__.description,
        dhcp_servers=__ret__.dhcp_servers,
        dhcp_static_mappings=__ret__.dhcp_static_mappings,
        filter=__ret__.filter,
        firewalls=__ret__.firewalls,
        icon_id=__ret__.icon_id,
        id=__ret__.id,
        internet_connection=__ret__.internet_connection,
        l2tps=__ret__.l2tps,
        name=__ret__.name,
        plan=__ret__.plan,
        port_forwardings=__ret__.port_forwardings,
        pptps=__ret__.pptps,
        private_network_interfaces=__ret__.private_network_interfaces,
        public_ip=__ret__.public_ip,
        public_netmask=__ret__.public_netmask,
        public_network_interfaces=__ret__.public_network_interfaces,
        site_to_site_vpns=__ret__.site_to_site_vpns,
        static_nats=__ret__.static_nats,
        static_routes=__ret__.static_routes,
        syslog_host=__ret__.syslog_host,
        tags=__ret__.tags,
        users=__ret__.users,
        version=__ret__.version,
        wire_guards=__ret__.wire_guards,
        zone=__ret__.zone)


@_utilities.lift_output_func(get_vpc_router)
def get_vpc_router_output(filter: Optional[pulumi.Input[Optional[pulumi.InputType['GetVPCRouterFilterArgs']]]] = None,
                          zone: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVPCRouterResult]:
    """
    Get information about an existing VPC Router.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_vpc_router(filter=sakuracloud.GetVPCRouterFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetVPCRouterFilterArgs'] filter: One or more values used for filtering, as defined below.
    :param str zone: The name of zone that the VPC Router is in (e.g. `is1a`, `tk1a`).
    """
    ...
