# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSSHKeyResult',
    'AwaitableGetSSHKeyResult',
    'get_ssh_key',
    'get_ssh_key_output',
]

@pulumi.output_type
class GetSSHKeyResult:
    """
    A collection of values returned by getSSHKey.
    """
    def __init__(__self__, description=None, filter=None, fingerprint=None, id=None, name=None, public_key=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if fingerprint and not isinstance(fingerprint, str):
            raise TypeError("Expected argument 'fingerprint' to be a str")
        pulumi.set(__self__, "fingerprint", fingerprint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_key and not isinstance(public_key, str):
            raise TypeError("Expected argument 'public_key' to be a str")
        pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the SSHKey.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetSSHKeyFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def fingerprint(self) -> str:
        """
        The fingerprint of public key.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SSHKey.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        The value of public key.
        """
        return pulumi.get(self, "public_key")


class AwaitableGetSSHKeyResult(GetSSHKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSSHKeyResult(
            description=self.description,
            filter=self.filter,
            fingerprint=self.fingerprint,
            id=self.id,
            name=self.name,
            public_key=self.public_key)


def get_ssh_key(filter: Optional[pulumi.InputType['GetSSHKeyFilterArgs']] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSSHKeyResult:
    """
    Get information about an existing SSH Key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_ssh_key(filter=sakuracloud.GetSSHKeyFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetSSHKeyFilterArgs'] filter: One or more values used for filtering, as defined below.
    """
    __args__ = dict()
    __args__['filter'] = filter
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('sakuracloud:index/getSSHKey:getSSHKey', __args__, opts=opts, typ=GetSSHKeyResult).value

    return AwaitableGetSSHKeyResult(
        description=__ret__.description,
        filter=__ret__.filter,
        fingerprint=__ret__.fingerprint,
        id=__ret__.id,
        name=__ret__.name,
        public_key=__ret__.public_key)


@_utilities.lift_output_func(get_ssh_key)
def get_ssh_key_output(filter: Optional[pulumi.Input[Optional[pulumi.InputType['GetSSHKeyFilterArgs']]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSSHKeyResult]:
    """
    Get information about an existing SSH Key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_ssh_key(filter=sakuracloud.GetSSHKeyFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetSSHKeyFilterArgs'] filter: One or more values used for filtering, as defined below.
    """
    ...
