# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetServerResult',
    'AwaitableGetServerResult',
    'get_server',
    'get_server_output',
]

@pulumi.output_type
class GetServerResult:
    """
    A collection of values returned by getServer.
    """
    def __init__(__self__, cdrom_id=None, commitment=None, core=None, description=None, disks=None, dns_servers=None, filter=None, gateway=None, gpu=None, hostname=None, icon_id=None, id=None, interface_driver=None, ip_address=None, memory=None, name=None, netmask=None, network_address=None, network_interfaces=None, private_host_id=None, private_host_name=None, tags=None, zone=None):
        if cdrom_id and not isinstance(cdrom_id, str):
            raise TypeError("Expected argument 'cdrom_id' to be a str")
        pulumi.set(__self__, "cdrom_id", cdrom_id)
        if commitment and not isinstance(commitment, str):
            raise TypeError("Expected argument 'commitment' to be a str")
        pulumi.set(__self__, "commitment", commitment)
        if core and not isinstance(core, int):
            raise TypeError("Expected argument 'core' to be a int")
        pulumi.set(__self__, "core", core)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if disks and not isinstance(disks, list):
            raise TypeError("Expected argument 'disks' to be a list")
        pulumi.set(__self__, "disks", disks)
        if dns_servers and not isinstance(dns_servers, list):
            raise TypeError("Expected argument 'dns_servers' to be a list")
        pulumi.set(__self__, "dns_servers", dns_servers)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if gateway and not isinstance(gateway, str):
            raise TypeError("Expected argument 'gateway' to be a str")
        pulumi.set(__self__, "gateway", gateway)
        if gpu and not isinstance(gpu, int):
            raise TypeError("Expected argument 'gpu' to be a int")
        pulumi.set(__self__, "gpu", gpu)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if icon_id and not isinstance(icon_id, str):
            raise TypeError("Expected argument 'icon_id' to be a str")
        pulumi.set(__self__, "icon_id", icon_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interface_driver and not isinstance(interface_driver, str):
            raise TypeError("Expected argument 'interface_driver' to be a str")
        pulumi.set(__self__, "interface_driver", interface_driver)
        if ip_address and not isinstance(ip_address, str):
            raise TypeError("Expected argument 'ip_address' to be a str")
        pulumi.set(__self__, "ip_address", ip_address)
        if memory and not isinstance(memory, int):
            raise TypeError("Expected argument 'memory' to be a int")
        pulumi.set(__self__, "memory", memory)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if netmask and not isinstance(netmask, int):
            raise TypeError("Expected argument 'netmask' to be a int")
        pulumi.set(__self__, "netmask", netmask)
        if network_address and not isinstance(network_address, str):
            raise TypeError("Expected argument 'network_address' to be a str")
        pulumi.set(__self__, "network_address", network_address)
        if network_interfaces and not isinstance(network_interfaces, list):
            raise TypeError("Expected argument 'network_interfaces' to be a list")
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        if private_host_id and not isinstance(private_host_id, str):
            raise TypeError("Expected argument 'private_host_id' to be a str")
        pulumi.set(__self__, "private_host_id", private_host_id)
        if private_host_name and not isinstance(private_host_name, str):
            raise TypeError("Expected argument 'private_host_name' to be a str")
        pulumi.set(__self__, "private_host_name", private_host_name)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="cdromId")
    def cdrom_id(self) -> str:
        """
        The id of the CD-ROM attached to the server.
        """
        return pulumi.get(self, "cdrom_id")

    @property
    @pulumi.getter
    def commitment(self) -> str:
        """
        The policy of how to allocate virtual CPUs to the server. This will be one of [`standard`/`dedicatedcpu`].
        """
        return pulumi.get(self, "commitment")

    @property
    @pulumi.getter
    def core(self) -> int:
        """
        The number of virtual CPUs.
        """
        return pulumi.get(self, "core")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Server.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disks(self) -> Sequence[str]:
        """
        A list of disk id connected to the server.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Sequence[str]:
        """
        A list of IP address of DNS server in the zone.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetServerFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def gateway(self) -> str:
        """
        The IP address of the gateway used by Server.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter
    def gpu(self) -> int:
        """
        The number of GPUs.
        """
        return pulumi.get(self, "gpu")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        The hostname of the Server.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> str:
        """
        The icon id attached to the Server.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="interfaceDriver")
    def interface_driver(self) -> str:
        """
        The driver name of network interface. This will be one of [`virtio`/`e1000`].
        """
        return pulumi.get(self, "interface_driver")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address assigned to the Server.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        The size of memory in GiB.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def netmask(self) -> int:
        """
        The bit length of the subnet assigned to the Server.
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> str:
        """
        The network address which the `ip_address` belongs.
        """
        return pulumi.get(self, "network_address")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.GetServerNetworkInterfaceResult']:
        """
        A list of `network_interface` blocks as defined below.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="privateHostId")
    def private_host_id(self) -> str:
        """
        The id of the private host which the server is assigned.
        """
        return pulumi.get(self, "private_host_id")

    @property
    @pulumi.getter(name="privateHostName")
    def private_host_name(self) -> str:
        """
        The name of the private host which the server is assigned.
        """
        return pulumi.get(self, "private_host_name")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Any tags assigned to the Server.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


class AwaitableGetServerResult(GetServerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerResult(
            cdrom_id=self.cdrom_id,
            commitment=self.commitment,
            core=self.core,
            description=self.description,
            disks=self.disks,
            dns_servers=self.dns_servers,
            filter=self.filter,
            gateway=self.gateway,
            gpu=self.gpu,
            hostname=self.hostname,
            icon_id=self.icon_id,
            id=self.id,
            interface_driver=self.interface_driver,
            ip_address=self.ip_address,
            memory=self.memory,
            name=self.name,
            netmask=self.netmask,
            network_address=self.network_address,
            network_interfaces=self.network_interfaces,
            private_host_id=self.private_host_id,
            private_host_name=self.private_host_name,
            tags=self.tags,
            zone=self.zone)


def get_server(filter: Optional[pulumi.InputType['GetServerFilterArgs']] = None,
               zone: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerResult:
    """
    Get information about an existing Server.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_server(filter=sakuracloud.GetServerFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetServerFilterArgs'] filter: One or more values used for filtering, as defined below.
    :param str zone: The name of zone that the Server is in (e.g. `is1a`, `tk1a`).
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['zone'] = zone
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('sakuracloud:index/getServer:getServer', __args__, opts=opts, typ=GetServerResult).value

    return AwaitableGetServerResult(
        cdrom_id=__ret__.cdrom_id,
        commitment=__ret__.commitment,
        core=__ret__.core,
        description=__ret__.description,
        disks=__ret__.disks,
        dns_servers=__ret__.dns_servers,
        filter=__ret__.filter,
        gateway=__ret__.gateway,
        gpu=__ret__.gpu,
        hostname=__ret__.hostname,
        icon_id=__ret__.icon_id,
        id=__ret__.id,
        interface_driver=__ret__.interface_driver,
        ip_address=__ret__.ip_address,
        memory=__ret__.memory,
        name=__ret__.name,
        netmask=__ret__.netmask,
        network_address=__ret__.network_address,
        network_interfaces=__ret__.network_interfaces,
        private_host_id=__ret__.private_host_id,
        private_host_name=__ret__.private_host_name,
        tags=__ret__.tags,
        zone=__ret__.zone)


@_utilities.lift_output_func(get_server)
def get_server_output(filter: Optional[pulumi.Input[Optional[pulumi.InputType['GetServerFilterArgs']]]] = None,
                      zone: Optional[pulumi.Input[Optional[str]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServerResult]:
    """
    Get information about an existing Server.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_server(filter=sakuracloud.GetServerFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetServerFilterArgs'] filter: One or more values used for filtering, as defined below.
    :param str zone: The name of zone that the Server is in (e.g. `is1a`, `tk1a`).
    """
    ...
