# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInternetResult',
    'AwaitableGetInternetResult',
    'get_internet',
    'get_internet_output',
]

@pulumi.output_type
class GetInternetResult:
    """
    A collection of values returned by getInternet.
    """
    def __init__(__self__, band_width=None, description=None, enable_ipv6=None, filter=None, gateway=None, icon_id=None, id=None, ip_addresses=None, ipv6_network_address=None, ipv6_prefix=None, ipv6_prefix_len=None, max_ip_address=None, min_ip_address=None, name=None, netmask=None, network_address=None, server_ids=None, switch_id=None, tags=None, zone=None):
        if band_width and not isinstance(band_width, int):
            raise TypeError("Expected argument 'band_width' to be a int")
        pulumi.set(__self__, "band_width", band_width)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enable_ipv6 and not isinstance(enable_ipv6, bool):
            raise TypeError("Expected argument 'enable_ipv6' to be a bool")
        pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if gateway and not isinstance(gateway, str):
            raise TypeError("Expected argument 'gateway' to be a str")
        pulumi.set(__self__, "gateway", gateway)
        if icon_id and not isinstance(icon_id, str):
            raise TypeError("Expected argument 'icon_id' to be a str")
        pulumi.set(__self__, "icon_id", icon_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_addresses and not isinstance(ip_addresses, list):
            raise TypeError("Expected argument 'ip_addresses' to be a list")
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        if ipv6_network_address and not isinstance(ipv6_network_address, str):
            raise TypeError("Expected argument 'ipv6_network_address' to be a str")
        pulumi.set(__self__, "ipv6_network_address", ipv6_network_address)
        if ipv6_prefix and not isinstance(ipv6_prefix, str):
            raise TypeError("Expected argument 'ipv6_prefix' to be a str")
        pulumi.set(__self__, "ipv6_prefix", ipv6_prefix)
        if ipv6_prefix_len and not isinstance(ipv6_prefix_len, int):
            raise TypeError("Expected argument 'ipv6_prefix_len' to be a int")
        pulumi.set(__self__, "ipv6_prefix_len", ipv6_prefix_len)
        if max_ip_address and not isinstance(max_ip_address, str):
            raise TypeError("Expected argument 'max_ip_address' to be a str")
        pulumi.set(__self__, "max_ip_address", max_ip_address)
        if min_ip_address and not isinstance(min_ip_address, str):
            raise TypeError("Expected argument 'min_ip_address' to be a str")
        pulumi.set(__self__, "min_ip_address", min_ip_address)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if netmask and not isinstance(netmask, int):
            raise TypeError("Expected argument 'netmask' to be a int")
        pulumi.set(__self__, "netmask", netmask)
        if network_address and not isinstance(network_address, str):
            raise TypeError("Expected argument 'network_address' to be a str")
        pulumi.set(__self__, "network_address", network_address)
        if server_ids and not isinstance(server_ids, list):
            raise TypeError("Expected argument 'server_ids' to be a list")
        pulumi.set(__self__, "server_ids", server_ids)
        if switch_id and not isinstance(switch_id, str):
            raise TypeError("Expected argument 'switch_id' to be a str")
        pulumi.set(__self__, "switch_id", switch_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="bandWidth")
    def band_width(self) -> int:
        """
        The bandwidth of the network connected to the Internet in Mbps.
        """
        return pulumi.get(self, "band_width")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Switch+Router.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> bool:
        """
        The flag to enable IPv6.
        """
        return pulumi.get(self, "enable_ipv6")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetInternetFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def gateway(self) -> str:
        """
        The IP address of the gateway used by Switch+Router.
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> str:
        """
        The icon id attached to the Switch+Router.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        """
        A list of assigned global address to the Switch+Router.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter(name="ipv6NetworkAddress")
    def ipv6_network_address(self) -> str:
        """
        The IPv6 network address assigned to the Switch+Router.
        """
        return pulumi.get(self, "ipv6_network_address")

    @property
    @pulumi.getter(name="ipv6Prefix")
    def ipv6_prefix(self) -> str:
        """
        The network prefix of assigned IPv6 addresses to the Switch+Router.
        """
        return pulumi.get(self, "ipv6_prefix")

    @property
    @pulumi.getter(name="ipv6PrefixLen")
    def ipv6_prefix_len(self) -> int:
        """
        The bit length of IPv6 network prefix.
        """
        return pulumi.get(self, "ipv6_prefix_len")

    @property
    @pulumi.getter(name="maxIpAddress")
    def max_ip_address(self) -> str:
        """
        Maximum IP address in assigned global addresses to the Switch+Router.
        """
        return pulumi.get(self, "max_ip_address")

    @property
    @pulumi.getter(name="minIpAddress")
    def min_ip_address(self) -> str:
        """
        Minimum IP address in assigned global addresses to the Switch+Router.
        """
        return pulumi.get(self, "min_ip_address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Switch+Router.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def netmask(self) -> int:
        """
        The bit length of the subnet assigned to the Switch+Router.
        """
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> str:
        """
        The IPv4 network address assigned to the Switch+Router.
        """
        return pulumi.get(self, "network_address")

    @property
    @pulumi.getter(name="serverIds")
    def server_ids(self) -> Sequence[str]:
        """
        A list of the ID of Servers connected to the Switch+Router.
        """
        return pulumi.get(self, "server_ids")

    @property
    @pulumi.getter(name="switchId")
    def switch_id(self) -> str:
        """
        The id of the switch connected from the Switch+Router.
        """
        return pulumi.get(self, "switch_id")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Any tags assigned to the Switch+Router.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


class AwaitableGetInternetResult(GetInternetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInternetResult(
            band_width=self.band_width,
            description=self.description,
            enable_ipv6=self.enable_ipv6,
            filter=self.filter,
            gateway=self.gateway,
            icon_id=self.icon_id,
            id=self.id,
            ip_addresses=self.ip_addresses,
            ipv6_network_address=self.ipv6_network_address,
            ipv6_prefix=self.ipv6_prefix,
            ipv6_prefix_len=self.ipv6_prefix_len,
            max_ip_address=self.max_ip_address,
            min_ip_address=self.min_ip_address,
            name=self.name,
            netmask=self.netmask,
            network_address=self.network_address,
            server_ids=self.server_ids,
            switch_id=self.switch_id,
            tags=self.tags,
            zone=self.zone)


def get_internet(filter: Optional[pulumi.InputType['GetInternetFilterArgs']] = None,
                 zone: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInternetResult:
    """
    Get information about an existing Switch+Router.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_internet(filter=sakuracloud.GetInternetFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetInternetFilterArgs'] filter: One or more values used for filtering, as defined below.
    :param str zone: The name of zone that the Switch+Router is in (e.g. `is1a`, `tk1a`).
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['zone'] = zone
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('sakuracloud:index/getInternet:getInternet', __args__, opts=opts, typ=GetInternetResult).value

    return AwaitableGetInternetResult(
        band_width=__ret__.band_width,
        description=__ret__.description,
        enable_ipv6=__ret__.enable_ipv6,
        filter=__ret__.filter,
        gateway=__ret__.gateway,
        icon_id=__ret__.icon_id,
        id=__ret__.id,
        ip_addresses=__ret__.ip_addresses,
        ipv6_network_address=__ret__.ipv6_network_address,
        ipv6_prefix=__ret__.ipv6_prefix,
        ipv6_prefix_len=__ret__.ipv6_prefix_len,
        max_ip_address=__ret__.max_ip_address,
        min_ip_address=__ret__.min_ip_address,
        name=__ret__.name,
        netmask=__ret__.netmask,
        network_address=__ret__.network_address,
        server_ids=__ret__.server_ids,
        switch_id=__ret__.switch_id,
        tags=__ret__.tags,
        zone=__ret__.zone)


@_utilities.lift_output_func(get_internet)
def get_internet_output(filter: Optional[pulumi.Input[Optional[pulumi.InputType['GetInternetFilterArgs']]]] = None,
                        zone: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInternetResult]:
    """
    Get information about an existing Switch+Router.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_internet(filter=sakuracloud.GetInternetFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetInternetFilterArgs'] filter: One or more values used for filtering, as defined below.
    :param str zone: The name of zone that the Switch+Router is in (e.g. `is1a`, `tk1a`).
    """
    ...
