# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDNSResult',
    'AwaitableGetDNSResult',
    'get_dns',
    'get_dns_output',
]

@pulumi.output_type
class GetDNSResult:
    """
    A collection of values returned by getDNS.
    """
    def __init__(__self__, description=None, dns_servers=None, filter=None, icon_id=None, id=None, records=None, tags=None, zone=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dns_servers and not isinstance(dns_servers, list):
            raise TypeError("Expected argument 'dns_servers' to be a list")
        pulumi.set(__self__, "dns_servers", dns_servers)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if icon_id and not isinstance(icon_id, str):
            raise TypeError("Expected argument 'icon_id' to be a str")
        pulumi.set(__self__, "icon_id", icon_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if records and not isinstance(records, list):
            raise TypeError("Expected argument 'records' to be a list")
        pulumi.set(__self__, "records", records)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the DNS.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Sequence[str]:
        """
        A list of IP address of DNS server that manage this zone.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetDNSFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> str:
        """
        The icon id attached to the DNS.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def records(self) -> Sequence['outputs.GetDNSRecordResult']:
        """
        A list of `record` blocks as defined below.
        """
        return pulumi.get(self, "records")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Any tags assigned to the DNS.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        The name of managed domain.
        """
        return pulumi.get(self, "zone")


class AwaitableGetDNSResult(GetDNSResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDNSResult(
            description=self.description,
            dns_servers=self.dns_servers,
            filter=self.filter,
            icon_id=self.icon_id,
            id=self.id,
            records=self.records,
            tags=self.tags,
            zone=self.zone)


def get_dns(filter: Optional[pulumi.InputType['GetDNSFilterArgs']] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDNSResult:
    """
    Get information about an existing DNS.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_dns(filter=sakuracloud.GetDNSFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetDNSFilterArgs'] filter: One or more values used for filtering, as defined below.
    """
    __args__ = dict()
    __args__['filter'] = filter
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('sakuracloud:index/getDNS:getDNS', __args__, opts=opts, typ=GetDNSResult).value

    return AwaitableGetDNSResult(
        description=__ret__.description,
        dns_servers=__ret__.dns_servers,
        filter=__ret__.filter,
        icon_id=__ret__.icon_id,
        id=__ret__.id,
        records=__ret__.records,
        tags=__ret__.tags,
        zone=__ret__.zone)


@_utilities.lift_output_func(get_dns)
def get_dns_output(filter: Optional[pulumi.Input[Optional[pulumi.InputType['GetDNSFilterArgs']]]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDNSResult]:
    """
    Get information about an existing DNS.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_dns(filter=sakuracloud.GetDNSFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetDNSFilterArgs'] filter: One or more values used for filtering, as defined below.
    """
    ...
