# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDiskResult',
    'AwaitableGetDiskResult',
    'get_disk',
    'get_disk_output',
]

@pulumi.output_type
class GetDiskResult:
    """
    A collection of values returned by getDisk.
    """
    def __init__(__self__, connector=None, description=None, filter=None, icon_id=None, id=None, name=None, plan=None, server_id=None, size=None, source_archive_id=None, source_disk_id=None, tags=None, zone=None):
        if connector and not isinstance(connector, str):
            raise TypeError("Expected argument 'connector' to be a str")
        pulumi.set(__self__, "connector", connector)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if icon_id and not isinstance(icon_id, str):
            raise TypeError("Expected argument 'icon_id' to be a str")
        pulumi.set(__self__, "icon_id", icon_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if plan and not isinstance(plan, str):
            raise TypeError("Expected argument 'plan' to be a str")
        pulumi.set(__self__, "plan", plan)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)
        if source_archive_id and not isinstance(source_archive_id, str):
            raise TypeError("Expected argument 'source_archive_id' to be a str")
        pulumi.set(__self__, "source_archive_id", source_archive_id)
        if source_disk_id and not isinstance(source_disk_id, str):
            raise TypeError("Expected argument 'source_disk_id' to be a str")
        pulumi.set(__self__, "source_disk_id", source_disk_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def connector(self) -> str:
        """
        The name of the disk connector. This will be one of [`virtio`/`ide`].
        """
        return pulumi.get(self, "connector")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Disk.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetDiskFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> str:
        """
        The icon id attached to the Disk.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Disk.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def plan(self) -> str:
        """
        The plan name of the Disk. This will be one of [`ssd`/`hdd`].
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> str:
        """
        The id of the Server connected to the Disk.
        """
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of Disk in GiB.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sourceArchiveId")
    def source_archive_id(self) -> str:
        """
        The id of the source archive.
        """
        return pulumi.get(self, "source_archive_id")

    @property
    @pulumi.getter(name="sourceDiskId")
    def source_disk_id(self) -> str:
        """
        The id of the source disk.
        """
        return pulumi.get(self, "source_disk_id")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Any tags assigned to the Disk.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


class AwaitableGetDiskResult(GetDiskResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDiskResult(
            connector=self.connector,
            description=self.description,
            filter=self.filter,
            icon_id=self.icon_id,
            id=self.id,
            name=self.name,
            plan=self.plan,
            server_id=self.server_id,
            size=self.size,
            source_archive_id=self.source_archive_id,
            source_disk_id=self.source_disk_id,
            tags=self.tags,
            zone=self.zone)


def get_disk(filter: Optional[pulumi.InputType['GetDiskFilterArgs']] = None,
             zone: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDiskResult:
    """
    Get information about an existing Disk.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_disk(filter=sakuracloud.GetDiskFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetDiskFilterArgs'] filter: One or more values used for filtering, as defined below.
    :param str zone: The name of zone that the Disk is in (e.g. `is1a`, `tk1a`).
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['zone'] = zone
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('sakuracloud:index/getDisk:getDisk', __args__, opts=opts, typ=GetDiskResult).value

    return AwaitableGetDiskResult(
        connector=__ret__.connector,
        description=__ret__.description,
        filter=__ret__.filter,
        icon_id=__ret__.icon_id,
        id=__ret__.id,
        name=__ret__.name,
        plan=__ret__.plan,
        server_id=__ret__.server_id,
        size=__ret__.size,
        source_archive_id=__ret__.source_archive_id,
        source_disk_id=__ret__.source_disk_id,
        tags=__ret__.tags,
        zone=__ret__.zone)


@_utilities.lift_output_func(get_disk)
def get_disk_output(filter: Optional[pulumi.Input[Optional[pulumi.InputType['GetDiskFilterArgs']]]] = None,
                    zone: Optional[pulumi.Input[Optional[str]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDiskResult]:
    """
    Get information about an existing Disk.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_disk(filter=sakuracloud.GetDiskFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetDiskFilterArgs'] filter: One or more values used for filtering, as defined below.
    :param str zone: The name of zone that the Disk is in (e.g. `is1a`, `tk1a`).
    """
    ...
