# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCertificateAuthorityResult',
    'AwaitableGetCertificateAuthorityResult',
    'get_certificate_authority',
    'get_certificate_authority_output',
]

@pulumi.output_type
class GetCertificateAuthorityResult:
    """
    A collection of values returned by getCertificateAuthority.
    """
    def __init__(__self__, certificate=None, clients=None, crl_url=None, description=None, filter=None, icon_id=None, id=None, name=None, not_after=None, not_before=None, serial_number=None, servers=None, subject_string=None, tags=None):
        if certificate and not isinstance(certificate, str):
            raise TypeError("Expected argument 'certificate' to be a str")
        pulumi.set(__self__, "certificate", certificate)
        if clients and not isinstance(clients, list):
            raise TypeError("Expected argument 'clients' to be a list")
        pulumi.set(__self__, "clients", clients)
        if crl_url and not isinstance(crl_url, str):
            raise TypeError("Expected argument 'crl_url' to be a str")
        pulumi.set(__self__, "crl_url", crl_url)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filter and not isinstance(filter, dict):
            raise TypeError("Expected argument 'filter' to be a dict")
        pulumi.set(__self__, "filter", filter)
        if icon_id and not isinstance(icon_id, str):
            raise TypeError("Expected argument 'icon_id' to be a str")
        pulumi.set(__self__, "icon_id", icon_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if not_after and not isinstance(not_after, str):
            raise TypeError("Expected argument 'not_after' to be a str")
        pulumi.set(__self__, "not_after", not_after)
        if not_before and not isinstance(not_before, str):
            raise TypeError("Expected argument 'not_before' to be a str")
        pulumi.set(__self__, "not_before", not_before)
        if serial_number and not isinstance(serial_number, str):
            raise TypeError("Expected argument 'serial_number' to be a str")
        pulumi.set(__self__, "serial_number", serial_number)
        if servers and not isinstance(servers, list):
            raise TypeError("Expected argument 'servers' to be a list")
        pulumi.set(__self__, "servers", servers)
        if subject_string and not isinstance(subject_string, str):
            raise TypeError("Expected argument 'subject_string' to be a str")
        pulumi.set(__self__, "subject_string", subject_string)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def certificate(self) -> str:
        """
        The body of the CA's certificate in PEM format.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter
    def clients(self) -> Sequence['outputs.GetCertificateAuthorityClientResult']:
        """
        A list of `client` blocks as defined below.
        """
        return pulumi.get(self, "clients")

    @property
    @pulumi.getter(name="crlUrl")
    def crl_url(self) -> str:
        """
        The URL of the CRL.
        """
        return pulumi.get(self, "crl_url")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the CertificateAuthority.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def filter(self) -> Optional['outputs.GetCertificateAuthorityFilterResult']:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> str:
        """
        The icon id attached to the CertificateAuthority.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the CertificateAuthority.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> str:
        """
        The date on which the certificate validity period ends, in RFC3339 format.
        """
        return pulumi.get(self, "not_after")

    @property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> str:
        """
        The date on which the certificate validity period begins, in RFC3339 format.
        """
        return pulumi.get(self, "not_before")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> str:
        """
        The body of the CA's certificate in PEM format.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter
    def servers(self) -> Sequence['outputs.GetCertificateAuthorityServerResult']:
        """
        A list of `server` blocks as defined below.
        """
        return pulumi.get(self, "servers")

    @property
    @pulumi.getter(name="subjectString")
    def subject_string(self) -> str:
        """
        .
        """
        return pulumi.get(self, "subject_string")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Any tags assigned to the CertificateAuthority.
        """
        return pulumi.get(self, "tags")


class AwaitableGetCertificateAuthorityResult(GetCertificateAuthorityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateAuthorityResult(
            certificate=self.certificate,
            clients=self.clients,
            crl_url=self.crl_url,
            description=self.description,
            filter=self.filter,
            icon_id=self.icon_id,
            id=self.id,
            name=self.name,
            not_after=self.not_after,
            not_before=self.not_before,
            serial_number=self.serial_number,
            servers=self.servers,
            subject_string=self.subject_string,
            tags=self.tags)


def get_certificate_authority(filter: Optional[pulumi.InputType['GetCertificateAuthorityFilterArgs']] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateAuthorityResult:
    """
    Get information about an existing sakuracloud_certificate_authority.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_certificate_authority(filter=sakuracloud.GetCertificateAuthorityFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetCertificateAuthorityFilterArgs'] filter: One or more values used for filtering, as defined below.
    """
    __args__ = dict()
    __args__['filter'] = filter
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('sakuracloud:index/getCertificateAuthority:getCertificateAuthority', __args__, opts=opts, typ=GetCertificateAuthorityResult).value

    return AwaitableGetCertificateAuthorityResult(
        certificate=__ret__.certificate,
        clients=__ret__.clients,
        crl_url=__ret__.crl_url,
        description=__ret__.description,
        filter=__ret__.filter,
        icon_id=__ret__.icon_id,
        id=__ret__.id,
        name=__ret__.name,
        not_after=__ret__.not_after,
        not_before=__ret__.not_before,
        serial_number=__ret__.serial_number,
        servers=__ret__.servers,
        subject_string=__ret__.subject_string,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_certificate_authority)
def get_certificate_authority_output(filter: Optional[pulumi.Input[Optional[pulumi.InputType['GetCertificateAuthorityFilterArgs']]]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCertificateAuthorityResult]:
    """
    Get information about an existing sakuracloud_certificate_authority.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sakuracloud as sakuracloud

    foobar = sakuracloud.get_certificate_authority(filter=sakuracloud.GetCertificateAuthorityFilterArgs(
        names=["foobar"],
    ))
    ```


    :param pulumi.InputType['GetCertificateAuthorityFilterArgs'] filter: One or more values used for filtering, as defined below.
    """
    ...
