# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ESMEArgs', 'ESME']

@pulumi.input_type
class ESMEArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 icon_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a ESME resource.
        :param pulumi.Input[str] description: The description of the ESME. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[str] icon_id: The icon id to attach to the ESME.
        :param pulumi.Input[str] name: The name of the ESME. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the ESME.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if icon_id is not None:
            pulumi.set(__self__, "icon_id", icon_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the ESME. The length of this value must be in the range [`1`-`512`].
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> Optional[pulumi.Input[str]]:
        """
        The icon id to attach to the ESME.
        """
        return pulumi.get(self, "icon_id")

    @icon_id.setter
    def icon_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ESME. The length of this value must be in the range [`1`-`64`].
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Any tags to assign to the ESME.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ESMEState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 icon_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 send_message_with_generated_otp_api_url: Optional[pulumi.Input[str]] = None,
                 send_message_with_inputted_otp_api_url: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering ESME resources.
        :param pulumi.Input[str] description: The description of the ESME. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[str] icon_id: The icon id to attach to the ESME.
        :param pulumi.Input[str] name: The name of the ESME. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[str] send_message_with_generated_otp_api_url: The API URL for send SMS with generated OTP.
        :param pulumi.Input[str] send_message_with_inputted_otp_api_url: The API URL for send SMS with inputted OTP.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the ESME.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if icon_id is not None:
            pulumi.set(__self__, "icon_id", icon_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if send_message_with_generated_otp_api_url is not None:
            pulumi.set(__self__, "send_message_with_generated_otp_api_url", send_message_with_generated_otp_api_url)
        if send_message_with_inputted_otp_api_url is not None:
            pulumi.set(__self__, "send_message_with_inputted_otp_api_url", send_message_with_inputted_otp_api_url)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the ESME. The length of this value must be in the range [`1`-`512`].
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> Optional[pulumi.Input[str]]:
        """
        The icon id to attach to the ESME.
        """
        return pulumi.get(self, "icon_id")

    @icon_id.setter
    def icon_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ESME. The length of this value must be in the range [`1`-`64`].
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sendMessageWithGeneratedOtpApiUrl")
    def send_message_with_generated_otp_api_url(self) -> Optional[pulumi.Input[str]]:
        """
        The API URL for send SMS with generated OTP.
        """
        return pulumi.get(self, "send_message_with_generated_otp_api_url")

    @send_message_with_generated_otp_api_url.setter
    def send_message_with_generated_otp_api_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "send_message_with_generated_otp_api_url", value)

    @property
    @pulumi.getter(name="sendMessageWithInputtedOtpApiUrl")
    def send_message_with_inputted_otp_api_url(self) -> Optional[pulumi.Input[str]]:
        """
        The API URL for send SMS with inputted OTP.
        """
        return pulumi.get(self, "send_message_with_inputted_otp_api_url")

    @send_message_with_inputted_otp_api_url.setter
    def send_message_with_inputted_otp_api_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "send_message_with_inputted_otp_api_url", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Any tags to assign to the ESME.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class ESME(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 icon_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages a SakuraCloud ESME resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sakuracloud as sakuracloud

        foobar = sakuracloud.ESME("foobar",
            description="description",
            tags=[
                "tag1",
                "tag2",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the ESME. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[str] icon_id: The icon id to attach to the ESME.
        :param pulumi.Input[str] name: The name of the ESME. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the ESME.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ESMEArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a SakuraCloud ESME resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sakuracloud as sakuracloud

        foobar = sakuracloud.ESME("foobar",
            description="description",
            tags=[
                "tag1",
                "tag2",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param ESMEArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ESMEArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 icon_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ESMEArgs.__new__(ESMEArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["icon_id"] = icon_id
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["send_message_with_generated_otp_api_url"] = None
            __props__.__dict__["send_message_with_inputted_otp_api_url"] = None
        super(ESME, __self__).__init__(
            'sakuracloud:index/eSME:ESME',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            icon_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            send_message_with_generated_otp_api_url: Optional[pulumi.Input[str]] = None,
            send_message_with_inputted_otp_api_url: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'ESME':
        """
        Get an existing ESME resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the ESME. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[str] icon_id: The icon id to attach to the ESME.
        :param pulumi.Input[str] name: The name of the ESME. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[str] send_message_with_generated_otp_api_url: The API URL for send SMS with generated OTP.
        :param pulumi.Input[str] send_message_with_inputted_otp_api_url: The API URL for send SMS with inputted OTP.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the ESME.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ESMEState.__new__(_ESMEState)

        __props__.__dict__["description"] = description
        __props__.__dict__["icon_id"] = icon_id
        __props__.__dict__["name"] = name
        __props__.__dict__["send_message_with_generated_otp_api_url"] = send_message_with_generated_otp_api_url
        __props__.__dict__["send_message_with_inputted_otp_api_url"] = send_message_with_inputted_otp_api_url
        __props__.__dict__["tags"] = tags
        return ESME(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the ESME. The length of this value must be in the range [`1`-`512`].
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> pulumi.Output[Optional[str]]:
        """
        The icon id to attach to the ESME.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the ESME. The length of this value must be in the range [`1`-`64`].
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sendMessageWithGeneratedOtpApiUrl")
    def send_message_with_generated_otp_api_url(self) -> pulumi.Output[str]:
        """
        The API URL for send SMS with generated OTP.
        """
        return pulumi.get(self, "send_message_with_generated_otp_api_url")

    @property
    @pulumi.getter(name="sendMessageWithInputtedOtpApiUrl")
    def send_message_with_inputted_otp_api_url(self) -> pulumi.Output[str]:
        """
        The API URL for send SMS with inputted OTP.
        """
        return pulumi.get(self, "send_message_with_inputted_otp_api_url")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Any tags to assign to the ESME.
        """
        return pulumi.get(self, "tags")

