# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseArgs', 'Database']

@pulumi.input_type
class DatabaseArgs:
    def __init__(__self__, *,
                 network_interface: pulumi.Input['DatabaseNetworkInterfaceArgs'],
                 password: pulumi.Input[str],
                 username: pulumi.Input[str],
                 backup: Optional[pulumi.Input['DatabaseBackupArgs']] = None,
                 database_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 icon_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 replica_password: Optional[pulumi.Input[str]] = None,
                 replica_user: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Database resource.
        :param pulumi.Input['DatabaseNetworkInterfaceArgs'] network_interface: An `network_interface` block as defined below.
        :param pulumi.Input[str] password: The password of default user on the database.
        :param pulumi.Input[str] username: The name of default user on the database. The length of this value must be in the range [`3`-`20`]. Changing this forces a new resource to be created.
        :param pulumi.Input['DatabaseBackupArgs'] backup: A `backup` block as defined below.
        :param pulumi.Input[str] database_type: The type of the database. This must be one of [`mariadb`/`postgres`]. Changing this forces a new resource to be created. Default:`postgres`.
        :param pulumi.Input[str] description: The description of the Database. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[str] icon_id: The icon id to attach to the Database.
        :param pulumi.Input[str] name: The name of the Database. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: The map for setting RDBMS-specific parameters. Valid keys can be found with the `usacloud database list-parameters` command.
        :param pulumi.Input[str] plan: The plan name of the Database. This must be one of [`10g`/`30g`/`90g`/`240g`/`500g`/`1t`]. Changing this forces a new resource to be created. Default:`10g`.
        :param pulumi.Input[str] replica_password: The password of user that processing a replication.
        :param pulumi.Input[str] replica_user: The name of user that processing a replication. Default:`replica`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the Database.
        :param pulumi.Input[str] zone: The name of zone that the Database will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "network_interface", network_interface)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if icon_id is not None:
            pulumi.set(__self__, "icon_id", icon_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if replica_password is not None:
            pulumi.set(__self__, "replica_password", replica_password)
        if replica_user is not None:
            pulumi.set(__self__, "replica_user", replica_user)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="networkInterface")
    def network_interface(self) -> pulumi.Input['DatabaseNetworkInterfaceArgs']:
        """
        An `network_interface` block as defined below.
        """
        return pulumi.get(self, "network_interface")

    @network_interface.setter
    def network_interface(self, value: pulumi.Input['DatabaseNetworkInterfaceArgs']):
        pulumi.set(self, "network_interface", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password of default user on the database.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The name of default user on the database. The length of this value must be in the range [`3`-`20`]. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input['DatabaseBackupArgs']]:
        """
        A `backup` block as defined below.
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input['DatabaseBackupArgs']]):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the database. This must be one of [`mariadb`/`postgres`]. Changing this forces a new resource to be created. Default:`postgres`.
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Database. The length of this value must be in the range [`1`-`512`].
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> Optional[pulumi.Input[str]]:
        """
        The icon id to attach to the Database.
        """
        return pulumi.get(self, "icon_id")

    @icon_id.setter
    def icon_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Database. The length of this value must be in the range [`1`-`64`].
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The map for setting RDBMS-specific parameters. Valid keys can be found with the `usacloud database list-parameters` command.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[str]]:
        """
        The plan name of the Database. This must be one of [`10g`/`30g`/`90g`/`240g`/`500g`/`1t`]. Changing this forces a new resource to be created. Default:`10g`.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter(name="replicaPassword")
    def replica_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of user that processing a replication.
        """
        return pulumi.get(self, "replica_password")

    @replica_password.setter
    def replica_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replica_password", value)

    @property
    @pulumi.getter(name="replicaUser")
    def replica_user(self) -> Optional[pulumi.Input[str]]:
        """
        The name of user that processing a replication. Default:`replica`.
        """
        return pulumi.get(self, "replica_user")

    @replica_user.setter
    def replica_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replica_user", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Any tags to assign to the Database.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The name of zone that the Database will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _DatabaseState:
    def __init__(__self__, *,
                 backup: Optional[pulumi.Input['DatabaseBackupArgs']] = None,
                 database_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 icon_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interface: Optional[pulumi.Input['DatabaseNetworkInterfaceArgs']] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 replica_password: Optional[pulumi.Input[str]] = None,
                 replica_user: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Database resources.
        :param pulumi.Input['DatabaseBackupArgs'] backup: A `backup` block as defined below.
        :param pulumi.Input[str] database_type: The type of the database. This must be one of [`mariadb`/`postgres`]. Changing this forces a new resource to be created. Default:`postgres`.
        :param pulumi.Input[str] description: The description of the Database. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[str] icon_id: The icon id to attach to the Database.
        :param pulumi.Input[str] name: The name of the Database. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input['DatabaseNetworkInterfaceArgs'] network_interface: An `network_interface` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: The map for setting RDBMS-specific parameters. Valid keys can be found with the `usacloud database list-parameters` command.
        :param pulumi.Input[str] password: The password of default user on the database.
        :param pulumi.Input[str] plan: The plan name of the Database. This must be one of [`10g`/`30g`/`90g`/`240g`/`500g`/`1t`]. Changing this forces a new resource to be created. Default:`10g`.
        :param pulumi.Input[str] replica_password: The password of user that processing a replication.
        :param pulumi.Input[str] replica_user: The name of user that processing a replication. Default:`replica`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the Database.
        :param pulumi.Input[str] username: The name of default user on the database. The length of this value must be in the range [`3`-`20`]. Changing this forces a new resource to be created.
        :param pulumi.Input[str] zone: The name of zone that the Database will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if icon_id is not None:
            pulumi.set(__self__, "icon_id", icon_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interface is not None:
            pulumi.set(__self__, "network_interface", network_interface)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if replica_password is not None:
            pulumi.set(__self__, "replica_password", replica_password)
        if replica_user is not None:
            pulumi.set(__self__, "replica_user", replica_user)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input['DatabaseBackupArgs']]:
        """
        A `backup` block as defined below.
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input['DatabaseBackupArgs']]):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the database. This must be one of [`mariadb`/`postgres`]. Changing this forces a new resource to be created. Default:`postgres`.
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Database. The length of this value must be in the range [`1`-`512`].
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> Optional[pulumi.Input[str]]:
        """
        The icon id to attach to the Database.
        """
        return pulumi.get(self, "icon_id")

    @icon_id.setter
    def icon_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Database. The length of this value must be in the range [`1`-`64`].
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkInterface")
    def network_interface(self) -> Optional[pulumi.Input['DatabaseNetworkInterfaceArgs']]:
        """
        An `network_interface` block as defined below.
        """
        return pulumi.get(self, "network_interface")

    @network_interface.setter
    def network_interface(self, value: Optional[pulumi.Input['DatabaseNetworkInterfaceArgs']]):
        pulumi.set(self, "network_interface", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The map for setting RDBMS-specific parameters. Valid keys can be found with the `usacloud database list-parameters` command.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of default user on the database.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[str]]:
        """
        The plan name of the Database. This must be one of [`10g`/`30g`/`90g`/`240g`/`500g`/`1t`]. Changing this forces a new resource to be created. Default:`10g`.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter(name="replicaPassword")
    def replica_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of user that processing a replication.
        """
        return pulumi.get(self, "replica_password")

    @replica_password.setter
    def replica_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replica_password", value)

    @property
    @pulumi.getter(name="replicaUser")
    def replica_user(self) -> Optional[pulumi.Input[str]]:
        """
        The name of user that processing a replication. Default:`replica`.
        """
        return pulumi.get(self, "replica_user")

    @replica_user.setter
    def replica_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replica_user", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Any tags to assign to the Database.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The name of default user on the database. The length of this value must be in the range [`3`-`20`]. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The name of zone that the Database will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class Database(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup: Optional[pulumi.Input[pulumi.InputType['DatabaseBackupArgs']]] = None,
                 database_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 icon_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interface: Optional[pulumi.Input[pulumi.InputType['DatabaseNetworkInterfaceArgs']]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 replica_password: Optional[pulumi.Input[str]] = None,
                 replica_user: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a SakuraCloud Database.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sakuracloud as sakuracloud

        config = pulumi.Config()
        username = config.require_object("username")
        password = config.require_object("password")
        replica_password = config.require_object("replicaPassword")
        foobar_switch = sakuracloud.Switch("foobarSwitch")
        foobar_database = sakuracloud.Database("foobarDatabase",
            database_type="mariadb",
            plan="30g",
            username=username,
            password=password,
            replica_password=replica_password,
            network_interface=sakuracloud.DatabaseNetworkInterfaceArgs(
                switch_id=foobar_switch.id,
                ip_address="192.168.11.11",
                netmask=24,
                gateway="192.168.11.1",
                port=3306,
                source_ranges=[
                    "192.168.11.0/24",
                    "192.168.12.0/24",
                ],
            ),
            backup=sakuracloud.DatabaseBackupArgs(
                time="00:00",
                weekdays=[
                    "mon",
                    "tue",
                ],
            ),
            parameters={
                "max_connections": "100",
            },
            description="description",
            tags=[
                "tag1",
                "tag2",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DatabaseBackupArgs']] backup: A `backup` block as defined below.
        :param pulumi.Input[str] database_type: The type of the database. This must be one of [`mariadb`/`postgres`]. Changing this forces a new resource to be created. Default:`postgres`.
        :param pulumi.Input[str] description: The description of the Database. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[str] icon_id: The icon id to attach to the Database.
        :param pulumi.Input[str] name: The name of the Database. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[pulumi.InputType['DatabaseNetworkInterfaceArgs']] network_interface: An `network_interface` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: The map for setting RDBMS-specific parameters. Valid keys can be found with the `usacloud database list-parameters` command.
        :param pulumi.Input[str] password: The password of default user on the database.
        :param pulumi.Input[str] plan: The plan name of the Database. This must be one of [`10g`/`30g`/`90g`/`240g`/`500g`/`1t`]. Changing this forces a new resource to be created. Default:`10g`.
        :param pulumi.Input[str] replica_password: The password of user that processing a replication.
        :param pulumi.Input[str] replica_user: The name of user that processing a replication. Default:`replica`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the Database.
        :param pulumi.Input[str] username: The name of default user on the database. The length of this value must be in the range [`3`-`20`]. Changing this forces a new resource to be created.
        :param pulumi.Input[str] zone: The name of zone that the Database will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a SakuraCloud Database.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sakuracloud as sakuracloud

        config = pulumi.Config()
        username = config.require_object("username")
        password = config.require_object("password")
        replica_password = config.require_object("replicaPassword")
        foobar_switch = sakuracloud.Switch("foobarSwitch")
        foobar_database = sakuracloud.Database("foobarDatabase",
            database_type="mariadb",
            plan="30g",
            username=username,
            password=password,
            replica_password=replica_password,
            network_interface=sakuracloud.DatabaseNetworkInterfaceArgs(
                switch_id=foobar_switch.id,
                ip_address="192.168.11.11",
                netmask=24,
                gateway="192.168.11.1",
                port=3306,
                source_ranges=[
                    "192.168.11.0/24",
                    "192.168.12.0/24",
                ],
            ),
            backup=sakuracloud.DatabaseBackupArgs(
                time="00:00",
                weekdays=[
                    "mon",
                    "tue",
                ],
            ),
            parameters={
                "max_connections": "100",
            },
            description="description",
            tags=[
                "tag1",
                "tag2",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup: Optional[pulumi.Input[pulumi.InputType['DatabaseBackupArgs']]] = None,
                 database_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 icon_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interface: Optional[pulumi.Input[pulumi.InputType['DatabaseNetworkInterfaceArgs']]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 replica_password: Optional[pulumi.Input[str]] = None,
                 replica_user: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseArgs.__new__(DatabaseArgs)

            __props__.__dict__["backup"] = backup
            __props__.__dict__["database_type"] = database_type
            __props__.__dict__["description"] = description
            __props__.__dict__["icon_id"] = icon_id
            __props__.__dict__["name"] = name
            if network_interface is None and not opts.urn:
                raise TypeError("Missing required property 'network_interface'")
            __props__.__dict__["network_interface"] = network_interface
            __props__.__dict__["parameters"] = parameters
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = password
            __props__.__dict__["plan"] = plan
            __props__.__dict__["replica_password"] = replica_password
            __props__.__dict__["replica_user"] = replica_user
            __props__.__dict__["tags"] = tags
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["zone"] = zone
        super(Database, __self__).__init__(
            'sakuracloud:index/database:Database',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup: Optional[pulumi.Input[pulumi.InputType['DatabaseBackupArgs']]] = None,
            database_type: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            icon_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_interface: Optional[pulumi.Input[pulumi.InputType['DatabaseNetworkInterfaceArgs']]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            password: Optional[pulumi.Input[str]] = None,
            plan: Optional[pulumi.Input[str]] = None,
            replica_password: Optional[pulumi.Input[str]] = None,
            replica_user: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            username: Optional[pulumi.Input[str]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'Database':
        """
        Get an existing Database resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DatabaseBackupArgs']] backup: A `backup` block as defined below.
        :param pulumi.Input[str] database_type: The type of the database. This must be one of [`mariadb`/`postgres`]. Changing this forces a new resource to be created. Default:`postgres`.
        :param pulumi.Input[str] description: The description of the Database. The length of this value must be in the range [`1`-`512`].
        :param pulumi.Input[str] icon_id: The icon id to attach to the Database.
        :param pulumi.Input[str] name: The name of the Database. The length of this value must be in the range [`1`-`64`].
        :param pulumi.Input[pulumi.InputType['DatabaseNetworkInterfaceArgs']] network_interface: An `network_interface` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: The map for setting RDBMS-specific parameters. Valid keys can be found with the `usacloud database list-parameters` command.
        :param pulumi.Input[str] password: The password of default user on the database.
        :param pulumi.Input[str] plan: The plan name of the Database. This must be one of [`10g`/`30g`/`90g`/`240g`/`500g`/`1t`]. Changing this forces a new resource to be created. Default:`10g`.
        :param pulumi.Input[str] replica_password: The password of user that processing a replication.
        :param pulumi.Input[str] replica_user: The name of user that processing a replication. Default:`replica`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Any tags to assign to the Database.
        :param pulumi.Input[str] username: The name of default user on the database. The length of this value must be in the range [`3`-`20`]. Changing this forces a new resource to be created.
        :param pulumi.Input[str] zone: The name of zone that the Database will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseState.__new__(_DatabaseState)

        __props__.__dict__["backup"] = backup
        __props__.__dict__["database_type"] = database_type
        __props__.__dict__["description"] = description
        __props__.__dict__["icon_id"] = icon_id
        __props__.__dict__["name"] = name
        __props__.__dict__["network_interface"] = network_interface
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["password"] = password
        __props__.__dict__["plan"] = plan
        __props__.__dict__["replica_password"] = replica_password
        __props__.__dict__["replica_user"] = replica_user
        __props__.__dict__["tags"] = tags
        __props__.__dict__["username"] = username
        __props__.__dict__["zone"] = zone
        return Database(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backup(self) -> pulumi.Output[Optional['outputs.DatabaseBackup']]:
        """
        A `backup` block as defined below.
        """
        return pulumi.get(self, "backup")

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of the database. This must be one of [`mariadb`/`postgres`]. Changing this forces a new resource to be created. Default:`postgres`.
        """
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Database. The length of this value must be in the range [`1`-`512`].
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="iconId")
    def icon_id(self) -> pulumi.Output[Optional[str]]:
        """
        The icon id to attach to the Database.
        """
        return pulumi.get(self, "icon_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Database. The length of this value must be in the range [`1`-`64`].
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterface")
    def network_interface(self) -> pulumi.Output['outputs.DatabaseNetworkInterface']:
        """
        An `network_interface` block as defined below.
        """
        return pulumi.get(self, "network_interface")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The map for setting RDBMS-specific parameters. Valid keys can be found with the `usacloud database list-parameters` command.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        The password of default user on the database.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[Optional[str]]:
        """
        The plan name of the Database. This must be one of [`10g`/`30g`/`90g`/`240g`/`500g`/`1t`]. Changing this forces a new resource to be created. Default:`10g`.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter(name="replicaPassword")
    def replica_password(self) -> pulumi.Output[Optional[str]]:
        """
        The password of user that processing a replication.
        """
        return pulumi.get(self, "replica_password")

    @property
    @pulumi.getter(name="replicaUser")
    def replica_user(self) -> pulumi.Output[Optional[str]]:
        """
        The name of user that processing a replication. Default:`replica`.
        """
        return pulumi.get(self, "replica_user")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Any tags to assign to the Database.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        The name of default user on the database. The length of this value must be in the range [`3`-`20`]. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        The name of zone that the Database will be created. (e.g. `is1a`, `tk1a`). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zone")

