https://www.alarm.com/web/system/assets/customer-site/models/devices/base-device.js
https://www.alarm.com/web/system/assets/customer-site/models/devices/sensor.js

| Device Type         | Property Name                              | Description                                                                                                                                                                                                                                                         |
| ------------------- | ------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Base Device         | animationState                             | The model animation state.                                                                                                                                                                                                                                          |
| Base Device         | batteryLevelNull                           | The current device battery level with null as the default value.                                                                                                                                                                                                    |
| Base Device         | canBeSaved                                 | Does the logged in context have write permissions for this device?                                                                                                                                                                                                  |
| Base Device         | canChangeDescription                       | Can the device description be changed?                                                                                                                                                                                                                              |
| Base Device         | canChangeState                             | Can the state be changed for this device?                                                                                                                                                                                                                           |
| Base Device         | canConfirmStateChange                      | Can the device confirm that its state changed?                                                                                                                                                                                                                      |
| Base Device         | canReceiveCommands                         | Does this device support commands being sent to it?                                                                                                                                                                                                                 |
| Base Device         | criticalBattery                            | Whether the device has a critical battery status.                                                                                                                                                                                                                   |
| Base Device         | description                                | The name of the device on the system.                                                                                                                                                                                                                               |
| Base Device         | desiredState                               | The desired device state.                                                                                                                                                                                                                                           |
| Base Device         | deviceIcon                                 | The icon to present the device.                                                                                                                                                                                                                                     |
| Base Device         | displayDate                                | Returns the display string for the current stateInfo value.                                                                                                                                                                                                         |
| Base Device         | hasPermissionToChangeState                 | Can the logged in login change the state of this device?                                                                                                                                                                                                            |
| Base Device         | isRefreshingState                          | Whether the device is in the refreshing state.                                                                                                                                                                                                                      |
| Base Device         | lowBattery                                 | Whether the device has a low battery status.                                                                                                                                                                                                                        |
| Base Device         | remoteCommandsEnabled                      | Can the device status be changed remotely via app or web?                                                                                                                                                                                                           |
| Base Device         | state                                      | The current device state.                                                                                                                                                                                                                                           |
| Base Device         | stateInfo                                  | Information regarding the current device state.                                                                                                                                                                                                                     |
| Base Device         | stateSubtext                               | The model state subtext for home cards.                                                                                                                                                                                                                             |
| Base Device         | system                                     | The system (unit) that this device belongs to Id.                                                                                                                                                                                                                   |
| Base Light          | canEnableRemoteCommands                    | Can the remote commands be enabled or disabled?                                                                                                                                                                                                                     |
| Base Light          | canEnableStateTracking                     | Can state tracking be enabled for this light?                                                                                                                                                                                                                       |
| Base Light          | hexColor                                   | A hex string representing the currently active color. For decoding this should be used in conjunction with 'lightColorFormat'.                                                                                                                                      |
| Base Light          | isDimmer                                   | Is the light a dimmer?                                                                                                                                                                                                                                              |
| Base Light          | isFavorite                                 | Is the light in the Favorites Group?                                                                                                                                                                                                                                |
| Base Light          | isZWave                                    | Is the light a ZWave device.                                                                                                                                                                                                                                        |
| Base Light          | lightColorFormat                           | The format of the color hex string. This values maps in the LightColorFormat enum. Defaults to "Not Set".                                                                                                                                                           |
| Base Light          | lightGroups                                | Light groups that this light belongs to                                                                                                                                                                                                                             |
| Base Light          | lightLevel                                 | Dimmer value for a dimmer light                                                                                                                                                                                                                                     |
| Base Light          | percentWarmth                              | Represents a percentage from 0-100, the color temperature is between the minimum (cool) and maximum (100% warm) temperatures we support.                                                                                                                            |
| Base Light          | remoteCommandsEnabled                      | Whether remote commands are enabled or not.                                                                                                                                                                                                                         |
| Base Light          | shouldShowFavoritesToggle                  | Should the "Favorites" toggle be shown in the edit light modal?                                                                                                                                                                                                     |
| Base Light          | shouldUpdateMultiLevelState                | Whether or not we should update multilevel state as part of saving this model. Used to avoid turning on a multilevel light when updating non-lighting properties such as device name                                                                                |
| Base Light          | stateTrackingEnabled                       | Is state tracking enabled?                                                                                                                                                                                                                                          |
| Base Light          | supportsColorControl                       | Does it support any color changes?                                                                                                                                                                                                                                  |
| Base Light          | supportsRGBColorControl                    | Does it support RGB color changing?                                                                                                                                                                                                                                 |
| Base Light          | supportsWhiteLightColorControl             | Does it support color temperature changing? (Selecting between variations of white light).                                                                                                                                                                          |
| Base Managed Device | addDeviceResource                          | The add device resource of the device.                                                                                                                                                                                                                              |
| Base Managed Device | associatedCameraDeviceIds                  | { device_id: device_name } for all associated cameras.                                                                                                                                                                                                              |
| Base Managed Device | canAccessAppSettings                       | Can the app settings be accessed?                                                                                                                                                                                                                                   |
| Base Managed Device | canAccessTroubleshootingWizard             | Can the troubleshooting wizard be accessed?                                                                                                                                                                                                                         |
| Base Managed Device | canAccessWebSettings                       | Can the web settings be accessed?                                                                                                                                                                                                                                   |
| Base Managed Device | canBeAssociatedToVideoDevice               | Whether the device type can be associated to video devices.                                                                                                                                                                                                         |
| Base Managed Device | canBeDeleted                               | Can the device be deleted?                                                                                                                                                                                                                                          |
| Base Managed Device | canBeRenamed                               | Can the device be renamed?                                                                                                                                                                                                                                          |
| Base Managed Device | hasState                                   | Does this device have a state?                                                                                                                                                                                                                                      |
| Base Managed Device | isAssignedToCareReceiver                   | Is this mobile device assigned to a care receiver?                                                                                                                                                                                                                  |
| Base Managed Device | isMalfunctioning                           | Is the device currently set to a malfunction state.                                                                                                                                                                                                                 |
| Base Managed Device | isOAuth                                    | Is the device an OAuth device?                                                                                                                                                                                                                                      |
| Base Managed Device | isZWave                                    | Is the device a ZWave device.                                                                                                                                                                                                                                       |
| Base Managed Device | macAddress                                 | The mac address for the device, if available.                                                                                                                                                                                                                       |
| Base Managed Device | managedDeviceType                          | The type of device.                                                                                                                                                                                                                                                 |
| Base Managed Device | manufacturer                               | The manufacturer of the device.                                                                                                                                                                                                                                     |
| Base Managed Device | supportsCommandClassBasic                  | Does the Z-Wave device support CC Basic.                                                                                                                                                                                                                            |
| Base Managed Device | troubleshootingWizard                      | The route where the user can edit the troubleshooting wizard.                                                                                                                                                                                                       |
| Base Managed Device | webSettings                                | The route where the user can edit the device settings on the web.                                                                                                                                                                                                   |
| Identity            | accessControlLockdownEnabled               | Is the log in enrolled in access control?                                                                                                                                                                                                                           |
| Identity            | accessControlMigratedForLockdown           | Has the access control account been migrated to use Lockdown?                                                                                                                                                                                                       |
| Identity            | accessControlRestrictedAccessEnabled       | Is restricted access enabled?                                                                                                                                                                                                                                       |
| Identity            | accountInformation                         | The account information model containing information pertinent to account management.                                                                                                                                                                               |
| Identity            | accountType                                | Account type for the currently selected customer.                                                                                                                                                                                                                   |
| Identity            | applicationBuildNumber                     | The mobile build number, if applicable, based on BuildVersionInfoEnum in the backend.                                                                                                                                                                               |
| Identity            | applicationSessionProperties               | Properties for the application session duration and timeouts.                                                                                                                                                                                                       |
| Identity            | availableRouteItems                        | Available route items for the currently logged in login.                                                                                                                                                                                                            |
| Identity            | canCreateEditArmingSchedules               | Indicates if the end user has the ability to create and edit arming schedules.                                                                                                                                                                                      |
| Identity            | canCreateEditScenes                        | Indicates if the end user has the ability to create and edit scenes.                                                                                                                                                                                                |
| Identity            | canDonateClips                             | If true, users can view and interact with clip donation UI as well as donate clips.                                                                                                                                                                                 |
| Identity            | canEditOnvifSettings                       | If the user has permissions to edit onvif stream settings.                                                                                                                                                                                                          |
| Identity            | canEnableRecordingRulesAfterQuotaReset     | If true, users will have their recording rules re-enabled after quota reset.                                                                                                                                                                                        |
| Identity            | canViewClipUsageReports                    | If the user has permissions to view clip usage reports.                                                                                                                                                                                                             |
| Identity            | canViewKnowledgeBase                       | If the end-user is able to access the knowledge base articles.                                                                                                                                                                                                      |
| Identity            | canViewPeopleUi                            | Does the user have the people ui feature enabled? Note - This will be removed once the people specific routes are ready to be created.                                                                                                                              |
| Identity            | canViewUpdatedClipLimitsUXRefresh          | If the user has permissions see the updated notifications and card on the rules page associated with the clip limits UX refresh (https://jira.corp.adcinternal.com/jira/browse/VID-47927).                                                                          |
| Identity            | clipDonationAgreement                      | Properties relating to clip donation, e.g. whether the user has accepted the VA legal agreement in the past.                                                                                                                                                        |
| Identity            | dealerPath                                 | The dealer path for CSS styles.                                                                                                                                                                                                                                     |
| Identity            | dealerSpritePath                           | The dealer path for SVG sprites.                                                                                                                                                                                                                                    |
| Identity            | enableHomeScreenConfiguration              | Indicates that home screen configuration is allowed.                                                                                                                                                                                                                |
| Identity            | errorReportingConfiguration                | Configuration for client side error reporting.                                                                                                                                                                                                                      |
| Identity            | favIconUrl                                 | FavIcon for the dealer of the currently selected system.                                                                                                                                                                                                            |
| Identity            | hasAccessToNewRuleBuilderDropdown          | Indicates if the customer can access the New Rule Builder dropdown.                                                                                                                                                                                                 |
| Identity            | hasCarrierLookupBeta                       | Does the end-user have the carrier lookup beta permission?                                                                                                                                                                                                          |
| Identity            | hasCopyTemplateAccess                      | Indicates whether we are able to use the login template copying functionality.                                                                                                                                                                                      |
| Identity            | hasEmberEditLocationBeta                   | Indicates if we have the access to the EmberEditLocationBeta.                                                                                                                                                                                                       |
| Identity            | hasEmberEditLocationsAccess                | Indicates if we have the access to the ember edit locations page.                                                                                                                                                                                                   |
| Identity            | hasExistingPlusFutureUsersEnhancementsBeta | Does the end-user have the existing plus future users beta permission?                                                                                                                                                                                              |
| Identity            | hasFamiliarObjectEnrollmentBeta            | Does the end-user have access to the Familiar Object enrollment beta (e.g. Familiar Vehicle)?                                                                                                                                                                       |
| Identity            | hasLoginTemplatesEditAccess                | Does the end-user have access to edit templates on the Login Permission Templates page?                                                                                                                                                                             |
| Identity            | hasMLEGUserAccess                          | Has MLEG user access.                                                                                                                                                                                                                                               |
| Identity            | hasPointCentralUserTypeRevampBeta          | Does the end-user have the PointCentral User Type Revamp beta permission?                                                                                                                                                                                           |
| Identity            | hasPropertyManagementIntegrationEditAccess | Does the end-user have access to edit on the Property Management Integrations page?                                                                                                                                                                                 |
| Identity            | hasTroubleConditionsService                | Should the client run the trouble conditions service?                                                                                                                                                                                                               |
| Identity            | hasUsersPageBulkActionsBeta                | Indicates whether the user has access to the Users Page Bulk Actions beta.                                                                                                                                                                                          |
| Identity            | hasUsersPageQuickFiltersBeta               | Indicates if a user has access to the User Quick Filter beta.                                                                                                                                                                                                       |
| Identity            | isBuilderAccount                           | Is the account from the Builder Channel.                                                                                                                                                                                                                            |
| Identity            | isEscalatedEvents                          | Is this an escalated events session? (Escalated events, like visual verification, allows central station operators to view saved clips and live video, but instead of requiring an alarm from a panel, a user can configure certain recording rules to trigger it.) |
| Identity            | isMobileApp                                | Is the website served as a webview in the mobile app?                                                                                                                                                                                                               |
| Identity            | isMobileTechApp                            | Is the website served as a webview in the mobile tech app?                                                                                                                                                                                                          |
| Identity            | isVisualVerification                       | Is this a visual verification session? (Visual verification is a special version of our customer site that is used by central station operators to view saved clips and live video during an alarm.)                                                                |
| Identity            | isWindowsDevice                            | Is the device a windows device?                                                                                                                                                                                                                                     |
| Identity            | localizeTempUnitsToCelsius                 | Should the client convert temps to Celsius?                                                                                                                                                                                                                         |
| Identity            | loginIsEnterprise                          | Indicates if the current login is an enterprise login.                                                                                                                                                                                                              |
| Identity            | navigation                                 | Navigation structure for the application.                                                                                                                                                                                                                           |
| Identity            | postLoginRedirect                          | If set, the application should redirect to this object after login.                                                                                                                                                                                                 |
| Identity            | profile                                    | The profile model containing information pertinent to the profile portion of the app.                                                                                                                                                                               |
| Identity            | selectedSystem                             | Currently selected system (unit). Even if this is enterprise and a system group is selected, there should be a selected system (unit).                                                                                                                              |
| Identity            | selectedSystemGroup                        | Currently selected system group. If there is no system group selected, this will be null.                                                                                                                                                                           |
| Identity            | supportedDisplayModeFeatures               | List of supported Display Mode features.                                                                                                                                                                                                                            |
| Identity            | supportedNativeBridgeFeatures              | List of supported NativeBridge features.                                                                                                                                                                                                                            |
| Identity            | supportedNativeViewTransitions             | List of native views the app is capable of transitioning to.                                                                                                                                                                                                        |
| Identity            | upcomingAppointmentInfo                    | Contains the information regarding any upcoming appointments for notification display.                                                                                                                                                                              |
| Identity            | viewingParentGroup                         | Are we viewing the parent group level?                                                                                                                                                                                                                              |
| Identity            | wizard                                     | RouteItem for the current page of currently running wizard. Null if there is no wizard.                                                                                                                                                                             |
| Lock                | availableTemporaryAccessCodes              | The number of available Temporary Access Codes that were pushed to the locks on the unit.                                                                                                                                                                           |
| Lock                | canEnableRemoteCommands                    | Can the remote commands be enabled or disabled? (Only for control point locks)                                                                                                                                                                                      |
| Lock                | maxUserCodeLength                          | The maximum user code length this lock supports.                                                                                                                                                                                                                    |
| Lock                | supportsLatchControl                       | Whether the lock supports remotely controlling the latch.                                                                                                                                                                                                           |
| Lock                | supportsScheduledUserCodes                 | Whether the lock supports scheduled user code programming.                                                                                                                                                                                                          |
| Lock                | supportsTemporaryUserCodes                 | Whether the lock supports temporary user code programming.                                                                                                                                                                                                          |
| Lock                | totalTemporaryAccessCodes                  | The total number of Temporary Access Codes that were pushed to the locks.                                                                                                                                                                                           |
| Partition           | canAccessPanelWifi                         | Can this partition access panel-wifi route?                                                                                                                                                                                                                         |
| Partition           | canBypassSensorWhenArmed                   | Indicates the panel supports sending bypass commands when the panel is armed.                                                                                                                                                                                       |
| Partition           | canEnableAlexa                             | Can this partition enable Alexa features?                                                                                                                                                                                                                           |
| Partition           | dealerEnforcesForceBypass                  | Indicates whether to warn the user if a sensor is open while trying to arm the panel.                                                                                                                                                                               |
| Partition           | extendedArmingOptions                      | The extended arming options supported per arming mode.                                                                                                                                                                                                              |
| Partition           | hasOpenBypassableSensors                   | Indicates whether the partition has any open sensors related to "Force Bypass" option.                                                                                                                                                                              |
| Partition           | hasSensorInTroubleCondition                | Indicates whether the partition has any trouble condition related to "Force Bypass" option.                                                                                                                                                                         |
| Partition           | hideForceBypass                            | Indicates whether the force bypass checkbox should be hidden.                                                                                                                                                                                                       |
| Partition           | invalidExtendedArmingOptions               | The extended arming option combinations that are invalid for each arming mode.                                                                                                                                                                                      |
| Partition           | isAlexaEnabled                             | Are Alexa features enabled on this partition?                                                                                                                                                                                                                       |
| Partition           | needsClearIssuesPrompt                     | Should we prompt about present issues before allowing the user to arm?                                                                                                                                                                                              |
| Partition           | partitionId                                | The ID for this partition.                                                                                                                                                                                                                                          |
| Partition           | sensorNamingFormat                         | The allowed device naming format.                                                                                                                                                                                                                                   |
| Partition           | sensors                                    | Sensors for this partition.                                                                                                                                                                                                                                         |
| Partition           | showNewForceBypass                         | Indicates whether we show the new force bypass with new text                                                                                                                                                                                                        |
| Sensor              | deviceRole                                 | Indicates the current role of the sensor.                                                                                                                                                                                                                           |
| Sensor              | isBypassed                                 | Indicates this sensor is bypassed.                                                                                                                                                                                                                                  |
| Sensor              | isFlexIO                                   | Indicates if this sensor is a flex IO sensor.                                                                                                                                                                                                                       |
| Sensor              | isMonitoringEnabled                        | Does the sensor have normal activity monitoring enabled?                                                                                                                                                                                                            |
| Sensor              | openClosedStatus                           | Indicates if this sensor is in an "Open" or "Closed" state.                                                                                                                                                                                                         |
| Sensor              | sensorNamingFormat                         | The allowed sensor naming format.                                                                                                                                                                                                                                   |
| Sensor              | supportsBypass                             | Indicates this sensor supports bypass.                                                                                                                                                                                                                              |
| Sensor              | supportsImmediateBypass                    | Indicates this sensor supports bypass outside an arming event.                                                                                                                                                                                                      |
| Shade               | canEnableRemoteCommands                    | Can the remote commands be enabled or disabled?                                                                                                                                                                                                                     |
| Shade               | canRefreshStatus                           | Whether the device's status can be refreshed.                                                                                                                                                                                                                       |
| Shade               | isDimmer                                   | Whether the device is a dimmer.                                                                                                                                                                                                                                     |
| Shade               | remoteCommandsEnabled                      | Are remote commands enabled?                                                                                                                                                                                                                                        |
| Shade               | shadeLevel                                 | Dimmer value for a shade.                                                                                                                                                                                                                                           |
| Switch              | canTurnOff                                 | Does the logged in context have permission to turn this control point on and off?                                                                                                                                                                                   |
| Switch              | switchType                                 | The type of switch                                                                                                                                                                                                                                                  |
| Temperature Device  | ambientTemp                                | The current temperature reported by the device.                                                                                                                                                                                                                     |
| Temperature Device  | hasRtsIssue                                | Does this device have a Rts issue?                                                                                                                                                                                                                                  |
| Temperature Device  | humidityLevel                              | The current humidity level reported by the device.                                                                                                                                                                                                                  |
| Temperature Device  | isPaired                                   | Is this device paired to another?                                                                                                                                                                                                                                   |
| Temperature Device  | supportsHumidity                           | Whether the device supports humidity.                                                                                                                                                                                                                               |
| Temperature Device  | supportsPairing                            | Does this device support pairing? Does a thermostat support pairing to temperature sensors or does a temperature sensor support pairing to thermostats?                                                                                                             |
| Temperature Device  | tempForwardingActive                       | Is this device's temperature currently being used to drive itself or another device?                                                                                                                                                                                |
| Thermostat          | activeSensors                              | The collection of sensors (including the thermostat) that are currently driving the HVAC system.                                                                                                                                                                    |
| Thermostat          | autoSetpointBuffer                         | The minimum buffer between the heat and cool setpoints.                                                                                                                                                                                                             |
| Thermostat          | awayCoolSetpoint                           | The away preset cool setpoint.                                                                                                                                                                                                                                      |
| Thermostat          | awayHeatSetpoint                           | The away preset heat setpoint.                                                                                                                                                                                                                                      |
| Thermostat          | boilerControlSystem                        | The boiler control system this device belongs to.                                                                                                                                                                                                                   |
| Thermostat          | controlledThermostats                      | The thermostats that this thermostat controls                                                                                                                                                                                                                       |
| Thermostat          | coolRtsPresets                             | The paired RTS devices on cool mode, separated by setpoint.                                                                                                                                                                                                         |
| Thermostat          | coolSetpoint                               | The current cool setpoint.                                                                                                                                                                                                                                          |
| Thermostat          | desiredCoolSetpoint                        | The desired cool setpoint.                                                                                                                                                                                                                                          |
| Thermostat          | desiredFanMode                             | The desired fan mode.                                                                                                                                                                                                                                               |
| Thermostat          | desiredHeatSetpoint                        | The desired heat setpoint.                                                                                                                                                                                                                                          |
| Thermostat          | desiredLocalDisplayLockingMode             | The desired local display locking mode.                                                                                                                                                                                                                             |
| Thermostat          | fanDuration                                | The duration to run the fan. Only used to offset the commands.                                                                                                                                                                                                      |
| Thermostat          | fanMode                                    | The current fan mode.                                                                                                                                                                                                                                               |
| Thermostat          | forwardingAmbientTemp                      | The current temperature including any additional temperature sensor averaging.                                                                                                                                                                                      |
| Thermostat          | hasDirtySetpoint                           | Does the thermostat have a setpoint that is currently being changed?                                                                                                                                                                                                |
| Thermostat          | hasPendingSetpointChange                   | Does the thermostat have a pending setpoint change?                                                                                                                                                                                                                 |
| Thermostat          | hasPendingTempModeChange                   | Does the thermostat have a pending temp mode change?                                                                                                                                                                                                                |
| Thermostat          | hasRtsIssue                                | Indicates an issue with RTS forwarding.                                                                                                                                                                                                                             |
| Thermostat          | heatRtsPresets                             | The paired RTS devices on heat mode, separated by setpoint.                                                                                                                                                                                                         |
| Thermostat          | heatSetpoint                               | The current heat setpoint.                                                                                                                                                                                                                                          |
| Thermostat          | homeCoolSetpoint                           | The home preset cool setpoint.                                                                                                                                                                                                                                      |
| Thermostat          | homeHeatSetpoint                           | The home preset heat setpoint.                                                                                                                                                                                                                                      |
| Thermostat          | inferredState                              | The mode we think the thermostat is using when in auto mode (auto heat or auto cool)                                                                                                                                                                                |
| Thermostat          | isControlled                               | Whether the thermostat is controlled by another thermostat.                                                                                                                                                                                                         |
| Thermostat          | isPoolController                           | Whether the thermostat is a pool controller.                                                                                                                                                                                                                        |
| Thermostat          | localDisplayLockingMode                    | The current local display locking mode.                                                                                                                                                                                                                             |
| Thermostat          | maxAuxHeatSetpoint                         | The max valid aux heat setpoint.                                                                                                                                                                                                                                    |
| Thermostat          | maxCoolSetpoint                            | The max valid cool setpoint.                                                                                                                                                                                                                                        |
| Thermostat          | maxHeatSetpoint                            | The max valid heat setpoint.                                                                                                                                                                                                                                        |
| Thermostat          | minAuxHeatSetpoint                         | The min valid aux heat setpoint.                                                                                                                                                                                                                                    |
| Thermostat          | minCoolSetpoint                            | The min valid cool setpoint.                                                                                                                                                                                                                                        |
| Thermostat          | minHeatSetpoint                            | The min valid heat setpoint.                                                                                                                                                                                                                                        |
| Thermostat          | peakProtect                                | The Peak Protect                                                                                                                                                                                                                                                    |
| Thermostat          | pendingStateChanges                        | Property that contains state changes to be committed                                                                                                                                                                                                                |
| Thermostat          | remoteTemperatureSensors                   | The remote temperature sensors associated with the thermostat.                                                                                                                                                                                                      |
| Thermostat          | requiresSetup                              | Does the thermostat require a setup wizard to be run before being used?                                                                                                                                                                                             |
| Thermostat          | ruleSuggestions                            | An array of rule alerts for this thermostat.                                                                                                                                                                                                                        |
| Thermostat          | scheduleIconName                           | The name for the schedule icon.                                                                                                                                                                                                                                     |
| Thermostat          | scheduleMode                               | The schedule mode.                                                                                                                                                                                                                                                  |
| Thermostat          | setpointOffset                             | The amount to increment or decrement the setpoint by when changing it.                                                                                                                                                                                              |
| Thermostat          | sleepCoolSetpoint                          | The sleep preset cool setpoint.                                                                                                                                                                                                                                     |
| Thermostat          | sleepHeatSetpoint                          | The sleep preset heat setpoint.                                                                                                                                                                                                                                     |
| Thermostat          | supportedFanDurations                      | The fan mode durations that the thermostat supports                                                                                                                                                                                                                 |
| Thermostat          | supportsAutoMode                           | Whether the thermostat supports the auto temp mode.                                                                                                                                                                                                                 |
| Thermostat          | supportsAuxHeatMode                        | Whether the thermostat supports the aux heat temp mode.                                                                                                                                                                                                             |
| Thermostat          | supportsCirculateFanModeAlways             | Whether the thermostat supports the circulate fan mode regardless of temp mode.                                                                                                                                                                                     |
| Thermostat          | supportsCirculateFanModeWhenOff            | Whether the thermostat supports the circulate fan mode when in OFF mode.                                                                                                                                                                                            |
| Thermostat          | supportsCoolMode                           | Whether the thermostat supports the cool temp mode.                                                                                                                                                                                                                 |
| Thermostat          | supportsFanMode                            | Whether the thermostat supports fan mode control.                                                                                                                                                                                                                   |
| Thermostat          | supportsHeatMode                           | Whether the thermostat supports the heat temp mode.                                                                                                                                                                                                                 |
| Thermostat          | supportsHvacAnalytics                      | Whether the thermostat supports HVAC Analytics.                                                                                                                                                                                                                     |
| Thermostat          | supportsIndefiniteFanOn                    | Whether the thermostat supports running the fan indefinitely.                                                                                                                                                                                                       |
| Thermostat          | supportsLocalDisplayLocking                | Whether the thermostat supports local display locking.                                                                                                                                                                                                              |
| Thermostat          | supportsOffMode                            | Whether the thermostat supports the off temp mode.                                                                                                                                                                                                                  |
| Thermostat          | supportsPartialLocalDisplayLocking         | Whether the thermostat supports partial local display locking.                                                                                                                                                                                                      |
| Thermostat          | supportsSchedules                          | Whether the thermostat supports schedules.                                                                                                                                                                                                                          |
| Thermostat          | supportsSetpoints                          | Whether the thermostat supports setpoints.                                                                                                                                                                                                                          |
| Thermostat          | supportsSmartSchedules                     | Whether the thermostat supports the Smart Schedule mode.                                                                                                                                                                                                            |
| Thermostat          | supportsThirdPartySettings                 | Whether the thermostat supports third party settings.                                                                                                                                                                                                               |
| Thermostat          | thermostatSettingsTemplate                 | The thermostat settings template applied to this thermostat.                                                                                                                                                                                                        |
| Thermostat          | thirdPartySettingsUrl                      | The URL for third party settings.                                                                                                                                                                                                                                   |
| Thermostat          | thirdPartySettingsUrlDesc                  | The description for third party settings URL.                                                                                                                                                                                                                       |
| Thermostat          | valveSwitches                              | The valve switches associated with the thermostat.                                                                                                                                                                                                                  |
| Water Sensor        | sensorNamingFormat                         | The allowed device naming format.                                                                                                                                                                                                                                   |



| Device              | Inherits from                    | Enums                                                                       |
| ------------------- | -------------------------------- | --------------------------------------------------------------------------- |
| Base Device         |                                  |                                                                             |
| Base Light          | Base Device, Base Managed Device | LightStatus,LightColorFormat                                                |
| Base Managed Device | Base Device                      | LightStatus                                                                 |
| Lock                | Base Managed Device              | LockStatus                                                                  |
| Partition           | Base Managed Device              | ArmingState, ArmingOption                                                   |
| Sensor              | Base Managed Device              | SensorStatus, EventType, DeviceType, DeviceRole                             |
| Shade               | Base Device, Base Managed Device | ShadeStatus                                                                 |
| Switch              | Base Device                      | ControlPointRelayStatus                                                     |
| Temperature Device  | Base Device, Base Managed Device |                                                                             |
| Thermostat          | Base Device, Temperature Device  | ThermostatStatus, ThermostatFanMode, ThermostatLock, ThermostatSetpointType |
| Water Sensor        | Base Managed Device              | SensorStatus                                                                |



Create a Python dataclasses called Base Device that contains all of the attributes in the first table in this document. Set all data types to str.
