import asyncio
from .builds import Builds as Builds
from .exceptions import JenkinsError as JenkinsError, JenkinsNotFoundError as JenkinsNotFoundError
from .jobs import Jobs as Jobs
from .nodes import Nodes as Nodes
from .plugins import Plugins as Plugins
from .views import Views as Views
from aiohttp import ClientResponse as ClientResponse
from typing import Any, Optional, Tuple

JenkinsVersion: Any

class RetryClientSession:
    total: Any
    factor: Any
    statuses: Any
    session: Any
    def __init__(self, loop: Optional[asyncio.AbstractEventLoop], options: dict) -> None: ...
    async def request(self, *args: Any, **kwargs: Any) -> ClientResponse: ...
    async def close(self) -> None: ...

class Jenkins:
    host: Any
    loop: Any
    verify: Any
    retry: Any
    auth: Any
    timeout: Any
    crumb: Any
    builds: Any
    jobs: Any
    nodes: Any
    plugins: Any
    views: Any
    def __init__(self, host: str, login: Optional[str] = ..., password: Optional[str] = ..., *, loop: Optional[asyncio.AbstractEventLoop] = ..., verify: bool = ..., timeout: Optional[float] = ..., retry: Optional[dict] = ...) -> None: ...
    async def close(self) -> None: ...
    async def get_status(self) -> dict: ...
    async def get_version(self) -> JenkinsVersion: ...
    async def is_ready(self) -> bool: ...
    async def wait_until_ready(self, sleep_interval_sec: float = ...) -> None: ...
    async def quiet_down(self) -> None: ...
    async def cancel_quiet_down(self) -> None: ...
    async def restart(self) -> None: ...
    async def safe_restart(self) -> None: ...
    async def generate_token(self, name: str) -> Tuple[str, str]: ...
    async def revoke_token(self, token_uuid: str) -> None: ...
    async def run_groovy_script(self, script: str) -> str: ...
