LaPros
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

## Install

`pip install -U lapros`

## How to use

LaPros works with classifiers. It ranks the suspicious labels given
probabilies by some classification model. You can use normal Python
lists, Numpy arrays or Pandas data. Return values are in a Numpy array
or a Pandas series, the larger the value, the more suspicious are the
coresponding labels.

``` python
from lapros import suspect
```

------------------------------------------------------------------------

### suspect

Rank the suspicious labels given probas from a classifier. Accept numpy
arrays, pandas dataframes and series, and normal Python lists.

Params:

-   probas: Array of shape n x m, probabilites for possible classes.
-   labels: Array of shape n x 1, observed class labels

We can use interger, string or even float labels, given that the
probability dataframe’s columns are indexed by the same label set.

Return

-   a pandas DataFrame of one column, the magnitude of suspicious
    labels, valued between \[0, 1\], the larger the more suspicious. The
    index of the DataFrame indicates the index of suspicious samples.

``` python
labels = [1, 0, 0, 1, 1];
```

``` python
probas = [
    #
    [0.5, 0.6, 0.7, 0.8, 0.9],
    [0.5, 0.4, 0.3, 0.2, 0.1],
];
```

``` python
suspect(
    probas,
    labels=labels,
)
```

<div>
<style scoped>
    .dataframe tbody tr th:only-of-type {
        vertical-align: middle;
    }

    .dataframe tbody tr th {
        vertical-align: top;
    }

    .dataframe thead th {
        text-align: right;
    }
</style>
<table border="1" class="dataframe">
  <thead>
    <tr style="text-align: right;">
      <th></th>
      <th>err</th>
    </tr>
    <tr>
      <th>id</th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>1</th>
      <td>0.566667</td>
    </tr>
    <tr>
      <th>2</th>
      <td>0.066667</td>
    </tr>
  </tbody>
</table>
</div>
