# chkp-harmony-endpoint-management-sdk.generated.saas
<p>Harmony Endpoint offers a new web management interface for cloud users. By using the api, you will setup a virtual Endpoint management service in the cloud to manage policies and deployments for Harmony Endpoint agents.</p><p>The following documentation provides the operations supported by the Harmony Endpoint's Cloud API.</p><p>To use the Harmony Endpoint Cloud API service:</p><ol><li><p>Login as user to infinity portal, Using the Authenticate API .</p></li><li><p>Authenticate using the&nbsp;<a href='https://app.swaggerhub.com/apis-docs/Check-Point/infinity-portal-api/1.0.1#/Authentication/post_auth_userl' rel='noopener noreferrer'>Infinity Portal Authentication Service</a>, making sure to select the correct Infinity Portal API Server for the geographic region of your tenant.</p></li><li><p>Include the resulting <em>csrf </em>in the <em>'x-access-token' </em>header and the 'cloudinfra' cookie in every request made to the API service.</p></li><li><p>Call the Mssp Login API</p></li><li>Include return token in 'x-mgmt-mssp-session'&nbsp;in every request made to the API service.</li></ol><p><strong>* notice mssp session will expired after 5min you can use the keep-alive api to extend it.</strong></p><p>&nbsp;</p><p><strong>please use base path for the api's according to your tenant region:</strong></p><table style='height: 108px; width: 100%; border-collapse: collapse;' border='1'><tbody><tr style='height: 18px;'><td style='width: 50%; height: 18px; background: #4795d9'><strong>Region</strong></td><td style='width: 50%; height: 18px; background: #4795d9'><strong>Base Path</strong></td></tr><tr style='height: 18px;'><td style='width: 50%; height: 18px;'>EU</td><td style='width: 50%; height: 18px;'>https://cloudinfra-gw.portal.checkpoint.com</td></tr><tr style='height: 18px;'><td style='width: 50%; height: 18px;'>US</td><td style='width: 50%; height: 18px;'>https://cloudinfra-gw-us.portal.checkpoint.com</td></tr><tr style='height: 18px;'><td style='width: 50%; height: 18px;'>AP</td><td style='width: 50%; height: 18px;'>https://cloudinfra-gw.ap.portal.checkpoint.com</td></tr><tr style='height: 18px;'><td style='width: 50%; height: 18px;'>IN</td><td style='width: 50%; height: 18px;'>https://cloudinfra-gw.in.portal.checkpoint.com</td></tr><tr style='height: 18px;'><td style='width: 50%; height: 18px;'>UK</td><td style='width: 50%; height: 18px;'>https://cloudinfra-gw.uk.portal.checkpoint.com</td></tr></tbody></table><br><br>

The `chkp_harmony_endpoint_management_sdk.generated.saas` package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.626
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python &gt;&#x3D;3.7

## Installation & Usage

This python library package is generated without supporting files like setup.py or requirements files

To be able to use it, you will need these dependencies in your own package that uses this library:

* urllib3 >= 1.15
* certifi
* python-dateutil

## Getting Started

In your own code, to use this library to connect and interact with chkp-harmony-endpoint-management-sdk.generated.saas,
you can run the following:

```python

import time
import chkp_harmony_endpoint_management_sdk.generated.saas
from pprint import pprint
from chkp_harmony_endpoint_management_sdk.generated.saas.apis.tags import manage_session_api
from chkp_harmony_endpoint_management_sdk.generated.saas.model.forbidden_error_example import ForbiddenErrorExample
from chkp_harmony_endpoint_management_sdk.generated.saas.model.internal_error_example import InternalErrorExample
from chkp_harmony_endpoint_management_sdk.generated.saas.model.login_status_response import LoginStatusResponse
from chkp_harmony_endpoint_management_sdk.generated.saas.model.unauthorized_error_example import UnauthorizedErrorExample
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = chkp_harmony_endpoint_management_sdk.generated.saas.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: cloudInfraJwt
configuration.api_key['cloudInfraJwt'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['cloudInfraJwt'] = 'Bearer'

# Configure API key authorization: msspSession
configuration.api_key['msspSession'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['msspSession'] = 'Bearer'

# Enter a context with an instance of the API client
with chkp_harmony_endpoint_management_sdk.generated.saas.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = manage_session_api.ManageSessionApi(api_client)
    
    try:
        api_response = api_instance.public_mssp_keep_alive()
        pprint(api_response)
    except chkp_harmony_endpoint_management_sdk.generated.saas.ApiException as e:
        print("Exception when calling ManageSessionApi->public_mssp_keep_alive: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ManageSessionApi* | [**public_mssp_keep_alive**](chkp_harmony_endpoint_management_sdk/generated/saas/docs/apis/tags/ManageSessionApi.md#public_mssp_keep_alive) | **post** /public/mssp/v1/session/keep-alive | 
*ManageSessionApi* | [**public_mssp_login**](chkp_harmony_endpoint_management_sdk/generated/saas/docs/apis/tags/ManageSessionApi.md#public_mssp_login) | **post** /public/mssp/v1/session/login | 
*MsspServiceApi* | [**deploy_endpoint_instance**](chkp_harmony_endpoint_management_sdk/generated/saas/docs/apis/tags/MsspServiceApi.md#deploy_endpoint_instance) | **post** /public/mssp/v1/service/deploy | 
*MsspServiceApi* | [**manage_endpoint_instance**](chkp_harmony_endpoint_management_sdk/generated/saas/docs/apis/tags/MsspServiceApi.md#manage_endpoint_instance) | **post** /public/mssp/v1/service/operation | 
*MsspServiceApi* | [**tenants_status**](chkp_harmony_endpoint_management_sdk/generated/saas/docs/apis/tags/MsspServiceApi.md#tenants_status) | **get** /public/mssp/v1/service/status | 
*MsspServiceApi* | [**terminate_endpoint_instance**](chkp_harmony_endpoint_management_sdk/generated/saas/docs/apis/tags/MsspServiceApi.md#terminate_endpoint_instance) | **post** /public/mssp/v1/service/terminate | 
*OperationalApi* | [**public_mssp_operational**](chkp_harmony_endpoint_management_sdk/generated/saas/docs/apis/tags/OperationalApi.md#public_mssp_operational) | **get** /public/mssp/v1/operational | 
*OperationalApi* | [**public_mssp_trends_connected_clients**](chkp_harmony_endpoint_management_sdk/generated/saas/docs/apis/tags/OperationalApi.md#public_mssp_trends_connected_clients) | **post** /public/mssp/v1/operational/trends/connected | 
*SelfServiceApi* | [**public_deploy_single_endpoint_instance**](chkp_harmony_endpoint_management_sdk/generated/saas/docs/apis/tags/SelfServiceApi.md#public_deploy_single_endpoint_instance) | **post** /public/v1/self-service/deploy | 
*SelfServiceApi* | [**public_machines_single_status**](chkp_harmony_endpoint_management_sdk/generated/saas/docs/apis/tags/SelfServiceApi.md#public_machines_single_status) | **get** /public/v1/self-service/status | 
*SelfServiceApi* | [**public_terminate_single_endpoint_instance**](chkp_harmony_endpoint_management_sdk/generated/saas/docs/apis/tags/SelfServiceApi.md#public_terminate_single_endpoint_instance) | **delete** /public/v1/self-service/terminate/{machineId} | 

## Documentation For Models

 - [AMUpdateOn](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/AMUpdateOn.md)
 - [ActiveMachinesInfo](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/ActiveMachinesInfo.md)
 - [AlertDefinitionType](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/AlertDefinitionType.md)
 - [AlertMailSettings](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/AlertMailSettings.md)
 - [AlertNotificationSettings](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/AlertNotificationSettings.md)
 - [AlertState](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/AlertState.md)
 - [AlertStatus](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/AlertStatus.md)
 - [AlertThresholdSettings](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/AlertThresholdSettings.md)
 - [AlertThresholdType](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/AlertThresholdType.md)
 - [AntiMalwareUpdateStatus](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/AntiMalwareUpdateStatus.md)
 - [ClientVersions](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/ClientVersions.md)
 - [CountTrend](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/CountTrend.md)
 - [CountTrendDataPoint](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/CountTrendDataPoint.md)
 - [CountTrendPeriod](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/CountTrendPeriod.md)
 - [DayRange](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/DayRange.md)
 - [DeployMachinesInput](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/DeployMachinesInput.md)
 - [DeploymentInput](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/DeploymentInput.md)
 - [DeploymentSingleInput](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/DeploymentSingleInput.md)
 - [DeploymentStatusReal](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/DeploymentStatusReal.md)
 - [DevicesType](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/DevicesType.md)
 - [EmonView](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/EmonView.md)
 - [EndpointStatus](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/EndpointStatus.md)
 - [EndpointTarget](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/EndpointTarget.md)
 - [ErrorSource](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/ErrorSource.md)
 - [ErrorSourceClient](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/ErrorSourceClient.md)
 - [ErrorSourceUnknown](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/ErrorSourceUnknown.md)
 - [ErrorTypes](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/ErrorTypes.md)
 - [ErrorTypesGeneric](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/ErrorTypesGeneric.md)
 - [ErrorTypesGenericForbidden](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/ErrorTypesGenericForbidden.md)
 - [ErrorTypesGenericUnauthorized](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/ErrorTypesGenericUnauthorized.md)
 - [FdePrebootStatus](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/FdePrebootStatus.md)
 - [FdeStatus](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/FdeStatus.md)
 - [ForbiddenErrorExample](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/ForbiddenErrorExample.md)
 - [HealthStatus](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/HealthStatus.md)
 - [InternalErrorExample](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/InternalErrorExample.md)
 - [KeyNumericValuePair](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/KeyNumericValuePair.md)
 - [LastConnection](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/LastConnection.md)
 - [LocalizableString](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/LocalizableString.md)
 - [LocalizableStringArgs](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/LocalizableStringArgs.md)
 - [LoginStatusResponse](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/LoginStatusResponse.md)
 - [MSSPStatus](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/MSSPStatus.md)
 - [ManageMachinesResponse](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/ManageMachinesResponse.md)
 - [ManageTenantEndpointServerAction](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/ManageTenantEndpointServerAction.md)
 - [MsspDeploymentOverview](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/MsspDeploymentOverview.md)
 - [OSInfo](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/OSInfo.md)
 - [OsAndTypeInfo](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/OsAndTypeInfo.md)
 - [OverviewAlert](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/OverviewAlert.md)
 - [OverviewAlertDynamicTag](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/OverviewAlertDynamicTag.md)
 - [OverviewAlertSeverity](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/OverviewAlertSeverity.md)
 - [PortalGeneralResponse](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/PortalGeneralResponse.md)
 - [PublicMachineStatusResponse](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/PublicMachineStatusResponse.md)
 - [PublicManageEndpointsInput](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/PublicManageEndpointsInput.md)
 - [PublicMsspStructureAndMachinesInfo](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/PublicMsspStructureAndMachinesInfo.md)
 - [PublicServiceInfo](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/PublicServiceInfo.md)
 - [PublicServiceInfoLight](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/PublicServiceInfoLight.md)
 - [StatusCodes](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/StatusCodes.md)
 - [SupportedLoginRole](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/SupportedLoginRole.md)
 - [TenantOverview](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/TenantOverview.md)
 - [TenantTrendsOverview](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/TenantTrendsOverview.md)
 - [TenantType](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/TenantType.md)
 - [TenantsOverviewInfo](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/TenantsOverviewInfo.md)
 - [TenantsTrendsResponse](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/TenantsTrendsResponse.md)
 - [TerminateMachinesInput](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/TerminateMachinesInput.md)
 - [UnauthorizedErrorExample](chkp_harmony_endpoint_management_sdk/generated/saas/docs/models/UnauthorizedErrorExample.md)

## Documentation For Authorization

Authentication schemes defined for the API:
<a id="cloudInfraJwt"></a>
### cloudInfraJwt

- **Type**: API key
- **API key parameter name**: x-access-token
- **Location**: HTTP header

<a id="msspSession"></a>
### msspSession

- **Type**: API key
- **API key parameter name**: x-mgmt-mssp-session
- **Location**: HTTP header


## Author

harmony-endpoint-external-api@checkpoint.com
harmony-endpoint-external-api@checkpoint.com
harmony-endpoint-external-api@checkpoint.com
harmony-endpoint-external-api@checkpoint.com

## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in chkp_harmony_endpoint_management_sdk.generated.saas.apis and chkp_harmony_endpoint_management_sdk.generated.saas.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from chkp_harmony_endpoint_management_sdk.generated.saas.apis.default_api import DefaultApi`
- `from chkp_harmony_endpoint_management_sdk.generated.saas.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import chkp_harmony_endpoint_management_sdk.generated.saas
from chkp_harmony_endpoint_management_sdk.generated.saas.apis import *
from chkp_harmony_endpoint_management_sdk.generated.saas.models import *
```
