# coding: utf-8

# GTO-MO-1-1 - Removed partial_header
# flake8: noqa

from datetime import date, datetime
import decimal
import functools
import io
import re
import typing
import typing_extensions
import uuid

import frozendict

from chkp_harmony_endpoint_management_sdk.generated.saas import schemas


class OverviewAlert(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    class MetaOapg:
        required = {
            "thresholdsSettings",
            "localizableDescription",
            "id",
            "currentState",
            "mailSettings",
            "type",
            "notificationSettings",
        }
        
        class properties:
            id = schemas.StrSchema
        
            @staticmethod
            def type() -> typing.Type['AlertDefinitionType']:
                return AlertDefinitionType
        
            @staticmethod
            def localizableDescription() -> typing.Type['LocalizableString']:
                return LocalizableString
        
            @staticmethod
            def currentState() -> typing.Type['AlertState']:
                return AlertState
        
            @staticmethod
            def thresholdsSettings() -> typing.Type['AlertThresholdSettings']:
                return AlertThresholdSettings
        
            @staticmethod
            def notificationSettings() -> typing.Type['AlertNotificationSettings']:
                return AlertNotificationSettings
        
            @staticmethod
            def mailSettings() -> typing.Type['AlertMailSettings']:
                return AlertMailSettings
            __annotations__ = {
                "id": id,
                "type": type,
                "localizableDescription": localizableDescription,
                "currentState": currentState,
                "thresholdsSettings": thresholdsSettings,
                "notificationSettings": notificationSettings,
                "mailSettings": mailSettings,
            }
        additional_properties = schemas.NotAnyTypeSchema
    
    thresholdsSettings: 'AlertThresholdSettings'
    localizableDescription: 'LocalizableString'
    id: MetaOapg.properties.id
    currentState: 'AlertState'
    mailSettings: 'AlertMailSettings'
    type: 'AlertDefinitionType'
    notificationSettings: 'AlertNotificationSettings'
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["thresholdsSettings"]) -> 'AlertThresholdSettings': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["localizableDescription"]) -> 'LocalizableString': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["currentState"]) -> 'AlertState': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["mailSettings"]) -> 'AlertMailSettings': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["type"]) -> 'AlertDefinitionType': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["notificationSettings"]) -> 'AlertNotificationSettings': ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["thresholdsSettings"], typing_extensions.Literal["localizableDescription"], typing_extensions.Literal["id"], typing_extensions.Literal["currentState"], typing_extensions.Literal["mailSettings"], typing_extensions.Literal["type"], typing_extensions.Literal["notificationSettings"], ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["thresholdsSettings"]) -> 'AlertThresholdSettings': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["localizableDescription"]) -> 'LocalizableString': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["currentState"]) -> 'AlertState': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["mailSettings"]) -> 'AlertMailSettings': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["type"]) -> 'AlertDefinitionType': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["notificationSettings"]) -> 'AlertNotificationSettings': ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["thresholdsSettings"], typing_extensions.Literal["localizableDescription"], typing_extensions.Literal["id"], typing_extensions.Literal["currentState"], typing_extensions.Literal["mailSettings"], typing_extensions.Literal["type"], typing_extensions.Literal["notificationSettings"], ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        thresholdsSettings: 'AlertThresholdSettings',
        localizableDescription: 'LocalizableString',
        id: typing.Union[MetaOapg.properties.id, str, ],
        currentState: 'AlertState',
        mailSettings: 'AlertMailSettings',
        type: 'AlertDefinitionType',
        notificationSettings: 'AlertNotificationSettings',
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'OverviewAlert':
        return super().__new__(
            cls,
            *_args,
            thresholdsSettings=thresholdsSettings,
            localizableDescription=localizableDescription,
            id=id,
            currentState=currentState,
            mailSettings=mailSettings,
            type=type,
            notificationSettings=notificationSettings,
            _configuration=_configuration,
        )

from chkp_harmony_endpoint_management_sdk.generated.saas.model.alert_definition_type import AlertDefinitionType
from chkp_harmony_endpoint_management_sdk.generated.saas.model.alert_mail_settings import AlertMailSettings
from chkp_harmony_endpoint_management_sdk.generated.saas.model.alert_notification_settings import AlertNotificationSettings
from chkp_harmony_endpoint_management_sdk.generated.saas.model.alert_state import AlertState
from chkp_harmony_endpoint_management_sdk.generated.saas.model.alert_threshold_settings import AlertThresholdSettings
from chkp_harmony_endpoint_management_sdk.generated.saas.model.localizable_string import LocalizableString
