# coding: utf-8

# GTO-MO-1-1 - Removed partial_header
# flake8: noqa

from datetime import date, datetime
import decimal
import functools
import io
import re
import typing
import typing_extensions
import uuid

import frozendict

from chkp_harmony_endpoint_management_sdk.generated.saas import schemas


class MsspDeploymentOverview(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    class MetaOapg:
        required = {
            "alerts",
            "deploymentStatus",
            "healthStatus",
            "endpointStatus",
            "fdeStatus",
            "antiMalwareUpdateStatus",
            "fdePrebootStatus",
        }
        
        class properties:
        
            @staticmethod
            def endpointStatus() -> typing.Type['EndpointStatus']:
                return EndpointStatus
        
            @staticmethod
            def antiMalwareUpdateStatus() -> typing.Type['AntiMalwareUpdateStatus']:
                return AntiMalwareUpdateStatus
        
            @staticmethod
            def deploymentStatus() -> typing.Type['DeploymentStatusReal']:
                return DeploymentStatusReal
        
            @staticmethod
            def healthStatus() -> typing.Type['HealthStatus']:
                return HealthStatus
        
            @staticmethod
            def fdeStatus() -> typing.Type['FdeStatus']:
                return FdeStatus
        
            @staticmethod
            def fdePrebootStatus() -> typing.Type['FdePrebootStatus']:
                return FdePrebootStatus
            
            
            class alerts(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['OverviewAlert']:
                        return OverviewAlert
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple['OverviewAlert'], typing.List['OverviewAlert']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'alerts':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'OverviewAlert':
                    return super().__getitem__(i)
        
            @staticmethod
            def clientVersions() -> typing.Type['ClientVersions']:
                return ClientVersions
        
            @staticmethod
            def osInfo() -> typing.Type['OSInfo']:
                return OSInfo
        
            @staticmethod
            def osAndTypeInfo() -> typing.Type['OsAndTypeInfo']:
                return OsAndTypeInfo
        
            @staticmethod
            def amUpdateOn() -> typing.Type['AMUpdateOn']:
                return AMUpdateOn
        
            @staticmethod
            def lastConnection() -> typing.Type['LastConnection']:
                return LastConnection
        
            @staticmethod
            def devicesType() -> typing.Type['DevicesType']:
                return DevicesType
        
            @staticmethod
            def activeMachines() -> typing.Type['ActiveMachinesInfo']:
                return ActiveMachinesInfo
        
            @staticmethod
            def viewType() -> typing.Type['EmonView']:
                return EmonView
            __annotations__ = {
                "endpointStatus": endpointStatus,
                "antiMalwareUpdateStatus": antiMalwareUpdateStatus,
                "deploymentStatus": deploymentStatus,
                "healthStatus": healthStatus,
                "fdeStatus": fdeStatus,
                "fdePrebootStatus": fdePrebootStatus,
                "alerts": alerts,
                "clientVersions": clientVersions,
                "osInfo": osInfo,
                "osAndTypeInfo": osAndTypeInfo,
                "amUpdateOn": amUpdateOn,
                "lastConnection": lastConnection,
                "devicesType": devicesType,
                "activeMachines": activeMachines,
                "viewType": viewType,
            }
        additional_properties = schemas.NotAnyTypeSchema
    
    alerts: MetaOapg.properties.alerts
    deploymentStatus: 'DeploymentStatusReal'
    healthStatus: 'HealthStatus'
    endpointStatus: 'EndpointStatus'
    fdeStatus: 'FdeStatus'
    antiMalwareUpdateStatus: 'AntiMalwareUpdateStatus'
    fdePrebootStatus: 'FdePrebootStatus'
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["alerts"]) -> MetaOapg.properties.alerts: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deploymentStatus"]) -> 'DeploymentStatusReal': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["healthStatus"]) -> 'HealthStatus': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["endpointStatus"]) -> 'EndpointStatus': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["fdeStatus"]) -> 'FdeStatus': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["antiMalwareUpdateStatus"]) -> 'AntiMalwareUpdateStatus': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["fdePrebootStatus"]) -> 'FdePrebootStatus': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["clientVersions"]) -> 'ClientVersions': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["osInfo"]) -> 'OSInfo': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["osAndTypeInfo"]) -> 'OsAndTypeInfo': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["amUpdateOn"]) -> 'AMUpdateOn': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["lastConnection"]) -> 'LastConnection': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["devicesType"]) -> 'DevicesType': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["activeMachines"]) -> 'ActiveMachinesInfo': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["viewType"]) -> 'EmonView': ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["alerts"], typing_extensions.Literal["deploymentStatus"], typing_extensions.Literal["healthStatus"], typing_extensions.Literal["endpointStatus"], typing_extensions.Literal["fdeStatus"], typing_extensions.Literal["antiMalwareUpdateStatus"], typing_extensions.Literal["fdePrebootStatus"], typing_extensions.Literal["clientVersions"], typing_extensions.Literal["osInfo"], typing_extensions.Literal["osAndTypeInfo"], typing_extensions.Literal["amUpdateOn"], typing_extensions.Literal["lastConnection"], typing_extensions.Literal["devicesType"], typing_extensions.Literal["activeMachines"], typing_extensions.Literal["viewType"], ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["alerts"]) -> MetaOapg.properties.alerts: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deploymentStatus"]) -> 'DeploymentStatusReal': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["healthStatus"]) -> 'HealthStatus': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["endpointStatus"]) -> 'EndpointStatus': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["fdeStatus"]) -> 'FdeStatus': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["antiMalwareUpdateStatus"]) -> 'AntiMalwareUpdateStatus': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["fdePrebootStatus"]) -> 'FdePrebootStatus': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["clientVersions"]) -> typing.Union['ClientVersions', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["osInfo"]) -> typing.Union['OSInfo', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["osAndTypeInfo"]) -> typing.Union['OsAndTypeInfo', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["amUpdateOn"]) -> typing.Union['AMUpdateOn', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["lastConnection"]) -> typing.Union['LastConnection', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["devicesType"]) -> typing.Union['DevicesType', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["activeMachines"]) -> typing.Union['ActiveMachinesInfo', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["viewType"]) -> typing.Union['EmonView', schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["alerts"], typing_extensions.Literal["deploymentStatus"], typing_extensions.Literal["healthStatus"], typing_extensions.Literal["endpointStatus"], typing_extensions.Literal["fdeStatus"], typing_extensions.Literal["antiMalwareUpdateStatus"], typing_extensions.Literal["fdePrebootStatus"], typing_extensions.Literal["clientVersions"], typing_extensions.Literal["osInfo"], typing_extensions.Literal["osAndTypeInfo"], typing_extensions.Literal["amUpdateOn"], typing_extensions.Literal["lastConnection"], typing_extensions.Literal["devicesType"], typing_extensions.Literal["activeMachines"], typing_extensions.Literal["viewType"], ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        alerts: typing.Union[MetaOapg.properties.alerts, list, tuple, ],
        deploymentStatus: 'DeploymentStatusReal',
        healthStatus: 'HealthStatus',
        endpointStatus: 'EndpointStatus',
        fdeStatus: 'FdeStatus',
        antiMalwareUpdateStatus: 'AntiMalwareUpdateStatus',
        fdePrebootStatus: 'FdePrebootStatus',
        clientVersions: typing.Union['ClientVersions', schemas.Unset] = schemas.unset,
        osInfo: typing.Union['OSInfo', schemas.Unset] = schemas.unset,
        osAndTypeInfo: typing.Union['OsAndTypeInfo', schemas.Unset] = schemas.unset,
        amUpdateOn: typing.Union['AMUpdateOn', schemas.Unset] = schemas.unset,
        lastConnection: typing.Union['LastConnection', schemas.Unset] = schemas.unset,
        devicesType: typing.Union['DevicesType', schemas.Unset] = schemas.unset,
        activeMachines: typing.Union['ActiveMachinesInfo', schemas.Unset] = schemas.unset,
        viewType: typing.Union['EmonView', schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'MsspDeploymentOverview':
        return super().__new__(
            cls,
            *_args,
            alerts=alerts,
            deploymentStatus=deploymentStatus,
            healthStatus=healthStatus,
            endpointStatus=endpointStatus,
            fdeStatus=fdeStatus,
            antiMalwareUpdateStatus=antiMalwareUpdateStatus,
            fdePrebootStatus=fdePrebootStatus,
            clientVersions=clientVersions,
            osInfo=osInfo,
            osAndTypeInfo=osAndTypeInfo,
            amUpdateOn=amUpdateOn,
            lastConnection=lastConnection,
            devicesType=devicesType,
            activeMachines=activeMachines,
            viewType=viewType,
            _configuration=_configuration,
        )

from chkp_harmony_endpoint_management_sdk.generated.saas.model.active_machines_info import ActiveMachinesInfo
from chkp_harmony_endpoint_management_sdk.generated.saas.model.am_update_on import AMUpdateOn
from chkp_harmony_endpoint_management_sdk.generated.saas.model.anti_malware_update_status import AntiMalwareUpdateStatus
from chkp_harmony_endpoint_management_sdk.generated.saas.model.client_versions import ClientVersions
from chkp_harmony_endpoint_management_sdk.generated.saas.model.deployment_status_real import DeploymentStatusReal
from chkp_harmony_endpoint_management_sdk.generated.saas.model.devices_type import DevicesType
from chkp_harmony_endpoint_management_sdk.generated.saas.model.emon_view import EmonView
from chkp_harmony_endpoint_management_sdk.generated.saas.model.endpoint_status import EndpointStatus
from chkp_harmony_endpoint_management_sdk.generated.saas.model.fde_preboot_status import FdePrebootStatus
from chkp_harmony_endpoint_management_sdk.generated.saas.model.fde_status import FdeStatus
from chkp_harmony_endpoint_management_sdk.generated.saas.model.health_status import HealthStatus
from chkp_harmony_endpoint_management_sdk.generated.saas.model.last_connection import LastConnection
from chkp_harmony_endpoint_management_sdk.generated.saas.model.os_and_type_info import OsAndTypeInfo
from chkp_harmony_endpoint_management_sdk.generated.saas.model.os_info import OSInfo
from chkp_harmony_endpoint_management_sdk.generated.saas.model.overview_alert import OverviewAlert
