# coding: utf-8

# GTO-MO-1-1 - Removed partial_header
# flake8: noqa

from datetime import date, datetime
import decimal
import functools
import io
import re
import typing
import typing_extensions
import uuid

import frozendict

from chkp_harmony_endpoint_management_sdk.generated.saas import schemas


class HealthStatus(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    class MetaOapg:
        required = {
            "totalCount",
            "notRunningBladesCount",
        }
        
        class properties:
            totalCount = schemas.Float64Schema
            notRunningBladesCount = schemas.Float64Schema
            allBladesRunningCount = schemas.Float64Schema
            __annotations__ = {
                "totalCount": totalCount,
                "notRunningBladesCount": notRunningBladesCount,
                "allBladesRunningCount": allBladesRunningCount,
            }
        additional_properties = schemas.NotAnyTypeSchema
    
    totalCount: MetaOapg.properties.totalCount
    notRunningBladesCount: MetaOapg.properties.notRunningBladesCount
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["totalCount"]) -> MetaOapg.properties.totalCount: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["notRunningBladesCount"]) -> MetaOapg.properties.notRunningBladesCount: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["allBladesRunningCount"]) -> MetaOapg.properties.allBladesRunningCount: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["totalCount"], typing_extensions.Literal["notRunningBladesCount"], typing_extensions.Literal["allBladesRunningCount"], ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["totalCount"]) -> MetaOapg.properties.totalCount: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["notRunningBladesCount"]) -> MetaOapg.properties.notRunningBladesCount: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["allBladesRunningCount"]) -> typing.Union[MetaOapg.properties.allBladesRunningCount, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["totalCount"], typing_extensions.Literal["notRunningBladesCount"], typing_extensions.Literal["allBladesRunningCount"], ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        totalCount: typing.Union[MetaOapg.properties.totalCount, decimal.Decimal, int, float, ],
        notRunningBladesCount: typing.Union[MetaOapg.properties.notRunningBladesCount, decimal.Decimal, int, float, ],
        allBladesRunningCount: typing.Union[MetaOapg.properties.allBladesRunningCount, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'HealthStatus':
        return super().__new__(
            cls,
            *_args,
            totalCount=totalCount,
            notRunningBladesCount=notRunningBladesCount,
            allBladesRunningCount=allBladesRunningCount,
            _configuration=_configuration,
        )
