# coding: utf-8

# GTO-MO-1-1 - Removed partial_header
# flake8: noqa

from datetime import date, datetime
import decimal
import functools
import io
import re
import typing
import typing_extensions
import uuid

import frozendict

from chkp_harmony_endpoint_management_sdk.generated.saas import schemas


class AlertState(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    class MetaOapg:
        required = {
            "severity",
            "matchingEntities",
            "totalEntities",
            "status",
        }
        
        class properties:
            totalEntities = schemas.Float64Schema
            matchingEntities = schemas.Float64Schema
        
            @staticmethod
            def status() -> typing.Type['AlertStatus']:
                return AlertStatus
        
            @staticmethod
            def severity() -> typing.Type['OverviewAlertSeverity']:
                return OverviewAlertSeverity
            lastUpdate = schemas.DateTimeSchema
            __annotations__ = {
                "totalEntities": totalEntities,
                "matchingEntities": matchingEntities,
                "status": status,
                "severity": severity,
                "lastUpdate": lastUpdate,
            }
        additional_properties = schemas.NotAnyTypeSchema
    
    severity: 'OverviewAlertSeverity'
    matchingEntities: MetaOapg.properties.matchingEntities
    totalEntities: MetaOapg.properties.totalEntities
    status: 'AlertStatus'
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["severity"]) -> 'OverviewAlertSeverity': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["matchingEntities"]) -> MetaOapg.properties.matchingEntities: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["totalEntities"]) -> MetaOapg.properties.totalEntities: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["status"]) -> 'AlertStatus': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["lastUpdate"]) -> MetaOapg.properties.lastUpdate: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["severity"], typing_extensions.Literal["matchingEntities"], typing_extensions.Literal["totalEntities"], typing_extensions.Literal["status"], typing_extensions.Literal["lastUpdate"], ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["severity"]) -> 'OverviewAlertSeverity': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["matchingEntities"]) -> MetaOapg.properties.matchingEntities: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["totalEntities"]) -> MetaOapg.properties.totalEntities: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["status"]) -> 'AlertStatus': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["lastUpdate"]) -> typing.Union[MetaOapg.properties.lastUpdate, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["severity"], typing_extensions.Literal["matchingEntities"], typing_extensions.Literal["totalEntities"], typing_extensions.Literal["status"], typing_extensions.Literal["lastUpdate"], ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        severity: 'OverviewAlertSeverity',
        matchingEntities: typing.Union[MetaOapg.properties.matchingEntities, decimal.Decimal, int, float, ],
        totalEntities: typing.Union[MetaOapg.properties.totalEntities, decimal.Decimal, int, float, ],
        status: 'AlertStatus',
        lastUpdate: typing.Union[MetaOapg.properties.lastUpdate, str, datetime, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'AlertState':
        return super().__new__(
            cls,
            *_args,
            severity=severity,
            matchingEntities=matchingEntities,
            totalEntities=totalEntities,
            status=status,
            lastUpdate=lastUpdate,
            _configuration=_configuration,
        )

from chkp_harmony_endpoint_management_sdk.generated.saas.model.alert_status import AlertStatus
from chkp_harmony_endpoint_management_sdk.generated.saas.model.overview_alert_severity import OverviewAlertSeverity
