# coding: utf-8

"""
    Harmony Endpoint Management (Cloud API)

    <p>Harmony Endpoint offers a new web management interface for cloud users. By using the api, you will setup a virtual Endpoint management service in the cloud to manage policies and deployments for Harmony Endpoint agents.</p><p>The following documentation provides the operations supported by the Harmony Endpoint's Cloud API.</p><p>To use the Harmony Endpoint Cloud API service:</p><ol><li><p>Login as user to infinity portal, Using the Authenticate API .</p></li><li><p>Authenticate using the&nbsp;<a href='https://app.swaggerhub.com/apis-docs/Check-Point/infinity-portal-api/1.0.1#/Authentication/post_auth_userl' rel='noopener noreferrer'>Infinity Portal Authentication Service</a>, making sure to select the correct Infinity Portal API Server for the geographic region of your tenant.</p></li><li><p>Include the resulting <em>csrf </em>in the <em>'x-access-token' </em>header and the 'cloudinfra' cookie in every request made to the API service.</p></li><li><p>Call the Mssp Login API</p></li><li>Include return token in 'x-mgmt-mssp-session'&nbsp;in every request made to the API service.</li></ol><p><strong>* notice mssp session will expired after 5min you can use the keep-alive api to extend it.</strong></p><p>&nbsp;</p><p><strong>please use base path for the api's according to your tenant region:</strong></p><table style='height: 108px; width: 100%; border-collapse: collapse;' border='1'><tbody><tr style='height: 18px;'><td style='width: 50%; height: 18px; background: #4795d9'><strong>Region</strong></td><td style='width: 50%; height: 18px; background: #4795d9'><strong>Base Path</strong></td></tr><tr style='height: 18px;'><td style='width: 50%; height: 18px;'>EU</td><td style='width: 50%; height: 18px;'>https://cloudinfra-gw.portal.checkpoint.com</td></tr><tr style='height: 18px;'><td style='width: 50%; height: 18px;'>US</td><td style='width: 50%; height: 18px;'>https://cloudinfra-gw-us.portal.checkpoint.com</td></tr><tr style='height: 18px;'><td style='width: 50%; height: 18px;'>AP</td><td style='width: 50%; height: 18px;'>https://cloudinfra-gw.ap.portal.checkpoint.com</td></tr><tr style='height: 18px;'><td style='width: 50%; height: 18px;'>IN</td><td style='width: 50%; height: 18px;'>https://cloudinfra-gw.in.portal.checkpoint.com</td></tr><tr style='height: 18px;'><td style='width: 50%; height: 18px;'>UK</td><td style='width: 50%; height: 18px;'>https://cloudinfra-gw.uk.portal.checkpoint.com</td></tr></tbody></table><br><br>  # noqa: E501

    The version of the OpenAPI document: 1.0.626
    Contact: harmony-endpoint-external-api@checkpoint.com
    Generated by: https://openapi-generator.tech
"""
import dataclasses
import typing

from urllib3._collections import HTTPHeaderDict


class OpenApiException(Exception):
    """The base exception class for all OpenAPIExceptions"""


class ApiTypeError(OpenApiException, TypeError):
    def __init__(self, msg, path_to_item=None, valid_classes=None,
                 key_type=None):
        """ Raises an exception for TypeErrors

        Args:
            msg (str): the exception message

        Keyword Args:
            path_to_item (list): a list of keys an indices to get to the
                                 current_item
                                 None if unset
            valid_classes (tuple): the primitive classes that current item
                                   should be an instance of
                                   None if unset
            key_type (bool): False if our value is a value in a dict
                             True if it is a key in a dict
                             False if our item is an item in a list
                             None if unset
        """
        self.path_to_item = path_to_item
        self.valid_classes = valid_classes
        self.key_type = key_type
        full_msg = msg
        if path_to_item:
            full_msg = "{0} at {1}".format(msg, render_path(path_to_item))
        super(ApiTypeError, self).__init__(full_msg)


class ApiValueError(OpenApiException, ValueError):
    def __init__(self, msg, path_to_item=None):
        """
        Args:
            msg (str): the exception message

        Keyword Args:
            path_to_item (list) the path to the exception in the
                received_data dict. None if unset
        """

        self.path_to_item = path_to_item
        full_msg = msg
        if path_to_item:
            full_msg = "{0} at {1}".format(msg, render_path(path_to_item))
        super(ApiValueError, self).__init__(full_msg)


class ApiAttributeError(OpenApiException, AttributeError):
    def __init__(self, msg, path_to_item=None):
        """
        Raised when an attribute reference or assignment fails.

        Args:
            msg (str): the exception message

        Keyword Args:
            path_to_item (None/list) the path to the exception in the
                received_data dict
        """
        self.path_to_item = path_to_item
        full_msg = msg
        if path_to_item:
            full_msg = "{0} at {1}".format(msg, render_path(path_to_item))
        super(ApiAttributeError, self).__init__(full_msg)


class ApiKeyError(OpenApiException, KeyError):
    def __init__(self, msg, path_to_item=None):
        """
        Args:
            msg (str): the exception message

        Keyword Args:
            path_to_item (None/list) the path to the exception in the
                received_data dict
        """
        self.path_to_item = path_to_item
        full_msg = msg
        if path_to_item:
            full_msg = "{0} at {1}".format(msg, render_path(path_to_item))
        super(ApiKeyError, self).__init__(full_msg)


T = typing.TypeVar("T")


@dataclasses.dataclass
class ApiException(OpenApiException, typing.Generic[T]):
    status: int
    reason: str
    api_response: typing.Optional[T] = None

    @property
    def body(self) -> typing.Union[str, bytes, None]:
        if not self.api_response:
            return None
        return self.api_response.response.data

    @property
    def headers(self) -> typing.Optional[HTTPHeaderDict]:
        if not self.api_response:
            return None
        return self.api_response.response.getheaders()

    def __str__(self):
        """Custom error messages for exception"""
        error_message = "({0})\n"\
                        "Reason: {1}\n".format(self.status, self.reason)
        if self.headers:
            error_message += "HTTP response headers: {0}\n".format(
                self.headers)

        if self.body:
            error_message += "HTTP response body: {0}\n".format(self.body)

        return error_message


def render_path(path_to_item):
    """Returns a string representation of a path"""
    result = ""
    for pth in path_to_item:
        if isinstance(pth, int):
            result += "[{0}]".format(pth)
        else:
            result += "['{0}']".format(pth)
    return result
