# coding: utf-8

# flake8: noqa

"""
    Harmony Endpoint Management (Cloud API)

    <p>Harmony Endpoint offers a new web management interface for cloud users. By using the api, you will setup a virtual Endpoint management service in the cloud to manage policies and deployments for Harmony Endpoint agents.</p><p>The following documentation provides the operations supported by the Harmony Endpoint's Cloud API.</p><p>To use the Harmony Endpoint Cloud API service:</p><ol><li><p>Login as user to infinity portal, Using the Authenticate API .</p></li><li><p>Authenticate using the&nbsp;<a href='https://app.swaggerhub.com/apis-docs/Check-Point/infinity-portal-api/1.0.1#/Authentication/post_auth_userl' rel='noopener noreferrer'>Infinity Portal Authentication Service</a>, making sure to select the correct Infinity Portal API Server for the geographic region of your tenant.</p></li><li><p>Include the resulting <em>csrf </em>in the <em>'x-access-token' </em>header and the 'cloudinfra' cookie in every request made to the API service.</p></li><li><p>Call the Mssp Login API</p></li><li>Include return token in 'x-mgmt-mssp-session'&nbsp;in every request made to the API service.</li></ol><p><strong>* notice mssp session will expired after 5min you can use the keep-alive api to extend it.</strong></p><p>&nbsp;</p><p><strong>please use base path for the api's according to your tenant region:</strong></p><table style='height: 108px; width: 100%; border-collapse: collapse;' border='1'><tbody><tr style='height: 18px;'><td style='width: 50%; height: 18px; background: #4795d9'><strong>Region</strong></td><td style='width: 50%; height: 18px; background: #4795d9'><strong>Base Path</strong></td></tr><tr style='height: 18px;'><td style='width: 50%; height: 18px;'>EU</td><td style='width: 50%; height: 18px;'>https://cloudinfra-gw.portal.checkpoint.com</td></tr><tr style='height: 18px;'><td style='width: 50%; height: 18px;'>US</td><td style='width: 50%; height: 18px;'>https://cloudinfra-gw-us.portal.checkpoint.com</td></tr><tr style='height: 18px;'><td style='width: 50%; height: 18px;'>AP</td><td style='width: 50%; height: 18px;'>https://cloudinfra-gw.ap.portal.checkpoint.com</td></tr><tr style='height: 18px;'><td style='width: 50%; height: 18px;'>IN</td><td style='width: 50%; height: 18px;'>https://cloudinfra-gw.in.portal.checkpoint.com</td></tr><tr style='height: 18px;'><td style='width: 50%; height: 18px;'>UK</td><td style='width: 50%; height: 18px;'>https://cloudinfra-gw.uk.portal.checkpoint.com</td></tr></tbody></table><br><br>  # noqa: E501

    The version of the OpenAPI document: 1.0.626
    Contact: harmony-endpoint-external-api@checkpoint.com
    Generated by: https://openapi-generator.tech
"""

__version__ = "1.0.0"

# import ApiClient
from chkp_harmony_endpoint_management_sdk.generated.saas.api_client import ApiClient

# import Configuration
from chkp_harmony_endpoint_management_sdk.generated.saas.configuration import Configuration

# import exceptions
from chkp_harmony_endpoint_management_sdk.generated.saas.exceptions import OpenApiException
from chkp_harmony_endpoint_management_sdk.generated.saas.exceptions import ApiAttributeError
from chkp_harmony_endpoint_management_sdk.generated.saas.exceptions import ApiTypeError
from chkp_harmony_endpoint_management_sdk.generated.saas.exceptions import ApiValueError
from chkp_harmony_endpoint_management_sdk.generated.saas.exceptions import ApiKeyError
from chkp_harmony_endpoint_management_sdk.generated.saas.exceptions import ApiException

from chkp_harmony_endpoint_management_sdk.generated.saas.exceptions import ApiException

# Code generation part of HarmonyEndpoint

import json
from chkp_harmony_endpoint_management_sdk.core.logger import logger
from chkp_harmony_endpoint_management_sdk.classes.sdk_connection_state import SDKConnectionState
from chkp_harmony_endpoint_management_sdk.classes.harmony_endpoint_sdk_info import HarmonyEndpointSDKInfo
from chkp_harmony_endpoint_management_sdk.generated.saas.sdk_build import sdk_build_info

from chkp_harmony_endpoint_management_sdk.generated.saas.paths.public_mssp_v1_session_keep_alive.post import PublicMsspKeepAlive
from chkp_harmony_endpoint_management_sdk.generated.saas.paths.public_mssp_v1_session_login.post import PublicMsspLogin
from chkp_harmony_endpoint_management_sdk.generated.saas.paths.public_mssp_v1_service_deploy.post import DeployEndpointInstance
from chkp_harmony_endpoint_management_sdk.generated.saas.paths.public_mssp_v1_service_operation.post import ManageEndpointInstance
from chkp_harmony_endpoint_management_sdk.generated.saas.paths.public_mssp_v1_service_status.get import TenantsStatus
from chkp_harmony_endpoint_management_sdk.generated.saas.paths.public_mssp_v1_service_terminate.post import TerminateEndpointInstance
from chkp_harmony_endpoint_management_sdk.generated.saas.paths.public_mssp_v1_operational.get import PublicMsspOperational
from chkp_harmony_endpoint_management_sdk.generated.saas.paths.public_mssp_v1_operational_trends_connected.post import PublicMsspTrendsConnectedClients
from chkp_harmony_endpoint_management_sdk.generated.saas.paths.public_v1_self_service_deploy.post import PublicDeploySingleEndpointInstance
from chkp_harmony_endpoint_management_sdk.generated.saas.paths.public_v1_self_service_status.get import PublicMachinesSingleStatus
from chkp_harmony_endpoint_management_sdk.generated.saas.paths.public_v1_self_service_terminate_machine_id.delete import PublicTerminateSingleEndpointInstance

client = ApiClient()

class ManageSessionApi():
    def __init__(self, session_manager):
        self.__session_manager = session_manager

    @property
    def public_mssp_keep_alive(self):
        return PublicMsspKeepAlive(self.__session_manager.client).public_mssp_keep_alive

    @property
    def public_mssp_login(self):
        return PublicMsspLogin(self.__session_manager.client).public_mssp_login

class MsspServiceApi():
    def __init__(self, session_manager):
        self.__session_manager = session_manager

    @property
    def deploy_endpoint_instance(self):
        return DeployEndpointInstance(self.__session_manager.client).deploy_endpoint_instance

    @property
    def manage_endpoint_instance(self):
        return ManageEndpointInstance(self.__session_manager.client).manage_endpoint_instance

    @property
    def tenants_status(self):
        return TenantsStatus(self.__session_manager.client).tenants_status

    @property
    def terminate_endpoint_instance(self):
        return TerminateEndpointInstance(self.__session_manager.client).terminate_endpoint_instance

class OperationalApi():
    def __init__(self, session_manager):
        self.__session_manager = session_manager

    @property
    def public_mssp_operational(self):
        return PublicMsspOperational(self.__session_manager.client).public_mssp_operational

    @property
    def public_mssp_trends_connected_clients(self):
        return PublicMsspTrendsConnectedClients(self.__session_manager.client).public_mssp_trends_connected_clients

class SelfServiceApi():
    def __init__(self, session_manager):
        self.__session_manager = session_manager

    @property
    def public_deploy_single_endpoint_instance(self):
        return PublicDeploySingleEndpointInstance(self.__session_manager.client).public_deploy_single_endpoint_instance

    @property
    def public_machines_single_status(self):
        return PublicMachinesSingleStatus(self.__session_manager.client).public_machines_single_status

    @property
    def public_terminate_single_endpoint_instance(self):
        return PublicTerminateSingleEndpointInstance(self.__session_manager.client).public_terminate_single_endpoint_instance


operations = [
    {
        'class_name': 'manage_session_api',
        'class_description' : '',
        'methods': [
            {
                'method_name': 'public_mssp_keep_alive',
                'method_description': 'Keeps the MSSP session alive for five more minutes.',
            },
            {
                'method_name': 'public_mssp_login',
                'method_description': 'Logs in as MSSP. The session expires after five minutes.',
            },]
    },
    {
        'class_name': 'mssp_service_api',
        'class_description' : '',
        'methods': [
            {
                'method_name': 'deploy_endpoint_instance',
                'method_description': 'Deploys Harmony Endpoint servers. Note: You can deploy only five servers in an hour.',
            },
            {
                'method_name': 'manage_endpoint_instance',
                'method_description': 'Performs stop, start or restart operations on one or more endpoint servers. action can be one of [ &#x27;START&#x27;, &#x27;STOP&#x27;, &#x27;RESTART&#x27; ]',
            },
            {
                'method_name': 'tenants_status',
                'method_description': 'Gets the information about all the tenants in the MSSP account. The information includes: • Tenant name • Tenant ID • Endpoint servers’ status • Other operational related data if available.',
            },
            {
                'method_name': 'terminate_endpoint_instance',
                'method_description': 'Terminates one or more endpoint servers. Warning! You cannot revert this action.',
            },]
    },
    {
        'class_name': 'operational_api',
        'class_description' : '',
        'methods': [
            {
                'method_name': 'public_mssp_operational',
                'method_description': 'Gets the operational information, such as the number of active endpoints and the deployment status.',
            },
            {
                'method_name': 'public_mssp_trends_connected_clients',
                'method_description': 'Gets the the number of active endpoints over time.',
            },]
    },
    {
        'class_name': 'self_service_api',
        'class_description' : '',
        'methods': [
            {
                'method_name': 'public_deploy_single_endpoint_instance',
                'method_description': 'Use to deploy Harmony Endpoint servers. machineName: is not mandatory, machine name will be part of server FQDN. appType: epsPlatform - for Harmony Endpoint, sba4b - for Browse only server. Warning! this operation limit for 5 in an hour.',
            },
            {
                'method_name': 'public_machines_single_status',
                'method_description': 'Return information about your tenant. Information will includes Endpoint servers status and other operational related data.',
            },
            {
                'method_name': 'public_terminate_single_endpoint_instance',
                'method_description': 'Terminates Harmony Endpoint Server. Warning! You cannot revert this action.',
            },]
    },
]

class HarmonyEndpointBase:
    
    @staticmethod
    def info() -> HarmonyEndpointSDKInfo:
        return sdk_build_info()

    def __init__(self, instance_schema: str, session_manager):
        logger(f'A new instance "{instance_schema}" of sdk created, full version info: {HarmonyEndpointBase.info()}')
        self._session_manager = session_manager


    def disconnect(self):
        self._session_manager.disconnect()

    def reconnect(self):
        self._session_manager.reconnect()

    def connection_state(self) -> SDKConnectionState:
        self._session_manager.connection_state()


    @property
    def _manage_session_api(self):
        return ManageSessionApi(self._session_manager)

    @property
    def mssp_service_api(self):
        return MsspServiceApi(self._session_manager)

    @property
    def operational_api(self):
        return OperationalApi(self._session_manager)

    @property
    def self_service_api(self):
        return SelfServiceApi(self._session_manager)

