# do not import all endpoints into this module because that uses a lot of memory and stack frames
# if you need the ability to import all endpoints from this module, import them with
# from chkp_harmony_endpoint_management_sdk.generated.cloud.apis.path_to_api import path_to_api

import enum


class PathValues(str, enum.Enum):
    V1_ASSETMANAGEMENT_COMPUTERS_FILTERED = "/v1/asset-management/computers/filtered"
    V1_IOC_GET = "/v1/ioc/get"
    V1_IOC_EDIT = "/v1/ioc/edit"
    V1_IOC_CREATE = "/v1/ioc/create"
    V1_IOC_DELETE_ALL = "/v1/ioc/delete/all"
    V1_IOC_DELETE = "/v1/ioc/delete"
    V1_JOBS_JOB_ID = "/v1/jobs/{jobId}"
    V1_ORGANIZATION_TREE_SEARCH = "/v1/organization/tree/search"
    V1_ORGANIZATION_VIRTUALGROUP_CREATE = "/v1/organization/virtual-group/create"
    V1_ORGANIZATION_VIRTUALGROUP_VIRTUAL_GROUP_ID_MEMBERS_ADD = "/v1/organization/virtual-group/{virtualGroupId}/members/add"
    V1_ORGANIZATION_VIRTUALGROUP_VIRTUAL_GROUP_ID_MEMBERS_REMOVE = "/v1/organization/virtual-group/{virtualGroupId}/members/remove"
    V1_POLICY_RULE_ID_ASSIGNMENTS = "/v1/policy/{ruleId}/assignments"
    V1_POLICY_RULE_ID_ASSIGNMENTS_ADD = "/v1/policy/{ruleId}/assignments/add"
    V1_POLICY_RULE_ID_ASSIGNMENTS_REMOVE = "/v1/policy/{ruleId}/assignments/remove"
    V1_POLICY_INSTALL = "/v1/policy/install"
    V1_POLICY_RULE_ID_INSTALL = "/v1/policy/{ruleId}/install"
    V1_POLICY_RULE_ID_MODIFICATIONS = "/v1/policy/{ruleId}/modifications"
    V1_POLICY_RULE_ID = "/v1/policy/{ruleId}"
    V1_POLICY_RULE_ID_METADATA = "/v1/policy/{ruleId}/metadata"
    V1_POLICY_METADATA = "/v1/policy/metadata"
    POLICY_THREATPREVENTION_RULE_ID = "/policy/threat-prevention/{ruleId}"
    POLICY_THREATPREVENTION_RULE_ID_TEMPLATE = "/policy/threat-prevention/{ruleId}/template"
    V1_POSTURE_VULNERABILITY_DATA = "/v1/posture/vulnerability/data"
    V1_POSTURE_VULNERABILITY_DEVICES = "/v1/posture/vulnerability/devices"
    V1_POSTURE_VULNERABILITY_SCAN = "/v1/posture/vulnerability/scan"
    V1_POSTURE_VULNERABILITY_SCAN_STATUS = "/v1/posture/vulnerability/scan/status"
    V1_POSTURE_VULNERABILITY_PATCH = "/v1/posture/vulnerability/patch"
    V1_POSTURE_VULNERABILITY_PATCH_STATUS = "/v1/posture/vulnerability/patch/status"
    V1_REMEDIATION_AGENT_RESETCOMPUTER = "/v1/remediation/agent/reset-computer"
    V1_REMEDIATION_AGENT_SHUTDOWNCOMPUTER = "/v1/remediation/agent/shutdown-computer"
    V1_REMEDIATION_AGENT_REPAIRCOMPUTER = "/v1/remediation/agent/repair-computer"
    V1_REMEDIATION_AGENT_COLLECTLOGS = "/v1/remediation/agent/collect-logs"
    V1_REMEDIATION_AGENT_REGISTRY_KEY_ADD = "/v1/remediation/agent/registry/key/add"
    V1_REMEDIATION_AGENT_REGISTRY_KEY_DELETE = "/v1/remediation/agent/registry/key/delete"
    V1_REMEDIATION_AGENT_FILE_COPY = "/v1/remediation/agent/file/copy"
    V1_REMEDIATION_AGENT_FILE_MOVE = "/v1/remediation/agent/file/move"
    V1_REMEDIATION_AGENT_FILE_DELETE = "/v1/remediation/agent/file/delete"
    V1_REMEDIATION_AGENT_PROCESS_INFORMATION = "/v1/remediation/agent/process/information"
    V1_REMEDIATION_AGENT_PROCESS_TERMINATE = "/v1/remediation/agent/process/terminate"
    V1_REMEDIATION_AGENT_VPN_SITE_ADD = "/v1/remediation/agent/vpn/site/add"
    V1_REMEDIATION_AGENT_VPN_SITE_REMOVE = "/v1/remediation/agent/vpn/site/remove"
    V1_REMEDIATION_ANTIMALWARE_SCAN = "/v1/remediation/anti-malware/scan"
    V1_REMEDIATION_ANTIMALWARE_UPDATE = "/v1/remediation/anti-malware/update"
    V1_REMEDIATION_ANTIMALWARE_RESTORE = "/v1/remediation/anti-malware/restore"
    V1_REMEDIATION_FORENSICS_ANALYZEBYINDICATOR_URL = "/v1/remediation/forensics/analyze-by-indicator/url"
    V1_REMEDIATION_FORENSICS_ANALYZEBYINDICATOR_IP = "/v1/remediation/forensics/analyze-by-indicator/ip"
    V1_REMEDIATION_FORENSICS_ANALYZEBYINDICATOR_PATH = "/v1/remediation/forensics/analyze-by-indicator/path"
    V1_REMEDIATION_FORENSICS_ANALYZEBYINDICATOR_FILENAME = "/v1/remediation/forensics/analyze-by-indicator/file-name"
    V1_REMEDIATION_FORENSICS_ANALYZEBYINDICATOR_MD5 = "/v1/remediation/forensics/analyze-by-indicator/md5"
    V1_REMEDIATION_FORENSICS_FILE_QUARANTINE = "/v1/remediation/forensics/file/quarantine"
    V1_REMEDIATION_FORENSICS_FILE_RESTORE = "/v1/remediation/forensics/file/restore"
    V1_REMEDIATION_ISOLATE = "/v1/remediation/isolate"
    V1_REMEDIATION_DEISOLATE = "/v1/remediation/de-isolate"
    V1_REMEDIATION_STATUS = "/v1/remediation/status"
    V1_REMEDIATION_ID_STATUS = "/v1/remediation/{id}/status"
    V1_REMEDIATION_ID_ABORT = "/v1/remediation/{id}/abort"
    V1_REMEDIATION_ID_RESULTS_SLIM = "/v1/remediation/{id}/results/slim"
    V1_QUARANTINEMANAGEMENT_FILE_DATA = "/v1/quarantine-management/file/data"
    V1_QUARANTINEMANAGEMENT_FILE_RESTORE = "/v1/quarantine-management/file/restore"
    V1_QUARANTINEMANAGEMENT_FILE_FETCH = "/v1/quarantine-management/file/fetch"
    V1_SESSION_KEEPALIVE = "/v1/session/keepalive"
    V1_SESSION_LOGIN_CLOUD = "/v1/session/login/cloud"
