# coding: utf-8

# GTO-MO-1-1 - Removed partial_header
# flake8: noqa

from datetime import date, datetime
import decimal
import functools
import io
import re
import typing
import typing_extensions
import uuid

import frozendict

from chkp_harmony_endpoint_management_sdk.generated.cloud import schemas


class VulnerabilityPatchStatus(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Describes patch process\'s status for a given vulnerability on a given device
    """

    class MetaOapg:
        required = {
            "patch",
            "vulnerability",
            "device",
        }
        
        class properties:
        
            @staticmethod
            def device() -> typing.Type['VulnerabilityPatchStatusDevice']:
                return VulnerabilityPatchStatusDevice
        
            @staticmethod
            def vulnerability() -> typing.Type['VulnerabilityPatchStatusVulnerability']:
                return VulnerabilityPatchStatusVulnerability
        
            @staticmethod
            def patch() -> typing.Type['VulnerabilityPatchStatusPatch']:
                return VulnerabilityPatchStatusPatch
            __annotations__ = {
                "device": device,
                "vulnerability": vulnerability,
                "patch": patch,
            }
        additional_properties = schemas.NotAnyTypeSchema
    
    patch: 'VulnerabilityPatchStatusPatch'
    vulnerability: 'VulnerabilityPatchStatusVulnerability'
    device: 'VulnerabilityPatchStatusDevice'
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["patch"]) -> 'VulnerabilityPatchStatusPatch': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["vulnerability"]) -> 'VulnerabilityPatchStatusVulnerability': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["device"]) -> 'VulnerabilityPatchStatusDevice': ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["patch"], typing_extensions.Literal["vulnerability"], typing_extensions.Literal["device"], ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["patch"]) -> 'VulnerabilityPatchStatusPatch': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["vulnerability"]) -> 'VulnerabilityPatchStatusVulnerability': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["device"]) -> 'VulnerabilityPatchStatusDevice': ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["patch"], typing_extensions.Literal["vulnerability"], typing_extensions.Literal["device"], ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        patch: 'VulnerabilityPatchStatusPatch',
        vulnerability: 'VulnerabilityPatchStatusVulnerability',
        device: 'VulnerabilityPatchStatusDevice',
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'VulnerabilityPatchStatus':
        return super().__new__(
            cls,
            *_args,
            patch=patch,
            vulnerability=vulnerability,
            device=device,
            _configuration=_configuration,
        )

from chkp_harmony_endpoint_management_sdk.generated.cloud.model.vulnerability_patch_status_device import VulnerabilityPatchStatusDevice
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.vulnerability_patch_status_patch import VulnerabilityPatchStatusPatch
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.vulnerability_patch_status_vulnerability import VulnerabilityPatchStatusVulnerability
