# coding: utf-8

# GTO-MO-1-1 - Removed partial_header
# flake8: noqa

from datetime import date, datetime
import decimal
import functools
import io
import re
import typing
import typing_extensions
import uuid

import frozendict

from chkp_harmony_endpoint_management_sdk.generated.cloud import schemas


class VulnerabilityAffectedDeviceInfo(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Information about a device affected by one or more vulnerabilities
    """

    class MetaOapg:
        required = {
            "lastScanStatus",
            "name",
            "comment",
            "id",
            "vulnerableProductsCount",
            "cveCount",
            "type",
            "operatingSystem",
            "scannedAppCount",
            "firstScanned",
            "lastScanned",
        }
        
        class properties:
            id = schemas.StrSchema
            name = schemas.StrSchema
            type = schemas.StrSchema
        
            @staticmethod
            def lastScanStatus() -> typing.Type['DeviceVulnerabilityScanStatusEnum']:
                return DeviceVulnerabilityScanStatusEnum
            lastScanned = schemas.DateTimeSchema
            firstScanned = schemas.DateTimeSchema
            scannedAppCount = schemas.Int32Schema
            cveCount = schemas.Int32Schema
            vulnerableProductsCount = schemas.Int32Schema
            comment = schemas.StrSchema
        
            @staticmethod
            def operatingSystem() -> typing.Type['OperatingSystemSlimInfo']:
                return OperatingSystemSlimInfo
            __annotations__ = {
                "id": id,
                "name": name,
                "type": type,
                "lastScanStatus": lastScanStatus,
                "lastScanned": lastScanned,
                "firstScanned": firstScanned,
                "scannedAppCount": scannedAppCount,
                "cveCount": cveCount,
                "vulnerableProductsCount": vulnerableProductsCount,
                "comment": comment,
                "operatingSystem": operatingSystem,
            }
        additional_properties = schemas.NotAnyTypeSchema
    
    lastScanStatus: 'DeviceVulnerabilityScanStatusEnum'
    name: MetaOapg.properties.name
    comment: MetaOapg.properties.comment
    id: MetaOapg.properties.id
    vulnerableProductsCount: MetaOapg.properties.vulnerableProductsCount
    cveCount: MetaOapg.properties.cveCount
    type: MetaOapg.properties.type
    operatingSystem: 'OperatingSystemSlimInfo'
    scannedAppCount: MetaOapg.properties.scannedAppCount
    firstScanned: MetaOapg.properties.firstScanned
    lastScanned: MetaOapg.properties.lastScanned
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["lastScanStatus"]) -> 'DeviceVulnerabilityScanStatusEnum': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["comment"]) -> MetaOapg.properties.comment: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["vulnerableProductsCount"]) -> MetaOapg.properties.vulnerableProductsCount: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["cveCount"]) -> MetaOapg.properties.cveCount: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["type"]) -> MetaOapg.properties.type: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["operatingSystem"]) -> 'OperatingSystemSlimInfo': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["scannedAppCount"]) -> MetaOapg.properties.scannedAppCount: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["firstScanned"]) -> MetaOapg.properties.firstScanned: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["lastScanned"]) -> MetaOapg.properties.lastScanned: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["lastScanStatus"], typing_extensions.Literal["name"], typing_extensions.Literal["comment"], typing_extensions.Literal["id"], typing_extensions.Literal["vulnerableProductsCount"], typing_extensions.Literal["cveCount"], typing_extensions.Literal["type"], typing_extensions.Literal["operatingSystem"], typing_extensions.Literal["scannedAppCount"], typing_extensions.Literal["firstScanned"], typing_extensions.Literal["lastScanned"], ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["lastScanStatus"]) -> 'DeviceVulnerabilityScanStatusEnum': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["comment"]) -> MetaOapg.properties.comment: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["vulnerableProductsCount"]) -> MetaOapg.properties.vulnerableProductsCount: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["cveCount"]) -> MetaOapg.properties.cveCount: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["type"]) -> MetaOapg.properties.type: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["operatingSystem"]) -> 'OperatingSystemSlimInfo': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["scannedAppCount"]) -> MetaOapg.properties.scannedAppCount: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["firstScanned"]) -> MetaOapg.properties.firstScanned: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["lastScanned"]) -> MetaOapg.properties.lastScanned: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["lastScanStatus"], typing_extensions.Literal["name"], typing_extensions.Literal["comment"], typing_extensions.Literal["id"], typing_extensions.Literal["vulnerableProductsCount"], typing_extensions.Literal["cveCount"], typing_extensions.Literal["type"], typing_extensions.Literal["operatingSystem"], typing_extensions.Literal["scannedAppCount"], typing_extensions.Literal["firstScanned"], typing_extensions.Literal["lastScanned"], ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        lastScanStatus: 'DeviceVulnerabilityScanStatusEnum',
        name: typing.Union[MetaOapg.properties.name, str, ],
        comment: typing.Union[MetaOapg.properties.comment, str, ],
        id: typing.Union[MetaOapg.properties.id, str, ],
        vulnerableProductsCount: typing.Union[MetaOapg.properties.vulnerableProductsCount, decimal.Decimal, int, ],
        cveCount: typing.Union[MetaOapg.properties.cveCount, decimal.Decimal, int, ],
        type: typing.Union[MetaOapg.properties.type, str, ],
        operatingSystem: 'OperatingSystemSlimInfo',
        scannedAppCount: typing.Union[MetaOapg.properties.scannedAppCount, decimal.Decimal, int, ],
        firstScanned: typing.Union[MetaOapg.properties.firstScanned, str, datetime, ],
        lastScanned: typing.Union[MetaOapg.properties.lastScanned, str, datetime, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'VulnerabilityAffectedDeviceInfo':
        return super().__new__(
            cls,
            *_args,
            lastScanStatus=lastScanStatus,
            name=name,
            comment=comment,
            id=id,
            vulnerableProductsCount=vulnerableProductsCount,
            cveCount=cveCount,
            type=type,
            operatingSystem=operatingSystem,
            scannedAppCount=scannedAppCount,
            firstScanned=firstScanned,
            lastScanned=lastScanned,
            _configuration=_configuration,
        )

from chkp_harmony_endpoint_management_sdk.generated.cloud.model.device_vulnerability_scan_status_enum import DeviceVulnerabilityScanStatusEnum
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.operating_system_slim_info import OperatingSystemSlimInfo
