# coding: utf-8

# GTO-MO-1-1 - Removed partial_header
# flake8: noqa

from datetime import date, datetime
import decimal
import functools
import io
import re
import typing
import typing_extensions
import uuid

import frozendict

from chkp_harmony_endpoint_management_sdk.generated.cloud import schemas


class VulnerabilityAffectedDevice(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    class MetaOapg:
        required = {
            "patch",
            "application",
            "vulnerability",
            "device",
        }
        
        class properties:
        
            @staticmethod
            def application() -> typing.Type['VulnerableApplicationInfoSlim']:
                return VulnerableApplicationInfoSlim
        
            @staticmethod
            def device() -> typing.Type['VulnerabilityAffectedDeviceInfo']:
                return VulnerabilityAffectedDeviceInfo
        
            @staticmethod
            def vulnerability() -> typing.Type['DeviceVulnerabilityInfo']:
                return DeviceVulnerabilityInfo
        
            @staticmethod
            def patch() -> typing.Type['DeviceVulnerabilityPatchInfo']:
                return DeviceVulnerabilityPatchInfo
            __annotations__ = {
                "application": application,
                "device": device,
                "vulnerability": vulnerability,
                "patch": patch,
            }
        additional_properties = schemas.NotAnyTypeSchema
    
    patch: 'DeviceVulnerabilityPatchInfo'
    application: 'VulnerableApplicationInfoSlim'
    vulnerability: 'DeviceVulnerabilityInfo'
    device: 'VulnerabilityAffectedDeviceInfo'
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["patch"]) -> 'DeviceVulnerabilityPatchInfo': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["application"]) -> 'VulnerableApplicationInfoSlim': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["vulnerability"]) -> 'DeviceVulnerabilityInfo': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["device"]) -> 'VulnerabilityAffectedDeviceInfo': ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["patch"], typing_extensions.Literal["application"], typing_extensions.Literal["vulnerability"], typing_extensions.Literal["device"], ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["patch"]) -> 'DeviceVulnerabilityPatchInfo': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["application"]) -> 'VulnerableApplicationInfoSlim': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["vulnerability"]) -> 'DeviceVulnerabilityInfo': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["device"]) -> 'VulnerabilityAffectedDeviceInfo': ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["patch"], typing_extensions.Literal["application"], typing_extensions.Literal["vulnerability"], typing_extensions.Literal["device"], ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        patch: 'DeviceVulnerabilityPatchInfo',
        application: 'VulnerableApplicationInfoSlim',
        vulnerability: 'DeviceVulnerabilityInfo',
        device: 'VulnerabilityAffectedDeviceInfo',
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'VulnerabilityAffectedDevice':
        return super().__new__(
            cls,
            *_args,
            patch=patch,
            application=application,
            vulnerability=vulnerability,
            device=device,
            _configuration=_configuration,
        )

from chkp_harmony_endpoint_management_sdk.generated.cloud.model.device_vulnerability_info import DeviceVulnerabilityInfo
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.device_vulnerability_patch_info import DeviceVulnerabilityPatchInfo
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.vulnerability_affected_device_info import VulnerabilityAffectedDeviceInfo
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.vulnerable_application_info_slim import VulnerableApplicationInfoSlim
