# coding: utf-8

# GTO-MO-1-1 - Removed partial_header
# flake8: noqa

from datetime import date, datetime
import decimal
import functools
import io
import re
import typing
import typing_extensions
import uuid

import frozendict

from chkp_harmony_endpoint_management_sdk.generated.cloud import schemas


class PushOperationStatus(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Describes a Push Operation\'s status and progress
    """

    class MetaOapg:
        required = {
            "adminName",
            "aborted",
            "remainingTimeoutSeconds",
            "id",
            "numberOfAffectedEntities",
            "type",
            "createdOn",
            "overallStatus",
        }
        
        class properties:
            id = schemas.StrSchema
            createdOn = schemas.DateTimeSchema
        
            @staticmethod
            def type() -> typing.Type['PushOperationType']:
                return PushOperationType
            numberOfAffectedEntities = schemas.Float64Schema
            
            
            class remainingTimeoutSeconds(
                schemas.Float64Schema
            ):
            
            
                class MetaOapg:
                    format = 'double'
                    inclusive_minimum = 0
            aborted = schemas.BoolSchema
            adminName = schemas.StrSchema
        
            @staticmethod
            def overallStatus() -> typing.Type['PushOperationOverallStatus']:
                return PushOperationOverallStatus
            comment = schemas.StrSchema
        
            @staticmethod
            def operationParameters() -> typing.Type['PossibleOperationParams']:
                return PossibleOperationParams
            __annotations__ = {
                "id": id,
                "createdOn": createdOn,
                "type": type,
                "numberOfAffectedEntities": numberOfAffectedEntities,
                "remainingTimeoutSeconds": remainingTimeoutSeconds,
                "aborted": aborted,
                "adminName": adminName,
                "overallStatus": overallStatus,
                "comment": comment,
                "operationParameters": operationParameters,
            }
        additional_properties = schemas.NotAnyTypeSchema
    
    adminName: MetaOapg.properties.adminName
    aborted: MetaOapg.properties.aborted
    remainingTimeoutSeconds: MetaOapg.properties.remainingTimeoutSeconds
    id: MetaOapg.properties.id
    numberOfAffectedEntities: MetaOapg.properties.numberOfAffectedEntities
    type: 'PushOperationType'
    createdOn: MetaOapg.properties.createdOn
    overallStatus: 'PushOperationOverallStatus'
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["adminName"]) -> MetaOapg.properties.adminName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["aborted"]) -> MetaOapg.properties.aborted: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["remainingTimeoutSeconds"]) -> MetaOapg.properties.remainingTimeoutSeconds: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["numberOfAffectedEntities"]) -> MetaOapg.properties.numberOfAffectedEntities: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["type"]) -> 'PushOperationType': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["createdOn"]) -> MetaOapg.properties.createdOn: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["overallStatus"]) -> 'PushOperationOverallStatus': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["comment"]) -> MetaOapg.properties.comment: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["operationParameters"]) -> 'PossibleOperationParams': ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["adminName"], typing_extensions.Literal["aborted"], typing_extensions.Literal["remainingTimeoutSeconds"], typing_extensions.Literal["id"], typing_extensions.Literal["numberOfAffectedEntities"], typing_extensions.Literal["type"], typing_extensions.Literal["createdOn"], typing_extensions.Literal["overallStatus"], typing_extensions.Literal["comment"], typing_extensions.Literal["operationParameters"], ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["adminName"]) -> MetaOapg.properties.adminName: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["aborted"]) -> MetaOapg.properties.aborted: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["remainingTimeoutSeconds"]) -> MetaOapg.properties.remainingTimeoutSeconds: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["numberOfAffectedEntities"]) -> MetaOapg.properties.numberOfAffectedEntities: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["type"]) -> 'PushOperationType': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["createdOn"]) -> MetaOapg.properties.createdOn: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["overallStatus"]) -> 'PushOperationOverallStatus': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["comment"]) -> typing.Union[MetaOapg.properties.comment, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["operationParameters"]) -> typing.Union['PossibleOperationParams', schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["adminName"], typing_extensions.Literal["aborted"], typing_extensions.Literal["remainingTimeoutSeconds"], typing_extensions.Literal["id"], typing_extensions.Literal["numberOfAffectedEntities"], typing_extensions.Literal["type"], typing_extensions.Literal["createdOn"], typing_extensions.Literal["overallStatus"], typing_extensions.Literal["comment"], typing_extensions.Literal["operationParameters"], ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        adminName: typing.Union[MetaOapg.properties.adminName, str, ],
        aborted: typing.Union[MetaOapg.properties.aborted, bool, ],
        remainingTimeoutSeconds: typing.Union[MetaOapg.properties.remainingTimeoutSeconds, decimal.Decimal, int, float, ],
        id: typing.Union[MetaOapg.properties.id, str, ],
        numberOfAffectedEntities: typing.Union[MetaOapg.properties.numberOfAffectedEntities, decimal.Decimal, int, float, ],
        type: 'PushOperationType',
        createdOn: typing.Union[MetaOapg.properties.createdOn, str, datetime, ],
        overallStatus: 'PushOperationOverallStatus',
        comment: typing.Union[MetaOapg.properties.comment, str, schemas.Unset] = schemas.unset,
        operationParameters: typing.Union['PossibleOperationParams', schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'PushOperationStatus':
        return super().__new__(
            cls,
            *_args,
            adminName=adminName,
            aborted=aborted,
            remainingTimeoutSeconds=remainingTimeoutSeconds,
            id=id,
            numberOfAffectedEntities=numberOfAffectedEntities,
            type=type,
            createdOn=createdOn,
            overallStatus=overallStatus,
            comment=comment,
            operationParameters=operationParameters,
            _configuration=_configuration,
        )

from chkp_harmony_endpoint_management_sdk.generated.cloud.model.possible_operation_params import PossibleOperationParams
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.push_operation_overall_status import PushOperationOverallStatus
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.push_operation_type import PushOperationType
