# coding: utf-8

# GTO-MO-1-1 - Removed partial_header
# flake8: noqa

from datetime import date, datetime
import decimal
import functools
import io
import re
import typing
import typing_extensions
import uuid

import frozendict

from chkp_harmony_endpoint_management_sdk.generated.cloud import schemas


class OperatingSystemSlimInfo(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Minimal information about a device\'s operating system
    """

    class MetaOapg:
        required = {
            "name",
            "type",
            "version",
        }
        
        class properties:
            name = schemas.StrSchema
            version = schemas.StrSchema
        
            @staticmethod
            def type() -> typing.Type['OperatingSystemType']:
                return OperatingSystemType
            __annotations__ = {
                "name": name,
                "version": version,
                "type": type,
            }
        additional_properties = schemas.NotAnyTypeSchema
    
    name: MetaOapg.properties.name
    type: 'OperatingSystemType'
    version: MetaOapg.properties.version
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["type"]) -> 'OperatingSystemType': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["version"]) -> MetaOapg.properties.version: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["name"], typing_extensions.Literal["type"], typing_extensions.Literal["version"], ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["type"]) -> 'OperatingSystemType': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["version"]) -> MetaOapg.properties.version: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["name"], typing_extensions.Literal["type"], typing_extensions.Literal["version"], ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        name: typing.Union[MetaOapg.properties.name, str, ],
        type: 'OperatingSystemType',
        version: typing.Union[MetaOapg.properties.version, str, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'OperatingSystemSlimInfo':
        return super().__new__(
            cls,
            *_args,
            name=name,
            type=type,
            version=version,
            _configuration=_configuration,
        )

from chkp_harmony_endpoint_management_sdk.generated.cloud.model.operating_system_type import OperatingSystemType
