# coding: utf-8

# GTO-MO-1-1 - Removed partial_header
# flake8: noqa

from datetime import date, datetime
import decimal
import functools
import io
import re
import typing
import typing_extensions
import uuid

import frozendict

from chkp_harmony_endpoint_management_sdk.generated.cloud import schemas


class ModifiedRule(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    A rule that has been modified since it was last installed
    """

    class MetaOapg:
        required = {
            "connectionState",
            "name",
            "modified",
            "id",
            "family",
        }
        
        class properties:
            id = schemas.StrSchema
        
            @staticmethod
            def connectionState() -> typing.Type['ConnectionState']:
                return ConnectionState
            name = schemas.StrSchema
        
            @staticmethod
            def family() -> typing.Type['AnyFamily']:
                return AnyFamily
        
            @staticmethod
            def modified() -> typing.Type['RuleModifications']:
                return RuleModifications
        
            @staticmethod
            def lastModifiedOn() -> typing.Type['StandardizedTimestamp']:
                return StandardizedTimestamp
            lastModifiedBy = schemas.StrSchema
            __annotations__ = {
                "id": id,
                "connectionState": connectionState,
                "name": name,
                "family": family,
                "modified": modified,
                "lastModifiedOn": lastModifiedOn,
                "lastModifiedBy": lastModifiedBy,
            }
        additional_properties = schemas.NotAnyTypeSchema
    
    connectionState: 'ConnectionState'
    name: MetaOapg.properties.name
    modified: 'RuleModifications'
    id: MetaOapg.properties.id
    family: 'AnyFamily'
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["connectionState"]) -> 'ConnectionState': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["modified"]) -> 'RuleModifications': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["family"]) -> 'AnyFamily': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["lastModifiedOn"]) -> 'StandardizedTimestamp': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["lastModifiedBy"]) -> MetaOapg.properties.lastModifiedBy: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["connectionState"], typing_extensions.Literal["name"], typing_extensions.Literal["modified"], typing_extensions.Literal["id"], typing_extensions.Literal["family"], typing_extensions.Literal["lastModifiedOn"], typing_extensions.Literal["lastModifiedBy"], ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["connectionState"]) -> 'ConnectionState': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["modified"]) -> 'RuleModifications': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["family"]) -> 'AnyFamily': ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["lastModifiedOn"]) -> typing.Union['StandardizedTimestamp', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["lastModifiedBy"]) -> typing.Union[MetaOapg.properties.lastModifiedBy, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["connectionState"], typing_extensions.Literal["name"], typing_extensions.Literal["modified"], typing_extensions.Literal["id"], typing_extensions.Literal["family"], typing_extensions.Literal["lastModifiedOn"], typing_extensions.Literal["lastModifiedBy"], ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        connectionState: 'ConnectionState',
        name: typing.Union[MetaOapg.properties.name, str, ],
        modified: 'RuleModifications',
        id: typing.Union[MetaOapg.properties.id, str, ],
        family: 'AnyFamily',
        lastModifiedOn: typing.Union['StandardizedTimestamp', schemas.Unset] = schemas.unset,
        lastModifiedBy: typing.Union[MetaOapg.properties.lastModifiedBy, str, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'ModifiedRule':
        return super().__new__(
            cls,
            *_args,
            connectionState=connectionState,
            name=name,
            modified=modified,
            id=id,
            family=family,
            lastModifiedOn=lastModifiedOn,
            lastModifiedBy=lastModifiedBy,
            _configuration=_configuration,
        )

from chkp_harmony_endpoint_management_sdk.generated.cloud.model.any_family import AnyFamily
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.connection_state import ConnectionState
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.rule_modifications import RuleModifications
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.standardized_timestamp import StandardizedTimestamp
