# coding: utf-8

# GTO-MO-1-1 - Removed partial_header
# flake8: noqa

from datetime import date, datetime
import decimal
import functools
import io
import re
import typing
import typing_extensions
import uuid

import frozendict

from chkp_harmony_endpoint_management_sdk.generated.cloud import schemas


class LoginResponse(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    An object providing details about the session returned by a login request
    """

    class MetaOapg:
        required = {
            "apiToken",
            "sessionExpiryUtcMillisecondEpoch",
            "sessionExpirySeconds",
        }
        
        class properties:
            apiToken = schemas.StrSchema
            sessionExpirySeconds = schemas.Int32Schema
            sessionExpiryUtcMillisecondEpoch = schemas.Int32Schema
            __annotations__ = {
                "apiToken": apiToken,
                "sessionExpirySeconds": sessionExpirySeconds,
                "sessionExpiryUtcMillisecondEpoch": sessionExpiryUtcMillisecondEpoch,
            }
        additional_properties = schemas.NotAnyTypeSchema
    
    apiToken: MetaOapg.properties.apiToken
    sessionExpiryUtcMillisecondEpoch: MetaOapg.properties.sessionExpiryUtcMillisecondEpoch
    sessionExpirySeconds: MetaOapg.properties.sessionExpirySeconds
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["apiToken"]) -> MetaOapg.properties.apiToken: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["sessionExpiryUtcMillisecondEpoch"]) -> MetaOapg.properties.sessionExpiryUtcMillisecondEpoch: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["sessionExpirySeconds"]) -> MetaOapg.properties.sessionExpirySeconds: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["apiToken"], typing_extensions.Literal["sessionExpiryUtcMillisecondEpoch"], typing_extensions.Literal["sessionExpirySeconds"], ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["apiToken"]) -> MetaOapg.properties.apiToken: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["sessionExpiryUtcMillisecondEpoch"]) -> MetaOapg.properties.sessionExpiryUtcMillisecondEpoch: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["sessionExpirySeconds"]) -> MetaOapg.properties.sessionExpirySeconds: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["apiToken"], typing_extensions.Literal["sessionExpiryUtcMillisecondEpoch"], typing_extensions.Literal["sessionExpirySeconds"], ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        apiToken: typing.Union[MetaOapg.properties.apiToken, str, ],
        sessionExpiryUtcMillisecondEpoch: typing.Union[MetaOapg.properties.sessionExpiryUtcMillisecondEpoch, decimal.Decimal, int, ],
        sessionExpirySeconds: typing.Union[MetaOapg.properties.sessionExpirySeconds, decimal.Decimal, int, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'LoginResponse':
        return super().__new__(
            cls,
            *_args,
            apiToken=apiToken,
            sessionExpiryUtcMillisecondEpoch=sessionExpiryUtcMillisecondEpoch,
            sessionExpirySeconds=sessionExpirySeconds,
            _configuration=_configuration,
        )
