# coding: utf-8

# GTO-MO-1-1 - Removed partial_header
# flake8: noqa

from datetime import date, datetime
import decimal
import functools
import io
import re
import typing
import typing_extensions
import uuid

import frozendict

from chkp_harmony_endpoint_management_sdk.generated.cloud import schemas


class IThreatPreventionProtectionsSystem(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    class MetaOapg:
        
        class properties:
        
            @staticmethod
            def malware() -> typing.Type['PolicySettingsIMalwareProtectionBladeAntiMalware']:
                return PolicySettingsIMalwareProtectionBladeAntiMalware
        
            @staticmethod
            def bot() -> typing.Type['PolicySettingsIBotProtectionBladeAntiBot']:
                return PolicySettingsIBotProtectionBladeAntiBot
        
            @staticmethod
            def behavioral() -> typing.Type['PolicySettingsIBehavioralProtectionBladeForensics']:
                return PolicySettingsIBehavioralProtectionBladeForensics
        
            @staticmethod
            def exploit() -> typing.Type['PolicySettingsIExploitProtectionBladeThreatEmulation']:
                return PolicySettingsIExploitProtectionBladeThreatEmulation
            __annotations__ = {
                "malware": malware,
                "bot": bot,
                "behavioral": behavioral,
                "exploit": exploit,
            }
        additional_properties = schemas.NotAnyTypeSchema
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["malware"]) -> 'PolicySettingsIMalwareProtectionBladeAntiMalware': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["bot"]) -> 'PolicySettingsIBotProtectionBladeAntiBot': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["behavioral"]) -> 'PolicySettingsIBehavioralProtectionBladeForensics': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["exploit"]) -> 'PolicySettingsIExploitProtectionBladeThreatEmulation': ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["malware"], typing_extensions.Literal["bot"], typing_extensions.Literal["behavioral"], typing_extensions.Literal["exploit"], ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["malware"]) -> typing.Union['PolicySettingsIMalwareProtectionBladeAntiMalware', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["bot"]) -> typing.Union['PolicySettingsIBotProtectionBladeAntiBot', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["behavioral"]) -> typing.Union['PolicySettingsIBehavioralProtectionBladeForensics', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["exploit"]) -> typing.Union['PolicySettingsIExploitProtectionBladeThreatEmulation', schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["malware"], typing_extensions.Literal["bot"], typing_extensions.Literal["behavioral"], typing_extensions.Literal["exploit"], ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        malware: typing.Union['PolicySettingsIMalwareProtectionBladeAntiMalware', schemas.Unset] = schemas.unset,
        bot: typing.Union['PolicySettingsIBotProtectionBladeAntiBot', schemas.Unset] = schemas.unset,
        behavioral: typing.Union['PolicySettingsIBehavioralProtectionBladeForensics', schemas.Unset] = schemas.unset,
        exploit: typing.Union['PolicySettingsIExploitProtectionBladeThreatEmulation', schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'IThreatPreventionProtectionsSystem':
        return super().__new__(
            cls,
            *_args,
            malware=malware,
            bot=bot,
            behavioral=behavioral,
            exploit=exploit,
            _configuration=_configuration,
        )

from chkp_harmony_endpoint_management_sdk.generated.cloud.model.policy_settings_i_behavioral_protection_blade_forensics import PolicySettingsIBehavioralProtectionBladeForensics
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.policy_settings_i_bot_protection_blade_anti_bot import PolicySettingsIBotProtectionBladeAntiBot
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.policy_settings_i_exploit_protection_blade_threat_emulation import PolicySettingsIExploitProtectionBladeThreatEmulation
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.policy_settings_i_malware_protection_blade_anti_malware import PolicySettingsIMalwareProtectionBladeAntiMalware
