# coding: utf-8

# GTO-MO-1-1 - Removed partial_header
# flake8: noqa

from datetime import date, datetime
import decimal
import functools
import io
import re
import typing
import typing_extensions
import uuid

import frozendict

from chkp_harmony_endpoint_management_sdk.generated.cloud import schemas


class IMalwareProtectionScanScheduledScan(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    class MetaOapg:
        
        class properties:
            scanStartHour = schemas.Float64Schema
            scanDayOfMonth = schemas.Float64Schema
        
            @staticmethod
            def scanDayOfWeek() -> typing.Type['WeekDay']:
                return WeekDay
        
            @staticmethod
            def interval() -> typing.Type['IntervalPeriod']:
                return IntervalPeriod
            enabled = schemas.BoolSchema
            __annotations__ = {
                "scanStartHour": scanStartHour,
                "scanDayOfMonth": scanDayOfMonth,
                "scanDayOfWeek": scanDayOfWeek,
                "interval": interval,
                "enabled": enabled,
            }
        additional_properties = schemas.NotAnyTypeSchema
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["scanStartHour"]) -> MetaOapg.properties.scanStartHour: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["scanDayOfMonth"]) -> MetaOapg.properties.scanDayOfMonth: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["scanDayOfWeek"]) -> 'WeekDay': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["interval"]) -> 'IntervalPeriod': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enabled"]) -> MetaOapg.properties.enabled: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["scanStartHour"], typing_extensions.Literal["scanDayOfMonth"], typing_extensions.Literal["scanDayOfWeek"], typing_extensions.Literal["interval"], typing_extensions.Literal["enabled"], ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["scanStartHour"]) -> typing.Union[MetaOapg.properties.scanStartHour, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["scanDayOfMonth"]) -> typing.Union[MetaOapg.properties.scanDayOfMonth, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["scanDayOfWeek"]) -> typing.Union['WeekDay', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["interval"]) -> typing.Union['IntervalPeriod', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enabled"]) -> typing.Union[MetaOapg.properties.enabled, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["scanStartHour"], typing_extensions.Literal["scanDayOfMonth"], typing_extensions.Literal["scanDayOfWeek"], typing_extensions.Literal["interval"], typing_extensions.Literal["enabled"], ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        scanStartHour: typing.Union[MetaOapg.properties.scanStartHour, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        scanDayOfMonth: typing.Union[MetaOapg.properties.scanDayOfMonth, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        scanDayOfWeek: typing.Union['WeekDay', schemas.Unset] = schemas.unset,
        interval: typing.Union['IntervalPeriod', schemas.Unset] = schemas.unset,
        enabled: typing.Union[MetaOapg.properties.enabled, bool, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'IMalwareProtectionScanScheduledScan':
        return super().__new__(
            cls,
            *_args,
            scanStartHour=scanStartHour,
            scanDayOfMonth=scanDayOfMonth,
            scanDayOfWeek=scanDayOfWeek,
            interval=interval,
            enabled=enabled,
            _configuration=_configuration,
        )

from chkp_harmony_endpoint_management_sdk.generated.cloud.model.interval_period import IntervalPeriod
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.week_day import WeekDay
