# coding: utf-8

# GTO-MO-1-1 - Removed partial_header
# flake8: noqa

from datetime import date, datetime
import decimal
import functools
import io
import re
import typing
import typing_extensions
import uuid

import frozendict

from chkp_harmony_endpoint_management_sdk.generated.cloud import schemas


class IMalwareProtectionScan(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    class MetaOapg:
        
        class properties:
        
            @staticmethod
            def scanTargets() -> typing.Type['IMalwareProtectionScanScanTargets']:
                return IMalwareProtectionScanScanTargets
        
            @staticmethod
            def randomizedScan() -> typing.Type['IMalwareProtectionScanRandomizedScan']:
                return IMalwareProtectionScanRandomizedScan
        
            @staticmethod
            def scheduledScan() -> typing.Type['IMalwareProtectionScanScheduledScan']:
                return IMalwareProtectionScanScheduledScan
        
            @staticmethod
            def onAccessScan() -> typing.Type['IMalwareProtectionScanOnAccessScan']:
                return IMalwareProtectionScanOnAccessScan
        
            @staticmethod
            def scanOnIdle() -> typing.Type['IMalwareProtectionScanScanOnIdle']:
                return IMalwareProtectionScanScanOnIdle
            prohibitCancelScan = schemas.BoolSchema
            setMaxScanCancelDays = schemas.BoolSchema
            maxScanCancelDays = schemas.Float64Schema
            enableScanOptimization = schemas.BoolSchema
            forceInitialScan = schemas.BoolSchema
            __annotations__ = {
                "scanTargets": scanTargets,
                "randomizedScan": randomizedScan,
                "scheduledScan": scheduledScan,
                "onAccessScan": onAccessScan,
                "scanOnIdle": scanOnIdle,
                "prohibitCancelScan": prohibitCancelScan,
                "setMaxScanCancelDays": setMaxScanCancelDays,
                "maxScanCancelDays": maxScanCancelDays,
                "enableScanOptimization": enableScanOptimization,
                "forceInitialScan": forceInitialScan,
            }
        additional_properties = schemas.NotAnyTypeSchema
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["scanTargets"]) -> 'IMalwareProtectionScanScanTargets': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["randomizedScan"]) -> 'IMalwareProtectionScanRandomizedScan': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["scheduledScan"]) -> 'IMalwareProtectionScanScheduledScan': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["onAccessScan"]) -> 'IMalwareProtectionScanOnAccessScan': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["scanOnIdle"]) -> 'IMalwareProtectionScanScanOnIdle': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["prohibitCancelScan"]) -> MetaOapg.properties.prohibitCancelScan: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["setMaxScanCancelDays"]) -> MetaOapg.properties.setMaxScanCancelDays: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["maxScanCancelDays"]) -> MetaOapg.properties.maxScanCancelDays: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enableScanOptimization"]) -> MetaOapg.properties.enableScanOptimization: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["forceInitialScan"]) -> MetaOapg.properties.forceInitialScan: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["scanTargets"], typing_extensions.Literal["randomizedScan"], typing_extensions.Literal["scheduledScan"], typing_extensions.Literal["onAccessScan"], typing_extensions.Literal["scanOnIdle"], typing_extensions.Literal["prohibitCancelScan"], typing_extensions.Literal["setMaxScanCancelDays"], typing_extensions.Literal["maxScanCancelDays"], typing_extensions.Literal["enableScanOptimization"], typing_extensions.Literal["forceInitialScan"], ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["scanTargets"]) -> typing.Union['IMalwareProtectionScanScanTargets', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["randomizedScan"]) -> typing.Union['IMalwareProtectionScanRandomizedScan', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["scheduledScan"]) -> typing.Union['IMalwareProtectionScanScheduledScan', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["onAccessScan"]) -> typing.Union['IMalwareProtectionScanOnAccessScan', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["scanOnIdle"]) -> typing.Union['IMalwareProtectionScanScanOnIdle', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["prohibitCancelScan"]) -> typing.Union[MetaOapg.properties.prohibitCancelScan, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["setMaxScanCancelDays"]) -> typing.Union[MetaOapg.properties.setMaxScanCancelDays, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["maxScanCancelDays"]) -> typing.Union[MetaOapg.properties.maxScanCancelDays, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enableScanOptimization"]) -> typing.Union[MetaOapg.properties.enableScanOptimization, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["forceInitialScan"]) -> typing.Union[MetaOapg.properties.forceInitialScan, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["scanTargets"], typing_extensions.Literal["randomizedScan"], typing_extensions.Literal["scheduledScan"], typing_extensions.Literal["onAccessScan"], typing_extensions.Literal["scanOnIdle"], typing_extensions.Literal["prohibitCancelScan"], typing_extensions.Literal["setMaxScanCancelDays"], typing_extensions.Literal["maxScanCancelDays"], typing_extensions.Literal["enableScanOptimization"], typing_extensions.Literal["forceInitialScan"], ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        scanTargets: typing.Union['IMalwareProtectionScanScanTargets', schemas.Unset] = schemas.unset,
        randomizedScan: typing.Union['IMalwareProtectionScanRandomizedScan', schemas.Unset] = schemas.unset,
        scheduledScan: typing.Union['IMalwareProtectionScanScheduledScan', schemas.Unset] = schemas.unset,
        onAccessScan: typing.Union['IMalwareProtectionScanOnAccessScan', schemas.Unset] = schemas.unset,
        scanOnIdle: typing.Union['IMalwareProtectionScanScanOnIdle', schemas.Unset] = schemas.unset,
        prohibitCancelScan: typing.Union[MetaOapg.properties.prohibitCancelScan, bool, schemas.Unset] = schemas.unset,
        setMaxScanCancelDays: typing.Union[MetaOapg.properties.setMaxScanCancelDays, bool, schemas.Unset] = schemas.unset,
        maxScanCancelDays: typing.Union[MetaOapg.properties.maxScanCancelDays, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        enableScanOptimization: typing.Union[MetaOapg.properties.enableScanOptimization, bool, schemas.Unset] = schemas.unset,
        forceInitialScan: typing.Union[MetaOapg.properties.forceInitialScan, bool, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'IMalwareProtectionScan':
        return super().__new__(
            cls,
            *_args,
            scanTargets=scanTargets,
            randomizedScan=randomizedScan,
            scheduledScan=scheduledScan,
            onAccessScan=onAccessScan,
            scanOnIdle=scanOnIdle,
            prohibitCancelScan=prohibitCancelScan,
            setMaxScanCancelDays=setMaxScanCancelDays,
            maxScanCancelDays=maxScanCancelDays,
            enableScanOptimization=enableScanOptimization,
            forceInitialScan=forceInitialScan,
            _configuration=_configuration,
        )

from chkp_harmony_endpoint_management_sdk.generated.cloud.model.i_malware_protection_scan_on_access_scan import IMalwareProtectionScanOnAccessScan
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.i_malware_protection_scan_randomized_scan import IMalwareProtectionScanRandomizedScan
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.i_malware_protection_scan_scan_on_idle import IMalwareProtectionScanScanOnIdle
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.i_malware_protection_scan_scan_targets import IMalwareProtectionScanScanTargets
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.i_malware_protection_scan_scheduled_scan import IMalwareProtectionScanScheduledScan
