# coding: utf-8

# GTO-MO-1-1 - Removed partial_header
# flake8: noqa

from datetime import date, datetime
import decimal
import functools
import io
import re
import typing
import typing_extensions
import uuid

import frozendict

from chkp_harmony_endpoint_management_sdk.generated.cloud import schemas


class IMalwareProtection(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    class MetaOapg:
        
        class properties:
            enableAntiMalware = schemas.BoolSchema
        
            @staticmethod
            def antiMalwareMode() -> typing.Type['CapabilityMode']:
                return CapabilityMode
        
            @staticmethod
            def scan() -> typing.Type['IMalwareProtectionScan']:
                return IMalwareProtectionScan
        
            @staticmethod
            def treatment() -> typing.Type['IMalwareProtectionTreatment']:
                return IMalwareProtectionTreatment
        
            @staticmethod
            def signatures() -> typing.Type['IMalwareProtectionSignatures']:
                return IMalwareProtectionSignatures
            __annotations__ = {
                "enableAntiMalware": enableAntiMalware,
                "antiMalwareMode": antiMalwareMode,
                "scan": scan,
                "treatment": treatment,
                "signatures": signatures,
            }
        additional_properties = schemas.NotAnyTypeSchema
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enableAntiMalware"]) -> MetaOapg.properties.enableAntiMalware: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["antiMalwareMode"]) -> 'CapabilityMode': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["scan"]) -> 'IMalwareProtectionScan': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["treatment"]) -> 'IMalwareProtectionTreatment': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["signatures"]) -> 'IMalwareProtectionSignatures': ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["enableAntiMalware"], typing_extensions.Literal["antiMalwareMode"], typing_extensions.Literal["scan"], typing_extensions.Literal["treatment"], typing_extensions.Literal["signatures"], ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enableAntiMalware"]) -> typing.Union[MetaOapg.properties.enableAntiMalware, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["antiMalwareMode"]) -> typing.Union['CapabilityMode', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["scan"]) -> typing.Union['IMalwareProtectionScan', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["treatment"]) -> typing.Union['IMalwareProtectionTreatment', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["signatures"]) -> typing.Union['IMalwareProtectionSignatures', schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["enableAntiMalware"], typing_extensions.Literal["antiMalwareMode"], typing_extensions.Literal["scan"], typing_extensions.Literal["treatment"], typing_extensions.Literal["signatures"], ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        enableAntiMalware: typing.Union[MetaOapg.properties.enableAntiMalware, bool, schemas.Unset] = schemas.unset,
        antiMalwareMode: typing.Union['CapabilityMode', schemas.Unset] = schemas.unset,
        scan: typing.Union['IMalwareProtectionScan', schemas.Unset] = schemas.unset,
        treatment: typing.Union['IMalwareProtectionTreatment', schemas.Unset] = schemas.unset,
        signatures: typing.Union['IMalwareProtectionSignatures', schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'IMalwareProtection':
        return super().__new__(
            cls,
            *_args,
            enableAntiMalware=enableAntiMalware,
            antiMalwareMode=antiMalwareMode,
            scan=scan,
            treatment=treatment,
            signatures=signatures,
            _configuration=_configuration,
        )

from chkp_harmony_endpoint_management_sdk.generated.cloud.model.capability_mode import CapabilityMode
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.i_malware_protection_scan import IMalwareProtectionScan
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.i_malware_protection_signatures import IMalwareProtectionSignatures
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.i_malware_protection_treatment import IMalwareProtectionTreatment
