# coding: utf-8

# GTO-MO-1-1 - Removed partial_header
# flake8: noqa

from datetime import date, datetime
import decimal
import functools
import io
import re
import typing
import typing_extensions
import uuid

import frozendict

from chkp_harmony_endpoint_management_sdk.generated.cloud import schemas


class DeviceVulnerabilityInfo(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Describes a vulnerability affecting a device or multiple devices
    """

    class MetaOapg:
        required = {
            "versionId",
            "cvssScore",
            "cveId",
            "affectedDevicesCount",
            "description",
            "comment",
            "cveIdVersionId",
            "firstScanned",
            "lastScanned",
        }
        
        class properties:
            cveId = schemas.StrSchema
            versionId = schemas.Float64Schema
            cveIdVersionId = schemas.StrSchema
            cvssScore = schemas.Float64Schema
            lastScanned = schemas.DateTimeSchema
            firstScanned = schemas.DateTimeSchema
            affectedDevicesCount = schemas.Int32Schema
            comment = schemas.StrSchema
            description = schemas.StrSchema
            __annotations__ = {
                "cveId": cveId,
                "versionId": versionId,
                "cveIdVersionId": cveIdVersionId,
                "cvssScore": cvssScore,
                "lastScanned": lastScanned,
                "firstScanned": firstScanned,
                "affectedDevicesCount": affectedDevicesCount,
                "comment": comment,
                "description": description,
            }
        additional_properties = schemas.NotAnyTypeSchema
    
    versionId: MetaOapg.properties.versionId
    cvssScore: MetaOapg.properties.cvssScore
    cveId: MetaOapg.properties.cveId
    affectedDevicesCount: MetaOapg.properties.affectedDevicesCount
    description: MetaOapg.properties.description
    comment: MetaOapg.properties.comment
    cveIdVersionId: MetaOapg.properties.cveIdVersionId
    firstScanned: MetaOapg.properties.firstScanned
    lastScanned: MetaOapg.properties.lastScanned
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["versionId"]) -> MetaOapg.properties.versionId: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["cvssScore"]) -> MetaOapg.properties.cvssScore: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["cveId"]) -> MetaOapg.properties.cveId: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["affectedDevicesCount"]) -> MetaOapg.properties.affectedDevicesCount: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["description"]) -> MetaOapg.properties.description: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["comment"]) -> MetaOapg.properties.comment: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["cveIdVersionId"]) -> MetaOapg.properties.cveIdVersionId: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["firstScanned"]) -> MetaOapg.properties.firstScanned: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["lastScanned"]) -> MetaOapg.properties.lastScanned: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["versionId"], typing_extensions.Literal["cvssScore"], typing_extensions.Literal["cveId"], typing_extensions.Literal["affectedDevicesCount"], typing_extensions.Literal["description"], typing_extensions.Literal["comment"], typing_extensions.Literal["cveIdVersionId"], typing_extensions.Literal["firstScanned"], typing_extensions.Literal["lastScanned"], ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["versionId"]) -> MetaOapg.properties.versionId: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["cvssScore"]) -> MetaOapg.properties.cvssScore: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["cveId"]) -> MetaOapg.properties.cveId: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["affectedDevicesCount"]) -> MetaOapg.properties.affectedDevicesCount: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["description"]) -> MetaOapg.properties.description: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["comment"]) -> MetaOapg.properties.comment: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["cveIdVersionId"]) -> MetaOapg.properties.cveIdVersionId: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["firstScanned"]) -> MetaOapg.properties.firstScanned: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["lastScanned"]) -> MetaOapg.properties.lastScanned: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["versionId"], typing_extensions.Literal["cvssScore"], typing_extensions.Literal["cveId"], typing_extensions.Literal["affectedDevicesCount"], typing_extensions.Literal["description"], typing_extensions.Literal["comment"], typing_extensions.Literal["cveIdVersionId"], typing_extensions.Literal["firstScanned"], typing_extensions.Literal["lastScanned"], ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        versionId: typing.Union[MetaOapg.properties.versionId, decimal.Decimal, int, float, ],
        cvssScore: typing.Union[MetaOapg.properties.cvssScore, decimal.Decimal, int, float, ],
        cveId: typing.Union[MetaOapg.properties.cveId, str, ],
        affectedDevicesCount: typing.Union[MetaOapg.properties.affectedDevicesCount, decimal.Decimal, int, ],
        description: typing.Union[MetaOapg.properties.description, str, ],
        comment: typing.Union[MetaOapg.properties.comment, str, ],
        cveIdVersionId: typing.Union[MetaOapg.properties.cveIdVersionId, str, ],
        firstScanned: typing.Union[MetaOapg.properties.firstScanned, str, datetime, ],
        lastScanned: typing.Union[MetaOapg.properties.lastScanned, str, datetime, ],
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'DeviceVulnerabilityInfo':
        return super().__new__(
            cls,
            *_args,
            versionId=versionId,
            cvssScore=cvssScore,
            cveId=cveId,
            affectedDevicesCount=affectedDevicesCount,
            description=description,
            comment=comment,
            cveIdVersionId=cveIdVersionId,
            firstScanned=firstScanned,
            lastScanned=lastScanned,
            _configuration=_configuration,
        )
