# coding: utf-8

# GTO-MO-1-1 - Removed partial_header
# flake8: noqa

from datetime import date, datetime
import decimal
import functools
import io
import re
import typing
import typing_extensions
import uuid

import frozendict

from chkp_harmony_endpoint_management_sdk.generated.cloud import schemas


class Computer(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    class MetaOapg:
        required = {
            "computerFdeTpmId",
            "computerFdeLastRecoveryDate",
            "computerFdeVersion",
            "computerFdeWilWolStatus",
            "computerFdeWilWolStatusUpdatedOn",
            "computerFdeTpmVersion",
            "computerFdeTpmStatus",
        }
        
        class properties:
            computerFdeVersion = schemas.StrSchema
            computerFdeWilWolStatus = schemas.StrSchema
            computerFdeWilWolStatusUpdatedOn = schemas.StrSchema
            computerFdeLastRecoveryDate = schemas.StrSchema
            computerFdeTpmStatus = schemas.StrSchema
            computerFdeTpmVersion = schemas.StrSchema
            computerFdeTpmId = schemas.StrSchema
        
            @staticmethod
            def browserExtension() -> typing.Type['BrowserExtension']:
                return BrowserExtension
        
            @staticmethod
            def threatEmulation() -> typing.Type['ThreatEmulation']:
                return ThreatEmulation
        
            @staticmethod
            def efr() -> typing.Type['Efr']:
                return Efr
        
            @staticmethod
            def antiBot() -> typing.Type['AntiBot']:
                return AntiBot
        
            @staticmethod
            def antiMalware() -> typing.Type['AntiMalware']:
                return AntiMalware
        
            @staticmethod
            def endpointForServers() -> typing.Type['EndpointForServers']:
                return EndpointForServers
        
            @staticmethod
            def daWinPatchInformation() -> typing.Type['DaWinPatchInformation']:
                return DaWinPatchInformation
        
            @staticmethod
            def posture() -> typing.Type['Posture']:
                return Posture
            computerId = schemas.StrSchema
            computerName = schemas.StrSchema
        
            @staticmethod
            def computerDeploymentStatus() -> typing.Type['DeploymentStatus']:
                return DeploymentStatus
            computerIP = schemas.StrSchema
        
            @staticmethod
            def computerCapabilities() -> typing.Type['ICapabilities']:
                return ICapabilities
            computerClientVersion = schemas.StrSchema
            computerDeployTime = schemas.DateTimeSchema
            computerLastErrorCode = schemas.StrSchema
            computerLastErrorDescription = schemas.StrSchema
            
            
            class computerGroups(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['IBaseGroup']:
                        return IBaseGroup
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple['IBaseGroup'], typing.List['IBaseGroup']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'computerGroups':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'IBaseGroup':
                    return super().__getitem__(i)
            computerLastConnection = schemas.DateTimeSchema
            computerSyncedon = schemas.DateTimeSchema
            computerLastLoggedInUser = schemas.StrSchema
            computerUserName = schemas.StrSchema
            computerLastLoggedInPrebootUser = schemas.StrSchema
            computerFdeStatus = schemas.StrSchema
            computerFdeProgress = schemas.StrSchema
            daInstalled = schemas.BoolSchema
        
            @staticmethod
            def computerType() -> typing.Type['ComputerType']:
                return ComputerType
            amUpdatedOn = schemas.StrSchema
            osName = schemas.StrSchema
            osVersion = schemas.StrSchema
            isolationStatus = schemas.StrSchema
            distinguishedName = schemas.StrSchema
            isDeleted = schemas.BoolSchema
            amStatus = schemas.StrSchema
            complianceStatus = schemas.StrSchema
            deviceComment = schemas.StrSchema
            extraCol1 = schemas.StrSchema
            canonicalName = schemas.StrSchema
            
            
            class deviceParents(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['SlimDeviceParentNode']:
                        return SlimDeviceParentNode
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple['SlimDeviceParentNode'], typing.List['SlimDeviceParentNode']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'deviceParents':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'SlimDeviceParentNode':
                    return super().__getitem__(i)
            isInDomain = schemas.BoolSchema
            domainName = schemas.StrSchema
        
            @staticmethod
            def endpointType() -> typing.Type['EndpointTypeStatus']:
                return EndpointTypeStatus
            o_x = schemas.StrSchema
            scannerId = schemas.StrSchema
            computerAmDatVersion = schemas.StrSchema
            computerAmDatDate = schemas.StrSchema
            computerAmLicExpirationDate = schemas.StrSchema
            computerAmTotalInfected = schemas.StrSchema
            computerAmVersion = schemas.StrSchema
            
            
            class computerAmInfections(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.AnyTypeSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ]], typing.List[typing.Union[MetaOapg.items, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'computerAmInfections':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            computerNotRunningBladesMask = schemas.StrSchema
            computerSdPackageName = schemas.StrSchema
            computerSdPolicyName = schemas.StrSchema
            computerSdPolicyVersion = schemas.StrSchema
            computerAbState = schemas.StrSchema
            
            
            class computerAbStatusBotNames(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.AnyTypeSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ]], typing.List[typing.Union[MetaOapg.items, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'computerAbStatusBotNames':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            computerAmScannedon = schemas.StrSchema
            computerAmTotalQuarantined = schemas.StrSchema
            computerLastContactedPolicyServerIp = schemas.StrSchema
            computerLastContactedPolicyServerName = schemas.StrSchema
            computerSdPackageVersion = schemas.StrSchema
            
            
            class computerComplianceViolationIds(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    items = schemas.AnyTypeSchema
            
                def __new__(
                    cls,
                    _arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ]], typing.List[typing.Union[MetaOapg.items, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'computerComplianceViolationIds':
                    return super().__new__(
                        cls,
                        _arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class computerStatusSummary(
                schemas.DictSchema
            ):
            
                class MetaOapg:
                    additional_properties = schemas.AnyTypeSchema
                
                def __getitem__(self, name: typing.Union[str, ]) -> MetaOapg.additional_properties:
                    # dict_instance[name] accessor
                    return super().__getitem__(name)
                
                def get_item_oapg(self, name: typing.Union[str, ]) -> MetaOapg.additional_properties:
                    return super().get_item_oapg(name)
            
                def __new__(
                    cls,
                    *_args: typing.Union[dict, frozendict.frozendict, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                    **kwargs: typing.Union[MetaOapg.additional_properties, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ],
                ) -> 'computerStatusSummary':
                    return super().__new__(
                        cls,
                        *_args,
                        _configuration=_configuration,
                        **kwargs,
                    )
            computerFdePrebootStatusUpdatedOn = schemas.StrSchema
            
            
            class computerSmartCardStatus(
                schemas.Float64Base,
                schemas.NumberBase,
                schemas.NoneBase,
                schemas.Schema,
                schemas.NoneDecimalMixin
            ):
            
            
                class MetaOapg:
                    format = 'double'
            
            
                def __new__(
                    cls,
                    *_args: typing.Union[None, decimal.Decimal, int, float, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'computerSmartCardStatus':
                    return super().__new__(
                        cls,
                        *_args,
                        _configuration=_configuration,
                    )
        
            @staticmethod
            def fdeRemoteUnlockOperation() -> typing.Type['FdeRemoteOperation']:
                return FdeRemoteOperation
            fdeRemoteUnlockUserName = schemas.StrSchema
            fdeRemoteUnlockStatus = schemas.StrSchema
            fdeRecoveryType = schemas.StrSchema
            enforcedModifiedOn = schemas.DateTimeSchema
            enforcedPolicyMalware20 = schemas.StrSchema
            enforcedPolicyTe130 = schemas.StrSchema
            enforcedPolicyEfr120 = schemas.StrSchema
            enforcedPolicyAntibot100 = schemas.StrSchema
            enforcedPolicyMe30 = schemas.StrSchema
            enforcedPolicyFdeDevice35 = schemas.StrSchema
            enforcedPolicyFdeUser36 = schemas.StrSchema
            enforcedPolicyFw10 = schemas.StrSchema
            enforcedPolicyCompliance60 = schemas.StrSchema
            enforcedPolicyApplicationControl22 = schemas.StrSchema
            enforcedPolicySaAccessZones11 = schemas.StrSchema
            enforcedPolicyCommonClientSettings51 = schemas.StrSchema
            enforcedPolicyDocSecPolicy91 = schemas.StrSchema
            enforcedVersionPolicyMalware20 = schemas.Float64Schema
            enforcedVersionPolicyTe130 = schemas.Float64Schema
            enforcedVersionPolicyEfr120 = schemas.Float64Schema
            enforcedVersionPolicyAntibot100 = schemas.Float64Schema
            enforcedVersionPolicyMe30 = schemas.Float64Schema
            enforcedVersionPolicyFdeDevice35 = schemas.Float64Schema
            enforcedVersionPolicyFdeUser36 = schemas.Float64Schema
            enforcedVersionPolicyFw10 = schemas.Float64Schema
            enforcedVersionPolicyCompliance60 = schemas.Float64Schema
            enforcedVersionPolicyApplicationControl22 = schemas.Float64Schema
            enforcedVersionPolicySaAccessZones11 = schemas.Float64Schema
            enforcedVersionPolicyCommonClientSettings51 = schemas.Float64Schema
            enforcedVersionPolicyDocSecPolicy91 = schemas.Float64Schema
            enforcedNamePolicyMalware20 = schemas.StrSchema
            enforcedNamePolicyTe130 = schemas.StrSchema
            enforcedNamePolicyEfr120 = schemas.StrSchema
            enforcedNamePolicyAntibot100 = schemas.StrSchema
            enforcedNamePolicyMe30 = schemas.StrSchema
            enforcedNamePolicyFdeDevice35 = schemas.StrSchema
            enforcedNamePolicyFdeUser36 = schemas.StrSchema
            enforcedNamePolicyFw10 = schemas.StrSchema
            enforcedNamePolicyCompliance60 = schemas.StrSchema
            enforcedNamePolicyApplicationControl22 = schemas.StrSchema
            enforcedNamePolicySaAccessZones11 = schemas.StrSchema
            enforcedNamePolicyCommonClientSettings51 = schemas.StrSchema
            enforcedNamePolicyDocSecPolicy91 = schemas.StrSchema
            deployedModifiedOn = schemas.DateTimeSchema
            deployedPolicyMalware20 = schemas.StrSchema
            deployedPolicyTe130 = schemas.StrSchema
            deployedPolicyEfr120 = schemas.StrSchema
            deployedPolicyAntibot100 = schemas.StrSchema
            deployedPolicyMe30 = schemas.StrSchema
            deployedPolicyFdeDevice35 = schemas.StrSchema
            deployedPolicyFdeUser36 = schemas.StrSchema
            deployedPolicyFw10 = schemas.StrSchema
            deployedPolicyCompliance60 = schemas.StrSchema
            deployedPolicyApplicationControl22 = schemas.StrSchema
            deployedPolicySaAccessZones11 = schemas.StrSchema
            deployedPolicyCommonClientSettings51 = schemas.StrSchema
            deployedPolicyDocSecPolicy91 = schemas.StrSchema
            deployedVersionPolicyMalware20 = schemas.Float64Schema
            deployedVersionPolicyTe130 = schemas.Float64Schema
            deployedVersionPolicyEfr120 = schemas.Float64Schema
            deployedVersionPolicyAntibot100 = schemas.Float64Schema
            deployedVersionPolicyMe30 = schemas.Float64Schema
            deployedVersionPolicyFdeDevice35 = schemas.Float64Schema
            deployedVersionPolicyFdeUser36 = schemas.Float64Schema
            deployedVersionPolicyFw10 = schemas.Float64Schema
            deployedVersionPolicyCompliance60 = schemas.Float64Schema
            deployedVersionPolicyApplicationControl22 = schemas.Float64Schema
            deployedVersionPolicySaAccessZones11 = schemas.Float64Schema
            deployedVersionPolicyCommonClientSettings51 = schemas.Float64Schema
            deployedVersionPolicyDocSecPolicy91 = schemas.Float64Schema
            deployedNamePolicyMalware20 = schemas.StrSchema
            deployedNamePolicyTe130 = schemas.StrSchema
            deployedNamePolicyEfr120 = schemas.StrSchema
            deployedNamePolicyAntibot100 = schemas.StrSchema
            deployedNamePolicyMe30 = schemas.StrSchema
            deployedNamePolicyFdeDevice35 = schemas.StrSchema
            deployedNamePolicyFdeUser36 = schemas.StrSchema
            deployedNamePolicyFw10 = schemas.StrSchema
            deployedNamePolicyCompliance60 = schemas.StrSchema
            deployedNamePolicyApplicationControl22 = schemas.StrSchema
            deployedNamePolicySaAccessZones11 = schemas.StrSchema
            deployedNamePolicyCommonClientSettings51 = schemas.StrSchema
            deployedNamePolicyDocSecPolicy91 = schemas.StrSchema
            computerCpuLoadCategory = schemas.StrSchema
            computerTotalCpuLoadCategory = schemas.StrSchema
            computerCpuRank = schemas.Float64Schema
            computerTotalCpuRank = schemas.Float64Schema
            amProviderBrand = schemas.StrSchema
            __annotations__ = {
                "computerFdeVersion": computerFdeVersion,
                "computerFdeWilWolStatus": computerFdeWilWolStatus,
                "computerFdeWilWolStatusUpdatedOn": computerFdeWilWolStatusUpdatedOn,
                "computerFdeLastRecoveryDate": computerFdeLastRecoveryDate,
                "computerFdeTpmStatus": computerFdeTpmStatus,
                "computerFdeTpmVersion": computerFdeTpmVersion,
                "computerFdeTpmId": computerFdeTpmId,
                "browserExtension": browserExtension,
                "threatEmulation": threatEmulation,
                "efr": efr,
                "antiBot": antiBot,
                "antiMalware": antiMalware,
                "endpointForServers": endpointForServers,
                "daWinPatchInformation": daWinPatchInformation,
                "posture": posture,
                "computerId": computerId,
                "computerName": computerName,
                "computerDeploymentStatus": computerDeploymentStatus,
                "computerIP": computerIP,
                "computerCapabilities": computerCapabilities,
                "computerClientVersion": computerClientVersion,
                "computerDeployTime": computerDeployTime,
                "computerLastErrorCode": computerLastErrorCode,
                "computerLastErrorDescription": computerLastErrorDescription,
                "computerGroups": computerGroups,
                "computerLastConnection": computerLastConnection,
                "computerSyncedon": computerSyncedon,
                "computerLastLoggedInUser": computerLastLoggedInUser,
                "computerUserName": computerUserName,
                "computerLastLoggedInPrebootUser": computerLastLoggedInPrebootUser,
                "computerFdeStatus": computerFdeStatus,
                "computerFdeProgress": computerFdeProgress,
                "daInstalled": daInstalled,
                "computerType": computerType,
                "amUpdatedOn": amUpdatedOn,
                "osName": osName,
                "osVersion": osVersion,
                "isolationStatus": isolationStatus,
                "distinguishedName": distinguishedName,
                "isDeleted": isDeleted,
                "amStatus": amStatus,
                "complianceStatus": complianceStatus,
                "deviceComment": deviceComment,
                "extraCol1": extraCol1,
                "canonicalName": canonicalName,
                "deviceParents": deviceParents,
                "isInDomain": isInDomain,
                "domainName": domainName,
                "endpointType": endpointType,
                "o_x": o_x,
                "scannerId": scannerId,
                "computerAmDatVersion": computerAmDatVersion,
                "computerAmDatDate": computerAmDatDate,
                "computerAmLicExpirationDate": computerAmLicExpirationDate,
                "computerAmTotalInfected": computerAmTotalInfected,
                "computerAmVersion": computerAmVersion,
                "computerAmInfections": computerAmInfections,
                "computerNotRunningBladesMask": computerNotRunningBladesMask,
                "computerSdPackageName": computerSdPackageName,
                "computerSdPolicyName": computerSdPolicyName,
                "computerSdPolicyVersion": computerSdPolicyVersion,
                "computerAbState": computerAbState,
                "computerAbStatusBotNames": computerAbStatusBotNames,
                "computerAmScannedon": computerAmScannedon,
                "computerAmTotalQuarantined": computerAmTotalQuarantined,
                "computerLastContactedPolicyServerIp": computerLastContactedPolicyServerIp,
                "computerLastContactedPolicyServerName": computerLastContactedPolicyServerName,
                "computerSdPackageVersion": computerSdPackageVersion,
                "computerComplianceViolationIds": computerComplianceViolationIds,
                "computerStatusSummary": computerStatusSummary,
                "computerFdePrebootStatusUpdatedOn": computerFdePrebootStatusUpdatedOn,
                "computerSmartCardStatus": computerSmartCardStatus,
                "fdeRemoteUnlockOperation": fdeRemoteUnlockOperation,
                "fdeRemoteUnlockUserName": fdeRemoteUnlockUserName,
                "fdeRemoteUnlockStatus": fdeRemoteUnlockStatus,
                "fdeRecoveryType": fdeRecoveryType,
                "enforcedModifiedOn": enforcedModifiedOn,
                "enforcedPolicyMalware20": enforcedPolicyMalware20,
                "enforcedPolicyTe130": enforcedPolicyTe130,
                "enforcedPolicyEfr120": enforcedPolicyEfr120,
                "enforcedPolicyAntibot100": enforcedPolicyAntibot100,
                "enforcedPolicyMe30": enforcedPolicyMe30,
                "enforcedPolicyFdeDevice35": enforcedPolicyFdeDevice35,
                "enforcedPolicyFdeUser36": enforcedPolicyFdeUser36,
                "enforcedPolicyFw10": enforcedPolicyFw10,
                "enforcedPolicyCompliance60": enforcedPolicyCompliance60,
                "enforcedPolicyApplicationControl22": enforcedPolicyApplicationControl22,
                "enforcedPolicySaAccessZones11": enforcedPolicySaAccessZones11,
                "enforcedPolicyCommonClientSettings51": enforcedPolicyCommonClientSettings51,
                "enforcedPolicyDocSecPolicy91": enforcedPolicyDocSecPolicy91,
                "enforcedVersionPolicyMalware20": enforcedVersionPolicyMalware20,
                "enforcedVersionPolicyTe130": enforcedVersionPolicyTe130,
                "enforcedVersionPolicyEfr120": enforcedVersionPolicyEfr120,
                "enforcedVersionPolicyAntibot100": enforcedVersionPolicyAntibot100,
                "enforcedVersionPolicyMe30": enforcedVersionPolicyMe30,
                "enforcedVersionPolicyFdeDevice35": enforcedVersionPolicyFdeDevice35,
                "enforcedVersionPolicyFdeUser36": enforcedVersionPolicyFdeUser36,
                "enforcedVersionPolicyFw10": enforcedVersionPolicyFw10,
                "enforcedVersionPolicyCompliance60": enforcedVersionPolicyCompliance60,
                "enforcedVersionPolicyApplicationControl22": enforcedVersionPolicyApplicationControl22,
                "enforcedVersionPolicySaAccessZones11": enforcedVersionPolicySaAccessZones11,
                "enforcedVersionPolicyCommonClientSettings51": enforcedVersionPolicyCommonClientSettings51,
                "enforcedVersionPolicyDocSecPolicy91": enforcedVersionPolicyDocSecPolicy91,
                "enforcedNamePolicyMalware20": enforcedNamePolicyMalware20,
                "enforcedNamePolicyTe130": enforcedNamePolicyTe130,
                "enforcedNamePolicyEfr120": enforcedNamePolicyEfr120,
                "enforcedNamePolicyAntibot100": enforcedNamePolicyAntibot100,
                "enforcedNamePolicyMe30": enforcedNamePolicyMe30,
                "enforcedNamePolicyFdeDevice35": enforcedNamePolicyFdeDevice35,
                "enforcedNamePolicyFdeUser36": enforcedNamePolicyFdeUser36,
                "enforcedNamePolicyFw10": enforcedNamePolicyFw10,
                "enforcedNamePolicyCompliance60": enforcedNamePolicyCompliance60,
                "enforcedNamePolicyApplicationControl22": enforcedNamePolicyApplicationControl22,
                "enforcedNamePolicySaAccessZones11": enforcedNamePolicySaAccessZones11,
                "enforcedNamePolicyCommonClientSettings51": enforcedNamePolicyCommonClientSettings51,
                "enforcedNamePolicyDocSecPolicy91": enforcedNamePolicyDocSecPolicy91,
                "deployedModifiedOn": deployedModifiedOn,
                "deployedPolicyMalware20": deployedPolicyMalware20,
                "deployedPolicyTe130": deployedPolicyTe130,
                "deployedPolicyEfr120": deployedPolicyEfr120,
                "deployedPolicyAntibot100": deployedPolicyAntibot100,
                "deployedPolicyMe30": deployedPolicyMe30,
                "deployedPolicyFdeDevice35": deployedPolicyFdeDevice35,
                "deployedPolicyFdeUser36": deployedPolicyFdeUser36,
                "deployedPolicyFw10": deployedPolicyFw10,
                "deployedPolicyCompliance60": deployedPolicyCompliance60,
                "deployedPolicyApplicationControl22": deployedPolicyApplicationControl22,
                "deployedPolicySaAccessZones11": deployedPolicySaAccessZones11,
                "deployedPolicyCommonClientSettings51": deployedPolicyCommonClientSettings51,
                "deployedPolicyDocSecPolicy91": deployedPolicyDocSecPolicy91,
                "deployedVersionPolicyMalware20": deployedVersionPolicyMalware20,
                "deployedVersionPolicyTe130": deployedVersionPolicyTe130,
                "deployedVersionPolicyEfr120": deployedVersionPolicyEfr120,
                "deployedVersionPolicyAntibot100": deployedVersionPolicyAntibot100,
                "deployedVersionPolicyMe30": deployedVersionPolicyMe30,
                "deployedVersionPolicyFdeDevice35": deployedVersionPolicyFdeDevice35,
                "deployedVersionPolicyFdeUser36": deployedVersionPolicyFdeUser36,
                "deployedVersionPolicyFw10": deployedVersionPolicyFw10,
                "deployedVersionPolicyCompliance60": deployedVersionPolicyCompliance60,
                "deployedVersionPolicyApplicationControl22": deployedVersionPolicyApplicationControl22,
                "deployedVersionPolicySaAccessZones11": deployedVersionPolicySaAccessZones11,
                "deployedVersionPolicyCommonClientSettings51": deployedVersionPolicyCommonClientSettings51,
                "deployedVersionPolicyDocSecPolicy91": deployedVersionPolicyDocSecPolicy91,
                "deployedNamePolicyMalware20": deployedNamePolicyMalware20,
                "deployedNamePolicyTe130": deployedNamePolicyTe130,
                "deployedNamePolicyEfr120": deployedNamePolicyEfr120,
                "deployedNamePolicyAntibot100": deployedNamePolicyAntibot100,
                "deployedNamePolicyMe30": deployedNamePolicyMe30,
                "deployedNamePolicyFdeDevice35": deployedNamePolicyFdeDevice35,
                "deployedNamePolicyFdeUser36": deployedNamePolicyFdeUser36,
                "deployedNamePolicyFw10": deployedNamePolicyFw10,
                "deployedNamePolicyCompliance60": deployedNamePolicyCompliance60,
                "deployedNamePolicyApplicationControl22": deployedNamePolicyApplicationControl22,
                "deployedNamePolicySaAccessZones11": deployedNamePolicySaAccessZones11,
                "deployedNamePolicyCommonClientSettings51": deployedNamePolicyCommonClientSettings51,
                "deployedNamePolicyDocSecPolicy91": deployedNamePolicyDocSecPolicy91,
                "computerCpuLoadCategory": computerCpuLoadCategory,
                "computerTotalCpuLoadCategory": computerTotalCpuLoadCategory,
                "computerCpuRank": computerCpuRank,
                "computerTotalCpuRank": computerTotalCpuRank,
                "amProviderBrand": amProviderBrand,
            }
        additional_properties = schemas.NotAnyTypeSchema
    
    computerFdeTpmId: MetaOapg.properties.computerFdeTpmId
    computerFdeLastRecoveryDate: MetaOapg.properties.computerFdeLastRecoveryDate
    computerFdeVersion: MetaOapg.properties.computerFdeVersion
    computerFdeWilWolStatus: MetaOapg.properties.computerFdeWilWolStatus
    computerFdeWilWolStatusUpdatedOn: MetaOapg.properties.computerFdeWilWolStatusUpdatedOn
    computerFdeTpmVersion: MetaOapg.properties.computerFdeTpmVersion
    computerFdeTpmStatus: MetaOapg.properties.computerFdeTpmStatus
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerFdeTpmId"]) -> MetaOapg.properties.computerFdeTpmId: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerFdeLastRecoveryDate"]) -> MetaOapg.properties.computerFdeLastRecoveryDate: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerFdeVersion"]) -> MetaOapg.properties.computerFdeVersion: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerFdeWilWolStatus"]) -> MetaOapg.properties.computerFdeWilWolStatus: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerFdeWilWolStatusUpdatedOn"]) -> MetaOapg.properties.computerFdeWilWolStatusUpdatedOn: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerFdeTpmVersion"]) -> MetaOapg.properties.computerFdeTpmVersion: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerFdeTpmStatus"]) -> MetaOapg.properties.computerFdeTpmStatus: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["browserExtension"]) -> 'BrowserExtension': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["threatEmulation"]) -> 'ThreatEmulation': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["efr"]) -> 'Efr': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["antiBot"]) -> 'AntiBot': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["antiMalware"]) -> 'AntiMalware': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["endpointForServers"]) -> 'EndpointForServers': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["daWinPatchInformation"]) -> 'DaWinPatchInformation': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["posture"]) -> 'Posture': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerId"]) -> MetaOapg.properties.computerId: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerName"]) -> MetaOapg.properties.computerName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerDeploymentStatus"]) -> 'DeploymentStatus': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerIP"]) -> MetaOapg.properties.computerIP: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerCapabilities"]) -> 'ICapabilities': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerClientVersion"]) -> MetaOapg.properties.computerClientVersion: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerDeployTime"]) -> MetaOapg.properties.computerDeployTime: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerLastErrorCode"]) -> MetaOapg.properties.computerLastErrorCode: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerLastErrorDescription"]) -> MetaOapg.properties.computerLastErrorDescription: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerGroups"]) -> MetaOapg.properties.computerGroups: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerLastConnection"]) -> MetaOapg.properties.computerLastConnection: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerSyncedon"]) -> MetaOapg.properties.computerSyncedon: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerLastLoggedInUser"]) -> MetaOapg.properties.computerLastLoggedInUser: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerUserName"]) -> MetaOapg.properties.computerUserName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerLastLoggedInPrebootUser"]) -> MetaOapg.properties.computerLastLoggedInPrebootUser: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerFdeStatus"]) -> MetaOapg.properties.computerFdeStatus: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerFdeProgress"]) -> MetaOapg.properties.computerFdeProgress: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["daInstalled"]) -> MetaOapg.properties.daInstalled: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerType"]) -> 'ComputerType': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["amUpdatedOn"]) -> MetaOapg.properties.amUpdatedOn: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["osName"]) -> MetaOapg.properties.osName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["osVersion"]) -> MetaOapg.properties.osVersion: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["isolationStatus"]) -> MetaOapg.properties.isolationStatus: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["distinguishedName"]) -> MetaOapg.properties.distinguishedName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["isDeleted"]) -> MetaOapg.properties.isDeleted: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["amStatus"]) -> MetaOapg.properties.amStatus: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["complianceStatus"]) -> MetaOapg.properties.complianceStatus: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deviceComment"]) -> MetaOapg.properties.deviceComment: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["extraCol1"]) -> MetaOapg.properties.extraCol1: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["canonicalName"]) -> MetaOapg.properties.canonicalName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deviceParents"]) -> MetaOapg.properties.deviceParents: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["isInDomain"]) -> MetaOapg.properties.isInDomain: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["domainName"]) -> MetaOapg.properties.domainName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["endpointType"]) -> 'EndpointTypeStatus': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["o_x"]) -> MetaOapg.properties.o_x: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["scannerId"]) -> MetaOapg.properties.scannerId: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerAmDatVersion"]) -> MetaOapg.properties.computerAmDatVersion: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerAmDatDate"]) -> MetaOapg.properties.computerAmDatDate: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerAmLicExpirationDate"]) -> MetaOapg.properties.computerAmLicExpirationDate: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerAmTotalInfected"]) -> MetaOapg.properties.computerAmTotalInfected: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerAmVersion"]) -> MetaOapg.properties.computerAmVersion: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerAmInfections"]) -> MetaOapg.properties.computerAmInfections: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerNotRunningBladesMask"]) -> MetaOapg.properties.computerNotRunningBladesMask: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerSdPackageName"]) -> MetaOapg.properties.computerSdPackageName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerSdPolicyName"]) -> MetaOapg.properties.computerSdPolicyName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerSdPolicyVersion"]) -> MetaOapg.properties.computerSdPolicyVersion: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerAbState"]) -> MetaOapg.properties.computerAbState: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerAbStatusBotNames"]) -> MetaOapg.properties.computerAbStatusBotNames: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerAmScannedon"]) -> MetaOapg.properties.computerAmScannedon: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerAmTotalQuarantined"]) -> MetaOapg.properties.computerAmTotalQuarantined: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerLastContactedPolicyServerIp"]) -> MetaOapg.properties.computerLastContactedPolicyServerIp: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerLastContactedPolicyServerName"]) -> MetaOapg.properties.computerLastContactedPolicyServerName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerSdPackageVersion"]) -> MetaOapg.properties.computerSdPackageVersion: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerComplianceViolationIds"]) -> MetaOapg.properties.computerComplianceViolationIds: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerStatusSummary"]) -> MetaOapg.properties.computerStatusSummary: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerFdePrebootStatusUpdatedOn"]) -> MetaOapg.properties.computerFdePrebootStatusUpdatedOn: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerSmartCardStatus"]) -> MetaOapg.properties.computerSmartCardStatus: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["fdeRemoteUnlockOperation"]) -> 'FdeRemoteOperation': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["fdeRemoteUnlockUserName"]) -> MetaOapg.properties.fdeRemoteUnlockUserName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["fdeRemoteUnlockStatus"]) -> MetaOapg.properties.fdeRemoteUnlockStatus: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["fdeRecoveryType"]) -> MetaOapg.properties.fdeRecoveryType: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedModifiedOn"]) -> MetaOapg.properties.enforcedModifiedOn: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedPolicyMalware20"]) -> MetaOapg.properties.enforcedPolicyMalware20: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedPolicyTe130"]) -> MetaOapg.properties.enforcedPolicyTe130: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedPolicyEfr120"]) -> MetaOapg.properties.enforcedPolicyEfr120: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedPolicyAntibot100"]) -> MetaOapg.properties.enforcedPolicyAntibot100: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedPolicyMe30"]) -> MetaOapg.properties.enforcedPolicyMe30: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedPolicyFdeDevice35"]) -> MetaOapg.properties.enforcedPolicyFdeDevice35: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedPolicyFdeUser36"]) -> MetaOapg.properties.enforcedPolicyFdeUser36: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedPolicyFw10"]) -> MetaOapg.properties.enforcedPolicyFw10: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedPolicyCompliance60"]) -> MetaOapg.properties.enforcedPolicyCompliance60: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedPolicyApplicationControl22"]) -> MetaOapg.properties.enforcedPolicyApplicationControl22: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedPolicySaAccessZones11"]) -> MetaOapg.properties.enforcedPolicySaAccessZones11: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedPolicyCommonClientSettings51"]) -> MetaOapg.properties.enforcedPolicyCommonClientSettings51: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedPolicyDocSecPolicy91"]) -> MetaOapg.properties.enforcedPolicyDocSecPolicy91: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedVersionPolicyMalware20"]) -> MetaOapg.properties.enforcedVersionPolicyMalware20: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedVersionPolicyTe130"]) -> MetaOapg.properties.enforcedVersionPolicyTe130: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedVersionPolicyEfr120"]) -> MetaOapg.properties.enforcedVersionPolicyEfr120: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedVersionPolicyAntibot100"]) -> MetaOapg.properties.enforcedVersionPolicyAntibot100: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedVersionPolicyMe30"]) -> MetaOapg.properties.enforcedVersionPolicyMe30: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedVersionPolicyFdeDevice35"]) -> MetaOapg.properties.enforcedVersionPolicyFdeDevice35: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedVersionPolicyFdeUser36"]) -> MetaOapg.properties.enforcedVersionPolicyFdeUser36: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedVersionPolicyFw10"]) -> MetaOapg.properties.enforcedVersionPolicyFw10: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedVersionPolicyCompliance60"]) -> MetaOapg.properties.enforcedVersionPolicyCompliance60: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedVersionPolicyApplicationControl22"]) -> MetaOapg.properties.enforcedVersionPolicyApplicationControl22: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedVersionPolicySaAccessZones11"]) -> MetaOapg.properties.enforcedVersionPolicySaAccessZones11: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedVersionPolicyCommonClientSettings51"]) -> MetaOapg.properties.enforcedVersionPolicyCommonClientSettings51: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedVersionPolicyDocSecPolicy91"]) -> MetaOapg.properties.enforcedVersionPolicyDocSecPolicy91: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedNamePolicyMalware20"]) -> MetaOapg.properties.enforcedNamePolicyMalware20: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedNamePolicyTe130"]) -> MetaOapg.properties.enforcedNamePolicyTe130: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedNamePolicyEfr120"]) -> MetaOapg.properties.enforcedNamePolicyEfr120: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedNamePolicyAntibot100"]) -> MetaOapg.properties.enforcedNamePolicyAntibot100: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedNamePolicyMe30"]) -> MetaOapg.properties.enforcedNamePolicyMe30: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedNamePolicyFdeDevice35"]) -> MetaOapg.properties.enforcedNamePolicyFdeDevice35: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedNamePolicyFdeUser36"]) -> MetaOapg.properties.enforcedNamePolicyFdeUser36: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedNamePolicyFw10"]) -> MetaOapg.properties.enforcedNamePolicyFw10: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedNamePolicyCompliance60"]) -> MetaOapg.properties.enforcedNamePolicyCompliance60: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedNamePolicyApplicationControl22"]) -> MetaOapg.properties.enforcedNamePolicyApplicationControl22: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedNamePolicySaAccessZones11"]) -> MetaOapg.properties.enforcedNamePolicySaAccessZones11: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedNamePolicyCommonClientSettings51"]) -> MetaOapg.properties.enforcedNamePolicyCommonClientSettings51: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enforcedNamePolicyDocSecPolicy91"]) -> MetaOapg.properties.enforcedNamePolicyDocSecPolicy91: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedModifiedOn"]) -> MetaOapg.properties.deployedModifiedOn: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedPolicyMalware20"]) -> MetaOapg.properties.deployedPolicyMalware20: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedPolicyTe130"]) -> MetaOapg.properties.deployedPolicyTe130: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedPolicyEfr120"]) -> MetaOapg.properties.deployedPolicyEfr120: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedPolicyAntibot100"]) -> MetaOapg.properties.deployedPolicyAntibot100: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedPolicyMe30"]) -> MetaOapg.properties.deployedPolicyMe30: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedPolicyFdeDevice35"]) -> MetaOapg.properties.deployedPolicyFdeDevice35: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedPolicyFdeUser36"]) -> MetaOapg.properties.deployedPolicyFdeUser36: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedPolicyFw10"]) -> MetaOapg.properties.deployedPolicyFw10: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedPolicyCompliance60"]) -> MetaOapg.properties.deployedPolicyCompliance60: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedPolicyApplicationControl22"]) -> MetaOapg.properties.deployedPolicyApplicationControl22: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedPolicySaAccessZones11"]) -> MetaOapg.properties.deployedPolicySaAccessZones11: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedPolicyCommonClientSettings51"]) -> MetaOapg.properties.deployedPolicyCommonClientSettings51: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedPolicyDocSecPolicy91"]) -> MetaOapg.properties.deployedPolicyDocSecPolicy91: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedVersionPolicyMalware20"]) -> MetaOapg.properties.deployedVersionPolicyMalware20: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedVersionPolicyTe130"]) -> MetaOapg.properties.deployedVersionPolicyTe130: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedVersionPolicyEfr120"]) -> MetaOapg.properties.deployedVersionPolicyEfr120: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedVersionPolicyAntibot100"]) -> MetaOapg.properties.deployedVersionPolicyAntibot100: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedVersionPolicyMe30"]) -> MetaOapg.properties.deployedVersionPolicyMe30: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedVersionPolicyFdeDevice35"]) -> MetaOapg.properties.deployedVersionPolicyFdeDevice35: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedVersionPolicyFdeUser36"]) -> MetaOapg.properties.deployedVersionPolicyFdeUser36: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedVersionPolicyFw10"]) -> MetaOapg.properties.deployedVersionPolicyFw10: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedVersionPolicyCompliance60"]) -> MetaOapg.properties.deployedVersionPolicyCompliance60: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedVersionPolicyApplicationControl22"]) -> MetaOapg.properties.deployedVersionPolicyApplicationControl22: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedVersionPolicySaAccessZones11"]) -> MetaOapg.properties.deployedVersionPolicySaAccessZones11: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedVersionPolicyCommonClientSettings51"]) -> MetaOapg.properties.deployedVersionPolicyCommonClientSettings51: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedVersionPolicyDocSecPolicy91"]) -> MetaOapg.properties.deployedVersionPolicyDocSecPolicy91: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedNamePolicyMalware20"]) -> MetaOapg.properties.deployedNamePolicyMalware20: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedNamePolicyTe130"]) -> MetaOapg.properties.deployedNamePolicyTe130: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedNamePolicyEfr120"]) -> MetaOapg.properties.deployedNamePolicyEfr120: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedNamePolicyAntibot100"]) -> MetaOapg.properties.deployedNamePolicyAntibot100: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedNamePolicyMe30"]) -> MetaOapg.properties.deployedNamePolicyMe30: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedNamePolicyFdeDevice35"]) -> MetaOapg.properties.deployedNamePolicyFdeDevice35: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedNamePolicyFdeUser36"]) -> MetaOapg.properties.deployedNamePolicyFdeUser36: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedNamePolicyFw10"]) -> MetaOapg.properties.deployedNamePolicyFw10: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedNamePolicyCompliance60"]) -> MetaOapg.properties.deployedNamePolicyCompliance60: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedNamePolicyApplicationControl22"]) -> MetaOapg.properties.deployedNamePolicyApplicationControl22: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedNamePolicySaAccessZones11"]) -> MetaOapg.properties.deployedNamePolicySaAccessZones11: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedNamePolicyCommonClientSettings51"]) -> MetaOapg.properties.deployedNamePolicyCommonClientSettings51: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["deployedNamePolicyDocSecPolicy91"]) -> MetaOapg.properties.deployedNamePolicyDocSecPolicy91: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerCpuLoadCategory"]) -> MetaOapg.properties.computerCpuLoadCategory: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerTotalCpuLoadCategory"]) -> MetaOapg.properties.computerTotalCpuLoadCategory: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerCpuRank"]) -> MetaOapg.properties.computerCpuRank: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["computerTotalCpuRank"]) -> MetaOapg.properties.computerTotalCpuRank: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["amProviderBrand"]) -> MetaOapg.properties.amProviderBrand: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["computerFdeTpmId"], typing_extensions.Literal["computerFdeLastRecoveryDate"], typing_extensions.Literal["computerFdeVersion"], typing_extensions.Literal["computerFdeWilWolStatus"], typing_extensions.Literal["computerFdeWilWolStatusUpdatedOn"], typing_extensions.Literal["computerFdeTpmVersion"], typing_extensions.Literal["computerFdeTpmStatus"], typing_extensions.Literal["browserExtension"], typing_extensions.Literal["threatEmulation"], typing_extensions.Literal["efr"], typing_extensions.Literal["antiBot"], typing_extensions.Literal["antiMalware"], typing_extensions.Literal["endpointForServers"], typing_extensions.Literal["daWinPatchInformation"], typing_extensions.Literal["posture"], typing_extensions.Literal["computerId"], typing_extensions.Literal["computerName"], typing_extensions.Literal["computerDeploymentStatus"], typing_extensions.Literal["computerIP"], typing_extensions.Literal["computerCapabilities"], typing_extensions.Literal["computerClientVersion"], typing_extensions.Literal["computerDeployTime"], typing_extensions.Literal["computerLastErrorCode"], typing_extensions.Literal["computerLastErrorDescription"], typing_extensions.Literal["computerGroups"], typing_extensions.Literal["computerLastConnection"], typing_extensions.Literal["computerSyncedon"], typing_extensions.Literal["computerLastLoggedInUser"], typing_extensions.Literal["computerUserName"], typing_extensions.Literal["computerLastLoggedInPrebootUser"], typing_extensions.Literal["computerFdeStatus"], typing_extensions.Literal["computerFdeProgress"], typing_extensions.Literal["daInstalled"], typing_extensions.Literal["computerType"], typing_extensions.Literal["amUpdatedOn"], typing_extensions.Literal["osName"], typing_extensions.Literal["osVersion"], typing_extensions.Literal["isolationStatus"], typing_extensions.Literal["distinguishedName"], typing_extensions.Literal["isDeleted"], typing_extensions.Literal["amStatus"], typing_extensions.Literal["complianceStatus"], typing_extensions.Literal["deviceComment"], typing_extensions.Literal["extraCol1"], typing_extensions.Literal["canonicalName"], typing_extensions.Literal["deviceParents"], typing_extensions.Literal["isInDomain"], typing_extensions.Literal["domainName"], typing_extensions.Literal["endpointType"], typing_extensions.Literal["o_x"], typing_extensions.Literal["scannerId"], typing_extensions.Literal["computerAmDatVersion"], typing_extensions.Literal["computerAmDatDate"], typing_extensions.Literal["computerAmLicExpirationDate"], typing_extensions.Literal["computerAmTotalInfected"], typing_extensions.Literal["computerAmVersion"], typing_extensions.Literal["computerAmInfections"], typing_extensions.Literal["computerNotRunningBladesMask"], typing_extensions.Literal["computerSdPackageName"], typing_extensions.Literal["computerSdPolicyName"], typing_extensions.Literal["computerSdPolicyVersion"], typing_extensions.Literal["computerAbState"], typing_extensions.Literal["computerAbStatusBotNames"], typing_extensions.Literal["computerAmScannedon"], typing_extensions.Literal["computerAmTotalQuarantined"], typing_extensions.Literal["computerLastContactedPolicyServerIp"], typing_extensions.Literal["computerLastContactedPolicyServerName"], typing_extensions.Literal["computerSdPackageVersion"], typing_extensions.Literal["computerComplianceViolationIds"], typing_extensions.Literal["computerStatusSummary"], typing_extensions.Literal["computerFdePrebootStatusUpdatedOn"], typing_extensions.Literal["computerSmartCardStatus"], typing_extensions.Literal["fdeRemoteUnlockOperation"], typing_extensions.Literal["fdeRemoteUnlockUserName"], typing_extensions.Literal["fdeRemoteUnlockStatus"], typing_extensions.Literal["fdeRecoveryType"], typing_extensions.Literal["enforcedModifiedOn"], typing_extensions.Literal["enforcedPolicyMalware20"], typing_extensions.Literal["enforcedPolicyTe130"], typing_extensions.Literal["enforcedPolicyEfr120"], typing_extensions.Literal["enforcedPolicyAntibot100"], typing_extensions.Literal["enforcedPolicyMe30"], typing_extensions.Literal["enforcedPolicyFdeDevice35"], typing_extensions.Literal["enforcedPolicyFdeUser36"], typing_extensions.Literal["enforcedPolicyFw10"], typing_extensions.Literal["enforcedPolicyCompliance60"], typing_extensions.Literal["enforcedPolicyApplicationControl22"], typing_extensions.Literal["enforcedPolicySaAccessZones11"], typing_extensions.Literal["enforcedPolicyCommonClientSettings51"], typing_extensions.Literal["enforcedPolicyDocSecPolicy91"], typing_extensions.Literal["enforcedVersionPolicyMalware20"], typing_extensions.Literal["enforcedVersionPolicyTe130"], typing_extensions.Literal["enforcedVersionPolicyEfr120"], typing_extensions.Literal["enforcedVersionPolicyAntibot100"], typing_extensions.Literal["enforcedVersionPolicyMe30"], typing_extensions.Literal["enforcedVersionPolicyFdeDevice35"], typing_extensions.Literal["enforcedVersionPolicyFdeUser36"], typing_extensions.Literal["enforcedVersionPolicyFw10"], typing_extensions.Literal["enforcedVersionPolicyCompliance60"], typing_extensions.Literal["enforcedVersionPolicyApplicationControl22"], typing_extensions.Literal["enforcedVersionPolicySaAccessZones11"], typing_extensions.Literal["enforcedVersionPolicyCommonClientSettings51"], typing_extensions.Literal["enforcedVersionPolicyDocSecPolicy91"], typing_extensions.Literal["enforcedNamePolicyMalware20"], typing_extensions.Literal["enforcedNamePolicyTe130"], typing_extensions.Literal["enforcedNamePolicyEfr120"], typing_extensions.Literal["enforcedNamePolicyAntibot100"], typing_extensions.Literal["enforcedNamePolicyMe30"], typing_extensions.Literal["enforcedNamePolicyFdeDevice35"], typing_extensions.Literal["enforcedNamePolicyFdeUser36"], typing_extensions.Literal["enforcedNamePolicyFw10"], typing_extensions.Literal["enforcedNamePolicyCompliance60"], typing_extensions.Literal["enforcedNamePolicyApplicationControl22"], typing_extensions.Literal["enforcedNamePolicySaAccessZones11"], typing_extensions.Literal["enforcedNamePolicyCommonClientSettings51"], typing_extensions.Literal["enforcedNamePolicyDocSecPolicy91"], typing_extensions.Literal["deployedModifiedOn"], typing_extensions.Literal["deployedPolicyMalware20"], typing_extensions.Literal["deployedPolicyTe130"], typing_extensions.Literal["deployedPolicyEfr120"], typing_extensions.Literal["deployedPolicyAntibot100"], typing_extensions.Literal["deployedPolicyMe30"], typing_extensions.Literal["deployedPolicyFdeDevice35"], typing_extensions.Literal["deployedPolicyFdeUser36"], typing_extensions.Literal["deployedPolicyFw10"], typing_extensions.Literal["deployedPolicyCompliance60"], typing_extensions.Literal["deployedPolicyApplicationControl22"], typing_extensions.Literal["deployedPolicySaAccessZones11"], typing_extensions.Literal["deployedPolicyCommonClientSettings51"], typing_extensions.Literal["deployedPolicyDocSecPolicy91"], typing_extensions.Literal["deployedVersionPolicyMalware20"], typing_extensions.Literal["deployedVersionPolicyTe130"], typing_extensions.Literal["deployedVersionPolicyEfr120"], typing_extensions.Literal["deployedVersionPolicyAntibot100"], typing_extensions.Literal["deployedVersionPolicyMe30"], typing_extensions.Literal["deployedVersionPolicyFdeDevice35"], typing_extensions.Literal["deployedVersionPolicyFdeUser36"], typing_extensions.Literal["deployedVersionPolicyFw10"], typing_extensions.Literal["deployedVersionPolicyCompliance60"], typing_extensions.Literal["deployedVersionPolicyApplicationControl22"], typing_extensions.Literal["deployedVersionPolicySaAccessZones11"], typing_extensions.Literal["deployedVersionPolicyCommonClientSettings51"], typing_extensions.Literal["deployedVersionPolicyDocSecPolicy91"], typing_extensions.Literal["deployedNamePolicyMalware20"], typing_extensions.Literal["deployedNamePolicyTe130"], typing_extensions.Literal["deployedNamePolicyEfr120"], typing_extensions.Literal["deployedNamePolicyAntibot100"], typing_extensions.Literal["deployedNamePolicyMe30"], typing_extensions.Literal["deployedNamePolicyFdeDevice35"], typing_extensions.Literal["deployedNamePolicyFdeUser36"], typing_extensions.Literal["deployedNamePolicyFw10"], typing_extensions.Literal["deployedNamePolicyCompliance60"], typing_extensions.Literal["deployedNamePolicyApplicationControl22"], typing_extensions.Literal["deployedNamePolicySaAccessZones11"], typing_extensions.Literal["deployedNamePolicyCommonClientSettings51"], typing_extensions.Literal["deployedNamePolicyDocSecPolicy91"], typing_extensions.Literal["computerCpuLoadCategory"], typing_extensions.Literal["computerTotalCpuLoadCategory"], typing_extensions.Literal["computerCpuRank"], typing_extensions.Literal["computerTotalCpuRank"], typing_extensions.Literal["amProviderBrand"], ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerFdeTpmId"]) -> MetaOapg.properties.computerFdeTpmId: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerFdeLastRecoveryDate"]) -> MetaOapg.properties.computerFdeLastRecoveryDate: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerFdeVersion"]) -> MetaOapg.properties.computerFdeVersion: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerFdeWilWolStatus"]) -> MetaOapg.properties.computerFdeWilWolStatus: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerFdeWilWolStatusUpdatedOn"]) -> MetaOapg.properties.computerFdeWilWolStatusUpdatedOn: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerFdeTpmVersion"]) -> MetaOapg.properties.computerFdeTpmVersion: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerFdeTpmStatus"]) -> MetaOapg.properties.computerFdeTpmStatus: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["browserExtension"]) -> typing.Union['BrowserExtension', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["threatEmulation"]) -> typing.Union['ThreatEmulation', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["efr"]) -> typing.Union['Efr', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["antiBot"]) -> typing.Union['AntiBot', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["antiMalware"]) -> typing.Union['AntiMalware', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["endpointForServers"]) -> typing.Union['EndpointForServers', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["daWinPatchInformation"]) -> typing.Union['DaWinPatchInformation', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["posture"]) -> typing.Union['Posture', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerId"]) -> typing.Union[MetaOapg.properties.computerId, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerName"]) -> typing.Union[MetaOapg.properties.computerName, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerDeploymentStatus"]) -> typing.Union['DeploymentStatus', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerIP"]) -> typing.Union[MetaOapg.properties.computerIP, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerCapabilities"]) -> typing.Union['ICapabilities', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerClientVersion"]) -> typing.Union[MetaOapg.properties.computerClientVersion, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerDeployTime"]) -> typing.Union[MetaOapg.properties.computerDeployTime, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerLastErrorCode"]) -> typing.Union[MetaOapg.properties.computerLastErrorCode, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerLastErrorDescription"]) -> typing.Union[MetaOapg.properties.computerLastErrorDescription, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerGroups"]) -> typing.Union[MetaOapg.properties.computerGroups, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerLastConnection"]) -> typing.Union[MetaOapg.properties.computerLastConnection, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerSyncedon"]) -> typing.Union[MetaOapg.properties.computerSyncedon, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerLastLoggedInUser"]) -> typing.Union[MetaOapg.properties.computerLastLoggedInUser, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerUserName"]) -> typing.Union[MetaOapg.properties.computerUserName, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerLastLoggedInPrebootUser"]) -> typing.Union[MetaOapg.properties.computerLastLoggedInPrebootUser, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerFdeStatus"]) -> typing.Union[MetaOapg.properties.computerFdeStatus, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerFdeProgress"]) -> typing.Union[MetaOapg.properties.computerFdeProgress, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["daInstalled"]) -> typing.Union[MetaOapg.properties.daInstalled, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerType"]) -> typing.Union['ComputerType', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["amUpdatedOn"]) -> typing.Union[MetaOapg.properties.amUpdatedOn, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["osName"]) -> typing.Union[MetaOapg.properties.osName, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["osVersion"]) -> typing.Union[MetaOapg.properties.osVersion, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["isolationStatus"]) -> typing.Union[MetaOapg.properties.isolationStatus, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["distinguishedName"]) -> typing.Union[MetaOapg.properties.distinguishedName, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["isDeleted"]) -> typing.Union[MetaOapg.properties.isDeleted, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["amStatus"]) -> typing.Union[MetaOapg.properties.amStatus, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["complianceStatus"]) -> typing.Union[MetaOapg.properties.complianceStatus, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deviceComment"]) -> typing.Union[MetaOapg.properties.deviceComment, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["extraCol1"]) -> typing.Union[MetaOapg.properties.extraCol1, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["canonicalName"]) -> typing.Union[MetaOapg.properties.canonicalName, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deviceParents"]) -> typing.Union[MetaOapg.properties.deviceParents, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["isInDomain"]) -> typing.Union[MetaOapg.properties.isInDomain, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["domainName"]) -> typing.Union[MetaOapg.properties.domainName, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["endpointType"]) -> typing.Union['EndpointTypeStatus', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["o_x"]) -> typing.Union[MetaOapg.properties.o_x, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["scannerId"]) -> typing.Union[MetaOapg.properties.scannerId, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerAmDatVersion"]) -> typing.Union[MetaOapg.properties.computerAmDatVersion, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerAmDatDate"]) -> typing.Union[MetaOapg.properties.computerAmDatDate, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerAmLicExpirationDate"]) -> typing.Union[MetaOapg.properties.computerAmLicExpirationDate, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerAmTotalInfected"]) -> typing.Union[MetaOapg.properties.computerAmTotalInfected, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerAmVersion"]) -> typing.Union[MetaOapg.properties.computerAmVersion, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerAmInfections"]) -> typing.Union[MetaOapg.properties.computerAmInfections, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerNotRunningBladesMask"]) -> typing.Union[MetaOapg.properties.computerNotRunningBladesMask, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerSdPackageName"]) -> typing.Union[MetaOapg.properties.computerSdPackageName, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerSdPolicyName"]) -> typing.Union[MetaOapg.properties.computerSdPolicyName, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerSdPolicyVersion"]) -> typing.Union[MetaOapg.properties.computerSdPolicyVersion, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerAbState"]) -> typing.Union[MetaOapg.properties.computerAbState, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerAbStatusBotNames"]) -> typing.Union[MetaOapg.properties.computerAbStatusBotNames, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerAmScannedon"]) -> typing.Union[MetaOapg.properties.computerAmScannedon, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerAmTotalQuarantined"]) -> typing.Union[MetaOapg.properties.computerAmTotalQuarantined, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerLastContactedPolicyServerIp"]) -> typing.Union[MetaOapg.properties.computerLastContactedPolicyServerIp, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerLastContactedPolicyServerName"]) -> typing.Union[MetaOapg.properties.computerLastContactedPolicyServerName, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerSdPackageVersion"]) -> typing.Union[MetaOapg.properties.computerSdPackageVersion, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerComplianceViolationIds"]) -> typing.Union[MetaOapg.properties.computerComplianceViolationIds, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerStatusSummary"]) -> typing.Union[MetaOapg.properties.computerStatusSummary, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerFdePrebootStatusUpdatedOn"]) -> typing.Union[MetaOapg.properties.computerFdePrebootStatusUpdatedOn, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerSmartCardStatus"]) -> typing.Union[MetaOapg.properties.computerSmartCardStatus, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["fdeRemoteUnlockOperation"]) -> typing.Union['FdeRemoteOperation', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["fdeRemoteUnlockUserName"]) -> typing.Union[MetaOapg.properties.fdeRemoteUnlockUserName, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["fdeRemoteUnlockStatus"]) -> typing.Union[MetaOapg.properties.fdeRemoteUnlockStatus, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["fdeRecoveryType"]) -> typing.Union[MetaOapg.properties.fdeRecoveryType, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedModifiedOn"]) -> typing.Union[MetaOapg.properties.enforcedModifiedOn, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedPolicyMalware20"]) -> typing.Union[MetaOapg.properties.enforcedPolicyMalware20, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedPolicyTe130"]) -> typing.Union[MetaOapg.properties.enforcedPolicyTe130, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedPolicyEfr120"]) -> typing.Union[MetaOapg.properties.enforcedPolicyEfr120, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedPolicyAntibot100"]) -> typing.Union[MetaOapg.properties.enforcedPolicyAntibot100, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedPolicyMe30"]) -> typing.Union[MetaOapg.properties.enforcedPolicyMe30, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedPolicyFdeDevice35"]) -> typing.Union[MetaOapg.properties.enforcedPolicyFdeDevice35, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedPolicyFdeUser36"]) -> typing.Union[MetaOapg.properties.enforcedPolicyFdeUser36, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedPolicyFw10"]) -> typing.Union[MetaOapg.properties.enforcedPolicyFw10, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedPolicyCompliance60"]) -> typing.Union[MetaOapg.properties.enforcedPolicyCompliance60, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedPolicyApplicationControl22"]) -> typing.Union[MetaOapg.properties.enforcedPolicyApplicationControl22, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedPolicySaAccessZones11"]) -> typing.Union[MetaOapg.properties.enforcedPolicySaAccessZones11, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedPolicyCommonClientSettings51"]) -> typing.Union[MetaOapg.properties.enforcedPolicyCommonClientSettings51, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedPolicyDocSecPolicy91"]) -> typing.Union[MetaOapg.properties.enforcedPolicyDocSecPolicy91, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedVersionPolicyMalware20"]) -> typing.Union[MetaOapg.properties.enforcedVersionPolicyMalware20, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedVersionPolicyTe130"]) -> typing.Union[MetaOapg.properties.enforcedVersionPolicyTe130, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedVersionPolicyEfr120"]) -> typing.Union[MetaOapg.properties.enforcedVersionPolicyEfr120, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedVersionPolicyAntibot100"]) -> typing.Union[MetaOapg.properties.enforcedVersionPolicyAntibot100, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedVersionPolicyMe30"]) -> typing.Union[MetaOapg.properties.enforcedVersionPolicyMe30, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedVersionPolicyFdeDevice35"]) -> typing.Union[MetaOapg.properties.enforcedVersionPolicyFdeDevice35, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedVersionPolicyFdeUser36"]) -> typing.Union[MetaOapg.properties.enforcedVersionPolicyFdeUser36, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedVersionPolicyFw10"]) -> typing.Union[MetaOapg.properties.enforcedVersionPolicyFw10, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedVersionPolicyCompliance60"]) -> typing.Union[MetaOapg.properties.enforcedVersionPolicyCompliance60, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedVersionPolicyApplicationControl22"]) -> typing.Union[MetaOapg.properties.enforcedVersionPolicyApplicationControl22, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedVersionPolicySaAccessZones11"]) -> typing.Union[MetaOapg.properties.enforcedVersionPolicySaAccessZones11, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedVersionPolicyCommonClientSettings51"]) -> typing.Union[MetaOapg.properties.enforcedVersionPolicyCommonClientSettings51, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedVersionPolicyDocSecPolicy91"]) -> typing.Union[MetaOapg.properties.enforcedVersionPolicyDocSecPolicy91, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedNamePolicyMalware20"]) -> typing.Union[MetaOapg.properties.enforcedNamePolicyMalware20, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedNamePolicyTe130"]) -> typing.Union[MetaOapg.properties.enforcedNamePolicyTe130, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedNamePolicyEfr120"]) -> typing.Union[MetaOapg.properties.enforcedNamePolicyEfr120, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedNamePolicyAntibot100"]) -> typing.Union[MetaOapg.properties.enforcedNamePolicyAntibot100, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedNamePolicyMe30"]) -> typing.Union[MetaOapg.properties.enforcedNamePolicyMe30, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedNamePolicyFdeDevice35"]) -> typing.Union[MetaOapg.properties.enforcedNamePolicyFdeDevice35, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedNamePolicyFdeUser36"]) -> typing.Union[MetaOapg.properties.enforcedNamePolicyFdeUser36, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedNamePolicyFw10"]) -> typing.Union[MetaOapg.properties.enforcedNamePolicyFw10, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedNamePolicyCompliance60"]) -> typing.Union[MetaOapg.properties.enforcedNamePolicyCompliance60, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedNamePolicyApplicationControl22"]) -> typing.Union[MetaOapg.properties.enforcedNamePolicyApplicationControl22, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedNamePolicySaAccessZones11"]) -> typing.Union[MetaOapg.properties.enforcedNamePolicySaAccessZones11, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedNamePolicyCommonClientSettings51"]) -> typing.Union[MetaOapg.properties.enforcedNamePolicyCommonClientSettings51, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enforcedNamePolicyDocSecPolicy91"]) -> typing.Union[MetaOapg.properties.enforcedNamePolicyDocSecPolicy91, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedModifiedOn"]) -> typing.Union[MetaOapg.properties.deployedModifiedOn, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedPolicyMalware20"]) -> typing.Union[MetaOapg.properties.deployedPolicyMalware20, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedPolicyTe130"]) -> typing.Union[MetaOapg.properties.deployedPolicyTe130, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedPolicyEfr120"]) -> typing.Union[MetaOapg.properties.deployedPolicyEfr120, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedPolicyAntibot100"]) -> typing.Union[MetaOapg.properties.deployedPolicyAntibot100, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedPolicyMe30"]) -> typing.Union[MetaOapg.properties.deployedPolicyMe30, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedPolicyFdeDevice35"]) -> typing.Union[MetaOapg.properties.deployedPolicyFdeDevice35, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedPolicyFdeUser36"]) -> typing.Union[MetaOapg.properties.deployedPolicyFdeUser36, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedPolicyFw10"]) -> typing.Union[MetaOapg.properties.deployedPolicyFw10, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedPolicyCompliance60"]) -> typing.Union[MetaOapg.properties.deployedPolicyCompliance60, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedPolicyApplicationControl22"]) -> typing.Union[MetaOapg.properties.deployedPolicyApplicationControl22, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedPolicySaAccessZones11"]) -> typing.Union[MetaOapg.properties.deployedPolicySaAccessZones11, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedPolicyCommonClientSettings51"]) -> typing.Union[MetaOapg.properties.deployedPolicyCommonClientSettings51, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedPolicyDocSecPolicy91"]) -> typing.Union[MetaOapg.properties.deployedPolicyDocSecPolicy91, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedVersionPolicyMalware20"]) -> typing.Union[MetaOapg.properties.deployedVersionPolicyMalware20, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedVersionPolicyTe130"]) -> typing.Union[MetaOapg.properties.deployedVersionPolicyTe130, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedVersionPolicyEfr120"]) -> typing.Union[MetaOapg.properties.deployedVersionPolicyEfr120, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedVersionPolicyAntibot100"]) -> typing.Union[MetaOapg.properties.deployedVersionPolicyAntibot100, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedVersionPolicyMe30"]) -> typing.Union[MetaOapg.properties.deployedVersionPolicyMe30, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedVersionPolicyFdeDevice35"]) -> typing.Union[MetaOapg.properties.deployedVersionPolicyFdeDevice35, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedVersionPolicyFdeUser36"]) -> typing.Union[MetaOapg.properties.deployedVersionPolicyFdeUser36, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedVersionPolicyFw10"]) -> typing.Union[MetaOapg.properties.deployedVersionPolicyFw10, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedVersionPolicyCompliance60"]) -> typing.Union[MetaOapg.properties.deployedVersionPolicyCompliance60, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedVersionPolicyApplicationControl22"]) -> typing.Union[MetaOapg.properties.deployedVersionPolicyApplicationControl22, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedVersionPolicySaAccessZones11"]) -> typing.Union[MetaOapg.properties.deployedVersionPolicySaAccessZones11, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedVersionPolicyCommonClientSettings51"]) -> typing.Union[MetaOapg.properties.deployedVersionPolicyCommonClientSettings51, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedVersionPolicyDocSecPolicy91"]) -> typing.Union[MetaOapg.properties.deployedVersionPolicyDocSecPolicy91, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedNamePolicyMalware20"]) -> typing.Union[MetaOapg.properties.deployedNamePolicyMalware20, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedNamePolicyTe130"]) -> typing.Union[MetaOapg.properties.deployedNamePolicyTe130, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedNamePolicyEfr120"]) -> typing.Union[MetaOapg.properties.deployedNamePolicyEfr120, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedNamePolicyAntibot100"]) -> typing.Union[MetaOapg.properties.deployedNamePolicyAntibot100, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedNamePolicyMe30"]) -> typing.Union[MetaOapg.properties.deployedNamePolicyMe30, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedNamePolicyFdeDevice35"]) -> typing.Union[MetaOapg.properties.deployedNamePolicyFdeDevice35, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedNamePolicyFdeUser36"]) -> typing.Union[MetaOapg.properties.deployedNamePolicyFdeUser36, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedNamePolicyFw10"]) -> typing.Union[MetaOapg.properties.deployedNamePolicyFw10, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedNamePolicyCompliance60"]) -> typing.Union[MetaOapg.properties.deployedNamePolicyCompliance60, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedNamePolicyApplicationControl22"]) -> typing.Union[MetaOapg.properties.deployedNamePolicyApplicationControl22, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedNamePolicySaAccessZones11"]) -> typing.Union[MetaOapg.properties.deployedNamePolicySaAccessZones11, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedNamePolicyCommonClientSettings51"]) -> typing.Union[MetaOapg.properties.deployedNamePolicyCommonClientSettings51, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["deployedNamePolicyDocSecPolicy91"]) -> typing.Union[MetaOapg.properties.deployedNamePolicyDocSecPolicy91, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerCpuLoadCategory"]) -> typing.Union[MetaOapg.properties.computerCpuLoadCategory, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerTotalCpuLoadCategory"]) -> typing.Union[MetaOapg.properties.computerTotalCpuLoadCategory, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerCpuRank"]) -> typing.Union[MetaOapg.properties.computerCpuRank, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["computerTotalCpuRank"]) -> typing.Union[MetaOapg.properties.computerTotalCpuRank, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["amProviderBrand"]) -> typing.Union[MetaOapg.properties.amProviderBrand, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["computerFdeTpmId"], typing_extensions.Literal["computerFdeLastRecoveryDate"], typing_extensions.Literal["computerFdeVersion"], typing_extensions.Literal["computerFdeWilWolStatus"], typing_extensions.Literal["computerFdeWilWolStatusUpdatedOn"], typing_extensions.Literal["computerFdeTpmVersion"], typing_extensions.Literal["computerFdeTpmStatus"], typing_extensions.Literal["browserExtension"], typing_extensions.Literal["threatEmulation"], typing_extensions.Literal["efr"], typing_extensions.Literal["antiBot"], typing_extensions.Literal["antiMalware"], typing_extensions.Literal["endpointForServers"], typing_extensions.Literal["daWinPatchInformation"], typing_extensions.Literal["posture"], typing_extensions.Literal["computerId"], typing_extensions.Literal["computerName"], typing_extensions.Literal["computerDeploymentStatus"], typing_extensions.Literal["computerIP"], typing_extensions.Literal["computerCapabilities"], typing_extensions.Literal["computerClientVersion"], typing_extensions.Literal["computerDeployTime"], typing_extensions.Literal["computerLastErrorCode"], typing_extensions.Literal["computerLastErrorDescription"], typing_extensions.Literal["computerGroups"], typing_extensions.Literal["computerLastConnection"], typing_extensions.Literal["computerSyncedon"], typing_extensions.Literal["computerLastLoggedInUser"], typing_extensions.Literal["computerUserName"], typing_extensions.Literal["computerLastLoggedInPrebootUser"], typing_extensions.Literal["computerFdeStatus"], typing_extensions.Literal["computerFdeProgress"], typing_extensions.Literal["daInstalled"], typing_extensions.Literal["computerType"], typing_extensions.Literal["amUpdatedOn"], typing_extensions.Literal["osName"], typing_extensions.Literal["osVersion"], typing_extensions.Literal["isolationStatus"], typing_extensions.Literal["distinguishedName"], typing_extensions.Literal["isDeleted"], typing_extensions.Literal["amStatus"], typing_extensions.Literal["complianceStatus"], typing_extensions.Literal["deviceComment"], typing_extensions.Literal["extraCol1"], typing_extensions.Literal["canonicalName"], typing_extensions.Literal["deviceParents"], typing_extensions.Literal["isInDomain"], typing_extensions.Literal["domainName"], typing_extensions.Literal["endpointType"], typing_extensions.Literal["o_x"], typing_extensions.Literal["scannerId"], typing_extensions.Literal["computerAmDatVersion"], typing_extensions.Literal["computerAmDatDate"], typing_extensions.Literal["computerAmLicExpirationDate"], typing_extensions.Literal["computerAmTotalInfected"], typing_extensions.Literal["computerAmVersion"], typing_extensions.Literal["computerAmInfections"], typing_extensions.Literal["computerNotRunningBladesMask"], typing_extensions.Literal["computerSdPackageName"], typing_extensions.Literal["computerSdPolicyName"], typing_extensions.Literal["computerSdPolicyVersion"], typing_extensions.Literal["computerAbState"], typing_extensions.Literal["computerAbStatusBotNames"], typing_extensions.Literal["computerAmScannedon"], typing_extensions.Literal["computerAmTotalQuarantined"], typing_extensions.Literal["computerLastContactedPolicyServerIp"], typing_extensions.Literal["computerLastContactedPolicyServerName"], typing_extensions.Literal["computerSdPackageVersion"], typing_extensions.Literal["computerComplianceViolationIds"], typing_extensions.Literal["computerStatusSummary"], typing_extensions.Literal["computerFdePrebootStatusUpdatedOn"], typing_extensions.Literal["computerSmartCardStatus"], typing_extensions.Literal["fdeRemoteUnlockOperation"], typing_extensions.Literal["fdeRemoteUnlockUserName"], typing_extensions.Literal["fdeRemoteUnlockStatus"], typing_extensions.Literal["fdeRecoveryType"], typing_extensions.Literal["enforcedModifiedOn"], typing_extensions.Literal["enforcedPolicyMalware20"], typing_extensions.Literal["enforcedPolicyTe130"], typing_extensions.Literal["enforcedPolicyEfr120"], typing_extensions.Literal["enforcedPolicyAntibot100"], typing_extensions.Literal["enforcedPolicyMe30"], typing_extensions.Literal["enforcedPolicyFdeDevice35"], typing_extensions.Literal["enforcedPolicyFdeUser36"], typing_extensions.Literal["enforcedPolicyFw10"], typing_extensions.Literal["enforcedPolicyCompliance60"], typing_extensions.Literal["enforcedPolicyApplicationControl22"], typing_extensions.Literal["enforcedPolicySaAccessZones11"], typing_extensions.Literal["enforcedPolicyCommonClientSettings51"], typing_extensions.Literal["enforcedPolicyDocSecPolicy91"], typing_extensions.Literal["enforcedVersionPolicyMalware20"], typing_extensions.Literal["enforcedVersionPolicyTe130"], typing_extensions.Literal["enforcedVersionPolicyEfr120"], typing_extensions.Literal["enforcedVersionPolicyAntibot100"], typing_extensions.Literal["enforcedVersionPolicyMe30"], typing_extensions.Literal["enforcedVersionPolicyFdeDevice35"], typing_extensions.Literal["enforcedVersionPolicyFdeUser36"], typing_extensions.Literal["enforcedVersionPolicyFw10"], typing_extensions.Literal["enforcedVersionPolicyCompliance60"], typing_extensions.Literal["enforcedVersionPolicyApplicationControl22"], typing_extensions.Literal["enforcedVersionPolicySaAccessZones11"], typing_extensions.Literal["enforcedVersionPolicyCommonClientSettings51"], typing_extensions.Literal["enforcedVersionPolicyDocSecPolicy91"], typing_extensions.Literal["enforcedNamePolicyMalware20"], typing_extensions.Literal["enforcedNamePolicyTe130"], typing_extensions.Literal["enforcedNamePolicyEfr120"], typing_extensions.Literal["enforcedNamePolicyAntibot100"], typing_extensions.Literal["enforcedNamePolicyMe30"], typing_extensions.Literal["enforcedNamePolicyFdeDevice35"], typing_extensions.Literal["enforcedNamePolicyFdeUser36"], typing_extensions.Literal["enforcedNamePolicyFw10"], typing_extensions.Literal["enforcedNamePolicyCompliance60"], typing_extensions.Literal["enforcedNamePolicyApplicationControl22"], typing_extensions.Literal["enforcedNamePolicySaAccessZones11"], typing_extensions.Literal["enforcedNamePolicyCommonClientSettings51"], typing_extensions.Literal["enforcedNamePolicyDocSecPolicy91"], typing_extensions.Literal["deployedModifiedOn"], typing_extensions.Literal["deployedPolicyMalware20"], typing_extensions.Literal["deployedPolicyTe130"], typing_extensions.Literal["deployedPolicyEfr120"], typing_extensions.Literal["deployedPolicyAntibot100"], typing_extensions.Literal["deployedPolicyMe30"], typing_extensions.Literal["deployedPolicyFdeDevice35"], typing_extensions.Literal["deployedPolicyFdeUser36"], typing_extensions.Literal["deployedPolicyFw10"], typing_extensions.Literal["deployedPolicyCompliance60"], typing_extensions.Literal["deployedPolicyApplicationControl22"], typing_extensions.Literal["deployedPolicySaAccessZones11"], typing_extensions.Literal["deployedPolicyCommonClientSettings51"], typing_extensions.Literal["deployedPolicyDocSecPolicy91"], typing_extensions.Literal["deployedVersionPolicyMalware20"], typing_extensions.Literal["deployedVersionPolicyTe130"], typing_extensions.Literal["deployedVersionPolicyEfr120"], typing_extensions.Literal["deployedVersionPolicyAntibot100"], typing_extensions.Literal["deployedVersionPolicyMe30"], typing_extensions.Literal["deployedVersionPolicyFdeDevice35"], typing_extensions.Literal["deployedVersionPolicyFdeUser36"], typing_extensions.Literal["deployedVersionPolicyFw10"], typing_extensions.Literal["deployedVersionPolicyCompliance60"], typing_extensions.Literal["deployedVersionPolicyApplicationControl22"], typing_extensions.Literal["deployedVersionPolicySaAccessZones11"], typing_extensions.Literal["deployedVersionPolicyCommonClientSettings51"], typing_extensions.Literal["deployedVersionPolicyDocSecPolicy91"], typing_extensions.Literal["deployedNamePolicyMalware20"], typing_extensions.Literal["deployedNamePolicyTe130"], typing_extensions.Literal["deployedNamePolicyEfr120"], typing_extensions.Literal["deployedNamePolicyAntibot100"], typing_extensions.Literal["deployedNamePolicyMe30"], typing_extensions.Literal["deployedNamePolicyFdeDevice35"], typing_extensions.Literal["deployedNamePolicyFdeUser36"], typing_extensions.Literal["deployedNamePolicyFw10"], typing_extensions.Literal["deployedNamePolicyCompliance60"], typing_extensions.Literal["deployedNamePolicyApplicationControl22"], typing_extensions.Literal["deployedNamePolicySaAccessZones11"], typing_extensions.Literal["deployedNamePolicyCommonClientSettings51"], typing_extensions.Literal["deployedNamePolicyDocSecPolicy91"], typing_extensions.Literal["computerCpuLoadCategory"], typing_extensions.Literal["computerTotalCpuLoadCategory"], typing_extensions.Literal["computerCpuRank"], typing_extensions.Literal["computerTotalCpuRank"], typing_extensions.Literal["amProviderBrand"], ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        computerFdeTpmId: typing.Union[MetaOapg.properties.computerFdeTpmId, str, ],
        computerFdeLastRecoveryDate: typing.Union[MetaOapg.properties.computerFdeLastRecoveryDate, str, ],
        computerFdeVersion: typing.Union[MetaOapg.properties.computerFdeVersion, str, ],
        computerFdeWilWolStatus: typing.Union[MetaOapg.properties.computerFdeWilWolStatus, str, ],
        computerFdeWilWolStatusUpdatedOn: typing.Union[MetaOapg.properties.computerFdeWilWolStatusUpdatedOn, str, ],
        computerFdeTpmVersion: typing.Union[MetaOapg.properties.computerFdeTpmVersion, str, ],
        computerFdeTpmStatus: typing.Union[MetaOapg.properties.computerFdeTpmStatus, str, ],
        browserExtension: typing.Union['BrowserExtension', schemas.Unset] = schemas.unset,
        threatEmulation: typing.Union['ThreatEmulation', schemas.Unset] = schemas.unset,
        efr: typing.Union['Efr', schemas.Unset] = schemas.unset,
        antiBot: typing.Union['AntiBot', schemas.Unset] = schemas.unset,
        antiMalware: typing.Union['AntiMalware', schemas.Unset] = schemas.unset,
        endpointForServers: typing.Union['EndpointForServers', schemas.Unset] = schemas.unset,
        daWinPatchInformation: typing.Union['DaWinPatchInformation', schemas.Unset] = schemas.unset,
        posture: typing.Union['Posture', schemas.Unset] = schemas.unset,
        computerId: typing.Union[MetaOapg.properties.computerId, str, schemas.Unset] = schemas.unset,
        computerName: typing.Union[MetaOapg.properties.computerName, str, schemas.Unset] = schemas.unset,
        computerDeploymentStatus: typing.Union['DeploymentStatus', schemas.Unset] = schemas.unset,
        computerIP: typing.Union[MetaOapg.properties.computerIP, str, schemas.Unset] = schemas.unset,
        computerCapabilities: typing.Union['ICapabilities', schemas.Unset] = schemas.unset,
        computerClientVersion: typing.Union[MetaOapg.properties.computerClientVersion, str, schemas.Unset] = schemas.unset,
        computerDeployTime: typing.Union[MetaOapg.properties.computerDeployTime, str, datetime, schemas.Unset] = schemas.unset,
        computerLastErrorCode: typing.Union[MetaOapg.properties.computerLastErrorCode, str, schemas.Unset] = schemas.unset,
        computerLastErrorDescription: typing.Union[MetaOapg.properties.computerLastErrorDescription, str, schemas.Unset] = schemas.unset,
        computerGroups: typing.Union[MetaOapg.properties.computerGroups, list, tuple, schemas.Unset] = schemas.unset,
        computerLastConnection: typing.Union[MetaOapg.properties.computerLastConnection, str, datetime, schemas.Unset] = schemas.unset,
        computerSyncedon: typing.Union[MetaOapg.properties.computerSyncedon, str, datetime, schemas.Unset] = schemas.unset,
        computerLastLoggedInUser: typing.Union[MetaOapg.properties.computerLastLoggedInUser, str, schemas.Unset] = schemas.unset,
        computerUserName: typing.Union[MetaOapg.properties.computerUserName, str, schemas.Unset] = schemas.unset,
        computerLastLoggedInPrebootUser: typing.Union[MetaOapg.properties.computerLastLoggedInPrebootUser, str, schemas.Unset] = schemas.unset,
        computerFdeStatus: typing.Union[MetaOapg.properties.computerFdeStatus, str, schemas.Unset] = schemas.unset,
        computerFdeProgress: typing.Union[MetaOapg.properties.computerFdeProgress, str, schemas.Unset] = schemas.unset,
        daInstalled: typing.Union[MetaOapg.properties.daInstalled, bool, schemas.Unset] = schemas.unset,
        computerType: typing.Union['ComputerType', schemas.Unset] = schemas.unset,
        amUpdatedOn: typing.Union[MetaOapg.properties.amUpdatedOn, str, schemas.Unset] = schemas.unset,
        osName: typing.Union[MetaOapg.properties.osName, str, schemas.Unset] = schemas.unset,
        osVersion: typing.Union[MetaOapg.properties.osVersion, str, schemas.Unset] = schemas.unset,
        isolationStatus: typing.Union[MetaOapg.properties.isolationStatus, str, schemas.Unset] = schemas.unset,
        distinguishedName: typing.Union[MetaOapg.properties.distinguishedName, str, schemas.Unset] = schemas.unset,
        isDeleted: typing.Union[MetaOapg.properties.isDeleted, bool, schemas.Unset] = schemas.unset,
        amStatus: typing.Union[MetaOapg.properties.amStatus, str, schemas.Unset] = schemas.unset,
        complianceStatus: typing.Union[MetaOapg.properties.complianceStatus, str, schemas.Unset] = schemas.unset,
        deviceComment: typing.Union[MetaOapg.properties.deviceComment, str, schemas.Unset] = schemas.unset,
        extraCol1: typing.Union[MetaOapg.properties.extraCol1, str, schemas.Unset] = schemas.unset,
        canonicalName: typing.Union[MetaOapg.properties.canonicalName, str, schemas.Unset] = schemas.unset,
        deviceParents: typing.Union[MetaOapg.properties.deviceParents, list, tuple, schemas.Unset] = schemas.unset,
        isInDomain: typing.Union[MetaOapg.properties.isInDomain, bool, schemas.Unset] = schemas.unset,
        domainName: typing.Union[MetaOapg.properties.domainName, str, schemas.Unset] = schemas.unset,
        endpointType: typing.Union['EndpointTypeStatus', schemas.Unset] = schemas.unset,
        o_x: typing.Union[MetaOapg.properties.o_x, str, schemas.Unset] = schemas.unset,
        scannerId: typing.Union[MetaOapg.properties.scannerId, str, schemas.Unset] = schemas.unset,
        computerAmDatVersion: typing.Union[MetaOapg.properties.computerAmDatVersion, str, schemas.Unset] = schemas.unset,
        computerAmDatDate: typing.Union[MetaOapg.properties.computerAmDatDate, str, schemas.Unset] = schemas.unset,
        computerAmLicExpirationDate: typing.Union[MetaOapg.properties.computerAmLicExpirationDate, str, schemas.Unset] = schemas.unset,
        computerAmTotalInfected: typing.Union[MetaOapg.properties.computerAmTotalInfected, str, schemas.Unset] = schemas.unset,
        computerAmVersion: typing.Union[MetaOapg.properties.computerAmVersion, str, schemas.Unset] = schemas.unset,
        computerAmInfections: typing.Union[MetaOapg.properties.computerAmInfections, list, tuple, schemas.Unset] = schemas.unset,
        computerNotRunningBladesMask: typing.Union[MetaOapg.properties.computerNotRunningBladesMask, str, schemas.Unset] = schemas.unset,
        computerSdPackageName: typing.Union[MetaOapg.properties.computerSdPackageName, str, schemas.Unset] = schemas.unset,
        computerSdPolicyName: typing.Union[MetaOapg.properties.computerSdPolicyName, str, schemas.Unset] = schemas.unset,
        computerSdPolicyVersion: typing.Union[MetaOapg.properties.computerSdPolicyVersion, str, schemas.Unset] = schemas.unset,
        computerAbState: typing.Union[MetaOapg.properties.computerAbState, str, schemas.Unset] = schemas.unset,
        computerAbStatusBotNames: typing.Union[MetaOapg.properties.computerAbStatusBotNames, list, tuple, schemas.Unset] = schemas.unset,
        computerAmScannedon: typing.Union[MetaOapg.properties.computerAmScannedon, str, schemas.Unset] = schemas.unset,
        computerAmTotalQuarantined: typing.Union[MetaOapg.properties.computerAmTotalQuarantined, str, schemas.Unset] = schemas.unset,
        computerLastContactedPolicyServerIp: typing.Union[MetaOapg.properties.computerLastContactedPolicyServerIp, str, schemas.Unset] = schemas.unset,
        computerLastContactedPolicyServerName: typing.Union[MetaOapg.properties.computerLastContactedPolicyServerName, str, schemas.Unset] = schemas.unset,
        computerSdPackageVersion: typing.Union[MetaOapg.properties.computerSdPackageVersion, str, schemas.Unset] = schemas.unset,
        computerComplianceViolationIds: typing.Union[MetaOapg.properties.computerComplianceViolationIds, list, tuple, schemas.Unset] = schemas.unset,
        computerStatusSummary: typing.Union[MetaOapg.properties.computerStatusSummary, dict, frozendict.frozendict, schemas.Unset] = schemas.unset,
        computerFdePrebootStatusUpdatedOn: typing.Union[MetaOapg.properties.computerFdePrebootStatusUpdatedOn, str, schemas.Unset] = schemas.unset,
        computerSmartCardStatus: typing.Union[MetaOapg.properties.computerSmartCardStatus, None, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        fdeRemoteUnlockOperation: typing.Union['FdeRemoteOperation', schemas.Unset] = schemas.unset,
        fdeRemoteUnlockUserName: typing.Union[MetaOapg.properties.fdeRemoteUnlockUserName, str, schemas.Unset] = schemas.unset,
        fdeRemoteUnlockStatus: typing.Union[MetaOapg.properties.fdeRemoteUnlockStatus, str, schemas.Unset] = schemas.unset,
        fdeRecoveryType: typing.Union[MetaOapg.properties.fdeRecoveryType, str, schemas.Unset] = schemas.unset,
        enforcedModifiedOn: typing.Union[MetaOapg.properties.enforcedModifiedOn, str, datetime, schemas.Unset] = schemas.unset,
        enforcedPolicyMalware20: typing.Union[MetaOapg.properties.enforcedPolicyMalware20, str, schemas.Unset] = schemas.unset,
        enforcedPolicyTe130: typing.Union[MetaOapg.properties.enforcedPolicyTe130, str, schemas.Unset] = schemas.unset,
        enforcedPolicyEfr120: typing.Union[MetaOapg.properties.enforcedPolicyEfr120, str, schemas.Unset] = schemas.unset,
        enforcedPolicyAntibot100: typing.Union[MetaOapg.properties.enforcedPolicyAntibot100, str, schemas.Unset] = schemas.unset,
        enforcedPolicyMe30: typing.Union[MetaOapg.properties.enforcedPolicyMe30, str, schemas.Unset] = schemas.unset,
        enforcedPolicyFdeDevice35: typing.Union[MetaOapg.properties.enforcedPolicyFdeDevice35, str, schemas.Unset] = schemas.unset,
        enforcedPolicyFdeUser36: typing.Union[MetaOapg.properties.enforcedPolicyFdeUser36, str, schemas.Unset] = schemas.unset,
        enforcedPolicyFw10: typing.Union[MetaOapg.properties.enforcedPolicyFw10, str, schemas.Unset] = schemas.unset,
        enforcedPolicyCompliance60: typing.Union[MetaOapg.properties.enforcedPolicyCompliance60, str, schemas.Unset] = schemas.unset,
        enforcedPolicyApplicationControl22: typing.Union[MetaOapg.properties.enforcedPolicyApplicationControl22, str, schemas.Unset] = schemas.unset,
        enforcedPolicySaAccessZones11: typing.Union[MetaOapg.properties.enforcedPolicySaAccessZones11, str, schemas.Unset] = schemas.unset,
        enforcedPolicyCommonClientSettings51: typing.Union[MetaOapg.properties.enforcedPolicyCommonClientSettings51, str, schemas.Unset] = schemas.unset,
        enforcedPolicyDocSecPolicy91: typing.Union[MetaOapg.properties.enforcedPolicyDocSecPolicy91, str, schemas.Unset] = schemas.unset,
        enforcedVersionPolicyMalware20: typing.Union[MetaOapg.properties.enforcedVersionPolicyMalware20, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        enforcedVersionPolicyTe130: typing.Union[MetaOapg.properties.enforcedVersionPolicyTe130, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        enforcedVersionPolicyEfr120: typing.Union[MetaOapg.properties.enforcedVersionPolicyEfr120, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        enforcedVersionPolicyAntibot100: typing.Union[MetaOapg.properties.enforcedVersionPolicyAntibot100, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        enforcedVersionPolicyMe30: typing.Union[MetaOapg.properties.enforcedVersionPolicyMe30, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        enforcedVersionPolicyFdeDevice35: typing.Union[MetaOapg.properties.enforcedVersionPolicyFdeDevice35, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        enforcedVersionPolicyFdeUser36: typing.Union[MetaOapg.properties.enforcedVersionPolicyFdeUser36, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        enforcedVersionPolicyFw10: typing.Union[MetaOapg.properties.enforcedVersionPolicyFw10, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        enforcedVersionPolicyCompliance60: typing.Union[MetaOapg.properties.enforcedVersionPolicyCompliance60, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        enforcedVersionPolicyApplicationControl22: typing.Union[MetaOapg.properties.enforcedVersionPolicyApplicationControl22, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        enforcedVersionPolicySaAccessZones11: typing.Union[MetaOapg.properties.enforcedVersionPolicySaAccessZones11, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        enforcedVersionPolicyCommonClientSettings51: typing.Union[MetaOapg.properties.enforcedVersionPolicyCommonClientSettings51, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        enforcedVersionPolicyDocSecPolicy91: typing.Union[MetaOapg.properties.enforcedVersionPolicyDocSecPolicy91, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        enforcedNamePolicyMalware20: typing.Union[MetaOapg.properties.enforcedNamePolicyMalware20, str, schemas.Unset] = schemas.unset,
        enforcedNamePolicyTe130: typing.Union[MetaOapg.properties.enforcedNamePolicyTe130, str, schemas.Unset] = schemas.unset,
        enforcedNamePolicyEfr120: typing.Union[MetaOapg.properties.enforcedNamePolicyEfr120, str, schemas.Unset] = schemas.unset,
        enforcedNamePolicyAntibot100: typing.Union[MetaOapg.properties.enforcedNamePolicyAntibot100, str, schemas.Unset] = schemas.unset,
        enforcedNamePolicyMe30: typing.Union[MetaOapg.properties.enforcedNamePolicyMe30, str, schemas.Unset] = schemas.unset,
        enforcedNamePolicyFdeDevice35: typing.Union[MetaOapg.properties.enforcedNamePolicyFdeDevice35, str, schemas.Unset] = schemas.unset,
        enforcedNamePolicyFdeUser36: typing.Union[MetaOapg.properties.enforcedNamePolicyFdeUser36, str, schemas.Unset] = schemas.unset,
        enforcedNamePolicyFw10: typing.Union[MetaOapg.properties.enforcedNamePolicyFw10, str, schemas.Unset] = schemas.unset,
        enforcedNamePolicyCompliance60: typing.Union[MetaOapg.properties.enforcedNamePolicyCompliance60, str, schemas.Unset] = schemas.unset,
        enforcedNamePolicyApplicationControl22: typing.Union[MetaOapg.properties.enforcedNamePolicyApplicationControl22, str, schemas.Unset] = schemas.unset,
        enforcedNamePolicySaAccessZones11: typing.Union[MetaOapg.properties.enforcedNamePolicySaAccessZones11, str, schemas.Unset] = schemas.unset,
        enforcedNamePolicyCommonClientSettings51: typing.Union[MetaOapg.properties.enforcedNamePolicyCommonClientSettings51, str, schemas.Unset] = schemas.unset,
        enforcedNamePolicyDocSecPolicy91: typing.Union[MetaOapg.properties.enforcedNamePolicyDocSecPolicy91, str, schemas.Unset] = schemas.unset,
        deployedModifiedOn: typing.Union[MetaOapg.properties.deployedModifiedOn, str, datetime, schemas.Unset] = schemas.unset,
        deployedPolicyMalware20: typing.Union[MetaOapg.properties.deployedPolicyMalware20, str, schemas.Unset] = schemas.unset,
        deployedPolicyTe130: typing.Union[MetaOapg.properties.deployedPolicyTe130, str, schemas.Unset] = schemas.unset,
        deployedPolicyEfr120: typing.Union[MetaOapg.properties.deployedPolicyEfr120, str, schemas.Unset] = schemas.unset,
        deployedPolicyAntibot100: typing.Union[MetaOapg.properties.deployedPolicyAntibot100, str, schemas.Unset] = schemas.unset,
        deployedPolicyMe30: typing.Union[MetaOapg.properties.deployedPolicyMe30, str, schemas.Unset] = schemas.unset,
        deployedPolicyFdeDevice35: typing.Union[MetaOapg.properties.deployedPolicyFdeDevice35, str, schemas.Unset] = schemas.unset,
        deployedPolicyFdeUser36: typing.Union[MetaOapg.properties.deployedPolicyFdeUser36, str, schemas.Unset] = schemas.unset,
        deployedPolicyFw10: typing.Union[MetaOapg.properties.deployedPolicyFw10, str, schemas.Unset] = schemas.unset,
        deployedPolicyCompliance60: typing.Union[MetaOapg.properties.deployedPolicyCompliance60, str, schemas.Unset] = schemas.unset,
        deployedPolicyApplicationControl22: typing.Union[MetaOapg.properties.deployedPolicyApplicationControl22, str, schemas.Unset] = schemas.unset,
        deployedPolicySaAccessZones11: typing.Union[MetaOapg.properties.deployedPolicySaAccessZones11, str, schemas.Unset] = schemas.unset,
        deployedPolicyCommonClientSettings51: typing.Union[MetaOapg.properties.deployedPolicyCommonClientSettings51, str, schemas.Unset] = schemas.unset,
        deployedPolicyDocSecPolicy91: typing.Union[MetaOapg.properties.deployedPolicyDocSecPolicy91, str, schemas.Unset] = schemas.unset,
        deployedVersionPolicyMalware20: typing.Union[MetaOapg.properties.deployedVersionPolicyMalware20, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        deployedVersionPolicyTe130: typing.Union[MetaOapg.properties.deployedVersionPolicyTe130, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        deployedVersionPolicyEfr120: typing.Union[MetaOapg.properties.deployedVersionPolicyEfr120, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        deployedVersionPolicyAntibot100: typing.Union[MetaOapg.properties.deployedVersionPolicyAntibot100, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        deployedVersionPolicyMe30: typing.Union[MetaOapg.properties.deployedVersionPolicyMe30, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        deployedVersionPolicyFdeDevice35: typing.Union[MetaOapg.properties.deployedVersionPolicyFdeDevice35, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        deployedVersionPolicyFdeUser36: typing.Union[MetaOapg.properties.deployedVersionPolicyFdeUser36, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        deployedVersionPolicyFw10: typing.Union[MetaOapg.properties.deployedVersionPolicyFw10, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        deployedVersionPolicyCompliance60: typing.Union[MetaOapg.properties.deployedVersionPolicyCompliance60, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        deployedVersionPolicyApplicationControl22: typing.Union[MetaOapg.properties.deployedVersionPolicyApplicationControl22, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        deployedVersionPolicySaAccessZones11: typing.Union[MetaOapg.properties.deployedVersionPolicySaAccessZones11, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        deployedVersionPolicyCommonClientSettings51: typing.Union[MetaOapg.properties.deployedVersionPolicyCommonClientSettings51, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        deployedVersionPolicyDocSecPolicy91: typing.Union[MetaOapg.properties.deployedVersionPolicyDocSecPolicy91, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        deployedNamePolicyMalware20: typing.Union[MetaOapg.properties.deployedNamePolicyMalware20, str, schemas.Unset] = schemas.unset,
        deployedNamePolicyTe130: typing.Union[MetaOapg.properties.deployedNamePolicyTe130, str, schemas.Unset] = schemas.unset,
        deployedNamePolicyEfr120: typing.Union[MetaOapg.properties.deployedNamePolicyEfr120, str, schemas.Unset] = schemas.unset,
        deployedNamePolicyAntibot100: typing.Union[MetaOapg.properties.deployedNamePolicyAntibot100, str, schemas.Unset] = schemas.unset,
        deployedNamePolicyMe30: typing.Union[MetaOapg.properties.deployedNamePolicyMe30, str, schemas.Unset] = schemas.unset,
        deployedNamePolicyFdeDevice35: typing.Union[MetaOapg.properties.deployedNamePolicyFdeDevice35, str, schemas.Unset] = schemas.unset,
        deployedNamePolicyFdeUser36: typing.Union[MetaOapg.properties.deployedNamePolicyFdeUser36, str, schemas.Unset] = schemas.unset,
        deployedNamePolicyFw10: typing.Union[MetaOapg.properties.deployedNamePolicyFw10, str, schemas.Unset] = schemas.unset,
        deployedNamePolicyCompliance60: typing.Union[MetaOapg.properties.deployedNamePolicyCompliance60, str, schemas.Unset] = schemas.unset,
        deployedNamePolicyApplicationControl22: typing.Union[MetaOapg.properties.deployedNamePolicyApplicationControl22, str, schemas.Unset] = schemas.unset,
        deployedNamePolicySaAccessZones11: typing.Union[MetaOapg.properties.deployedNamePolicySaAccessZones11, str, schemas.Unset] = schemas.unset,
        deployedNamePolicyCommonClientSettings51: typing.Union[MetaOapg.properties.deployedNamePolicyCommonClientSettings51, str, schemas.Unset] = schemas.unset,
        deployedNamePolicyDocSecPolicy91: typing.Union[MetaOapg.properties.deployedNamePolicyDocSecPolicy91, str, schemas.Unset] = schemas.unset,
        computerCpuLoadCategory: typing.Union[MetaOapg.properties.computerCpuLoadCategory, str, schemas.Unset] = schemas.unset,
        computerTotalCpuLoadCategory: typing.Union[MetaOapg.properties.computerTotalCpuLoadCategory, str, schemas.Unset] = schemas.unset,
        computerCpuRank: typing.Union[MetaOapg.properties.computerCpuRank, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        computerTotalCpuRank: typing.Union[MetaOapg.properties.computerTotalCpuRank, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        amProviderBrand: typing.Union[MetaOapg.properties.amProviderBrand, str, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
    ) -> 'Computer':
        return super().__new__(
            cls,
            *_args,
            computerFdeTpmId=computerFdeTpmId,
            computerFdeLastRecoveryDate=computerFdeLastRecoveryDate,
            computerFdeVersion=computerFdeVersion,
            computerFdeWilWolStatus=computerFdeWilWolStatus,
            computerFdeWilWolStatusUpdatedOn=computerFdeWilWolStatusUpdatedOn,
            computerFdeTpmVersion=computerFdeTpmVersion,
            computerFdeTpmStatus=computerFdeTpmStatus,
            browserExtension=browserExtension,
            threatEmulation=threatEmulation,
            efr=efr,
            antiBot=antiBot,
            antiMalware=antiMalware,
            endpointForServers=endpointForServers,
            daWinPatchInformation=daWinPatchInformation,
            posture=posture,
            computerId=computerId,
            computerName=computerName,
            computerDeploymentStatus=computerDeploymentStatus,
            computerIP=computerIP,
            computerCapabilities=computerCapabilities,
            computerClientVersion=computerClientVersion,
            computerDeployTime=computerDeployTime,
            computerLastErrorCode=computerLastErrorCode,
            computerLastErrorDescription=computerLastErrorDescription,
            computerGroups=computerGroups,
            computerLastConnection=computerLastConnection,
            computerSyncedon=computerSyncedon,
            computerLastLoggedInUser=computerLastLoggedInUser,
            computerUserName=computerUserName,
            computerLastLoggedInPrebootUser=computerLastLoggedInPrebootUser,
            computerFdeStatus=computerFdeStatus,
            computerFdeProgress=computerFdeProgress,
            daInstalled=daInstalled,
            computerType=computerType,
            amUpdatedOn=amUpdatedOn,
            osName=osName,
            osVersion=osVersion,
            isolationStatus=isolationStatus,
            distinguishedName=distinguishedName,
            isDeleted=isDeleted,
            amStatus=amStatus,
            complianceStatus=complianceStatus,
            deviceComment=deviceComment,
            extraCol1=extraCol1,
            canonicalName=canonicalName,
            deviceParents=deviceParents,
            isInDomain=isInDomain,
            domainName=domainName,
            endpointType=endpointType,
            o_x=o_x,
            scannerId=scannerId,
            computerAmDatVersion=computerAmDatVersion,
            computerAmDatDate=computerAmDatDate,
            computerAmLicExpirationDate=computerAmLicExpirationDate,
            computerAmTotalInfected=computerAmTotalInfected,
            computerAmVersion=computerAmVersion,
            computerAmInfections=computerAmInfections,
            computerNotRunningBladesMask=computerNotRunningBladesMask,
            computerSdPackageName=computerSdPackageName,
            computerSdPolicyName=computerSdPolicyName,
            computerSdPolicyVersion=computerSdPolicyVersion,
            computerAbState=computerAbState,
            computerAbStatusBotNames=computerAbStatusBotNames,
            computerAmScannedon=computerAmScannedon,
            computerAmTotalQuarantined=computerAmTotalQuarantined,
            computerLastContactedPolicyServerIp=computerLastContactedPolicyServerIp,
            computerLastContactedPolicyServerName=computerLastContactedPolicyServerName,
            computerSdPackageVersion=computerSdPackageVersion,
            computerComplianceViolationIds=computerComplianceViolationIds,
            computerStatusSummary=computerStatusSummary,
            computerFdePrebootStatusUpdatedOn=computerFdePrebootStatusUpdatedOn,
            computerSmartCardStatus=computerSmartCardStatus,
            fdeRemoteUnlockOperation=fdeRemoteUnlockOperation,
            fdeRemoteUnlockUserName=fdeRemoteUnlockUserName,
            fdeRemoteUnlockStatus=fdeRemoteUnlockStatus,
            fdeRecoveryType=fdeRecoveryType,
            enforcedModifiedOn=enforcedModifiedOn,
            enforcedPolicyMalware20=enforcedPolicyMalware20,
            enforcedPolicyTe130=enforcedPolicyTe130,
            enforcedPolicyEfr120=enforcedPolicyEfr120,
            enforcedPolicyAntibot100=enforcedPolicyAntibot100,
            enforcedPolicyMe30=enforcedPolicyMe30,
            enforcedPolicyFdeDevice35=enforcedPolicyFdeDevice35,
            enforcedPolicyFdeUser36=enforcedPolicyFdeUser36,
            enforcedPolicyFw10=enforcedPolicyFw10,
            enforcedPolicyCompliance60=enforcedPolicyCompliance60,
            enforcedPolicyApplicationControl22=enforcedPolicyApplicationControl22,
            enforcedPolicySaAccessZones11=enforcedPolicySaAccessZones11,
            enforcedPolicyCommonClientSettings51=enforcedPolicyCommonClientSettings51,
            enforcedPolicyDocSecPolicy91=enforcedPolicyDocSecPolicy91,
            enforcedVersionPolicyMalware20=enforcedVersionPolicyMalware20,
            enforcedVersionPolicyTe130=enforcedVersionPolicyTe130,
            enforcedVersionPolicyEfr120=enforcedVersionPolicyEfr120,
            enforcedVersionPolicyAntibot100=enforcedVersionPolicyAntibot100,
            enforcedVersionPolicyMe30=enforcedVersionPolicyMe30,
            enforcedVersionPolicyFdeDevice35=enforcedVersionPolicyFdeDevice35,
            enforcedVersionPolicyFdeUser36=enforcedVersionPolicyFdeUser36,
            enforcedVersionPolicyFw10=enforcedVersionPolicyFw10,
            enforcedVersionPolicyCompliance60=enforcedVersionPolicyCompliance60,
            enforcedVersionPolicyApplicationControl22=enforcedVersionPolicyApplicationControl22,
            enforcedVersionPolicySaAccessZones11=enforcedVersionPolicySaAccessZones11,
            enforcedVersionPolicyCommonClientSettings51=enforcedVersionPolicyCommonClientSettings51,
            enforcedVersionPolicyDocSecPolicy91=enforcedVersionPolicyDocSecPolicy91,
            enforcedNamePolicyMalware20=enforcedNamePolicyMalware20,
            enforcedNamePolicyTe130=enforcedNamePolicyTe130,
            enforcedNamePolicyEfr120=enforcedNamePolicyEfr120,
            enforcedNamePolicyAntibot100=enforcedNamePolicyAntibot100,
            enforcedNamePolicyMe30=enforcedNamePolicyMe30,
            enforcedNamePolicyFdeDevice35=enforcedNamePolicyFdeDevice35,
            enforcedNamePolicyFdeUser36=enforcedNamePolicyFdeUser36,
            enforcedNamePolicyFw10=enforcedNamePolicyFw10,
            enforcedNamePolicyCompliance60=enforcedNamePolicyCompliance60,
            enforcedNamePolicyApplicationControl22=enforcedNamePolicyApplicationControl22,
            enforcedNamePolicySaAccessZones11=enforcedNamePolicySaAccessZones11,
            enforcedNamePolicyCommonClientSettings51=enforcedNamePolicyCommonClientSettings51,
            enforcedNamePolicyDocSecPolicy91=enforcedNamePolicyDocSecPolicy91,
            deployedModifiedOn=deployedModifiedOn,
            deployedPolicyMalware20=deployedPolicyMalware20,
            deployedPolicyTe130=deployedPolicyTe130,
            deployedPolicyEfr120=deployedPolicyEfr120,
            deployedPolicyAntibot100=deployedPolicyAntibot100,
            deployedPolicyMe30=deployedPolicyMe30,
            deployedPolicyFdeDevice35=deployedPolicyFdeDevice35,
            deployedPolicyFdeUser36=deployedPolicyFdeUser36,
            deployedPolicyFw10=deployedPolicyFw10,
            deployedPolicyCompliance60=deployedPolicyCompliance60,
            deployedPolicyApplicationControl22=deployedPolicyApplicationControl22,
            deployedPolicySaAccessZones11=deployedPolicySaAccessZones11,
            deployedPolicyCommonClientSettings51=deployedPolicyCommonClientSettings51,
            deployedPolicyDocSecPolicy91=deployedPolicyDocSecPolicy91,
            deployedVersionPolicyMalware20=deployedVersionPolicyMalware20,
            deployedVersionPolicyTe130=deployedVersionPolicyTe130,
            deployedVersionPolicyEfr120=deployedVersionPolicyEfr120,
            deployedVersionPolicyAntibot100=deployedVersionPolicyAntibot100,
            deployedVersionPolicyMe30=deployedVersionPolicyMe30,
            deployedVersionPolicyFdeDevice35=deployedVersionPolicyFdeDevice35,
            deployedVersionPolicyFdeUser36=deployedVersionPolicyFdeUser36,
            deployedVersionPolicyFw10=deployedVersionPolicyFw10,
            deployedVersionPolicyCompliance60=deployedVersionPolicyCompliance60,
            deployedVersionPolicyApplicationControl22=deployedVersionPolicyApplicationControl22,
            deployedVersionPolicySaAccessZones11=deployedVersionPolicySaAccessZones11,
            deployedVersionPolicyCommonClientSettings51=deployedVersionPolicyCommonClientSettings51,
            deployedVersionPolicyDocSecPolicy91=deployedVersionPolicyDocSecPolicy91,
            deployedNamePolicyMalware20=deployedNamePolicyMalware20,
            deployedNamePolicyTe130=deployedNamePolicyTe130,
            deployedNamePolicyEfr120=deployedNamePolicyEfr120,
            deployedNamePolicyAntibot100=deployedNamePolicyAntibot100,
            deployedNamePolicyMe30=deployedNamePolicyMe30,
            deployedNamePolicyFdeDevice35=deployedNamePolicyFdeDevice35,
            deployedNamePolicyFdeUser36=deployedNamePolicyFdeUser36,
            deployedNamePolicyFw10=deployedNamePolicyFw10,
            deployedNamePolicyCompliance60=deployedNamePolicyCompliance60,
            deployedNamePolicyApplicationControl22=deployedNamePolicyApplicationControl22,
            deployedNamePolicySaAccessZones11=deployedNamePolicySaAccessZones11,
            deployedNamePolicyCommonClientSettings51=deployedNamePolicyCommonClientSettings51,
            deployedNamePolicyDocSecPolicy91=deployedNamePolicyDocSecPolicy91,
            computerCpuLoadCategory=computerCpuLoadCategory,
            computerTotalCpuLoadCategory=computerTotalCpuLoadCategory,
            computerCpuRank=computerCpuRank,
            computerTotalCpuRank=computerTotalCpuRank,
            amProviderBrand=amProviderBrand,
            _configuration=_configuration,
        )

from chkp_harmony_endpoint_management_sdk.generated.cloud.model.anti_bot import AntiBot
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.anti_malware import AntiMalware
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.browser_extension import BrowserExtension
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.computer_type import ComputerType
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.da_win_patch_information import DaWinPatchInformation
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.deployment_status import DeploymentStatus
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.efr import Efr
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.endpoint_for_servers import EndpointForServers
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.endpoint_type_status import EndpointTypeStatus
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.fde_remote_operation import FdeRemoteOperation
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.i_base_group import IBaseGroup
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.i_capabilities import ICapabilities
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.posture import Posture
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.slim_device_parent_node import SlimDeviceParentNode
from chkp_harmony_endpoint_management_sdk.generated.cloud.model.threat_emulation import ThreatEmulation
