from django.db import models


class Tournaments(models.Model):
    active = models.IntegerField()
    calendar_created = models.IntegerField()
    disqualification_condition = models.IntegerField()
    division_id = models.IntegerField()
    division_priority = models.IntegerField()
    division_round = models.IntegerField(blank=True, null=True)
    down2_selected = models.IntegerField()
    down_selected = models.IntegerField()
    edited_by_id = models.IntegerField(blank=True, null=True)
    external_id = models.IntegerField()
    field_id = models.IntegerField()
    last_edit_date = models.DateTimeField(blank=True, null=True)
    league_id = models.IntegerField()
    logo = models.CharField(max_length=12, blank=True, null=True)
    loss_points_rule = models.IntegerField(blank=True, null=True)
    name = models.CharField(max_length=50, blank=True, null=True)
    name_en = models.CharField(max_length=255, blank=True, null=True)
    national = models.IntegerField()
    number_of_players = models.IntegerField()
    number_of_rounds = models.IntegerField()
    number_of_teams = models.IntegerField()
    number_of_tours = models.IntegerField()
    page_height = models.IntegerField(blank=True, null=True)
    priority = models.IntegerField()
    protocol_type = models.IntegerField()
    rating_rule = models.IntegerField()
    referee_category_id = models.IntegerField()
    referees_max = models.IntegerField()
    region_id = models.IntegerField()
    scheme = models.CharField(max_length=255)
    season_id = models.IntegerField()
    short_name = models.CharField(max_length=20, blank=True, null=True)
    show_empty_cells = models.IntegerField(blank=True, null=True)
    show_league = models.IntegerField()
    show_numbers = models.IntegerField()
    show_player_number = models.IntegerField(blank=True, null=True)
    show_region = models.IntegerField()
    show_stats = models.IntegerField(blank=True, null=True)
    start_date = models.DateField(blank=True, null=True)
    statistics_type = models.IntegerField()
    technical_defeat = models.CharField(max_length=5)
    tournament_id = models.AutoField(primary_key=True)
    tournament_type = models.CharField(max_length=20)
    unique_id = models.CharField(max_length=50, blank=True, null=True)
    up2_selected = models.IntegerField()
    up_selected = models.IntegerField()
    zone_id = models.IntegerField()

    class Meta:
        managed = False
        db_table = 'tournaments'
