"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NextComponent = exports.NextJsTypeDef = exports.NextJsTypeScriptProject = exports.NextJsProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const file_1 = require("../file");
const node_project_1 = require("../node-project");
const sample_file_1 = require("../sample-file");
const tasks_1 = require("../tasks");
const typescript_1 = require("../typescript");
const typescript_config_1 = require("../typescript-config");
const util_1 = require("../util");
const postcss_1 = require("./postcss");
/**
 * (experimental) Next.js project without TypeScript.
 *
 * @experimental
 * @pjid nextjs
 */
class NextJsProject extends node_project_1.NodeProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _e, _f, _g, _h;
        super({
            jest: false,
            minNodeVersion: '12.13.0',
            ...options,
        });
        this.srcdir = (_e = options.srcdir) !== null && _e !== void 0 ? _e : 'pages';
        this.assetsdir = (_f = options.assetsdir) !== null && _f !== void 0 ? _f : 'public';
        this.tailwind = (_g = options.tailwind) !== null && _g !== void 0 ? _g : true;
        new NextComponent(this, { typescript: false, tailwind: this.tailwind });
        // generate sample code in `pages` and `public` if these directories are empty or non-existent.
        if ((_h = options.sampleCode) !== null && _h !== void 0 ? _h : true) {
            new NextSampleCode(this, {
                fileExt: 'js',
                srcdir: this.srcdir,
                assetsdir: this.assetsdir,
                tailwind: this.tailwind,
            });
        }
    }
}
exports.NextJsProject = NextJsProject;
_a = JSII_RTTI_SYMBOL_1;
NextJsProject[_a] = { fqn: "projen.web.NextJsProject", version: "0.17.95" };
/**
 * (experimental) Next.js project with TypeScript.
 *
 * @experimental
 * @pjid nextjs-ts
 */
class NextJsTypeScriptProject extends typescript_1.TypeScriptAppProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _e, _f, _g, _h;
        const defaultOptions = {
            srcdir: 'pages',
            eslint: false,
            minNodeVersion: '12.13.0',
            jest: false,
            tsconfig: {
                include: ['**/*.ts', '**/*.tsx'],
                compilerOptions: {
                    // required by Next.js
                    esModuleInterop: true,
                    module: 'esnext',
                    moduleResolution: typescript_config_1.TypeScriptModuleResolution.NODE,
                    isolatedModules: true,
                    resolveJsonModule: true,
                    jsx: typescript_config_1.TypeScriptJsxMode.PRESERVE,
                    // recommended by Next.js
                    allowJs: true,
                    skipLibCheck: true,
                    forceConsistentCasingInFileNames: true,
                    noEmit: true,
                    lib: ['dom', 'dom.iterable', 'esnext'],
                    strict: false,
                    target: 'es5',
                },
            },
        };
        // never generate default TypeScript sample code, since this class provides its own
        super(util_1.deepMerge([defaultOptions, options, { sampleCode: false }]));
        this.srcdir = (_e = options.srcdir) !== null && _e !== void 0 ? _e : 'pages';
        this.assetsdir = (_f = options.assetsdir) !== null && _f !== void 0 ? _f : 'public';
        this.tailwind = (_g = options.tailwind) !== null && _g !== void 0 ? _g : true;
        new NextComponent(this, { typescript: true, tailwind: this.tailwind });
        // 'next build' command fails if tsconfig.json is immutable
        if (this.tsconfig) {
            this.tsconfig.file.readonly = false;
        }
        this.nextJsTypeDef = new NextJsTypeDef(this, 'next-env.d.ts');
        // generate sample code in `pages` and `public` if these directories are empty or non-existent.
        if ((_h = options.sampleCode) !== null && _h !== void 0 ? _h : true) {
            new NextSampleCode(this, {
                fileExt: 'tsx',
                srcdir: this.srcdir,
                assetsdir: this.assetsdir,
                tailwind: this.tailwind,
            });
        }
    }
}
exports.NextJsTypeScriptProject = NextJsTypeScriptProject;
_b = JSII_RTTI_SYMBOL_1;
NextJsTypeScriptProject[_b] = { fqn: "projen.web.NextJsTypeScriptProject", version: "0.17.95" };
/**
 * @experimental
 */
class NextJsTypeDef extends file_1.FileBase {
    /**
     * @experimental
     */
    constructor(project, filePath, options = {}) {
        super(project, filePath, options);
    }
    /**
     * (experimental) Implemented by derived classes and returns the contents of the file to emit.
     *
     * @experimental
     */
    synthesizeContent(_) {
        return [
            '/// <reference types="next" />',
            '/// <reference types="next/types/global" />',
        ].join('\n');
    }
}
exports.NextJsTypeDef = NextJsTypeDef;
_c = JSII_RTTI_SYMBOL_1;
NextJsTypeDef[_c] = { fqn: "projen.web.NextJsTypeDef", version: "0.17.95" };
/**
 * @experimental
 */
class NextComponent extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _e, _f, _g;
        super(project);
        this.typescript = (_e = options.typescript) !== null && _e !== void 0 ? _e : false;
        this.tailwind = (_f = options.tailwind) !== null && _f !== void 0 ? _f : true;
        project.addDeps('next', 'react', 'react-dom');
        if (this.typescript) {
            project.addDevDeps('@types/react', '@types/react-dom');
        }
        if (this.tailwind) {
            new postcss_1.PostCss(project, { tailwind: true });
        }
        // NextJS CLI commands, see: https://nextjs.org/docs/api-reference/cli
        project.addTask('dev', {
            description: 'Starts the Next.js application in development mode',
            category: tasks_1.TaskCategory.BUILD,
            exec: 'next dev',
        });
        project.addTask('build', {
            description: 'Creates an optimized production build of your Next.js application',
            category: tasks_1.TaskCategory.BUILD,
            exec: 'next build',
        });
        project.addTask('export', {
            description: 'Exports the application for production deployment',
            category: tasks_1.TaskCategory.RELEASE,
            exec: 'next export',
        });
        project.addTask('server', {
            description: 'Starts the Next.js application in production mode',
            category: tasks_1.TaskCategory.RELEASE,
            exec: 'next start',
        });
        project.addTask('telemetry', {
            description: 'Checks the status of Next.js telemetry collection',
            category: tasks_1.TaskCategory.MISC,
            exec: 'next telemetry',
        });
        (_g = project.npmignore) === null || _g === void 0 ? void 0 : _g.exclude('# Next.js', '/.next/');
        project.gitignore.exclude('# Next.js', '/.next/');
    }
}
exports.NextComponent = NextComponent;
_d = JSII_RTTI_SYMBOL_1;
NextComponent[_d] = { fqn: "projen.web.NextComponent", version: "0.17.95" };
class NextSampleCode extends component_1.Component {
    constructor(project, options) {
        var _e;
        super(project);
        this.fileExt = (_e = options.fileExt) !== null && _e !== void 0 ? _e : 'js';
        this.srcdir = options.srcdir;
        this.assetsdir = options.assetsdir;
        this.tailwind = options.tailwind;
        const indexJs = [
            'import Head from "next/head"',
            '',
            'export default function Home() {',
            '  return (',
            '    <div className="container">',
            '      <Head>',
            '        <title>Create Next App</title>',
            '      </Head>',
            '',
            '      <main>',
            '        <h1 className="title">',
            '          Welcome to <a href="https://nextjs.org">Next.js!</a>',
            '        </h1>',
            '',
            '        <p className="description">',
            '          Get started by editing <code>pages/index.js</code>',
            '        </p>',
            '',
            '        <div className="grid">',
            '          <a href="https://nextjs.org/docs" className="card">',
            '            <h3>Documentation &rarr;</h3>',
            '            <p>Find in-depth information about Next.js features and API.</p>',
            '          </a>',
            '',
            '          <a href="https://nextjs.org/learn" className="card">',
            '            <h3>Learn &rarr;</h3>',
            '            <p>Learn about Next.js in an interactive course with quizzes!</p>',
            '          </a>',
            '',
            '          <a',
            '            href="https://github.com/vercel/next.js/tree/master/examples"',
            '            className="card"',
            '          >',
            '            <h3>Examples &rarr;</h3>',
            '            <p>Discover and deploy boilerplate example Next.js projects.</p>',
            '          </a>',
            '',
            '          <a',
            '            href="https://vercel.com/import?filter=next.js&utm_source=create-next-app&utm_medium=default-template&utm_campaign=create-next-app"',
            '            className="card"',
            '          >',
            '            <h3>Deploy &rarr;</h3>',
            '            <p>',
            '              Instantly deploy your Next.js site to a public URL with Vercel.',
            '            </p>',
            '          </a>',
            '        </div>',
            '      </main>',
            '',
            '      <footer>',
            '        <a',
            '          href="https://vercel.com?utm_source=create-next-app&utm_medium=default-template&utm_campaign=create-next-app"',
            '          target="_blank"',
            '          rel="noopener noreferrer"',
            '        >',
            '          Powered by Vercel',
            '          <img src="/vercel.svg" alt="Vercel Logo" className="logo" />',
            '        </a>',
            '      </footer>',
            '',
            '      <style jsx>{`',
            '        .container {',
            '          min-height: 100vh;',
            '          padding: 0 0.5rem;',
            '          display: flex;',
            '          flex-direction: column;',
            '          justify-content: center;',
            '          align-items: center;',
            '        }',
            '',
            '        main {',
            '          padding: 5rem 0;',
            '          flex: 1;',
            '          display: flex;',
            '          flex-direction: column;',
            '          justify-content: center;',
            '          align-items: center;',
            '        }',
            '',
            '        footer {',
            '          width: 100%;',
            '          height: 100px;',
            '          border-top: 1px solid #eaeaea;',
            '          display: flex;',
            '          justify-content: center;',
            '          align-items: center;',
            '        }',
            '',
            '        footer img {',
            '          margin-left: 0.5rem;',
            '        }',
            '',
            '        footer a {',
            '          display: flex;',
            '          justify-content: center;',
            '          align-items: center;',
            '        }',
            '',
            '        a {',
            '          color: inherit;',
            '          text-decoration: none;',
            '        }',
            '',
            '        .title a {',
            '          color: #0070f3;',
            '          text-decoration: none;',
            '        }',
            '',
            '        .title a:hover,',
            '        .title a:focus,',
            '        .title a:active {',
            '          text-decoration: underline;',
            '        }',
            '',
            '        .title {',
            '          margin: 0;',
            '          line-height: 1.15;',
            '          font-size: 4rem;',
            '        }',
            '',
            '        .title,',
            '        .description {',
            '          text-align: center;',
            '        }',
            '',
            '        .description {',
            '          line-height: 1.5;',
            '          font-size: 1.5rem;',
            '        }',
            '',
            '        code {',
            '          background: #fafafa;',
            '          border-radius: 5px;',
            '          padding: 0.75rem;',
            '          font-size: 1.1rem;',
            '          font-family: Menlo, Monaco, Lucida Console, Liberation Mono,',
            '            DejaVu Sans Mono, Bitstream Vera Sans Mono, Courier New, monospace;',
            '        }',
            '',
            '        .grid {',
            '          display: flex;',
            '          align-items: center;',
            '          justify-content: center;',
            '          flex-wrap: wrap;',
            '',
            '          max-width: 800px;',
            '          margin-top: 3rem;',
            '        }',
            '',
            '        .card {',
            '          margin: 1rem;',
            '          flex-basis: 45%;',
            '          padding: 1.5rem;',
            '          text-align: left;',
            '          color: inherit;',
            '          text-decoration: none;',
            '          border: 1px solid #eaeaea;',
            '          border-radius: 10px;',
            '          transition: color 0.15s ease, border-color 0.15s ease;',
            '        }',
            '',
            '        .card:hover,',
            '        .card:focus,',
            '        .card:active {',
            '          color: #0070f3;',
            '          border-color: #0070f3;',
            '        }',
            '',
            '        .card h3 {',
            '          margin: 0 0 1rem 0;',
            '          font-size: 1.5rem;',
            '        }',
            '',
            '        .card p {',
            '          margin: 0;',
            '          font-size: 1.25rem;',
            '          line-height: 1.5;',
            '        }',
            '',
            '        .logo {',
            '          height: 1em;',
            '        }',
            '',
            '        @media (max-width: 600px) {',
            '          .grid {',
            '            width: 100%;',
            '            flex-direction: column;',
            '          }',
            '        }',
            '      `}</style>',
            '',
            '      <style jsx global>{`',
            '        html,',
            '        body {',
            '          padding: 0;',
            '          margin: 0;',
            '          font-family: -apple-system, BlinkMacSystemFont, Segoe UI, Roboto,',
            '            Oxygen, Ubuntu, Cantarell, Fira Sans, Droid Sans, Helvetica Neue,',
            '            sans-serif;',
            '        }',
            '',
            '        * {',
            '          box-sizing: border-box;',
            '        }',
            '      `}</style>',
            '    </div>',
            '  )',
            '}',
            '',
        ];
        if (this.tailwind) {
            indexJs.unshift('import "tailwindcss/tailwind.css"');
        }
        const vercelSvg = [
            '<svg width="283" height="64" viewBox="0 0 283 64" fill="none" ',
            '    xmlns="http://www.w3.org/2000/svg">',
            '    <path d="M141.04 16c-11.04 0-19 7.2-19 18s8.96 18 20 18c6.67 0 12.55-2.64 16.19-7.09l-7.65-4.42c-2.02 2.21-5.09 3.5-8.54 3.5-4.79 0-8.86-2.5-10.37-6.5h28.02c.22-1.12.35-2.28.35-3.5 0-10.79-7.96-17.99-19-17.99zm-9.46 14.5c1.25-3.99 4.67-6.5 9.45-6.5 4.79 0 8.21 2.51 9.45 6.5h-18.9zM248.72 16c-11.04 0-19 7.2-19 18s8.96 18 20 18c6.67 0 12.55-2.64 16.19-7.09l-7.65-4.42c-2.02 2.21-5.09 3.5-8.54 3.5-4.79 0-8.86-2.5-10.37-6.5h28.02c.22-1.12.35-2.28.35-3.5 0-10.79-7.96-17.99-19-17.99zm-9.45 14.5c1.25-3.99 4.67-6.5 9.45-6.5 4.79 0 8.21 2.51 9.45 6.5h-18.9zM200.24 34c0 6 3.92 10 10 10 4.12 0 7.21-1.87 8.8-4.92l7.68 4.43c-3.18 5.3-9.14 8.49-16.48 8.49-11.05 0-19-7.2-19-18s7.96-18 19-18c7.34 0 13.29 3.19 16.48 8.49l-7.68 4.43c-1.59-3.05-4.68-4.92-8.8-4.92-6.07 0-10 4-10 10zm82.48-29v46h-9V5h9zM36.95 0L73.9 64H0L36.95 0zm92.38 5l-27.71 48L73.91 5H84.3l17.32 30 17.32-30h10.39zm58.91 12v9.69c-1-.29-2.06-.49-3.2-.49-5.81 0-10 4-10 10V51h-9V17h9v9.2c0-5.08 5.91-9.2 13.2-9.2z" fill="#000"/>',
            '</svg>',
        ];
        new sample_file_1.SampleDir(project, this.srcdir, {
            files: {
                ['index.' + this.fileExt]: indexJs.join('\n'),
            },
        });
        new sample_file_1.SampleDir(project, this.assetsdir, {
            files: {
                'vercel.svg': vercelSvg.join('\n'),
            },
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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