"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpgradeDependenciesSchedule = exports.UpgradeDependencies = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
function context(value) {
    return `\${{ ${value} }}`;
}
function setOutput(name, value) {
    return `echo "::set-output name=${name}::${value}"`;
}
const RUNNER_TEMP = context('runner.temp');
const DEFAULT_TOKEN = context('secrets.GITHUB_TOKEN');
const REPO = context('github.repository');
const RUN_ID = context('github.run_id');
const RUN_URL = `https://github.com/${REPO}/actions/runs/${RUN_ID}`;
const UBUNTU_LATEST = 'ubuntu-latest';
/**
 * (experimental) Upgrade node project dependencies.
 *
 * @experimental
 */
class UpgradeDependencies extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _c;
        super(project);
        this._project = project;
        this.options = options;
        project.addDevDeps('npm-check-updates@^11');
        const task = this.createTask();
        if (project.github && ((_c = options.workflow) !== null && _c !== void 0 ? _c : true)) {
            this.workflow = this.createWorkflow(task, project.github);
        }
    }
    createTask() {
        var _c, _d, _e;
        const taskName = (_c = this.options.taskName) !== null && _c !== void 0 ? _c : 'upgrade-dependencies';
        const task = this._project.addTask(taskName, {
            // this task should not run in CI mode because its designed to
            // update package.json and lock files.
            env: { CI: '0' },
        });
        const exclude = (_d = this.options.exclude) !== null && _d !== void 0 ? _d : [];
        if ((_e = this.options.ignoreProjen) !== null && _e !== void 0 ? _e : true) {
            exclude.push('projen');
        }
        const ncuCommand = ['npm-check-updates', '--upgrade', '--target=minor'];
        if (exclude.length > 0) {
            ncuCommand.push(`--reject='${exclude.join(',')}'`);
        }
        if (this.options.include) {
            ncuCommand.push(`--filter='${this.options.include.join(',')}'`);
        }
        task.exec(ncuCommand.join(' '));
        task.exec(this._project.projenCommand);
        return task;
    }
    createWorkflow(task, github) {
        var _c, _d;
        const schedule = (_d = (_c = this.options.workflowOptions) === null || _c === void 0 ? void 0 : _c.schedule) !== null && _d !== void 0 ? _d : UpgradeDependenciesSchedule.DAILY;
        const workflow = github.addWorkflow(task.name);
        const triggers = { workflow_dispatch: {} };
        if (schedule.cron) {
            triggers.schedule = schedule.cron.map(e => ({ cron: e }));
        }
        workflow.on(triggers);
        const upgrade = this.createUpgrade(task);
        const pr = this.createPr(workflow, upgrade);
        const jobs = {};
        jobs[upgrade.jobId] = upgrade.job;
        jobs[pr.jobId] = pr.job;
        workflow.addJobs(jobs);
        return workflow;
    }
    createUpgrade(task) {
        var _c, _d;
        const build = (_d = (_c = this.options.workflowOptions) === null || _c === void 0 ? void 0 : _c.rebuild) !== null && _d !== void 0 ? _d : true;
        const patchFile = 'upgrade.patch';
        const buildStepId = 'build';
        const conclusion = 'conclusion';
        const patchPath = `${RUNNER_TEMP}/${patchFile}`;
        // thats all we should need at this stage since all we do is clone.
        // note that this also prevents new code that is introduced in the upgrade
        // to have write access to anything, in case its somehow executed. (for example during build)
        const permissions = { contents: 'read' };
        const outputs = {};
        const steps = [
            {
                name: 'Checkout',
                uses: 'actions/checkout@v2',
            },
            ...this._project.installWorkflowSteps,
            {
                name: 'Upgrade dependencies',
                run: this._project.runTaskCommand(task),
            },
        ];
        if (build) {
            steps.push({
                name: 'Build',
                id: buildStepId,
                run: `${this._project.runTaskCommand(this._project.buildTask)} && ${setOutput(conclusion, 'success')} || ${setOutput(conclusion, 'failure')}`,
            });
            outputs[conclusion] = context(`steps.${buildStepId}.outputs.${conclusion}`);
        }
        steps.push({
            name: 'Create Patch',
            run: [
                'git add .',
                `git diff --patch --staged > ${patchPath}`,
            ].join('\n'),
        }, {
            name: 'Upload patch',
            uses: 'actions/upload-artifact@v2',
            with: { name: patchFile, path: patchPath },
        });
        return {
            job: {
                'name': 'Upgrade',
                'permissions': permissions,
                'runs-on': UBUNTU_LATEST,
                'outputs': outputs,
                'steps': steps,
            },
            jobId: 'upgrade',
            patchFile: patchFile,
            patchPath: patchPath,
            build: build,
            buildConclusionOutput: conclusion,
        };
    }
    createPr(workflow, upgrade) {
        var _c, _d, _e, _f;
        const customToken = ((_c = this.options.workflowOptions) === null || _c === void 0 ? void 0 : _c.secret) ? context(`secrets.${this.options.workflowOptions.secret}`) : undefined;
        const workflowName = workflow.name;
        const branchName = `github-actions/${workflowName}`;
        const prStepId = 'create-pr';
        // necessary to create pr's.
        const permissions = { 'contents': 'write', 'pull-requests': 'write' };
        const steps = [
            {
                name: 'Checkout',
                uses: 'actions/checkout@v2',
            },
            {
                name: 'Download patch',
                uses: 'actions/download-artifact@v2',
                with: { name: upgrade.patchFile, path: RUNNER_TEMP },
            },
            {
                name: 'Apply patch',
                run: `[ -s ${upgrade.patchPath} ] && git apply ${upgrade.patchPath} || echo "Empty patch. Skipping."`,
            },
            {
                name: 'Create Pull Request',
                id: prStepId,
                uses: 'peter-evans/create-pull-request@v3',
                with: {
                    // the pr can modify workflow files, so we need to use the custom
                    // secret if one is configured.
                    'token': customToken !== null && customToken !== void 0 ? customToken : DEFAULT_TOKEN,
                    'commit-message': 'upgrade',
                    'branch': branchName,
                    'title': `chore(deps): ${workflowName}`,
                    'labels': (_f = (_e = (_d = this.options.workflowOptions) === null || _d === void 0 ? void 0 : _d.labels) === null || _e === void 0 ? void 0 : _e.join(',')) !== null && _f !== void 0 ? _f : '',
                    'body': [
                        `See ${RUN_URL}`,
                        '',
                        '------',
                        '',
                        '*Automatically created by projen via GitHubActions*',
                    ].join('\n'),
                },
            },
        ];
        if (this._project.buildWorkflowJobId && upgrade.build) {
            const body = {
                name: this._project.buildWorkflowJobId,
                head_sha: branchName,
                status: 'completed',
                conclusion: context(`needs.${upgrade.jobId}.outputs.${upgrade.buildConclusionOutput}`),
                output: {
                    title: `Created via the ${workflowName} workflow.`,
                    summary: `Action run URL: ${RUN_URL}`,
                },
            };
            steps.push({
                name: 'Update status check',
                if: `steps.${prStepId}.outputs.pull-request-url != \'\'`,
                run: 'curl -i --fail '
                    + '-X POST '
                    + '-H "Accept: application/vnd.github.v3+json" '
                    + `-H "Authorization: token \${GITHUB_TOKEN}" https://api.github.com/repos/${REPO}/check-runs `
                    + `-d '${JSON.stringify(body)}'`,
                env: { GITHUB_TOKEN: DEFAULT_TOKEN },
            });
            // necessary to update status checks
            permissions.checks = 'write';
        }
        return {
            job: {
                'name': 'Create Pull Request',
                'needs': upgrade.jobId,
                'permissions': permissions,
                'runs-on': UBUNTU_LATEST,
                'steps': steps,
            },
            jobId: 'pr',
        };
    }
}
exports.UpgradeDependencies = UpgradeDependencies;
_a = JSII_RTTI_SYMBOL_1;
UpgradeDependencies[_a] = { fqn: "projen.UpgradeDependencies", version: "0.17.95" };
/**
 * (experimental) How often to check for new versions and raise pull requests for version upgrades.
 *
 * @experimental
 */
class UpgradeDependenciesSchedule {
    constructor(cron) {
        this.cron = cron;
    }
    /**
     * (experimental) Create a schedule from a raw cron expression.
     *
     * @experimental
     */
    static expressions(cron) {
        return new UpgradeDependenciesSchedule(cron);
    }
}
exports.UpgradeDependenciesSchedule = UpgradeDependenciesSchedule;
_b = JSII_RTTI_SYMBOL_1;
UpgradeDependenciesSchedule[_b] = { fqn: "projen.UpgradeDependenciesSchedule", version: "0.17.95" };
/**
 * (experimental) Disables automatic upgrades.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.NEVER = new UpgradeDependenciesSchedule([]);
/**
 * (experimental) At 00:00.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.DAILY = new UpgradeDependenciesSchedule(['0 0 * * *']);
/**
 * (experimental) At 00:00 on every day-of-week from Monday through Friday.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.WEEKDAY = new UpgradeDependenciesSchedule(['0 0 * * 1-5']);
/**
 * (experimental) At 00:00 on Monday.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.WEEKLY = new UpgradeDependenciesSchedule(['0 0 * * 1']);
/**
 * (experimental) At 00:00 on day-of-month 1.
 *
 * @experimental
 */
UpgradeDependenciesSchedule.MONTHLY = new UpgradeDependenciesSchedule(['0 0 1 * *']);
//# sourceMappingURL=data:application/json;base64,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