"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const __1 = require("..");
const util_1 = require("./util");
test('default options', () => {
    const project = createProject({
        projenUpgradeSecret: 'PROJEN_SECRET',
    });
    new __1.UpgradeDependencies(project);
    const snapshot = util_1.synthSnapshot(project);
    expect(snapshot['.github/workflows/upgrade-dependencies.yml']).toBeDefined();
    expect(snapshot['.github/workflows/upgrade-dependencies.yml']).toMatchSnapshot();
});
test('custom options', () => {
    const project = createProject({
        projenUpgradeSecret: 'PROJEN_SECRET',
    });
    new __1.UpgradeDependencies(project, {
        workflowOptions: {
            schedule: __1.UpgradeDependenciesSchedule.MONTHLY,
        },
    });
    const snapshot = util_1.synthSnapshot(project);
    expect(snapshot['.github/workflows/upgrade-dependencies.yml']).toBeDefined();
    expect(snapshot['.github/workflows/upgrade-dependencies.yml']).toMatchSnapshot();
});
function createProject(options = {}) {
    return new __1.NodeProject({
        outdir: util_1.mkdtemp(),
        defaultReleaseBranch: 'main',
        name: 'node-project',
        ...options,
    });
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXBncmFkZS1kZXBlbmRlbmNpZXMudGVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9fX3Rlc3RzX18vdXBncmFkZS1kZXBlbmRlbmNpZXMudGVzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLDBCQUFtRjtBQUVuRixpQ0FBZ0Q7QUFFaEQsSUFBSSxDQUFDLGlCQUFpQixFQUFFLEdBQUcsRUFBRTtJQUUzQixNQUFNLE9BQU8sR0FBRyxhQUFhLENBQUM7UUFDNUIsbUJBQW1CLEVBQUUsZUFBZTtLQUNyQyxDQUFDLENBQUM7SUFDSCxJQUFJLHVCQUFtQixDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBRWpDLE1BQU0sUUFBUSxHQUFHLG9CQUFhLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDeEMsTUFBTSxDQUFDLFFBQVEsQ0FBQyw0Q0FBNEMsQ0FBQyxDQUFDLENBQUMsV0FBVyxFQUFFLENBQUM7SUFDN0UsTUFBTSxDQUFDLFFBQVEsQ0FBQyw0Q0FBNEMsQ0FBQyxDQUFDLENBQUMsZUFBZSxFQUFFLENBQUM7QUFDbkYsQ0FBQyxDQUFDLENBQUM7QUFFSCxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxFQUFFO0lBRTFCLE1BQU0sT0FBTyxHQUFHLGFBQWEsQ0FBQztRQUM1QixtQkFBbUIsRUFBRSxlQUFlO0tBQ3JDLENBQUMsQ0FBQztJQUNILElBQUksdUJBQW1CLENBQUMsT0FBTyxFQUFFO1FBQy9CLGVBQWUsRUFBRTtZQUNmLFFBQVEsRUFBRSwrQkFBMkIsQ0FBQyxPQUFPO1NBQzlDO0tBQ0YsQ0FBQyxDQUFDO0lBRUgsTUFBTSxRQUFRLEdBQUcsb0JBQWEsQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUN4QyxNQUFNLENBQUMsUUFBUSxDQUFDLDRDQUE0QyxDQUFDLENBQUMsQ0FBQyxXQUFXLEVBQUUsQ0FBQztJQUM3RSxNQUFNLENBQUMsUUFBUSxDQUFDLDRDQUE0QyxDQUFDLENBQUMsQ0FBQyxlQUFlLEVBQUUsQ0FBQztBQUNuRixDQUFDLENBQUMsQ0FBQztBQUdILFNBQVMsYUFBYSxDQUFDLFVBQXdHLEVBQUU7SUFDL0gsT0FBTyxJQUFJLGVBQVcsQ0FBQztRQUNyQixNQUFNLEVBQUUsY0FBTyxFQUFFO1FBQ2pCLG9CQUFvQixFQUFFLE1BQU07UUFDNUIsSUFBSSxFQUFFLGNBQWM7UUFDcEIsR0FBRyxPQUFPO0tBQ1gsQ0FBQyxDQUFDO0FBQ0wsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IE5vZGVQcm9qZWN0LCBVcGdyYWRlRGVwZW5kZW5jaWVzLCBVcGdyYWRlRGVwZW5kZW5jaWVzU2NoZWR1bGUgfSBmcm9tICcuLic7XG5pbXBvcnQgeyBOb2RlUHJvamVjdE9wdGlvbnMgfSBmcm9tICcuLi9ub2RlLXByb2plY3QnO1xuaW1wb3J0IHsgbWtkdGVtcCwgc3ludGhTbmFwc2hvdCB9IGZyb20gJy4vdXRpbCc7XG5cbnRlc3QoJ2RlZmF1bHQgb3B0aW9ucycsICgpID0+IHtcblxuICBjb25zdCBwcm9qZWN0ID0gY3JlYXRlUHJvamVjdCh7XG4gICAgcHJvamVuVXBncmFkZVNlY3JldDogJ1BST0pFTl9TRUNSRVQnLFxuICB9KTtcbiAgbmV3IFVwZ3JhZGVEZXBlbmRlbmNpZXMocHJvamVjdCk7XG5cbiAgY29uc3Qgc25hcHNob3QgPSBzeW50aFNuYXBzaG90KHByb2plY3QpO1xuICBleHBlY3Qoc25hcHNob3RbJy5naXRodWIvd29ya2Zsb3dzL3VwZ3JhZGUtZGVwZW5kZW5jaWVzLnltbCddKS50b0JlRGVmaW5lZCgpO1xuICBleHBlY3Qoc25hcHNob3RbJy5naXRodWIvd29ya2Zsb3dzL3VwZ3JhZGUtZGVwZW5kZW5jaWVzLnltbCddKS50b01hdGNoU25hcHNob3QoKTtcbn0pO1xuXG50ZXN0KCdjdXN0b20gb3B0aW9ucycsICgpID0+IHtcblxuICBjb25zdCBwcm9qZWN0ID0gY3JlYXRlUHJvamVjdCh7XG4gICAgcHJvamVuVXBncmFkZVNlY3JldDogJ1BST0pFTl9TRUNSRVQnLFxuICB9KTtcbiAgbmV3IFVwZ3JhZGVEZXBlbmRlbmNpZXMocHJvamVjdCwge1xuICAgIHdvcmtmbG93T3B0aW9uczoge1xuICAgICAgc2NoZWR1bGU6IFVwZ3JhZGVEZXBlbmRlbmNpZXNTY2hlZHVsZS5NT05USExZLFxuICAgIH0sXG4gIH0pO1xuXG4gIGNvbnN0IHNuYXBzaG90ID0gc3ludGhTbmFwc2hvdChwcm9qZWN0KTtcbiAgZXhwZWN0KHNuYXBzaG90WycuZ2l0aHViL3dvcmtmbG93cy91cGdyYWRlLWRlcGVuZGVuY2llcy55bWwnXSkudG9CZURlZmluZWQoKTtcbiAgZXhwZWN0KHNuYXBzaG90WycuZ2l0aHViL3dvcmtmbG93cy91cGdyYWRlLWRlcGVuZGVuY2llcy55bWwnXSkudG9NYXRjaFNuYXBzaG90KCk7XG59KTtcblxuXG5mdW5jdGlvbiBjcmVhdGVQcm9qZWN0KG9wdGlvbnM6IE9taXQ8Tm9kZVByb2plY3RPcHRpb25zLCAnb3V0ZGlyJyB8ICdkZWZhdWx0UmVsZWFzZUJyYW5jaCcgfCAnbmFtZScgfCAnZGVwZW5kZW5jaWVzVXBncmFkZSc+ID0ge30pOiBOb2RlUHJvamVjdCB7XG4gIHJldHVybiBuZXcgTm9kZVByb2plY3Qoe1xuICAgIG91dGRpcjogbWtkdGVtcCgpLFxuICAgIGRlZmF1bHRSZWxlYXNlQnJhbmNoOiAnbWFpbicsXG4gICAgbmFtZTogJ25vZGUtcHJvamVjdCcsXG4gICAgLi4ub3B0aW9ucyxcbiAgfSk7XG59Il19