"""Add alembic_revision column to Workspace

Revision ID: 696e383aabf2
Revises: 274bc650f9a2
Create Date: 2022-04-20 09:44:10.693572

"""
import sqlalchemy as sa
from alembic import op

import fief

# revision identifiers, used by Alembic.
revision = "696e383aabf2"
down_revision = "274bc650f9a2"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "workspaces",
        sa.Column("alembic_revision", sa.String(length=255), nullable=True),
    )
    op.create_index(
        op.f("ix_workspaces_alembic_revision"),
        "workspaces",
        ["alembic_revision"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_workspaces_alembic_revision"), table_name="workspaces")
    op.drop_column("workspaces", "alembic_revision")
    # ### end Alembic commands ###
