"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Request objects will be assigned when a request of the relevant type will be
 * made.
 */
exports.actualRequest = {};
/**
 * Responses can be simulated by assigning values here.
 */
exports.simulateResponse = {};
function reset() {
    exports.actualRequest = {};
    exports.simulateResponse = {};
}
exports.reset = reset;
exports.client = {
    configureAssumeRole: req => {
        exports.actualRequest.configureAssumeRoleRequest = req;
    },
    createCluster: async (req) => {
        exports.actualRequest.createClusterRequest = req;
        return {
            cluster: {
                name: req.name,
                roleArn: req.roleArn,
                version: '1.0',
                arn: `arn:${req.name}`,
                certificateAuthority: { data: 'certificateAuthority-data' },
                status: 'CREATING',
            },
        };
    },
    deleteCluster: async (req) => {
        exports.actualRequest.deleteClusterRequest = req;
        if (exports.simulateResponse.deleteClusterErrorCode) {
            const e = new Error('mock error');
            e.code = exports.simulateResponse.deleteClusterErrorCode;
            throw e;
        }
        return {
            cluster: {
                name: req.name,
            },
        };
    },
    describeCluster: async (req) => {
        exports.actualRequest.describeClusterRequest = req;
        if (exports.simulateResponse.describeClusterExceptionCode) {
            const e = new Error('mock exception');
            e.code = exports.simulateResponse.describeClusterExceptionCode;
            throw e;
        }
        return {
            cluster: {
                name: req.name,
                version: '1.0',
                roleArn: 'arn:role',
                arn: 'arn:cluster-arn',
                certificateAuthority: { data: 'certificateAuthority-data' },
                endpoint: 'http://endpoint',
                status: exports.simulateResponse.describeClusterResponseMockStatus || 'ACTIVE',
            },
        };
    },
    updateClusterConfig: async (req) => {
        exports.actualRequest.updateClusterConfigRequest = req;
        return {};
    },
    updateClusterVersion: async (req) => {
        exports.actualRequest.updateClusterVersionRequest = req;
        return {};
    },
    createFargateProfile: async (req) => {
        exports.actualRequest.createFargateProfile = req;
        return {};
    },
    describeFargateProfile: async (req) => {
        exports.actualRequest.describeFargateProfile = req;
        return {};
    },
    deleteFargateProfile: async (req) => {
        exports.actualRequest.deleteFargateProfile = req;
        return {};
    },
};
exports.MOCK_PROPS = {
    roleArn: 'arn:of:role',
    resourcesVpcConfig: {
        subnetIds: ['subnet1', 'subnet2'],
        securityGroupIds: ['sg1', 'sg2', 'sg3'],
    },
};
exports.MOCK_ASSUME_ROLE_ARN = 'assume:role:arn';
function newRequest(requestType, props, oldProps) {
    return {
        StackId: 'fake-stack-id',
        RequestId: 'fake-request-id',
        ResourceType: 'Custom::EKSCluster',
        ServiceToken: 'boom',
        LogicalResourceId: 'MyResourceId',
        PhysicalResourceId: 'physical-resource-id',
        ResponseURL: 'http://response-url',
        RequestType: requestType,
        OldResourceProperties: {
            Config: oldProps,
            AssumeRoleArn: exports.MOCK_ASSUME_ROLE_ARN,
        },
        ResourceProperties: {
            ServiceToken: 'boom',
            Config: props,
            AssumeRoleArn: exports.MOCK_ASSUME_ROLE_ARN,
        },
    };
}
exports.newRequest = newRequest;
//# sourceMappingURL=data:application/json;base64,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