"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cluster_1 = require("./cluster");
/**
 * Defines an EKS cluster that runs entirely on AWS Fargate.
 *
 * The cluster is created with a default Fargate Profile that matches the
 * "default" and "kube-system" namespaces. You can add additional profiles using
 * `addFargateProfile`.
 */
class FargateCluster extends cluster_1.Cluster {
    constructor(scope, id, props = {}) {
        var _a, _b, _c, _d;
        super(scope, id, {
            ...props,
            defaultCapacity: 0,
            kubectlEnabled: true,
            coreDnsComputeType: (_a = props.coreDnsComputeType) !== null && _a !== void 0 ? _a : cluster_1.CoreDnsComputeType.FARGATE,
        });
        this.addFargateProfile((_c = (_b = props.defaultProfile) === null || _b === void 0 ? void 0 : _b.fargateProfileName) !== null && _c !== void 0 ? _c : (props.defaultProfile ? 'custom' : 'default'), (_d = props.defaultProfile) !== null && _d !== void 0 ? _d : {
            selectors: [
                { namespace: 'default' },
                { namespace: 'kube-system' },
            ],
        });
    }
}
exports.FargateCluster = FargateCluster;
//# sourceMappingURL=data:application/json;base64,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