#  coding: utf-8
#  ----------------------------------------------------------------------------
#  <copyright company="Aspose" file="MapiKnownPropertyDescriptor.py">
#    Copyright (c) 2018-2020 Aspose Pty Ltd. All rights reserved.
#  </copyright>
#  <summary>
#    Permission is hereby granted, free of charge, to any person obtaining a
#   copy  of this software and associated documentation files (the "Software"),
#   to deal  in the Software without restriction, including without limitation
#   the rights  to use, copy, modify, merge, publish, distribute, sublicense,
#   and/or sell  copies of the Software, and to permit persons to whom the
#   Software is  furnished to do so, subject to the following conditions:
#
#   The above copyright notice and this permission notice shall be included in
#   all  copies or substantial portions of the Software.
#
#   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
#   FROM,  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
#   DEALINGS IN THE SOFTWARE.
#  </summary>
#  ----------------------------------------------------------------------------

import pprint
import re
import six
from typing import List, Set, Dict, Tuple, Optional
from datetime import datetime

from AsposeEmailCloudSdk.models.mapi_property_descriptor import MapiPropertyDescriptor


class MapiKnownPropertyDescriptor(MapiPropertyDescriptor):
    """Known Mapi Property descriptor             
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'discriminator': 'str',
        'name': 'str'
    }

    attribute_map = {
        'discriminator': 'discriminator',
        'name': 'name'
    }

    def __init__(self, name: str = None):
        """
        Known Mapi Property descriptor             
        :param name: Known property name.  See all known properties here: https://apireference.aspose.com/email/net/aspose.email.mapi/knownpropertylist/fields/index  Possible values: Mileage, ObjectUri, GDataContactVersion, GDataPhotoVersion, AddressBookProviderArrayType, AddressBookProviderEmailList, AddressCountryCode, AgingDontAgeMe, AllAttendeesString, AllowExternalCheck, AnniversaryEventEntryId, AppointmentAuxiliaryFlags, AppointmentColor, AppointmentCounterProposal, AppointmentDuration, AppointmentEndDate, AppointmentEndTime, AppointmentEndWhole, AppointmentLastSequence, AppointmentMessageClass, AppointmentNotAllowPropose, AppointmentProposalNumber, AppointmentProposedDuration, AppointmentProposedEndWhole, AppointmentProposedStartWhole, AppointmentRecur, AppointmentReplyName, AppointmentReplyTime, AppointmentSequence, AppointmentSequenceTime, AppointmentStartDate, AppointmentStartTime, AppointmentStartWhole, AppointmentStateFlags, AppointmentSubType, AppointmentTimeZoneDefinitionEndDisplay, AppointmentTimeZoneDefinitionRecur, AppointmentTimeZoneDefinitionStartDisplay, AppointmentUnsendableRecipients, AppointmentUpdateTime, AttendeeCriticalChange, AutoFillLocation, AutoLog, AutoProcessState, AutoStartCheck, Billing, BirthdayEventEntryId, BirthdayLocal, BusinessCardCardPicture, BusinessCardDisplayDefinition, BusyStatus, CalendarType, Categories, CcAttendeesString, ChangeHighlight, Classification, ClassificationDescription, ClassificationGuid, ClassificationKeep, Classified, CleanGlobalObjectId, ClientIntent, ClipEnd, ClipStart, CollaborateDoc, CommonEnd, CommonStart, Companies, ConferencingCheck, ConferencingType, ContactCharacterSet, ContactItemData, ContactLinkedGlobalAddressListEntryId, ContactLinkEntry, ContactLinkGlobalAddressListLinkId, ContactLinkGlobalAddressListLinkState, ContactLinkLinkRejectHistory, ContactLinkName, ContactLinkSearchKey, ContactLinkSMTPAddressCache, Contacts, ContactUserField1, ContactUserField2, ContactUserField3, ContactUserField4, ConversationActionLastAppliedTime, ConversationActionMaxDeliveryTime, ConversationActionMoveFolderEid, ConversationActionMoveStoreEid, ConversationActionVersion, ConversationProcessed, CurrentVersion, CurrentVersionName, DayInterval, DayOfMonth, DelegateMail, Department, Directory, DistributionListChecksum, DistributionListMembers, DistributionListName, DistributionListOneOffMembers, DistributionListStream, Email1AddressType, Email1DisplayName, Email1EmailAddress, Email1OriginalDisplayName, Email1OriginalEntryId, Email2AddressType, Email2DisplayName, Email2EmailAddress, Email2OriginalDisplayName, Email2OriginalEntryId, Email3AddressType, Email3DisplayName, Email3EmailAddress, Email3OriginalDisplayName, Email3OriginalEntryId, EndRecurrenceDate, EndRecurrenceTime, ExceptionReplaceTime, Fax1AddressType, Fax1EmailAddress, Fax1OriginalDisplayName, Fax1OriginalEntryId, Fax2AddressType, Fax2EmailAddress, Fax2OriginalDisplayName, Fax2OriginalEntryId, Fax3AddressType, Fax3EmailAddress, Fax3OriginalDisplayName, Fax3OriginalEntryId, FExceptionalAttendees, FExceptionalBody, FileUnder, FileUnderId, FileUnderList, FInvited, FlagRequest, FlagString, ForwardInstance, ForwardNotificationRecipients, FOthersAppointment, FreeBusyLocation, GlobalObjectId, HasPicture, HomeAddress, HomeAddressCountryCode, Html, ICalendarDayOfWeekMask, InboundICalStream, InfoPathFormName, InstantMessagingAddress, IntendedBusyStatus, InternetAccountName, InternetAccountStamp, IsContactLinked, IsException, IsRecurring, IsSilent, LinkedTaskItems, Location, LogDocumentPosted, LogDocumentPrinted, LogDocumentRouted, LogDocumentSaved, LogDuration, LogEnd, LogFlags, LogStart, LogType, LogTypeDesc, MeetingType, MeetingWorkspaceUrl, MonthInterval, MonthOfYear, MonthOfYearMask, NetShowUrl, NoEndDateFlag, NonSendableBcc, NonSendableCc, NonSendableTo, NonSendBccTrackStatus, NonSendCcTrackStatus, NonSendToTrackStatus, NoteColor, NoteHeight, NoteWidth, NoteX, NoteY, Occurrences, OldLocation, OldRecurrenceType, OldWhenEndWhole, OldWhenStartWhole, OnlinePassword, OptionalAttendees, OrganizerAlias, OriginalStoreEntryId, OtherAddress, OtherAddressCountryCode, OwnerCriticalChange, OwnerName, PendingStateForSiteMailboxDocument, PercentComplete, PostalAddressId, PostRssChannel, PostRssChannelLink, PostRssItemGuid, PostRssItemHash, PostRssItemLink, PostRssItemXml, PostRssSubscription, Private, PromptSendUpdate, RecurrenceDuration, RecurrencePattern, RecurrenceType, Recurring, ReferenceEntryId, ReminderDelta, ReminderFileParameter, ReminderOverride, ReminderPlaySound, ReminderSet, ReminderSignalTime, ReminderTime, ReminderTimeDate, ReminderTimeTime, ReminderType, RemoteStatus, RequiredAttendees, ResourceAttendees, ResponseStatus, ServerProcessed, ServerProcessingActions, SharingAnonymity, SharingBindingEntryId, SharingBrowseUrl, SharingCapabilities, SharingConfigurationUrl, SharingDataRangeEnd, SharingDataRangeStart, SharingDetail, SharingExtensionXml, SharingFilter, SharingFlags, SharingFlavor, SharingFolderEntryId, SharingIndexEntryId, SharingInitiatorEntryId, SharingInitiatorName, SharingInitiatorSmtp, SharingInstanceGuid, SharingLastAutoSyncTime, SharingLastSyncTime, SharingLocalComment, SharingLocalLastModificationTime, SharingLocalName, SharingLocalPath, SharingLocalStoreUid, SharingLocalType, SharingLocalUid, SharingOriginalMessageEntryId, SharingParentBindingEntryId, SharingParticipants, SharingPermissions, SharingProviderExtension, SharingProviderGuid, SharingProviderName, SharingProviderUrl, SharingRangeEnd, SharingRangeStart, SharingReciprocation, SharingRemoteByteSize, SharingRemoteComment, SharingRemoteCrc, SharingRemoteLastModificationTime, SharingRemoteMessageCount, SharingRemoteName, SharingRemotePass, SharingRemotePath, SharingRemoteStoreUid, SharingRemoteType, SharingRemoteUid, SharingRemoteUser, SharingRemoteVersion, SharingResponseTime, SharingResponseType, SharingRoamLog, SharingStart, SharingStatus, SharingStop, SharingSyncFlags, SharingSyncInterval, SharingTimeToLive, SharingTimeToLiveAuto, SharingWorkingHoursDays, SharingWorkingHoursEnd, SharingWorkingHoursStart, SharingWorkingHoursTimeZone, SideEffects, SingleBodyICal, SmartNoAttach, SpamOriginalFolder, StartRecurrenceDate, StartRecurrenceTime, TaskAcceptanceState, TaskAccepted, TaskActualEffort, TaskAssigner, TaskAssigners, TaskComplete, TaskCustomFlags, TaskDateCompleted, TaskDeadOccurrence, TaskDueDate, TaskEstimatedEffort, TaskFCreator, TaskFFixOffline, TaskFRecurring, TaskGlobalId, TaskHistory, TaskLastDelegate, TaskLastUpdate, TaskLastUser, TaskMode, TaskMultipleRecipients, TaskNoCompute, TaskOrdinal, TaskOwner, TaskOwnership, TaskRecurrence, TaskResetReminder, TaskRole, TaskStartDate, TaskState, TaskStatus, TaskStatusOnComplete, TaskUpdates, TaskVersion, TeamTask, TimeZone, TimeZoneDescription, TimeZoneStruct, ToAttendeesString, ToDoOrdinalDate, ToDoSubOrdinal, ToDoTitle, UseTnef, ValidFlagStringProof, VerbResponse, VerbStream, WeddingAnniversaryLocal, WeekInterval, Where, WorkAddress, WorkAddressCity, WorkAddressCountry, WorkAddressCountryCode, WorkAddressPostalCode, WorkAddressPostOfficeBox, WorkAddressState, WorkAddressStreet, YearInterval, YomiCompanyName, YomiFirstName, YomiLastName, AcceptLanguage, ApplicationName, AttachmentMacContentType, AttachmentMacInfo, AudioNotes, Author, AutomaticSpeechRecognitionData, ByteCount, CalendarAttendeeRole, CalendarBusystatus, CalendarContact, CalendarContactUrl, CalendarCreated, CalendarDescriptionUrl, CalendarDuration, CalendarExceptionDate, CalendarExceptionRule, CalendarGeoLatitude, CalendarGeoLongitude, CalendarInstanceType, CalendarIsOrganizer, CalendarLastModified, CalendarLocationUrl, CalendarMeetingStatus, CalendarMethod, CalendarProductId, CalendarRecurrenceIdRange, CalendarReminderOffset, CalendarResources, CalendarRsvp, CalendarSequence, CalendarTimeZone, CalendarTimeZoneId, CalendarTransparent, CalendarUid, CalendarVersion, Category, CharacterCount, Comments, Company, ContentBase, ContentClass, ContentType, CreateDateTimeReadOnly, CrossReference, DavId, DavIsCollection, DavIsStructuredDocument, DavParentName, DavUid, DocumentParts, EditTime, ExchangeIntendedBusyStatus, ExchangeJunkEmailMoveStamp, ExchangeModifyExceptionStructure, ExchangeNoModifyExceptions, ExchangePatternEnd, ExchangePatternStart, ExchangeReminderInterval, ExchDatabaseSchema, ExchDataExpectedContentClass, ExchDataSchemaCollectionReference, ExtractedAddresses, ExtractedContacts, ExtractedEmails, ExtractedMeetings, ExtractedPhones, ExtractedTasks, ExtractedUrls, From, HeadingPairs, HiddenCount, HttpmailCalendar, HttpmailHtmlDescription, HttpmailSendMessage, ICalendarRecurrenceDate, ICalendarRecurrenceRule, InternetSubject, Keywords, LastAuthor, LastPrinted, LastSaveDateTime, LineCount, LinksDirty, LocationUrl, Manager, MultimediaClipCount, NoteCount, OMSAccountGuid, OMSMobileModel, OMSScheduleTime, OMSServiceType, OMSSourceType, PageCount, ParagraphCount, PhishingStamp, PresentationFormat, QuarantineOriginalSender, RevisionNumber, RightsManagementLicense, Scale, Security, SlideCount, Subject, Template, Thumbnail, Title, WordCount, XCallId, XFaxNumberOfPages, XRequireProtectedPlayOnPhone, XSenderTelephoneNumber, XSharingBrowseUrl, XSharingCapabilities, XSharingConfigUrl, XSharingExendedCaps, XSharingFlavor, XSharingInstanceGuid, XSharingLocalType, XSharingProviderGuid, XSharingProviderName, XSharingProviderUrl, XSharingRemoteName, XSharingRemotePath, XSharingRemoteStoreUid, XSharingRemoteType, XSharingRemoteUid, XVoiceMessageAttachmentOrder, XVoiceMessageDuration, XVoiceMessageSenderName, Access, AccessControlListData, AccessLevel, Account, AdditionalRenEntryIds, AdditionalRenEntryIdsEx, AddressBookAuthorizedSenders, AddressBookContainerId, AddressBookDeliveryContentLength, AddressBookDisplayNamePrintable, AddressBookDisplayTypeExtended, AddressBookDistributionListExternalMemberCount, AddressBookDistributionListMemberCount, AddressBookDistributionListMemberSubmitAccepted, AddressBookDistributionListMemberSubmitRejected, AddressBookDistributionListRejectMessagesFromDLMembers, AddressBookEntryId, AddressBookExtensionAttribute1, AddressBookExtensionAttribute10, AddressBookExtensionAttribute11, AddressBookExtensionAttribute12, AddressBookExtensionAttribute13, AddressBookExtensionAttribute14, AddressBookExtensionAttribute15, AddressBookExtensionAttribute2, AddressBookExtensionAttribute3, AddressBookExtensionAttribute4, AddressBookExtensionAttribute5, AddressBookExtensionAttribute6, AddressBookExtensionAttribute7, AddressBookExtensionAttribute8, AddressBookExtensionAttribute9, AddressBookFolderPathname, AddressBookHierarchicalChildDepartments, AddressBookHierarchicalDepartmentMembers, AddressBookHierarchicalIsHierarchicalGroup, AddressBookHierarchicalParentDepartment, AddressBookHierarchicalRootDepartment, AddressBookHierarchicalShowInDepartments, AddressBookHomeMessageDatabase, AddressBookIsMaster, AddressBookIsMemberOfDistributionList, AddressBookManageDistributionList, AddressBookManager, AddressBookManagerDistinguishedName, AddressBookMember, AddressBookMessageId, AddressBookModerationEnabled, AddressBookNetworkAddress, AddressBookObjectDistinguishedName, AddressBookObjectGuid, AddressBookOrganizationalUnitRootDistinguishedName, AddressBookOwner, AddressBookOwnerBackLink, AddressBookParentEntryId, AddressBookPhoneticCompanyName, AddressBookPhoneticDepartmentName, AddressBookPhoneticDisplayName, AddressBookPhoneticGivenName, AddressBookPhoneticSurname, AddressBookProxyAddresses, AddressBookPublicDelegates, AddressBookReports, AddressBookRoomCapacity, AddressBookRoomContainers, AddressBookRoomDescription, AddressBookSenderHintTranslations, AddressBookSeniorityIndex, AddressBookTargetAddress, AddressBookUnauthorizedSenders, AddressBookX509Certificate, AddressType, AlternateRecipientAllowed, Anr, ArchiveDate, ArchivePeriod, ArchiveTag, Assistant, AssistantTelephoneNumber, Associated, AttachAdditionalInformation, AttachContentBase, AttachContentId, AttachContentLocation, AttachDataBinary, AttachDataObject, AttachEncoding, AttachExtension, AttachFilename, AttachFlags, AttachLongFilename, AttachLongPathname, AttachmentContactPhoto, AttachmentFlags, AttachmentHidden, AttachmentLinkId, AttachMethod, AttachMimeTag, AttachNumber, AttachPathname, AttachPayloadClass, AttachPayloadProviderGuidString, AttachRendering, AttachSize, AttachTag, AttachTransportName, AttributeHidden, AttributeReadOnly, AutoForwardComment, AutoForwarded, AutoResponseSuppress, Birthday, BlockStatus, Body, BodyContentId, BodyContentLocation, BodyHtml, Business2TelephoneNumber, Business2TelephoneNumbers, BusinessFaxNumber, BusinessHomePage, BusinessTelephoneNumber, CallbackTelephoneNumber, CallId, CarTelephoneNumber, CdoRecurrenceid, ChangeKey, ChangeNumber, ChildrensNames, ClientActions, ClientSubmitTime, CodePageId, Comment, CompanyMainTelephoneNumber, CompanyName, ComputerNetworkName, ConflictEntryId, ContainerClass, ContainerContents, ContainerFlags, ContainerHierarchy, ContentCount, ContentFilterSpamConfidenceLevel, ContentUnreadCount, ConversationId, ConversationIndex, ConversationIndexTracking, ConversationTopic, Country, CreationTime, CreatorEntryId, CreatorName, CustomerId, DamBackPatched, DamOriginalEntryId, DefaultPostMessageClass, DeferredActionMessageOriginalEntryId, DeferredDeliveryTime, DeferredSendNumber, DeferredSendTime, DeferredSendUnits, DelegatedByRule, DelegateFlags, DeleteAfterSubmit, DeletedCountTotal, DeletedOn, DeliverTime, DepartmentName, Depth, DisplayBcc, DisplayCc, DisplayName, DisplayNamePrefix, DisplayTo, DisplayType, DisplayTypeEx, EmailAddress, EndDate, EntryId, ExceptionEndTime, TagExceptionReplaceTime, ExceptionStartTime, ExchangeNTSecurityDescriptor, ExpiryNumber, ExpiryTime, ExpiryUnits, ExtendedFolderFlags, ExtendedRuleMessageActions, ExtendedRuleMessageCondition, ExtendedRuleSizeLimit, FaxNumberOfPages, FlagCompleteTime, FlagStatus, FlatUrlName, FolderAssociatedContents, FolderId, FolderFlags, FolderType, FollowupIcon, FreeBusyCountMonths, FreeBusyEntryIds, FreeBusyMessageEmailAddress, FreeBusyPublishEnd, FreeBusyPublishStart, FreeBusyRangeTimestamp, FtpSite, GatewayNeedsToRefresh, Gender, Generation, GivenName, GovernmentIdNumber, HasAttachments, HasDeferredActionMessages, HasNamedProperties, HasRules, HierarchyChangeNumber, HierRev, Hobbies, Home2TelephoneNumber, Home2TelephoneNumbers, HomeAddressCity, HomeAddressCountry, HomeAddressPostalCode, HomeAddressPostOfficeBox, HomeAddressStateOrProvince, HomeAddressStreet, HomeFaxNumber, HomeTelephoneNumber, TagHtml, ICalendarEndTime, ICalendarReminderNextTime, ICalendarStartTime, IconIndex, Importance, InConflict, InitialDetailsPane, Initials, InReplyToId, InstanceKey, InstanceNum, InstID, InternetCodepage, InternetMailOverrideFormat, InternetMessageId, InternetReferences, IpmAppointmentEntryId, IpmContactEntryId, IpmDraftsEntryId, IpmJournalEntryId, IpmNoteEntryId, IpmTaskEntryId, IsdnNumber, JunkAddRecipientsToSafeSendersList, JunkIncludeContacts, JunkPermanentlyDelete, JunkPhishingEnableLinks, JunkThreshold, Keyword, Language, LastModificationTime, LastModifierEntryId, LastModifierName, LastVerbExecuted, LastVerbExecutionTime, ListHelp, ListSubscribe, ListUnsubscribe, LocalCommitTime, LocalCommitTimeMax, LocaleId, Locality, TagLocation, MailboxOwnerEntryId, MailboxOwnerName, ManagerName, MappingSignature, MaximumSubmitMessageSize, MemberId, MemberName, MemberRights, MessageAttachments, MessageCcMe, MessageClass, MessageCodepage, MessageDeliveryTime, MessageEditorFormat, MessageFlags, MessageHandlingSystemCommonName, MessageLocaleId, MessageRecipientMe, MessageRecipients, MessageSize, MessageSizeExtended, MessageStatus, MessageSubmissionId, MessageToMe, Mid, MiddleName, MimeSkeleton, MobileTelephoneNumber, NativeBody, NextSendAcct, Nickname, NonDeliveryReportDiagCode, NonDeliveryReportReasonCode, NonDeliveryReportStatusCode, NonReceiptNotificationRequested, NormalizedSubject, ObjectType, OfficeLocation, OfflineAddressBookContainerGuid, OfflineAddressBookDistinguishedName, OfflineAddressBookMessageClass, OfflineAddressBookName, OfflineAddressBookSequence, OfflineAddressBookTruncatedProperties, OrdinalMost, OrganizationalIdNumber, OriginalAuthorEntryId, OriginalAuthorName, OriginalDeliveryTime, OriginalDisplayBcc, OriginalDisplayCc, OriginalDisplayTo, OriginalEntryId, OriginalMessageClass, OriginalMessageId, OriginalSenderAddressType, OriginalSenderEmailAddress, OriginalSenderEntryId, OriginalSenderName, OriginalSenderSearchKey, OriginalSensitivity, OriginalSentRepresentingAddressType, OriginalSentRepresentingEmailAddress, OriginalSentRepresentingEntryId, OriginalSentRepresentingName, OriginalSentRepresentingSearchKey, OriginalSubject, OriginalSubmitTime, OriginatorDeliveryReportRequested, OriginatorNonDeliveryReportRequested, OscSyncEnabled, OtherAddressCity, OtherAddressCountry, OtherAddressPostalCode, OtherAddressPostOfficeBox, OtherAddressStateOrProvince, OtherAddressStreet, OtherTelephoneNumber, OutOfOfficeState, OwnerAppointmentId, PagerTelephoneNumber, ParentEntryId, ParentFolderId, ParentKey, ParentSourceKey, PersonalHomePage, PolicyTag, PostalAddress, PostalCode, PostOfficeBox, PredecessorChangeList, PrimaryFaxNumber, PrimarySendAccount, PrimaryTelephoneNumber, Priority, Processed, Profession, ProhibitReceiveQuota, ProhibitSendQuota, PurportedSenderDomain, RadioTelephoneNumber, Read, ReadReceiptAddressType, ReadReceiptEmailAddress, ReadReceiptEntryId, ReadReceiptName, ReadReceiptRequested, ReadReceiptSearchKey, ReadReceiptSmtpAddress, ReceiptTime, ReceivedByAddressType, ReceivedByEmailAddress, ReceivedByEntryId, ReceivedByName, ReceivedBySearchKey, ReceivedBySmtpAddress, ReceivedRepresentingAddressType, ReceivedRepresentingEmailAddress, ReceivedRepresentingEntryId, ReceivedRepresentingName, ReceivedRepresentingSearchKey, ReceivedRepresentingSmtpAddress, RecipientDisplayName, RecipientEntryId, RecipientFlags, RecipientOrder, RecipientProposed, RecipientProposedEndTime, RecipientProposedStartTime, RecipientReassignmentProhibited, RecipientTrackStatus, RecipientTrackStatusTime, RecipientType, RecordKey, ReferredByName, RemindersOnlineEntryId, RemoteMessageTransferAgent, RenderingPosition, ReplyRecipientEntries, ReplyRecipientNames, ReplyRequested, ReplyTemplateId, ReplyTime, ReportDisposition, ReportDispositionMode, ReportEntryId, ReportingMessageTransferAgent, ReportName, ReportSearchKey, ReportTag, ReportText, ReportTime, ResolveMethod, ResponseRequested, Responsibility, RetentionDate, RetentionFlags, RetentionPeriod, Rights, RoamingDatatypes, RoamingDictionary, RoamingXmlStream, Rowid, RowType, RtfCompressed, RtfInSync, RuleActionNumber, RuleActions, RuleActionType, RuleCondition, RuleError, RuleFolderEntryId, RuleId, RuleIds, RuleLevel, RuleMessageLevel, RuleMessageName, RuleMessageProvider, RuleMessageProviderData, RuleMessageSequence, RuleMessageState, RuleMessageUserFlags, RuleName, RuleProvider, RuleProviderData, RuleSequence, RuleState, RuleUserFlags, RwRulesStream, ScheduleInfoAppointmentTombstone, ScheduleInfoAutoAcceptAppointments, ScheduleInfoDelegateEntryIds, ScheduleInfoDelegateNames, ScheduleInfoDelegateNamesW, ScheduleInfoDelegatorWantsCopy, ScheduleInfoDelegatorWantsInfo, ScheduleInfoDisallowOverlappingAppts, ScheduleInfoDisallowRecurringAppts, ScheduleInfoDontMailDelegates, ScheduleInfoFreeBusy, ScheduleInfoFreeBusyAway, ScheduleInfoFreeBusyBusy, ScheduleInfoFreeBusyMerged, ScheduleInfoFreeBusyTentative, ScheduleInfoMonthsAway, ScheduleInfoMonthsBusy, ScheduleInfoMonthsMerged, ScheduleInfoMonthsTentative, ScheduleInfoResourceType, SchedulePlusFreeBusyEntryId, ScriptData, SearchFolderDefinition, SearchFolderEfpFlags, SearchFolderExpiration, SearchFolderId, SearchFolderLastUsed, SearchFolderRecreateInfo, SearchFolderStorageType, SearchFolderTag, SearchFolderTemplateId, SearchKey, SecurityDescriptorAsXml, Selectable, SenderAddressType, SenderEmailAddress, SenderEntryId, SenderIdStatus, SenderName, SenderSearchKey, SenderSmtpAddress, SenderTelephoneNumber, SendInternetEncoding, SendRichInfo, Sensitivity, SentMailSvrEID, SentRepresentingAddressType, SentRepresentingEmailAddress, SentRepresentingEntryId, SentRepresentingFlags, SentRepresentingName, SentRepresentingSearchKey, SentRepresentingSmtpAddress, SmtpAddress, SortLocaleId, SourceKey, SpokenName, SpouseName, StartDate, StartDateEtc, StateOrProvince, StoreEntryId, StoreState, StoreSupportMask, StreetAddress, Subfolders, TagSubject, SubjectPrefix, SupplementaryInfo, Surname, SwappedToDoData, SwappedToDoStore, TargetEntryId, TelecommunicationsDeviceForDeafTelephoneNumber, TelexNumber, TemplateData, Templateid, TextAttachmentCharset, ThumbnailPhoto, TagTitle, TnefCorrelationKey, ToDoItemFlags, TransmittableDisplayName, TransportMessageHeaders, TrustSender, UserCertificate, UserEntryId, UserX509Certificate, ViewDescriptorBinary, ViewDescriptorName, ViewDescriptorStrings, ViewDescriptorVersion, VoiceMessageAttachmentOrder, VoiceMessageDuration, VoiceMessageSenderName, WeddingAnniversary, WlinkAddressBookEID, WlinkAddressBookStoreEID, WlinkCalendarColor, WlinkClientID, WlinkEntryId, WlinkFlags, WlinkFolderType, WlinkGroupClsid, WlinkGroupHeaderID, WlinkGroupName, WlinkOrdinal, WlinkRecordKey, WlinkROGroupType, WlinkSaveStamp, WlinkSection, WlinkStoreEntryId, WlinkType, Abstract, ActiveUserEntryid, AddrbookForLocalSiteEntryid, AddressBookDisplayName, ArrivalTime, AssocMessageSize, AssocMessageSizeExtended, AssocMsgWAttachCount, AttachOnAssocMsgCount, AttachOnNormalMsgCount, AutoAddNewSubs, BilateralInfo, CachedColumnCount, CategCount, ChangeAdvisor, ChangeNotificationGuid, Collector, ContactCount, ContentSearchKey, ContentsSynchronizer, DeletedAssocMessageSizeExtended, DeletedAssocMsgCount, DeletedFolderCount, DeletedMessageSizeExtended, DeletedMsgCount, DeletedNormalMessageSizeExtended, DesignInProgress, DisableFullFidelity, DisableWinsock, DlReportFlags, EformsForLocaleEntryid, EformsLocaleId, EformsRegistryEntryid, EmsAbAccessCategory, EmsAbActivationSchedule, EmsAbActivationStyle, EmsAbAddressEntryDisplayTable, EmsAbAddressEntryDisplayTableMsdos, EmsAbAddressSyntax, EmsAbAddressType, EmsAbAdmd, EmsAbAdminDescription, EmsAbAdminDisplayName, EmsAbAdminExtensionDll, EmsAbAliasedObjectName, EmsAbAliasedObjectNameO, EmsAbAltRecipient, EmsAbAltRecipientBl, EmsAbAltRecipientBlO, EmsAbAltRecipientO, EmsAbAncestorId, EmsAbAnonymousAccess, EmsAbAnonymousAccount, EmsAbAssocNtAccount, EmsAbAssocProtocolCfgNntp, EmsAbAssocProtocolCfgNntpO, EmsAbAssocRemoteDxa, EmsAbAssocRemoteDxaO, EmsAbAssociationLifetime, EmsAbAttributeCertificate, EmsAbAuthOrigBl, EmsAbAuthOrigBlO, EmsAbAuthenticationToUse, EmsAbAuthorityRevocationList, EmsAbAuthorizedDomain, EmsAbAuthorizedPassword, EmsAbAuthorizedPasswordConfirm, EmsAbAuthorizedUser, EmsAbAutoreply, EmsAbAutoreplyMessage, EmsAbAutoreplySubject, EmsAbAvailableAuthorizationPackages, EmsAbAvailableDistributions, EmsAbBridgeheadServers, EmsAbBridgeheadServersO, EmsAbBusinessCategory, EmsAbBusinessRoles, EmsAbCaCertificate, EmsAbCanCreatePf, EmsAbCanCreatePfBl, EmsAbCanCreatePfBlO, EmsAbCanCreatePfDl, EmsAbCanCreatePfDlBl, EmsAbCanCreatePfDlBlO, EmsAbCanCreatePfDlO, EmsAbCanCreatePfO, EmsAbCanNotCreatePf, EmsAbCanNotCreatePfBl, EmsAbCanNotCreatePfBlO, EmsAbCanNotCreatePfDl, EmsAbCanNotCreatePfDlBl, EmsAbCanNotCreatePfDlBlO, EmsAbCanNotCreatePfDlO, EmsAbCanNotCreatePfO, EmsAbCanPreserveDns, EmsAbCertificateChainV3, EmsAbCertificateRevocationList, EmsAbCertificateRevocationListV1, EmsAbCertificateRevocationListV3, EmsAbCharacterSet, EmsAbCharacterSetList, EmsAbChildRdns, EmsAbClientAccessEnabled, EmsAbClockAlertOffset, EmsAbClockAlertRepair, EmsAbClockWarningOffset, EmsAbClockWarningRepair, EmsAbCompromisedKeyList, EmsAbComputerName, EmsAbConnectedDomains, EmsAbConnectionListFilter, EmsAbConnectionListFilterType, EmsAbConnectionType, EmsAbContainerInfo, EmsAbContentType, EmsAbControlMsgFolderId, EmsAbControlMsgRules, EmsAbCost, EmsAbCountryName, EmsAbCrossCertificateCrl, EmsAbCrossCertificatePair, EmsAbDefaultMessageFormat, EmsAbDelegateUser, EmsAbDelivEits, EmsAbDelivExtContTypes, EmsAbDeliverAndRedirect, EmsAbDeliveryMechanism, EmsAbDeltaRevocationList, EmsAbDescription, EmsAbDestinationIndicator, EmsAbDiagnosticRegKey, EmsAbDisableDeferredCommit, EmsAbDisabledGatewayProxy, EmsAbDisplayNameOverride, EmsAbDisplayNameSuffix, EmsAbDlMemRejectPermsBl, EmsAbDlMemRejectPermsBlO, EmsAbDlMemberRule, EmsAbDmdName, EmsAbDoOabVersion, EmsAbDomainDefAltRecip, EmsAbDomainDefAltRecipO, EmsAbDomainName, EmsAbDsaSignature, EmsAbDxaAdminCopy, EmsAbDxaAdminForward, EmsAbDxaAdminUpdate, EmsAbDxaAppendReqcn, EmsAbDxaConfContainerList, EmsAbDxaConfContainerListO, EmsAbDxaConfReqTime, EmsAbDxaConfSeq, EmsAbDxaConfSeqUsn, EmsAbDxaExchangeOptions, EmsAbDxaExportNow, EmsAbDxaFlags, EmsAbDxaImpSeq, EmsAbDxaImpSeqTime, EmsAbDxaImpSeqUsn, EmsAbDxaImportNow, EmsAbDxaInTemplateMap, EmsAbDxaLocalAdmin, EmsAbDxaLocalAdminO, EmsAbDxaLoggingLevel, EmsAbDxaNativeAddressType, EmsAbDxaOutTemplateMap, EmsAbDxaPassword, EmsAbDxaPrevExchangeOptions, EmsAbDxaPrevExportNativeOnly, EmsAbDxaPrevInExchangeSensitivity, EmsAbDxaPrevRemoteEntries, EmsAbDxaPrevRemoteEntriesO, EmsAbDxaPrevReplicationSensitivity, EmsAbDxaPrevTemplateOptions, EmsAbDxaPrevTypes, EmsAbDxaRecipientCp, EmsAbDxaRemoteClient, EmsAbDxaRemoteClientO, EmsAbDxaReqSeq, EmsAbDxaReqSeqTime, EmsAbDxaReqSeqUsn, EmsAbDxaReqname, EmsAbDxaSvrSeq, EmsAbDxaSvrSeqTime, EmsAbDxaSvrSeqUsn, EmsAbDxaTask, EmsAbDxaTemplateOptions, EmsAbDxaTemplateTimestamp, EmsAbDxaTypes, EmsAbDxaUnconfContainerList, EmsAbDxaUnconfContainerListO, EmsAbEmployeeNumber, EmsAbEmployeeType, EmsAbEnableCompatibility, EmsAbEnabled, EmsAbEnabledAuthorizationPackages, EmsAbEnabledProtocolCfg, EmsAbEnabledProtocols, EmsAbEncapsulationMethod, EmsAbEncrypt, EmsAbEncryptAlgListNa, EmsAbEncryptAlgListOther, EmsAbEncryptAlgSelectedNa, EmsAbEncryptAlgSelectedOther, EmsAbExpandDlsLocally, EmsAbExpirationTime, EmsAbExportContainers, EmsAbExportContainersO, EmsAbExportCustomRecipients, EmsAbExtendedCharsAllowed, EmsAbExtensionData, EmsAbExtensionName, EmsAbExtensionNameInherited, EmsAbFacsimileTelephoneNumber, EmsAbFileVersion, EmsAbFilterLocalAddresses, EmsAbFoldersContainer, EmsAbFoldersContainerO, EmsAbFormData, EmsAbForwardingAddress, EmsAbGarbageCollPeriod, EmsAbGatewayLocalCred, EmsAbGatewayLocalDesig, EmsAbGatewayProxy, EmsAbGatewayRoutingTree, EmsAbGenerationQualifier, EmsAbGroupByAttr1, EmsAbGroupByAttr2, EmsAbGroupByAttr3, EmsAbGroupByAttr4, EmsAbGroupByAttrValueDn, EmsAbGroupByAttrValueDnO, EmsAbGroupByAttrValueStr, EmsAbGwartLastModified, EmsAbHasFullReplicaNcs, EmsAbHasFullReplicaNcsO, EmsAbHasMasterNcs, EmsAbHasMasterNcsO, EmsAbHelpData16, EmsAbHelpData32, EmsAbHelpFileName, EmsAbHeuristics, EmsAbHideDlMembership, EmsAbHideFromAddressBook, EmsAbHierarchyPath, EmsAbHomeMdbBl, EmsAbHomeMdbBlO, EmsAbHomeMta, EmsAbHomeMtaO, EmsAbHomePublicServer, EmsAbHomePublicServerO, EmsAbHouseIdentifier, EmsAbHttpPubAbAttributes, EmsAbHttpPubGal, EmsAbHttpPubGalLimit, EmsAbHttpPubPf, EmsAbHttpServers, EmsAbImportContainer, EmsAbImportContainerO, EmsAbImportSensitivity, EmsAbImportedFrom, EmsAbInboundAcceptAll, EmsAbInboundDn, EmsAbInboundDnO, EmsAbInboundHost, EmsAbInboundNewsfeed, EmsAbInboundNewsfeedType, EmsAbInboundSites, EmsAbInboundSitesO, EmsAbIncomingMsgSizeLimit, EmsAbIncomingPassword, EmsAbInsadmin, EmsAbInsadminO, EmsAbInstanceType, EmsAbInternationalIsdnNumber, EmsAbInvocationId, EmsAbIsDeleted, EmsAbIsSingleValued, EmsAbKccStatus, EmsAbKmServer, EmsAbKmServerO, EmsAbKnowledgeInformation, EmsAbLabeleduri, EmsAbLanguage, EmsAbLanguageIso639, EmsAbLdapDisplayName, EmsAbLdapSearchCfg, EmsAbLineWrap, EmsAbLinkId, EmsAbListPublicFolders, EmsAbLocalBridgeHead, EmsAbLocalBridgeHeadAddress, EmsAbLocalInitialTurn, EmsAbLocalScope, EmsAbLocalScopeO, EmsAbLogFilename, EmsAbLogRolloverInterval, EmsAbMailDrop, EmsAbMaintainAutoreplyHistory, EmsAbMapiDisplayType, EmsAbMapiId, EmsAbMaximumObjectId, EmsAbMdbBackoffInterval, EmsAbMdbMsgTimeOutPeriod, EmsAbMdbOverQuotaLimit, EmsAbMdbStorageQuota, EmsAbMdbUnreadLimit, EmsAbMdbUseDefaults, EmsAbMessageTrackingEnabled, EmsAbMimeTypes, EmsAbModerated, EmsAbModerator, EmsAbMonitorClock, EmsAbMonitorServers, EmsAbMonitorServices, EmsAbMonitoredConfigurations, EmsAbMonitoredConfigurationsO, EmsAbMonitoredServers, EmsAbMonitoredServersO, EmsAbMonitoredServices, EmsAbMonitoringAlertDelay, EmsAbMonitoringAlertUnits, EmsAbMonitoringAvailabilityStyle, EmsAbMonitoringAvailabilityWindow, EmsAbMonitoringCachedViaMail, EmsAbMonitoringCachedViaMailO, EmsAbMonitoringCachedViaRpc, EmsAbMonitoringCachedViaRpcO, EmsAbMonitoringEscalationProcedure, EmsAbMonitoringHotsitePollInterval, EmsAbMonitoringHotsitePollUnits, EmsAbMonitoringMailUpdateInterval, EmsAbMonitoringMailUpdateUnits, EmsAbMonitoringNormalPollInterval, EmsAbMonitoringNormalPollUnits, EmsAbMonitoringRecipients, EmsAbMonitoringRecipientsNdr, EmsAbMonitoringRecipientsNdrO, EmsAbMonitoringRecipientsO, EmsAbMonitoringRpcUpdateInterval, EmsAbMonitoringRpcUpdateUnits, EmsAbMonitoringWarningDelay, EmsAbMonitoringWarningUnits, EmsAbMtaLocalCred, EmsAbMtaLocalDesig, EmsAbNAddress, EmsAbNAddressType, EmsAbNewsfeedType, EmsAbNewsgroup, EmsAbNewsgroupList, EmsAbNntpCharacterSet, EmsAbNntpContentFormat, EmsAbNntpDistributions, EmsAbNntpDistributionsFlag, EmsAbNntpNewsfeeds, EmsAbNntpNewsfeedsO, EmsAbNtMachineName, EmsAbNtSecurityDescriptor, EmsAbNumOfOpenRetries, EmsAbNumOfTransferRetries, EmsAbObjViewContainers, EmsAbObjViewContainersO, EmsAbObjectClassCategory, EmsAbObjectOid, EmsAbObjectVersion, EmsAbOffLineAbContainers, EmsAbOffLineAbContainersO, EmsAbOffLineAbSchedule, EmsAbOffLineAbServer, EmsAbOffLineAbServerO, EmsAbOffLineAbStyle, EmsAbOidType, EmsAbOmObjectClass, EmsAbOmSyntax, EmsAbOofReplyToOriginator, EmsAbOpenRetryInterval, EmsAbOrganizationName, EmsAbOrganizationalUnitName, EmsAbOriginalDisplayTable, EmsAbOriginalDisplayTableMsdos, EmsAbOtherRecips, EmsAbOutboundHost, EmsAbOutboundHostType, EmsAbOutboundNewsfeed, EmsAbOutboundSites, EmsAbOutboundSitesO, EmsAbOutgoingMsgSizeLimit, EmsAbOverrideNntpContentFormat, EmsAbOwaServer, EmsAbPSelector, EmsAbPSelectorInbound, EmsAbPerMsgDialogDisplayTable, EmsAbPerRecipDialogDisplayTable, EmsAbPeriodRepSyncTimes, EmsAbPeriodReplStagger, EmsAbPersonalTitle, EmsAbPfContacts, EmsAbPfContactsO, EmsAbPopCharacterSet, EmsAbPopContentFormat, EmsAbPortNumber, EmsAbPostalAddress, EmsAbPreferredDeliveryMethod, EmsAbPreserveInternetContent, EmsAbPrmd, EmsAbPromoExpiration, EmsAbProtocolSettings, EmsAbProxyGenerationEnabled, EmsAbProxyGeneratorDll, EmsAbPublicDelegatesBl, EmsAbPublicDelegatesBlO, EmsAbQuotaNotificationSchedule, EmsAbQuotaNotificationStyle, EmsAbRangeLower, EmsAbRangeUpper, EmsAbRasAccount, EmsAbRasCallbackNumber, EmsAbRasPassword, EmsAbRasPhoneNumber, EmsAbRasPhonebookEntryName, EmsAbRasRemoteSrvrName, EmsAbReferralList, EmsAbRegisteredAddress, EmsAbRemoteBridgeHead, EmsAbRemoteBridgeHeadAddress, EmsAbRemoteOutBhServer, EmsAbRemoteOutBhServerO, EmsAbRemoteSite, EmsAbRemoteSiteO, EmsAbReplicatedObjectVersion, EmsAbReplicationMailMsgSize, EmsAbReplicationSensitivity, EmsAbReplicationStagger, EmsAbReportToOriginator, EmsAbReportToOwner, EmsAbReqSeq, EmsAbRequireSsl, EmsAbResponsibleLocalDxa, EmsAbResponsibleLocalDxaO, EmsAbReturnExactMsgSize, EmsAbRidServer, EmsAbRidServerO, EmsAbRoleOccupant, EmsAbRoleOccupantO, EmsAbRootNewsgroupsFolderId, EmsAbRoutingList, EmsAbRtsCheckpointSize, EmsAbRtsRecoveryTimeout, EmsAbRtsWindowSize, EmsAbRunsOn, EmsAbRunsOnO, EmsAbSSelector, EmsAbSSelectorInbound, EmsAbSchemaFlags, EmsAbSchemaVersion, EmsAbSearchFlags, EmsAbSearchGuide, EmsAbSecurityPolicy, EmsAbSecurityProtocol, EmsAbSeeAlso, EmsAbSeeAlsoO, EmsAbSendEmailMessage, EmsAbSendTnef, EmsAbSerialNumber, EmsAbServer, EmsAbServiceActionFirst, EmsAbServiceActionOther, EmsAbServiceActionSecond, EmsAbServiceRestartDelay, EmsAbServiceRestartMessage, EmsAbSessionDisconnectTimer, EmsAbSiteAffinity, EmsAbSiteFolderGuid, EmsAbSiteFolderServer, EmsAbSiteFolderServerO, EmsAbSiteProxySpace, EmsAbSmimeAlgListNa, EmsAbSmimeAlgListOther, EmsAbSmimeAlgSelectedNa, EmsAbSmimeAlgSelectedOther, EmsAbSpaceLastComputed, EmsAbStreetAddress, EmsAbSubRefs, EmsAbSubRefsO, EmsAbSubSite, EmsAbSubmissionContLength, EmsAbSupportSmimeSignatures, EmsAbSupportedAlgorithms, EmsAbSupportedApplicationContext, EmsAbSupportingStack, EmsAbSupportingStackBl, EmsAbSupportingStackBlO, EmsAbSupportingStackO, EmsAbTSelector, EmsAbTSelectorInbound, EmsAbTargetMtas, EmsAbTelephoneNumber, EmsAbTelephonePersonalPager, EmsAbTeletexTerminalIdentifier, EmsAbTempAssocThreshold, EmsAbTombstoneLifetime, EmsAbTrackingLogPathName, EmsAbTransRetryMins, EmsAbTransTimeoutMins, EmsAbTransferRetryInterval, EmsAbTransferTimeoutNonUrgent, EmsAbTransferTimeoutNormal, EmsAbTransferTimeoutUrgent, EmsAbTranslationTableUsed, EmsAbTransportExpeditedData, EmsAbTrustLevel, EmsAbTurnRequestThreshold, EmsAbTwoWayAlternateFacility, EmsAbType, EmsAbUnauthOrigBl, EmsAbUnauthOrigBlO, EmsAbUseServerValues, EmsAbUseSiteValues, EmsAbUsenetSiteName, EmsAbUserPassword, EmsAbUsnChanged, EmsAbUsnCreated, EmsAbUsnDsaLastObjRemoved, EmsAbUsnIntersite, EmsAbUsnLastObjRem, EmsAbUsnSource, EmsAbViewContainer1, EmsAbViewContainer2, EmsAbViewContainer3, EmsAbViewDefinition, EmsAbViewFlags, EmsAbViewSite, EmsAbVoiceMailFlags, EmsAbVoiceMailGreetings, EmsAbVoiceMailPassword, EmsAbVoiceMailRecordedName, EmsAbVoiceMailRecordingLength, EmsAbVoiceMailSpeed, EmsAbVoiceMailSystemGuid, EmsAbVoiceMailUserId, EmsAbVoiceMailVolume, EmsAbWwwHomePage, EmsAbX121Address, EmsAbX25CallUserDataIncoming, EmsAbX25CallUserDataOutgoing, EmsAbX25FacilitiesDataIncoming, EmsAbX25FacilitiesDataOutgoing, EmsAbX25LeasedLinePort, EmsAbX25LeasedOrSwitched, EmsAbX25RemoteMtaPhone, EmsAbX400AttachmentType, EmsAbX400SelectorSyntax, EmsAbX500AccessControlList, EmsAbX500Nc, EmsAbX500Rdn, EmsAbXmitTimeoutNonUrgent, EmsAbXmitTimeoutNormal, EmsAbXmitTimeoutUrgent, EventsRootFolderEntryid, ExcessStorageUsed, ExtendedAclData, FastTransfer, FavoritesDefaultName, FolderChildCount, FolderDesignFlags, FolderPathname, ForeignId, ForeignReportId, ForeignSubjectId, FreeBusyForLocalSiteEntryid, GwAdminOperations, GwMtsinEntryid, GwMtsoutEntryid, HasModeratorRules, HierarchyServer, HierarchySynchronizer, ImapInternalDate, InTransit, InboundNewsfeedDn, InternetCharset, InternetNewsgroupName, IpmDafEntryid, IpmFavoritesEntryid, IpmPublicFoldersEntryid, IsNewsgroup, IsNewsgroupAnchor, LastAccessTime, LastFullBackup, LastLogoffTime, LastLogonTime, LongtermEntryidFromTable, MessageProcessed, MessageSiteName, MoveToFolderEntryid, MoveToStoreEntryid, MsgBodyId, MtsSubjectId, NewSubsGetAutoAdd, NewsfeedInfo, NewsgroupComponent, NewsgroupRootFolderEntryid, NntpArticleFolderEntryid, NntpControlFolderEntryid, NonIpmSubtreeEntryid, NormalMessageSize, NormalMessageSizeExtended, NormalMsgWAttachCount, NtUserName, OfflineAddrbookEntryid, OfflineFlags, OfflineMessageEntryid, OldestDeletedOn, OriginatorAddr, OriginatorAddrtype, OriginatorEntryid, OriginatorName, OstEncryption, OutboundNewsfeedDn, OverallAgeLimit, OverallMsgAgeLimit, OwaUrl, OwnerCount, P1Content, P1ContentType, PreventMsgCreate, Preview, PreviewUnread, ProfileAbFilesPath, ProfileAddrInfo, ProfileAllpubComment, ProfileAllpubDisplayName, ProfileBindingOrder, ProfileConfigFlags, ProfileConnectFlags, ProfileFavfldComment, ProfileFavfldDisplayName, ProfileHomeServer, ProfileHomeServerAddrs, ProfileHomeServerDn, ProfileMailbox, ProfileMaxRestrict, ProfileMoab, ProfileMoabGuid, ProfileMoabSeq, ProfileOfflineInfo, ProfileOfflineStorePath, ProfileOpenFlags, ProfileOptionsData, ProfileSecureMailbox, ProfileServer, ProfileServerDn, ProfileTransportFlags, ProfileType, ProfileUiState, ProfileUnresolvedName, ProfileUnresolvedServer, ProfileUser, ProfileVersion, PstEncryption, PstPath, PstPwSzOld, PstRememberPw, PublicFolderEntryid, PublishInAddressBook, RecipientNumber, RecipientOnAssocMsgCount, RecipientOnNormalMsgCount, ReplicaList, ReplicaServer, ReplicaVersion, ReplicationAlwaysInterval, ReplicationMessagePriority, ReplicationMsgSize, ReplicationSchedule, ReplicationStyle, ReplyRecipientSmtpProxies, ReportDestinationEntryid, ReportDestinationName, RestrictionCount, RetentionAgeLimit, RuleTriggerHistory, RulesData, RulesTable, ScheduleFolderEntryid, SecureInSite, SecureOrigination, StorageLimitInformation, StorageQuotaLimit, StoreOffline, StoreSlowlink, SubjectTraceInfo, SvrGeneratingQuotaMsg, SynchronizeFlags, SysConfigFolderEntryid, TestLineSpeed, TraceInfo, TransferEnabled, UserName, X400EnvelopeType, AbDefaultDir, AbDefaultPab, AbProviderId, AbProviders, AbSearchPath, AbSearchPathUpdate, AlternateRecipient, AssocContentCount, AttachmentX400Parameters, AuthorizingUsers, BodyCrc, CommonViewsEntryid, ContactAddrtypes, ContactDefaultAddressIndex, ContactEmailAddresses, ContactEntryids, ContactVersion, ContainerModifyVersion, ContentConfidentialityAlgorithmId, ContentCorrelator, ContentIdentifier, ContentIntegrityCheck, ContentLength, ContentReturnRequested, ContentsSortOrder, ControlFlags, ControlId, ControlStructure, ControlType, ConversationKey, ConversionEits, ConversionProhibited, ConversionWithLossProhibited, ConvertedEits, Correlate, CorrelateMtsid, CreateTemplates, CreationVersion, ExCurrentVersion, DefCreateDl, DefCreateMailuser, DefaultProfile, DefaultStore, DefaultViewEntryid, Delegation, DeliveryPoint, Deltax, Deltay, DetailsTable, DiscVal, DiscardReason, DiscloseRecipients, DisclosureOfRecipients, DiscreteValues, DlExpansionHistory, DlExpansionProhibited, ExplicitConversion, FilteringHooks, FinderEntryid, FormCategory, FormCategorySub, FormClsid, FormContactName, FormDesignerGuid, FormDesignerName, FormHidden, FormHostMap, FormMessageBehavior, FormVersion, HeaderFolderEntryid, Icon, IdentityDisplay, IdentityEntryid, IdentitySearchKey, ImplicitConversionProhibited, IncompleteCopy, InternetApproved, InternetArticleNumber, InternetControl, InternetDistribution, InternetFollowupTo, InternetLines, InternetNewsgroups, InternetNntpPath, InternetOrganization, InternetPrecedence, IpmId, IpmOutboxEntryid, IpmOutboxSearchKey, IpmReturnRequested, IpmSentmailEntryid, IpmSentmailSearchKey, IpmSubtreeEntryid, IpmSubtreeSearchKey, IpmWastebasketEntryid, IpmWastebasketSearchKey, Languages, LatestDeliveryTime, MailPermission, MdbProvider, MessageDeliveryId, MessageDownloadTime, MessageSecurityLabel, MessageToken, MiniIcon, ModifyVersion, NewsgroupName, NntpXref, NonReceiptReason, ObsoletedIpms, OriginCheck, OriginalAuthorAddrtype, OriginalAuthorEmailAddress, OriginalAuthorSearchKey, OriginalDisplayName, OriginalEits, OriginalSearchKey, OriginallyIntendedRecipAddrtype, OriginallyIntendedRecipEmailAddress, OriginallyIntendedRecipEntryid, OriginallyIntendedRecipientName, OriginatingMtaCertificate, OriginatorAndDlExpansionHistory, OriginatorCertificate, OriginatorRequestedAlternateRecipient, OriginatorReturnAddress, OwnStoreEntryid, ParentDisplay, PhysicalDeliveryBureauFaxDelivery, PhysicalDeliveryMode, PhysicalDeliveryReportRequest, PhysicalForwardingAddress, PhysicalForwardingAddressRequested, PhysicalForwardingProhibited, PhysicalRenditionAttributes, PostFolderEntries, PostFolderNames, PostReplyDenied, PostReplyFolderEntries, PostReplyFolderNames, Preprocess, PrimaryCapability, ProfileName, ProofOfDelivery, ProofOfDeliveryRequested, ProofOfSubmission, ProofOfSubmissionRequested, ProviderDisplay, ProviderDllName, ProviderOrdinal, ProviderSubmitTime, ProviderUid, ReceiveFolderSettings, RecipientCertificate, RecipientNumberForAdvice, RecipientStatus, RedirectionHistory, RegisteredMailType, RelatedIpms, RemoteProgress, RemoteProgressText, RemoteValidateOk, ReportingDlName, ReportingMtaCertificate, RequestedDeliveryMethod, ResourceFlags, ResourceMethods, ResourcePath, ResourceType, ReturnedIpm, RtfSyncBodyCount, RtfSyncBodyCrc, RtfSyncBodyTag, RtfSyncPrefixCount, RtfSyncTrailingCount, Search, ExSecurity, SentmailEntryid, ServiceDeleteFiles, ServiceDllName, ServiceEntryName, ServiceExtraUids, ServiceName, ServiceSupportFiles, ServiceUid, Services, SpoolerStatus, Status, StatusCode, StatusString, StoreProviders, StoreRecordKey, SubjectIpm, SubmitFlags, Supersedes, TransportKey, TransportProviders, TransportStatus, TypeOfMtsUser, ValidFolderMask, ViewsEntryid, X400ContentType, X400DeferredDeliveryCancel, Xpos, Ypos
        :type name: str
        """
        super(MapiKnownPropertyDescriptor, self).__init__()

        self._name = None
        if name is not None:
            self.name = name


    @property
    def name(self) -> str:
        """
        Known property name.  See all known properties here: https://apireference.aspose.com/email/net/aspose.email.mapi/knownpropertylist/fields/index  Possible values: Mileage, ObjectUri, GDataContactVersion, GDataPhotoVersion, AddressBookProviderArrayType, AddressBookProviderEmailList, AddressCountryCode, AgingDontAgeMe, AllAttendeesString, AllowExternalCheck, AnniversaryEventEntryId, AppointmentAuxiliaryFlags, AppointmentColor, AppointmentCounterProposal, AppointmentDuration, AppointmentEndDate, AppointmentEndTime, AppointmentEndWhole, AppointmentLastSequence, AppointmentMessageClass, AppointmentNotAllowPropose, AppointmentProposalNumber, AppointmentProposedDuration, AppointmentProposedEndWhole, AppointmentProposedStartWhole, AppointmentRecur, AppointmentReplyName, AppointmentReplyTime, AppointmentSequence, AppointmentSequenceTime, AppointmentStartDate, AppointmentStartTime, AppointmentStartWhole, AppointmentStateFlags, AppointmentSubType, AppointmentTimeZoneDefinitionEndDisplay, AppointmentTimeZoneDefinitionRecur, AppointmentTimeZoneDefinitionStartDisplay, AppointmentUnsendableRecipients, AppointmentUpdateTime, AttendeeCriticalChange, AutoFillLocation, AutoLog, AutoProcessState, AutoStartCheck, Billing, BirthdayEventEntryId, BirthdayLocal, BusinessCardCardPicture, BusinessCardDisplayDefinition, BusyStatus, CalendarType, Categories, CcAttendeesString, ChangeHighlight, Classification, ClassificationDescription, ClassificationGuid, ClassificationKeep, Classified, CleanGlobalObjectId, ClientIntent, ClipEnd, ClipStart, CollaborateDoc, CommonEnd, CommonStart, Companies, ConferencingCheck, ConferencingType, ContactCharacterSet, ContactItemData, ContactLinkedGlobalAddressListEntryId, ContactLinkEntry, ContactLinkGlobalAddressListLinkId, ContactLinkGlobalAddressListLinkState, ContactLinkLinkRejectHistory, ContactLinkName, ContactLinkSearchKey, ContactLinkSMTPAddressCache, Contacts, ContactUserField1, ContactUserField2, ContactUserField3, ContactUserField4, ConversationActionLastAppliedTime, ConversationActionMaxDeliveryTime, ConversationActionMoveFolderEid, ConversationActionMoveStoreEid, ConversationActionVersion, ConversationProcessed, CurrentVersion, CurrentVersionName, DayInterval, DayOfMonth, DelegateMail, Department, Directory, DistributionListChecksum, DistributionListMembers, DistributionListName, DistributionListOneOffMembers, DistributionListStream, Email1AddressType, Email1DisplayName, Email1EmailAddress, Email1OriginalDisplayName, Email1OriginalEntryId, Email2AddressType, Email2DisplayName, Email2EmailAddress, Email2OriginalDisplayName, Email2OriginalEntryId, Email3AddressType, Email3DisplayName, Email3EmailAddress, Email3OriginalDisplayName, Email3OriginalEntryId, EndRecurrenceDate, EndRecurrenceTime, ExceptionReplaceTime, Fax1AddressType, Fax1EmailAddress, Fax1OriginalDisplayName, Fax1OriginalEntryId, Fax2AddressType, Fax2EmailAddress, Fax2OriginalDisplayName, Fax2OriginalEntryId, Fax3AddressType, Fax3EmailAddress, Fax3OriginalDisplayName, Fax3OriginalEntryId, FExceptionalAttendees, FExceptionalBody, FileUnder, FileUnderId, FileUnderList, FInvited, FlagRequest, FlagString, ForwardInstance, ForwardNotificationRecipients, FOthersAppointment, FreeBusyLocation, GlobalObjectId, HasPicture, HomeAddress, HomeAddressCountryCode, Html, ICalendarDayOfWeekMask, InboundICalStream, InfoPathFormName, InstantMessagingAddress, IntendedBusyStatus, InternetAccountName, InternetAccountStamp, IsContactLinked, IsException, IsRecurring, IsSilent, LinkedTaskItems, Location, LogDocumentPosted, LogDocumentPrinted, LogDocumentRouted, LogDocumentSaved, LogDuration, LogEnd, LogFlags, LogStart, LogType, LogTypeDesc, MeetingType, MeetingWorkspaceUrl, MonthInterval, MonthOfYear, MonthOfYearMask, NetShowUrl, NoEndDateFlag, NonSendableBcc, NonSendableCc, NonSendableTo, NonSendBccTrackStatus, NonSendCcTrackStatus, NonSendToTrackStatus, NoteColor, NoteHeight, NoteWidth, NoteX, NoteY, Occurrences, OldLocation, OldRecurrenceType, OldWhenEndWhole, OldWhenStartWhole, OnlinePassword, OptionalAttendees, OrganizerAlias, OriginalStoreEntryId, OtherAddress, OtherAddressCountryCode, OwnerCriticalChange, OwnerName, PendingStateForSiteMailboxDocument, PercentComplete, PostalAddressId, PostRssChannel, PostRssChannelLink, PostRssItemGuid, PostRssItemHash, PostRssItemLink, PostRssItemXml, PostRssSubscription, Private, PromptSendUpdate, RecurrenceDuration, RecurrencePattern, RecurrenceType, Recurring, ReferenceEntryId, ReminderDelta, ReminderFileParameter, ReminderOverride, ReminderPlaySound, ReminderSet, ReminderSignalTime, ReminderTime, ReminderTimeDate, ReminderTimeTime, ReminderType, RemoteStatus, RequiredAttendees, ResourceAttendees, ResponseStatus, ServerProcessed, ServerProcessingActions, SharingAnonymity, SharingBindingEntryId, SharingBrowseUrl, SharingCapabilities, SharingConfigurationUrl, SharingDataRangeEnd, SharingDataRangeStart, SharingDetail, SharingExtensionXml, SharingFilter, SharingFlags, SharingFlavor, SharingFolderEntryId, SharingIndexEntryId, SharingInitiatorEntryId, SharingInitiatorName, SharingInitiatorSmtp, SharingInstanceGuid, SharingLastAutoSyncTime, SharingLastSyncTime, SharingLocalComment, SharingLocalLastModificationTime, SharingLocalName, SharingLocalPath, SharingLocalStoreUid, SharingLocalType, SharingLocalUid, SharingOriginalMessageEntryId, SharingParentBindingEntryId, SharingParticipants, SharingPermissions, SharingProviderExtension, SharingProviderGuid, SharingProviderName, SharingProviderUrl, SharingRangeEnd, SharingRangeStart, SharingReciprocation, SharingRemoteByteSize, SharingRemoteComment, SharingRemoteCrc, SharingRemoteLastModificationTime, SharingRemoteMessageCount, SharingRemoteName, SharingRemotePass, SharingRemotePath, SharingRemoteStoreUid, SharingRemoteType, SharingRemoteUid, SharingRemoteUser, SharingRemoteVersion, SharingResponseTime, SharingResponseType, SharingRoamLog, SharingStart, SharingStatus, SharingStop, SharingSyncFlags, SharingSyncInterval, SharingTimeToLive, SharingTimeToLiveAuto, SharingWorkingHoursDays, SharingWorkingHoursEnd, SharingWorkingHoursStart, SharingWorkingHoursTimeZone, SideEffects, SingleBodyICal, SmartNoAttach, SpamOriginalFolder, StartRecurrenceDate, StartRecurrenceTime, TaskAcceptanceState, TaskAccepted, TaskActualEffort, TaskAssigner, TaskAssigners, TaskComplete, TaskCustomFlags, TaskDateCompleted, TaskDeadOccurrence, TaskDueDate, TaskEstimatedEffort, TaskFCreator, TaskFFixOffline, TaskFRecurring, TaskGlobalId, TaskHistory, TaskLastDelegate, TaskLastUpdate, TaskLastUser, TaskMode, TaskMultipleRecipients, TaskNoCompute, TaskOrdinal, TaskOwner, TaskOwnership, TaskRecurrence, TaskResetReminder, TaskRole, TaskStartDate, TaskState, TaskStatus, TaskStatusOnComplete, TaskUpdates, TaskVersion, TeamTask, TimeZone, TimeZoneDescription, TimeZoneStruct, ToAttendeesString, ToDoOrdinalDate, ToDoSubOrdinal, ToDoTitle, UseTnef, ValidFlagStringProof, VerbResponse, VerbStream, WeddingAnniversaryLocal, WeekInterval, Where, WorkAddress, WorkAddressCity, WorkAddressCountry, WorkAddressCountryCode, WorkAddressPostalCode, WorkAddressPostOfficeBox, WorkAddressState, WorkAddressStreet, YearInterval, YomiCompanyName, YomiFirstName, YomiLastName, AcceptLanguage, ApplicationName, AttachmentMacContentType, AttachmentMacInfo, AudioNotes, Author, AutomaticSpeechRecognitionData, ByteCount, CalendarAttendeeRole, CalendarBusystatus, CalendarContact, CalendarContactUrl, CalendarCreated, CalendarDescriptionUrl, CalendarDuration, CalendarExceptionDate, CalendarExceptionRule, CalendarGeoLatitude, CalendarGeoLongitude, CalendarInstanceType, CalendarIsOrganizer, CalendarLastModified, CalendarLocationUrl, CalendarMeetingStatus, CalendarMethod, CalendarProductId, CalendarRecurrenceIdRange, CalendarReminderOffset, CalendarResources, CalendarRsvp, CalendarSequence, CalendarTimeZone, CalendarTimeZoneId, CalendarTransparent, CalendarUid, CalendarVersion, Category, CharacterCount, Comments, Company, ContentBase, ContentClass, ContentType, CreateDateTimeReadOnly, CrossReference, DavId, DavIsCollection, DavIsStructuredDocument, DavParentName, DavUid, DocumentParts, EditTime, ExchangeIntendedBusyStatus, ExchangeJunkEmailMoveStamp, ExchangeModifyExceptionStructure, ExchangeNoModifyExceptions, ExchangePatternEnd, ExchangePatternStart, ExchangeReminderInterval, ExchDatabaseSchema, ExchDataExpectedContentClass, ExchDataSchemaCollectionReference, ExtractedAddresses, ExtractedContacts, ExtractedEmails, ExtractedMeetings, ExtractedPhones, ExtractedTasks, ExtractedUrls, From, HeadingPairs, HiddenCount, HttpmailCalendar, HttpmailHtmlDescription, HttpmailSendMessage, ICalendarRecurrenceDate, ICalendarRecurrenceRule, InternetSubject, Keywords, LastAuthor, LastPrinted, LastSaveDateTime, LineCount, LinksDirty, LocationUrl, Manager, MultimediaClipCount, NoteCount, OMSAccountGuid, OMSMobileModel, OMSScheduleTime, OMSServiceType, OMSSourceType, PageCount, ParagraphCount, PhishingStamp, PresentationFormat, QuarantineOriginalSender, RevisionNumber, RightsManagementLicense, Scale, Security, SlideCount, Subject, Template, Thumbnail, Title, WordCount, XCallId, XFaxNumberOfPages, XRequireProtectedPlayOnPhone, XSenderTelephoneNumber, XSharingBrowseUrl, XSharingCapabilities, XSharingConfigUrl, XSharingExendedCaps, XSharingFlavor, XSharingInstanceGuid, XSharingLocalType, XSharingProviderGuid, XSharingProviderName, XSharingProviderUrl, XSharingRemoteName, XSharingRemotePath, XSharingRemoteStoreUid, XSharingRemoteType, XSharingRemoteUid, XVoiceMessageAttachmentOrder, XVoiceMessageDuration, XVoiceMessageSenderName, Access, AccessControlListData, AccessLevel, Account, AdditionalRenEntryIds, AdditionalRenEntryIdsEx, AddressBookAuthorizedSenders, AddressBookContainerId, AddressBookDeliveryContentLength, AddressBookDisplayNamePrintable, AddressBookDisplayTypeExtended, AddressBookDistributionListExternalMemberCount, AddressBookDistributionListMemberCount, AddressBookDistributionListMemberSubmitAccepted, AddressBookDistributionListMemberSubmitRejected, AddressBookDistributionListRejectMessagesFromDLMembers, AddressBookEntryId, AddressBookExtensionAttribute1, AddressBookExtensionAttribute10, AddressBookExtensionAttribute11, AddressBookExtensionAttribute12, AddressBookExtensionAttribute13, AddressBookExtensionAttribute14, AddressBookExtensionAttribute15, AddressBookExtensionAttribute2, AddressBookExtensionAttribute3, AddressBookExtensionAttribute4, AddressBookExtensionAttribute5, AddressBookExtensionAttribute6, AddressBookExtensionAttribute7, AddressBookExtensionAttribute8, AddressBookExtensionAttribute9, AddressBookFolderPathname, AddressBookHierarchicalChildDepartments, AddressBookHierarchicalDepartmentMembers, AddressBookHierarchicalIsHierarchicalGroup, AddressBookHierarchicalParentDepartment, AddressBookHierarchicalRootDepartment, AddressBookHierarchicalShowInDepartments, AddressBookHomeMessageDatabase, AddressBookIsMaster, AddressBookIsMemberOfDistributionList, AddressBookManageDistributionList, AddressBookManager, AddressBookManagerDistinguishedName, AddressBookMember, AddressBookMessageId, AddressBookModerationEnabled, AddressBookNetworkAddress, AddressBookObjectDistinguishedName, AddressBookObjectGuid, AddressBookOrganizationalUnitRootDistinguishedName, AddressBookOwner, AddressBookOwnerBackLink, AddressBookParentEntryId, AddressBookPhoneticCompanyName, AddressBookPhoneticDepartmentName, AddressBookPhoneticDisplayName, AddressBookPhoneticGivenName, AddressBookPhoneticSurname, AddressBookProxyAddresses, AddressBookPublicDelegates, AddressBookReports, AddressBookRoomCapacity, AddressBookRoomContainers, AddressBookRoomDescription, AddressBookSenderHintTranslations, AddressBookSeniorityIndex, AddressBookTargetAddress, AddressBookUnauthorizedSenders, AddressBookX509Certificate, AddressType, AlternateRecipientAllowed, Anr, ArchiveDate, ArchivePeriod, ArchiveTag, Assistant, AssistantTelephoneNumber, Associated, AttachAdditionalInformation, AttachContentBase, AttachContentId, AttachContentLocation, AttachDataBinary, AttachDataObject, AttachEncoding, AttachExtension, AttachFilename, AttachFlags, AttachLongFilename, AttachLongPathname, AttachmentContactPhoto, AttachmentFlags, AttachmentHidden, AttachmentLinkId, AttachMethod, AttachMimeTag, AttachNumber, AttachPathname, AttachPayloadClass, AttachPayloadProviderGuidString, AttachRendering, AttachSize, AttachTag, AttachTransportName, AttributeHidden, AttributeReadOnly, AutoForwardComment, AutoForwarded, AutoResponseSuppress, Birthday, BlockStatus, Body, BodyContentId, BodyContentLocation, BodyHtml, Business2TelephoneNumber, Business2TelephoneNumbers, BusinessFaxNumber, BusinessHomePage, BusinessTelephoneNumber, CallbackTelephoneNumber, CallId, CarTelephoneNumber, CdoRecurrenceid, ChangeKey, ChangeNumber, ChildrensNames, ClientActions, ClientSubmitTime, CodePageId, Comment, CompanyMainTelephoneNumber, CompanyName, ComputerNetworkName, ConflictEntryId, ContainerClass, ContainerContents, ContainerFlags, ContainerHierarchy, ContentCount, ContentFilterSpamConfidenceLevel, ContentUnreadCount, ConversationId, ConversationIndex, ConversationIndexTracking, ConversationTopic, Country, CreationTime, CreatorEntryId, CreatorName, CustomerId, DamBackPatched, DamOriginalEntryId, DefaultPostMessageClass, DeferredActionMessageOriginalEntryId, DeferredDeliveryTime, DeferredSendNumber, DeferredSendTime, DeferredSendUnits, DelegatedByRule, DelegateFlags, DeleteAfterSubmit, DeletedCountTotal, DeletedOn, DeliverTime, DepartmentName, Depth, DisplayBcc, DisplayCc, DisplayName, DisplayNamePrefix, DisplayTo, DisplayType, DisplayTypeEx, EmailAddress, EndDate, EntryId, ExceptionEndTime, TagExceptionReplaceTime, ExceptionStartTime, ExchangeNTSecurityDescriptor, ExpiryNumber, ExpiryTime, ExpiryUnits, ExtendedFolderFlags, ExtendedRuleMessageActions, ExtendedRuleMessageCondition, ExtendedRuleSizeLimit, FaxNumberOfPages, FlagCompleteTime, FlagStatus, FlatUrlName, FolderAssociatedContents, FolderId, FolderFlags, FolderType, FollowupIcon, FreeBusyCountMonths, FreeBusyEntryIds, FreeBusyMessageEmailAddress, FreeBusyPublishEnd, FreeBusyPublishStart, FreeBusyRangeTimestamp, FtpSite, GatewayNeedsToRefresh, Gender, Generation, GivenName, GovernmentIdNumber, HasAttachments, HasDeferredActionMessages, HasNamedProperties, HasRules, HierarchyChangeNumber, HierRev, Hobbies, Home2TelephoneNumber, Home2TelephoneNumbers, HomeAddressCity, HomeAddressCountry, HomeAddressPostalCode, HomeAddressPostOfficeBox, HomeAddressStateOrProvince, HomeAddressStreet, HomeFaxNumber, HomeTelephoneNumber, TagHtml, ICalendarEndTime, ICalendarReminderNextTime, ICalendarStartTime, IconIndex, Importance, InConflict, InitialDetailsPane, Initials, InReplyToId, InstanceKey, InstanceNum, InstID, InternetCodepage, InternetMailOverrideFormat, InternetMessageId, InternetReferences, IpmAppointmentEntryId, IpmContactEntryId, IpmDraftsEntryId, IpmJournalEntryId, IpmNoteEntryId, IpmTaskEntryId, IsdnNumber, JunkAddRecipientsToSafeSendersList, JunkIncludeContacts, JunkPermanentlyDelete, JunkPhishingEnableLinks, JunkThreshold, Keyword, Language, LastModificationTime, LastModifierEntryId, LastModifierName, LastVerbExecuted, LastVerbExecutionTime, ListHelp, ListSubscribe, ListUnsubscribe, LocalCommitTime, LocalCommitTimeMax, LocaleId, Locality, TagLocation, MailboxOwnerEntryId, MailboxOwnerName, ManagerName, MappingSignature, MaximumSubmitMessageSize, MemberId, MemberName, MemberRights, MessageAttachments, MessageCcMe, MessageClass, MessageCodepage, MessageDeliveryTime, MessageEditorFormat, MessageFlags, MessageHandlingSystemCommonName, MessageLocaleId, MessageRecipientMe, MessageRecipients, MessageSize, MessageSizeExtended, MessageStatus, MessageSubmissionId, MessageToMe, Mid, MiddleName, MimeSkeleton, MobileTelephoneNumber, NativeBody, NextSendAcct, Nickname, NonDeliveryReportDiagCode, NonDeliveryReportReasonCode, NonDeliveryReportStatusCode, NonReceiptNotificationRequested, NormalizedSubject, ObjectType, OfficeLocation, OfflineAddressBookContainerGuid, OfflineAddressBookDistinguishedName, OfflineAddressBookMessageClass, OfflineAddressBookName, OfflineAddressBookSequence, OfflineAddressBookTruncatedProperties, OrdinalMost, OrganizationalIdNumber, OriginalAuthorEntryId, OriginalAuthorName, OriginalDeliveryTime, OriginalDisplayBcc, OriginalDisplayCc, OriginalDisplayTo, OriginalEntryId, OriginalMessageClass, OriginalMessageId, OriginalSenderAddressType, OriginalSenderEmailAddress, OriginalSenderEntryId, OriginalSenderName, OriginalSenderSearchKey, OriginalSensitivity, OriginalSentRepresentingAddressType, OriginalSentRepresentingEmailAddress, OriginalSentRepresentingEntryId, OriginalSentRepresentingName, OriginalSentRepresentingSearchKey, OriginalSubject, OriginalSubmitTime, OriginatorDeliveryReportRequested, OriginatorNonDeliveryReportRequested, OscSyncEnabled, OtherAddressCity, OtherAddressCountry, OtherAddressPostalCode, OtherAddressPostOfficeBox, OtherAddressStateOrProvince, OtherAddressStreet, OtherTelephoneNumber, OutOfOfficeState, OwnerAppointmentId, PagerTelephoneNumber, ParentEntryId, ParentFolderId, ParentKey, ParentSourceKey, PersonalHomePage, PolicyTag, PostalAddress, PostalCode, PostOfficeBox, PredecessorChangeList, PrimaryFaxNumber, PrimarySendAccount, PrimaryTelephoneNumber, Priority, Processed, Profession, ProhibitReceiveQuota, ProhibitSendQuota, PurportedSenderDomain, RadioTelephoneNumber, Read, ReadReceiptAddressType, ReadReceiptEmailAddress, ReadReceiptEntryId, ReadReceiptName, ReadReceiptRequested, ReadReceiptSearchKey, ReadReceiptSmtpAddress, ReceiptTime, ReceivedByAddressType, ReceivedByEmailAddress, ReceivedByEntryId, ReceivedByName, ReceivedBySearchKey, ReceivedBySmtpAddress, ReceivedRepresentingAddressType, ReceivedRepresentingEmailAddress, ReceivedRepresentingEntryId, ReceivedRepresentingName, ReceivedRepresentingSearchKey, ReceivedRepresentingSmtpAddress, RecipientDisplayName, RecipientEntryId, RecipientFlags, RecipientOrder, RecipientProposed, RecipientProposedEndTime, RecipientProposedStartTime, RecipientReassignmentProhibited, RecipientTrackStatus, RecipientTrackStatusTime, RecipientType, RecordKey, ReferredByName, RemindersOnlineEntryId, RemoteMessageTransferAgent, RenderingPosition, ReplyRecipientEntries, ReplyRecipientNames, ReplyRequested, ReplyTemplateId, ReplyTime, ReportDisposition, ReportDispositionMode, ReportEntryId, ReportingMessageTransferAgent, ReportName, ReportSearchKey, ReportTag, ReportText, ReportTime, ResolveMethod, ResponseRequested, Responsibility, RetentionDate, RetentionFlags, RetentionPeriod, Rights, RoamingDatatypes, RoamingDictionary, RoamingXmlStream, Rowid, RowType, RtfCompressed, RtfInSync, RuleActionNumber, RuleActions, RuleActionType, RuleCondition, RuleError, RuleFolderEntryId, RuleId, RuleIds, RuleLevel, RuleMessageLevel, RuleMessageName, RuleMessageProvider, RuleMessageProviderData, RuleMessageSequence, RuleMessageState, RuleMessageUserFlags, RuleName, RuleProvider, RuleProviderData, RuleSequence, RuleState, RuleUserFlags, RwRulesStream, ScheduleInfoAppointmentTombstone, ScheduleInfoAutoAcceptAppointments, ScheduleInfoDelegateEntryIds, ScheduleInfoDelegateNames, ScheduleInfoDelegateNamesW, ScheduleInfoDelegatorWantsCopy, ScheduleInfoDelegatorWantsInfo, ScheduleInfoDisallowOverlappingAppts, ScheduleInfoDisallowRecurringAppts, ScheduleInfoDontMailDelegates, ScheduleInfoFreeBusy, ScheduleInfoFreeBusyAway, ScheduleInfoFreeBusyBusy, ScheduleInfoFreeBusyMerged, ScheduleInfoFreeBusyTentative, ScheduleInfoMonthsAway, ScheduleInfoMonthsBusy, ScheduleInfoMonthsMerged, ScheduleInfoMonthsTentative, ScheduleInfoResourceType, SchedulePlusFreeBusyEntryId, ScriptData, SearchFolderDefinition, SearchFolderEfpFlags, SearchFolderExpiration, SearchFolderId, SearchFolderLastUsed, SearchFolderRecreateInfo, SearchFolderStorageType, SearchFolderTag, SearchFolderTemplateId, SearchKey, SecurityDescriptorAsXml, Selectable, SenderAddressType, SenderEmailAddress, SenderEntryId, SenderIdStatus, SenderName, SenderSearchKey, SenderSmtpAddress, SenderTelephoneNumber, SendInternetEncoding, SendRichInfo, Sensitivity, SentMailSvrEID, SentRepresentingAddressType, SentRepresentingEmailAddress, SentRepresentingEntryId, SentRepresentingFlags, SentRepresentingName, SentRepresentingSearchKey, SentRepresentingSmtpAddress, SmtpAddress, SortLocaleId, SourceKey, SpokenName, SpouseName, StartDate, StartDateEtc, StateOrProvince, StoreEntryId, StoreState, StoreSupportMask, StreetAddress, Subfolders, TagSubject, SubjectPrefix, SupplementaryInfo, Surname, SwappedToDoData, SwappedToDoStore, TargetEntryId, TelecommunicationsDeviceForDeafTelephoneNumber, TelexNumber, TemplateData, Templateid, TextAttachmentCharset, ThumbnailPhoto, TagTitle, TnefCorrelationKey, ToDoItemFlags, TransmittableDisplayName, TransportMessageHeaders, TrustSender, UserCertificate, UserEntryId, UserX509Certificate, ViewDescriptorBinary, ViewDescriptorName, ViewDescriptorStrings, ViewDescriptorVersion, VoiceMessageAttachmentOrder, VoiceMessageDuration, VoiceMessageSenderName, WeddingAnniversary, WlinkAddressBookEID, WlinkAddressBookStoreEID, WlinkCalendarColor, WlinkClientID, WlinkEntryId, WlinkFlags, WlinkFolderType, WlinkGroupClsid, WlinkGroupHeaderID, WlinkGroupName, WlinkOrdinal, WlinkRecordKey, WlinkROGroupType, WlinkSaveStamp, WlinkSection, WlinkStoreEntryId, WlinkType, Abstract, ActiveUserEntryid, AddrbookForLocalSiteEntryid, AddressBookDisplayName, ArrivalTime, AssocMessageSize, AssocMessageSizeExtended, AssocMsgWAttachCount, AttachOnAssocMsgCount, AttachOnNormalMsgCount, AutoAddNewSubs, BilateralInfo, CachedColumnCount, CategCount, ChangeAdvisor, ChangeNotificationGuid, Collector, ContactCount, ContentSearchKey, ContentsSynchronizer, DeletedAssocMessageSizeExtended, DeletedAssocMsgCount, DeletedFolderCount, DeletedMessageSizeExtended, DeletedMsgCount, DeletedNormalMessageSizeExtended, DesignInProgress, DisableFullFidelity, DisableWinsock, DlReportFlags, EformsForLocaleEntryid, EformsLocaleId, EformsRegistryEntryid, EmsAbAccessCategory, EmsAbActivationSchedule, EmsAbActivationStyle, EmsAbAddressEntryDisplayTable, EmsAbAddressEntryDisplayTableMsdos, EmsAbAddressSyntax, EmsAbAddressType, EmsAbAdmd, EmsAbAdminDescription, EmsAbAdminDisplayName, EmsAbAdminExtensionDll, EmsAbAliasedObjectName, EmsAbAliasedObjectNameO, EmsAbAltRecipient, EmsAbAltRecipientBl, EmsAbAltRecipientBlO, EmsAbAltRecipientO, EmsAbAncestorId, EmsAbAnonymousAccess, EmsAbAnonymousAccount, EmsAbAssocNtAccount, EmsAbAssocProtocolCfgNntp, EmsAbAssocProtocolCfgNntpO, EmsAbAssocRemoteDxa, EmsAbAssocRemoteDxaO, EmsAbAssociationLifetime, EmsAbAttributeCertificate, EmsAbAuthOrigBl, EmsAbAuthOrigBlO, EmsAbAuthenticationToUse, EmsAbAuthorityRevocationList, EmsAbAuthorizedDomain, EmsAbAuthorizedPassword, EmsAbAuthorizedPasswordConfirm, EmsAbAuthorizedUser, EmsAbAutoreply, EmsAbAutoreplyMessage, EmsAbAutoreplySubject, EmsAbAvailableAuthorizationPackages, EmsAbAvailableDistributions, EmsAbBridgeheadServers, EmsAbBridgeheadServersO, EmsAbBusinessCategory, EmsAbBusinessRoles, EmsAbCaCertificate, EmsAbCanCreatePf, EmsAbCanCreatePfBl, EmsAbCanCreatePfBlO, EmsAbCanCreatePfDl, EmsAbCanCreatePfDlBl, EmsAbCanCreatePfDlBlO, EmsAbCanCreatePfDlO, EmsAbCanCreatePfO, EmsAbCanNotCreatePf, EmsAbCanNotCreatePfBl, EmsAbCanNotCreatePfBlO, EmsAbCanNotCreatePfDl, EmsAbCanNotCreatePfDlBl, EmsAbCanNotCreatePfDlBlO, EmsAbCanNotCreatePfDlO, EmsAbCanNotCreatePfO, EmsAbCanPreserveDns, EmsAbCertificateChainV3, EmsAbCertificateRevocationList, EmsAbCertificateRevocationListV1, EmsAbCertificateRevocationListV3, EmsAbCharacterSet, EmsAbCharacterSetList, EmsAbChildRdns, EmsAbClientAccessEnabled, EmsAbClockAlertOffset, EmsAbClockAlertRepair, EmsAbClockWarningOffset, EmsAbClockWarningRepair, EmsAbCompromisedKeyList, EmsAbComputerName, EmsAbConnectedDomains, EmsAbConnectionListFilter, EmsAbConnectionListFilterType, EmsAbConnectionType, EmsAbContainerInfo, EmsAbContentType, EmsAbControlMsgFolderId, EmsAbControlMsgRules, EmsAbCost, EmsAbCountryName, EmsAbCrossCertificateCrl, EmsAbCrossCertificatePair, EmsAbDefaultMessageFormat, EmsAbDelegateUser, EmsAbDelivEits, EmsAbDelivExtContTypes, EmsAbDeliverAndRedirect, EmsAbDeliveryMechanism, EmsAbDeltaRevocationList, EmsAbDescription, EmsAbDestinationIndicator, EmsAbDiagnosticRegKey, EmsAbDisableDeferredCommit, EmsAbDisabledGatewayProxy, EmsAbDisplayNameOverride, EmsAbDisplayNameSuffix, EmsAbDlMemRejectPermsBl, EmsAbDlMemRejectPermsBlO, EmsAbDlMemberRule, EmsAbDmdName, EmsAbDoOabVersion, EmsAbDomainDefAltRecip, EmsAbDomainDefAltRecipO, EmsAbDomainName, EmsAbDsaSignature, EmsAbDxaAdminCopy, EmsAbDxaAdminForward, EmsAbDxaAdminUpdate, EmsAbDxaAppendReqcn, EmsAbDxaConfContainerList, EmsAbDxaConfContainerListO, EmsAbDxaConfReqTime, EmsAbDxaConfSeq, EmsAbDxaConfSeqUsn, EmsAbDxaExchangeOptions, EmsAbDxaExportNow, EmsAbDxaFlags, EmsAbDxaImpSeq, EmsAbDxaImpSeqTime, EmsAbDxaImpSeqUsn, EmsAbDxaImportNow, EmsAbDxaInTemplateMap, EmsAbDxaLocalAdmin, EmsAbDxaLocalAdminO, EmsAbDxaLoggingLevel, EmsAbDxaNativeAddressType, EmsAbDxaOutTemplateMap, EmsAbDxaPassword, EmsAbDxaPrevExchangeOptions, EmsAbDxaPrevExportNativeOnly, EmsAbDxaPrevInExchangeSensitivity, EmsAbDxaPrevRemoteEntries, EmsAbDxaPrevRemoteEntriesO, EmsAbDxaPrevReplicationSensitivity, EmsAbDxaPrevTemplateOptions, EmsAbDxaPrevTypes, EmsAbDxaRecipientCp, EmsAbDxaRemoteClient, EmsAbDxaRemoteClientO, EmsAbDxaReqSeq, EmsAbDxaReqSeqTime, EmsAbDxaReqSeqUsn, EmsAbDxaReqname, EmsAbDxaSvrSeq, EmsAbDxaSvrSeqTime, EmsAbDxaSvrSeqUsn, EmsAbDxaTask, EmsAbDxaTemplateOptions, EmsAbDxaTemplateTimestamp, EmsAbDxaTypes, EmsAbDxaUnconfContainerList, EmsAbDxaUnconfContainerListO, EmsAbEmployeeNumber, EmsAbEmployeeType, EmsAbEnableCompatibility, EmsAbEnabled, EmsAbEnabledAuthorizationPackages, EmsAbEnabledProtocolCfg, EmsAbEnabledProtocols, EmsAbEncapsulationMethod, EmsAbEncrypt, EmsAbEncryptAlgListNa, EmsAbEncryptAlgListOther, EmsAbEncryptAlgSelectedNa, EmsAbEncryptAlgSelectedOther, EmsAbExpandDlsLocally, EmsAbExpirationTime, EmsAbExportContainers, EmsAbExportContainersO, EmsAbExportCustomRecipients, EmsAbExtendedCharsAllowed, EmsAbExtensionData, EmsAbExtensionName, EmsAbExtensionNameInherited, EmsAbFacsimileTelephoneNumber, EmsAbFileVersion, EmsAbFilterLocalAddresses, EmsAbFoldersContainer, EmsAbFoldersContainerO, EmsAbFormData, EmsAbForwardingAddress, EmsAbGarbageCollPeriod, EmsAbGatewayLocalCred, EmsAbGatewayLocalDesig, EmsAbGatewayProxy, EmsAbGatewayRoutingTree, EmsAbGenerationQualifier, EmsAbGroupByAttr1, EmsAbGroupByAttr2, EmsAbGroupByAttr3, EmsAbGroupByAttr4, EmsAbGroupByAttrValueDn, EmsAbGroupByAttrValueDnO, EmsAbGroupByAttrValueStr, EmsAbGwartLastModified, EmsAbHasFullReplicaNcs, EmsAbHasFullReplicaNcsO, EmsAbHasMasterNcs, EmsAbHasMasterNcsO, EmsAbHelpData16, EmsAbHelpData32, EmsAbHelpFileName, EmsAbHeuristics, EmsAbHideDlMembership, EmsAbHideFromAddressBook, EmsAbHierarchyPath, EmsAbHomeMdbBl, EmsAbHomeMdbBlO, EmsAbHomeMta, EmsAbHomeMtaO, EmsAbHomePublicServer, EmsAbHomePublicServerO, EmsAbHouseIdentifier, EmsAbHttpPubAbAttributes, EmsAbHttpPubGal, EmsAbHttpPubGalLimit, EmsAbHttpPubPf, EmsAbHttpServers, EmsAbImportContainer, EmsAbImportContainerO, EmsAbImportSensitivity, EmsAbImportedFrom, EmsAbInboundAcceptAll, EmsAbInboundDn, EmsAbInboundDnO, EmsAbInboundHost, EmsAbInboundNewsfeed, EmsAbInboundNewsfeedType, EmsAbInboundSites, EmsAbInboundSitesO, EmsAbIncomingMsgSizeLimit, EmsAbIncomingPassword, EmsAbInsadmin, EmsAbInsadminO, EmsAbInstanceType, EmsAbInternationalIsdnNumber, EmsAbInvocationId, EmsAbIsDeleted, EmsAbIsSingleValued, EmsAbKccStatus, EmsAbKmServer, EmsAbKmServerO, EmsAbKnowledgeInformation, EmsAbLabeleduri, EmsAbLanguage, EmsAbLanguageIso639, EmsAbLdapDisplayName, EmsAbLdapSearchCfg, EmsAbLineWrap, EmsAbLinkId, EmsAbListPublicFolders, EmsAbLocalBridgeHead, EmsAbLocalBridgeHeadAddress, EmsAbLocalInitialTurn, EmsAbLocalScope, EmsAbLocalScopeO, EmsAbLogFilename, EmsAbLogRolloverInterval, EmsAbMailDrop, EmsAbMaintainAutoreplyHistory, EmsAbMapiDisplayType, EmsAbMapiId, EmsAbMaximumObjectId, EmsAbMdbBackoffInterval, EmsAbMdbMsgTimeOutPeriod, EmsAbMdbOverQuotaLimit, EmsAbMdbStorageQuota, EmsAbMdbUnreadLimit, EmsAbMdbUseDefaults, EmsAbMessageTrackingEnabled, EmsAbMimeTypes, EmsAbModerated, EmsAbModerator, EmsAbMonitorClock, EmsAbMonitorServers, EmsAbMonitorServices, EmsAbMonitoredConfigurations, EmsAbMonitoredConfigurationsO, EmsAbMonitoredServers, EmsAbMonitoredServersO, EmsAbMonitoredServices, EmsAbMonitoringAlertDelay, EmsAbMonitoringAlertUnits, EmsAbMonitoringAvailabilityStyle, EmsAbMonitoringAvailabilityWindow, EmsAbMonitoringCachedViaMail, EmsAbMonitoringCachedViaMailO, EmsAbMonitoringCachedViaRpc, EmsAbMonitoringCachedViaRpcO, EmsAbMonitoringEscalationProcedure, EmsAbMonitoringHotsitePollInterval, EmsAbMonitoringHotsitePollUnits, EmsAbMonitoringMailUpdateInterval, EmsAbMonitoringMailUpdateUnits, EmsAbMonitoringNormalPollInterval, EmsAbMonitoringNormalPollUnits, EmsAbMonitoringRecipients, EmsAbMonitoringRecipientsNdr, EmsAbMonitoringRecipientsNdrO, EmsAbMonitoringRecipientsO, EmsAbMonitoringRpcUpdateInterval, EmsAbMonitoringRpcUpdateUnits, EmsAbMonitoringWarningDelay, EmsAbMonitoringWarningUnits, EmsAbMtaLocalCred, EmsAbMtaLocalDesig, EmsAbNAddress, EmsAbNAddressType, EmsAbNewsfeedType, EmsAbNewsgroup, EmsAbNewsgroupList, EmsAbNntpCharacterSet, EmsAbNntpContentFormat, EmsAbNntpDistributions, EmsAbNntpDistributionsFlag, EmsAbNntpNewsfeeds, EmsAbNntpNewsfeedsO, EmsAbNtMachineName, EmsAbNtSecurityDescriptor, EmsAbNumOfOpenRetries, EmsAbNumOfTransferRetries, EmsAbObjViewContainers, EmsAbObjViewContainersO, EmsAbObjectClassCategory, EmsAbObjectOid, EmsAbObjectVersion, EmsAbOffLineAbContainers, EmsAbOffLineAbContainersO, EmsAbOffLineAbSchedule, EmsAbOffLineAbServer, EmsAbOffLineAbServerO, EmsAbOffLineAbStyle, EmsAbOidType, EmsAbOmObjectClass, EmsAbOmSyntax, EmsAbOofReplyToOriginator, EmsAbOpenRetryInterval, EmsAbOrganizationName, EmsAbOrganizationalUnitName, EmsAbOriginalDisplayTable, EmsAbOriginalDisplayTableMsdos, EmsAbOtherRecips, EmsAbOutboundHost, EmsAbOutboundHostType, EmsAbOutboundNewsfeed, EmsAbOutboundSites, EmsAbOutboundSitesO, EmsAbOutgoingMsgSizeLimit, EmsAbOverrideNntpContentFormat, EmsAbOwaServer, EmsAbPSelector, EmsAbPSelectorInbound, EmsAbPerMsgDialogDisplayTable, EmsAbPerRecipDialogDisplayTable, EmsAbPeriodRepSyncTimes, EmsAbPeriodReplStagger, EmsAbPersonalTitle, EmsAbPfContacts, EmsAbPfContactsO, EmsAbPopCharacterSet, EmsAbPopContentFormat, EmsAbPortNumber, EmsAbPostalAddress, EmsAbPreferredDeliveryMethod, EmsAbPreserveInternetContent, EmsAbPrmd, EmsAbPromoExpiration, EmsAbProtocolSettings, EmsAbProxyGenerationEnabled, EmsAbProxyGeneratorDll, EmsAbPublicDelegatesBl, EmsAbPublicDelegatesBlO, EmsAbQuotaNotificationSchedule, EmsAbQuotaNotificationStyle, EmsAbRangeLower, EmsAbRangeUpper, EmsAbRasAccount, EmsAbRasCallbackNumber, EmsAbRasPassword, EmsAbRasPhoneNumber, EmsAbRasPhonebookEntryName, EmsAbRasRemoteSrvrName, EmsAbReferralList, EmsAbRegisteredAddress, EmsAbRemoteBridgeHead, EmsAbRemoteBridgeHeadAddress, EmsAbRemoteOutBhServer, EmsAbRemoteOutBhServerO, EmsAbRemoteSite, EmsAbRemoteSiteO, EmsAbReplicatedObjectVersion, EmsAbReplicationMailMsgSize, EmsAbReplicationSensitivity, EmsAbReplicationStagger, EmsAbReportToOriginator, EmsAbReportToOwner, EmsAbReqSeq, EmsAbRequireSsl, EmsAbResponsibleLocalDxa, EmsAbResponsibleLocalDxaO, EmsAbReturnExactMsgSize, EmsAbRidServer, EmsAbRidServerO, EmsAbRoleOccupant, EmsAbRoleOccupantO, EmsAbRootNewsgroupsFolderId, EmsAbRoutingList, EmsAbRtsCheckpointSize, EmsAbRtsRecoveryTimeout, EmsAbRtsWindowSize, EmsAbRunsOn, EmsAbRunsOnO, EmsAbSSelector, EmsAbSSelectorInbound, EmsAbSchemaFlags, EmsAbSchemaVersion, EmsAbSearchFlags, EmsAbSearchGuide, EmsAbSecurityPolicy, EmsAbSecurityProtocol, EmsAbSeeAlso, EmsAbSeeAlsoO, EmsAbSendEmailMessage, EmsAbSendTnef, EmsAbSerialNumber, EmsAbServer, EmsAbServiceActionFirst, EmsAbServiceActionOther, EmsAbServiceActionSecond, EmsAbServiceRestartDelay, EmsAbServiceRestartMessage, EmsAbSessionDisconnectTimer, EmsAbSiteAffinity, EmsAbSiteFolderGuid, EmsAbSiteFolderServer, EmsAbSiteFolderServerO, EmsAbSiteProxySpace, EmsAbSmimeAlgListNa, EmsAbSmimeAlgListOther, EmsAbSmimeAlgSelectedNa, EmsAbSmimeAlgSelectedOther, EmsAbSpaceLastComputed, EmsAbStreetAddress, EmsAbSubRefs, EmsAbSubRefsO, EmsAbSubSite, EmsAbSubmissionContLength, EmsAbSupportSmimeSignatures, EmsAbSupportedAlgorithms, EmsAbSupportedApplicationContext, EmsAbSupportingStack, EmsAbSupportingStackBl, EmsAbSupportingStackBlO, EmsAbSupportingStackO, EmsAbTSelector, EmsAbTSelectorInbound, EmsAbTargetMtas, EmsAbTelephoneNumber, EmsAbTelephonePersonalPager, EmsAbTeletexTerminalIdentifier, EmsAbTempAssocThreshold, EmsAbTombstoneLifetime, EmsAbTrackingLogPathName, EmsAbTransRetryMins, EmsAbTransTimeoutMins, EmsAbTransferRetryInterval, EmsAbTransferTimeoutNonUrgent, EmsAbTransferTimeoutNormal, EmsAbTransferTimeoutUrgent, EmsAbTranslationTableUsed, EmsAbTransportExpeditedData, EmsAbTrustLevel, EmsAbTurnRequestThreshold, EmsAbTwoWayAlternateFacility, EmsAbType, EmsAbUnauthOrigBl, EmsAbUnauthOrigBlO, EmsAbUseServerValues, EmsAbUseSiteValues, EmsAbUsenetSiteName, EmsAbUserPassword, EmsAbUsnChanged, EmsAbUsnCreated, EmsAbUsnDsaLastObjRemoved, EmsAbUsnIntersite, EmsAbUsnLastObjRem, EmsAbUsnSource, EmsAbViewContainer1, EmsAbViewContainer2, EmsAbViewContainer3, EmsAbViewDefinition, EmsAbViewFlags, EmsAbViewSite, EmsAbVoiceMailFlags, EmsAbVoiceMailGreetings, EmsAbVoiceMailPassword, EmsAbVoiceMailRecordedName, EmsAbVoiceMailRecordingLength, EmsAbVoiceMailSpeed, EmsAbVoiceMailSystemGuid, EmsAbVoiceMailUserId, EmsAbVoiceMailVolume, EmsAbWwwHomePage, EmsAbX121Address, EmsAbX25CallUserDataIncoming, EmsAbX25CallUserDataOutgoing, EmsAbX25FacilitiesDataIncoming, EmsAbX25FacilitiesDataOutgoing, EmsAbX25LeasedLinePort, EmsAbX25LeasedOrSwitched, EmsAbX25RemoteMtaPhone, EmsAbX400AttachmentType, EmsAbX400SelectorSyntax, EmsAbX500AccessControlList, EmsAbX500Nc, EmsAbX500Rdn, EmsAbXmitTimeoutNonUrgent, EmsAbXmitTimeoutNormal, EmsAbXmitTimeoutUrgent, EventsRootFolderEntryid, ExcessStorageUsed, ExtendedAclData, FastTransfer, FavoritesDefaultName, FolderChildCount, FolderDesignFlags, FolderPathname, ForeignId, ForeignReportId, ForeignSubjectId, FreeBusyForLocalSiteEntryid, GwAdminOperations, GwMtsinEntryid, GwMtsoutEntryid, HasModeratorRules, HierarchyServer, HierarchySynchronizer, ImapInternalDate, InTransit, InboundNewsfeedDn, InternetCharset, InternetNewsgroupName, IpmDafEntryid, IpmFavoritesEntryid, IpmPublicFoldersEntryid, IsNewsgroup, IsNewsgroupAnchor, LastAccessTime, LastFullBackup, LastLogoffTime, LastLogonTime, LongtermEntryidFromTable, MessageProcessed, MessageSiteName, MoveToFolderEntryid, MoveToStoreEntryid, MsgBodyId, MtsSubjectId, NewSubsGetAutoAdd, NewsfeedInfo, NewsgroupComponent, NewsgroupRootFolderEntryid, NntpArticleFolderEntryid, NntpControlFolderEntryid, NonIpmSubtreeEntryid, NormalMessageSize, NormalMessageSizeExtended, NormalMsgWAttachCount, NtUserName, OfflineAddrbookEntryid, OfflineFlags, OfflineMessageEntryid, OldestDeletedOn, OriginatorAddr, OriginatorAddrtype, OriginatorEntryid, OriginatorName, OstEncryption, OutboundNewsfeedDn, OverallAgeLimit, OverallMsgAgeLimit, OwaUrl, OwnerCount, P1Content, P1ContentType, PreventMsgCreate, Preview, PreviewUnread, ProfileAbFilesPath, ProfileAddrInfo, ProfileAllpubComment, ProfileAllpubDisplayName, ProfileBindingOrder, ProfileConfigFlags, ProfileConnectFlags, ProfileFavfldComment, ProfileFavfldDisplayName, ProfileHomeServer, ProfileHomeServerAddrs, ProfileHomeServerDn, ProfileMailbox, ProfileMaxRestrict, ProfileMoab, ProfileMoabGuid, ProfileMoabSeq, ProfileOfflineInfo, ProfileOfflineStorePath, ProfileOpenFlags, ProfileOptionsData, ProfileSecureMailbox, ProfileServer, ProfileServerDn, ProfileTransportFlags, ProfileType, ProfileUiState, ProfileUnresolvedName, ProfileUnresolvedServer, ProfileUser, ProfileVersion, PstEncryption, PstPath, PstPwSzOld, PstRememberPw, PublicFolderEntryid, PublishInAddressBook, RecipientNumber, RecipientOnAssocMsgCount, RecipientOnNormalMsgCount, ReplicaList, ReplicaServer, ReplicaVersion, ReplicationAlwaysInterval, ReplicationMessagePriority, ReplicationMsgSize, ReplicationSchedule, ReplicationStyle, ReplyRecipientSmtpProxies, ReportDestinationEntryid, ReportDestinationName, RestrictionCount, RetentionAgeLimit, RuleTriggerHistory, RulesData, RulesTable, ScheduleFolderEntryid, SecureInSite, SecureOrigination, StorageLimitInformation, StorageQuotaLimit, StoreOffline, StoreSlowlink, SubjectTraceInfo, SvrGeneratingQuotaMsg, SynchronizeFlags, SysConfigFolderEntryid, TestLineSpeed, TraceInfo, TransferEnabled, UserName, X400EnvelopeType, AbDefaultDir, AbDefaultPab, AbProviderId, AbProviders, AbSearchPath, AbSearchPathUpdate, AlternateRecipient, AssocContentCount, AttachmentX400Parameters, AuthorizingUsers, BodyCrc, CommonViewsEntryid, ContactAddrtypes, ContactDefaultAddressIndex, ContactEmailAddresses, ContactEntryids, ContactVersion, ContainerModifyVersion, ContentConfidentialityAlgorithmId, ContentCorrelator, ContentIdentifier, ContentIntegrityCheck, ContentLength, ContentReturnRequested, ContentsSortOrder, ControlFlags, ControlId, ControlStructure, ControlType, ConversationKey, ConversionEits, ConversionProhibited, ConversionWithLossProhibited, ConvertedEits, Correlate, CorrelateMtsid, CreateTemplates, CreationVersion, ExCurrentVersion, DefCreateDl, DefCreateMailuser, DefaultProfile, DefaultStore, DefaultViewEntryid, Delegation, DeliveryPoint, Deltax, Deltay, DetailsTable, DiscVal, DiscardReason, DiscloseRecipients, DisclosureOfRecipients, DiscreteValues, DlExpansionHistory, DlExpansionProhibited, ExplicitConversion, FilteringHooks, FinderEntryid, FormCategory, FormCategorySub, FormClsid, FormContactName, FormDesignerGuid, FormDesignerName, FormHidden, FormHostMap, FormMessageBehavior, FormVersion, HeaderFolderEntryid, Icon, IdentityDisplay, IdentityEntryid, IdentitySearchKey, ImplicitConversionProhibited, IncompleteCopy, InternetApproved, InternetArticleNumber, InternetControl, InternetDistribution, InternetFollowupTo, InternetLines, InternetNewsgroups, InternetNntpPath, InternetOrganization, InternetPrecedence, IpmId, IpmOutboxEntryid, IpmOutboxSearchKey, IpmReturnRequested, IpmSentmailEntryid, IpmSentmailSearchKey, IpmSubtreeEntryid, IpmSubtreeSearchKey, IpmWastebasketEntryid, IpmWastebasketSearchKey, Languages, LatestDeliveryTime, MailPermission, MdbProvider, MessageDeliveryId, MessageDownloadTime, MessageSecurityLabel, MessageToken, MiniIcon, ModifyVersion, NewsgroupName, NntpXref, NonReceiptReason, ObsoletedIpms, OriginCheck, OriginalAuthorAddrtype, OriginalAuthorEmailAddress, OriginalAuthorSearchKey, OriginalDisplayName, OriginalEits, OriginalSearchKey, OriginallyIntendedRecipAddrtype, OriginallyIntendedRecipEmailAddress, OriginallyIntendedRecipEntryid, OriginallyIntendedRecipientName, OriginatingMtaCertificate, OriginatorAndDlExpansionHistory, OriginatorCertificate, OriginatorRequestedAlternateRecipient, OriginatorReturnAddress, OwnStoreEntryid, ParentDisplay, PhysicalDeliveryBureauFaxDelivery, PhysicalDeliveryMode, PhysicalDeliveryReportRequest, PhysicalForwardingAddress, PhysicalForwardingAddressRequested, PhysicalForwardingProhibited, PhysicalRenditionAttributes, PostFolderEntries, PostFolderNames, PostReplyDenied, PostReplyFolderEntries, PostReplyFolderNames, Preprocess, PrimaryCapability, ProfileName, ProofOfDelivery, ProofOfDeliveryRequested, ProofOfSubmission, ProofOfSubmissionRequested, ProviderDisplay, ProviderDllName, ProviderOrdinal, ProviderSubmitTime, ProviderUid, ReceiveFolderSettings, RecipientCertificate, RecipientNumberForAdvice, RecipientStatus, RedirectionHistory, RegisteredMailType, RelatedIpms, RemoteProgress, RemoteProgressText, RemoteValidateOk, ReportingDlName, ReportingMtaCertificate, RequestedDeliveryMethod, ResourceFlags, ResourceMethods, ResourcePath, ResourceType, ReturnedIpm, RtfSyncBodyCount, RtfSyncBodyCrc, RtfSyncBodyTag, RtfSyncPrefixCount, RtfSyncTrailingCount, Search, ExSecurity, SentmailEntryid, ServiceDeleteFiles, ServiceDllName, ServiceEntryName, ServiceExtraUids, ServiceName, ServiceSupportFiles, ServiceUid, Services, SpoolerStatus, Status, StatusCode, StatusString, StoreProviders, StoreRecordKey, SubjectIpm, SubmitFlags, Supersedes, TransportKey, TransportProviders, TransportStatus, TypeOfMtsUser, ValidFolderMask, ViewsEntryid, X400ContentType, X400DeferredDeliveryCancel, Xpos, Ypos

        :return: The name of this MapiKnownPropertyDescriptor.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str):
        """
        Known property name.  See all known properties here: https://apireference.aspose.com/email/net/aspose.email.mapi/knownpropertylist/fields/index  Possible values: Mileage, ObjectUri, GDataContactVersion, GDataPhotoVersion, AddressBookProviderArrayType, AddressBookProviderEmailList, AddressCountryCode, AgingDontAgeMe, AllAttendeesString, AllowExternalCheck, AnniversaryEventEntryId, AppointmentAuxiliaryFlags, AppointmentColor, AppointmentCounterProposal, AppointmentDuration, AppointmentEndDate, AppointmentEndTime, AppointmentEndWhole, AppointmentLastSequence, AppointmentMessageClass, AppointmentNotAllowPropose, AppointmentProposalNumber, AppointmentProposedDuration, AppointmentProposedEndWhole, AppointmentProposedStartWhole, AppointmentRecur, AppointmentReplyName, AppointmentReplyTime, AppointmentSequence, AppointmentSequenceTime, AppointmentStartDate, AppointmentStartTime, AppointmentStartWhole, AppointmentStateFlags, AppointmentSubType, AppointmentTimeZoneDefinitionEndDisplay, AppointmentTimeZoneDefinitionRecur, AppointmentTimeZoneDefinitionStartDisplay, AppointmentUnsendableRecipients, AppointmentUpdateTime, AttendeeCriticalChange, AutoFillLocation, AutoLog, AutoProcessState, AutoStartCheck, Billing, BirthdayEventEntryId, BirthdayLocal, BusinessCardCardPicture, BusinessCardDisplayDefinition, BusyStatus, CalendarType, Categories, CcAttendeesString, ChangeHighlight, Classification, ClassificationDescription, ClassificationGuid, ClassificationKeep, Classified, CleanGlobalObjectId, ClientIntent, ClipEnd, ClipStart, CollaborateDoc, CommonEnd, CommonStart, Companies, ConferencingCheck, ConferencingType, ContactCharacterSet, ContactItemData, ContactLinkedGlobalAddressListEntryId, ContactLinkEntry, ContactLinkGlobalAddressListLinkId, ContactLinkGlobalAddressListLinkState, ContactLinkLinkRejectHistory, ContactLinkName, ContactLinkSearchKey, ContactLinkSMTPAddressCache, Contacts, ContactUserField1, ContactUserField2, ContactUserField3, ContactUserField4, ConversationActionLastAppliedTime, ConversationActionMaxDeliveryTime, ConversationActionMoveFolderEid, ConversationActionMoveStoreEid, ConversationActionVersion, ConversationProcessed, CurrentVersion, CurrentVersionName, DayInterval, DayOfMonth, DelegateMail, Department, Directory, DistributionListChecksum, DistributionListMembers, DistributionListName, DistributionListOneOffMembers, DistributionListStream, Email1AddressType, Email1DisplayName, Email1EmailAddress, Email1OriginalDisplayName, Email1OriginalEntryId, Email2AddressType, Email2DisplayName, Email2EmailAddress, Email2OriginalDisplayName, Email2OriginalEntryId, Email3AddressType, Email3DisplayName, Email3EmailAddress, Email3OriginalDisplayName, Email3OriginalEntryId, EndRecurrenceDate, EndRecurrenceTime, ExceptionReplaceTime, Fax1AddressType, Fax1EmailAddress, Fax1OriginalDisplayName, Fax1OriginalEntryId, Fax2AddressType, Fax2EmailAddress, Fax2OriginalDisplayName, Fax2OriginalEntryId, Fax3AddressType, Fax3EmailAddress, Fax3OriginalDisplayName, Fax3OriginalEntryId, FExceptionalAttendees, FExceptionalBody, FileUnder, FileUnderId, FileUnderList, FInvited, FlagRequest, FlagString, ForwardInstance, ForwardNotificationRecipients, FOthersAppointment, FreeBusyLocation, GlobalObjectId, HasPicture, HomeAddress, HomeAddressCountryCode, Html, ICalendarDayOfWeekMask, InboundICalStream, InfoPathFormName, InstantMessagingAddress, IntendedBusyStatus, InternetAccountName, InternetAccountStamp, IsContactLinked, IsException, IsRecurring, IsSilent, LinkedTaskItems, Location, LogDocumentPosted, LogDocumentPrinted, LogDocumentRouted, LogDocumentSaved, LogDuration, LogEnd, LogFlags, LogStart, LogType, LogTypeDesc, MeetingType, MeetingWorkspaceUrl, MonthInterval, MonthOfYear, MonthOfYearMask, NetShowUrl, NoEndDateFlag, NonSendableBcc, NonSendableCc, NonSendableTo, NonSendBccTrackStatus, NonSendCcTrackStatus, NonSendToTrackStatus, NoteColor, NoteHeight, NoteWidth, NoteX, NoteY, Occurrences, OldLocation, OldRecurrenceType, OldWhenEndWhole, OldWhenStartWhole, OnlinePassword, OptionalAttendees, OrganizerAlias, OriginalStoreEntryId, OtherAddress, OtherAddressCountryCode, OwnerCriticalChange, OwnerName, PendingStateForSiteMailboxDocument, PercentComplete, PostalAddressId, PostRssChannel, PostRssChannelLink, PostRssItemGuid, PostRssItemHash, PostRssItemLink, PostRssItemXml, PostRssSubscription, Private, PromptSendUpdate, RecurrenceDuration, RecurrencePattern, RecurrenceType, Recurring, ReferenceEntryId, ReminderDelta, ReminderFileParameter, ReminderOverride, ReminderPlaySound, ReminderSet, ReminderSignalTime, ReminderTime, ReminderTimeDate, ReminderTimeTime, ReminderType, RemoteStatus, RequiredAttendees, ResourceAttendees, ResponseStatus, ServerProcessed, ServerProcessingActions, SharingAnonymity, SharingBindingEntryId, SharingBrowseUrl, SharingCapabilities, SharingConfigurationUrl, SharingDataRangeEnd, SharingDataRangeStart, SharingDetail, SharingExtensionXml, SharingFilter, SharingFlags, SharingFlavor, SharingFolderEntryId, SharingIndexEntryId, SharingInitiatorEntryId, SharingInitiatorName, SharingInitiatorSmtp, SharingInstanceGuid, SharingLastAutoSyncTime, SharingLastSyncTime, SharingLocalComment, SharingLocalLastModificationTime, SharingLocalName, SharingLocalPath, SharingLocalStoreUid, SharingLocalType, SharingLocalUid, SharingOriginalMessageEntryId, SharingParentBindingEntryId, SharingParticipants, SharingPermissions, SharingProviderExtension, SharingProviderGuid, SharingProviderName, SharingProviderUrl, SharingRangeEnd, SharingRangeStart, SharingReciprocation, SharingRemoteByteSize, SharingRemoteComment, SharingRemoteCrc, SharingRemoteLastModificationTime, SharingRemoteMessageCount, SharingRemoteName, SharingRemotePass, SharingRemotePath, SharingRemoteStoreUid, SharingRemoteType, SharingRemoteUid, SharingRemoteUser, SharingRemoteVersion, SharingResponseTime, SharingResponseType, SharingRoamLog, SharingStart, SharingStatus, SharingStop, SharingSyncFlags, SharingSyncInterval, SharingTimeToLive, SharingTimeToLiveAuto, SharingWorkingHoursDays, SharingWorkingHoursEnd, SharingWorkingHoursStart, SharingWorkingHoursTimeZone, SideEffects, SingleBodyICal, SmartNoAttach, SpamOriginalFolder, StartRecurrenceDate, StartRecurrenceTime, TaskAcceptanceState, TaskAccepted, TaskActualEffort, TaskAssigner, TaskAssigners, TaskComplete, TaskCustomFlags, TaskDateCompleted, TaskDeadOccurrence, TaskDueDate, TaskEstimatedEffort, TaskFCreator, TaskFFixOffline, TaskFRecurring, TaskGlobalId, TaskHistory, TaskLastDelegate, TaskLastUpdate, TaskLastUser, TaskMode, TaskMultipleRecipients, TaskNoCompute, TaskOrdinal, TaskOwner, TaskOwnership, TaskRecurrence, TaskResetReminder, TaskRole, TaskStartDate, TaskState, TaskStatus, TaskStatusOnComplete, TaskUpdates, TaskVersion, TeamTask, TimeZone, TimeZoneDescription, TimeZoneStruct, ToAttendeesString, ToDoOrdinalDate, ToDoSubOrdinal, ToDoTitle, UseTnef, ValidFlagStringProof, VerbResponse, VerbStream, WeddingAnniversaryLocal, WeekInterval, Where, WorkAddress, WorkAddressCity, WorkAddressCountry, WorkAddressCountryCode, WorkAddressPostalCode, WorkAddressPostOfficeBox, WorkAddressState, WorkAddressStreet, YearInterval, YomiCompanyName, YomiFirstName, YomiLastName, AcceptLanguage, ApplicationName, AttachmentMacContentType, AttachmentMacInfo, AudioNotes, Author, AutomaticSpeechRecognitionData, ByteCount, CalendarAttendeeRole, CalendarBusystatus, CalendarContact, CalendarContactUrl, CalendarCreated, CalendarDescriptionUrl, CalendarDuration, CalendarExceptionDate, CalendarExceptionRule, CalendarGeoLatitude, CalendarGeoLongitude, CalendarInstanceType, CalendarIsOrganizer, CalendarLastModified, CalendarLocationUrl, CalendarMeetingStatus, CalendarMethod, CalendarProductId, CalendarRecurrenceIdRange, CalendarReminderOffset, CalendarResources, CalendarRsvp, CalendarSequence, CalendarTimeZone, CalendarTimeZoneId, CalendarTransparent, CalendarUid, CalendarVersion, Category, CharacterCount, Comments, Company, ContentBase, ContentClass, ContentType, CreateDateTimeReadOnly, CrossReference, DavId, DavIsCollection, DavIsStructuredDocument, DavParentName, DavUid, DocumentParts, EditTime, ExchangeIntendedBusyStatus, ExchangeJunkEmailMoveStamp, ExchangeModifyExceptionStructure, ExchangeNoModifyExceptions, ExchangePatternEnd, ExchangePatternStart, ExchangeReminderInterval, ExchDatabaseSchema, ExchDataExpectedContentClass, ExchDataSchemaCollectionReference, ExtractedAddresses, ExtractedContacts, ExtractedEmails, ExtractedMeetings, ExtractedPhones, ExtractedTasks, ExtractedUrls, From, HeadingPairs, HiddenCount, HttpmailCalendar, HttpmailHtmlDescription, HttpmailSendMessage, ICalendarRecurrenceDate, ICalendarRecurrenceRule, InternetSubject, Keywords, LastAuthor, LastPrinted, LastSaveDateTime, LineCount, LinksDirty, LocationUrl, Manager, MultimediaClipCount, NoteCount, OMSAccountGuid, OMSMobileModel, OMSScheduleTime, OMSServiceType, OMSSourceType, PageCount, ParagraphCount, PhishingStamp, PresentationFormat, QuarantineOriginalSender, RevisionNumber, RightsManagementLicense, Scale, Security, SlideCount, Subject, Template, Thumbnail, Title, WordCount, XCallId, XFaxNumberOfPages, XRequireProtectedPlayOnPhone, XSenderTelephoneNumber, XSharingBrowseUrl, XSharingCapabilities, XSharingConfigUrl, XSharingExendedCaps, XSharingFlavor, XSharingInstanceGuid, XSharingLocalType, XSharingProviderGuid, XSharingProviderName, XSharingProviderUrl, XSharingRemoteName, XSharingRemotePath, XSharingRemoteStoreUid, XSharingRemoteType, XSharingRemoteUid, XVoiceMessageAttachmentOrder, XVoiceMessageDuration, XVoiceMessageSenderName, Access, AccessControlListData, AccessLevel, Account, AdditionalRenEntryIds, AdditionalRenEntryIdsEx, AddressBookAuthorizedSenders, AddressBookContainerId, AddressBookDeliveryContentLength, AddressBookDisplayNamePrintable, AddressBookDisplayTypeExtended, AddressBookDistributionListExternalMemberCount, AddressBookDistributionListMemberCount, AddressBookDistributionListMemberSubmitAccepted, AddressBookDistributionListMemberSubmitRejected, AddressBookDistributionListRejectMessagesFromDLMembers, AddressBookEntryId, AddressBookExtensionAttribute1, AddressBookExtensionAttribute10, AddressBookExtensionAttribute11, AddressBookExtensionAttribute12, AddressBookExtensionAttribute13, AddressBookExtensionAttribute14, AddressBookExtensionAttribute15, AddressBookExtensionAttribute2, AddressBookExtensionAttribute3, AddressBookExtensionAttribute4, AddressBookExtensionAttribute5, AddressBookExtensionAttribute6, AddressBookExtensionAttribute7, AddressBookExtensionAttribute8, AddressBookExtensionAttribute9, AddressBookFolderPathname, AddressBookHierarchicalChildDepartments, AddressBookHierarchicalDepartmentMembers, AddressBookHierarchicalIsHierarchicalGroup, AddressBookHierarchicalParentDepartment, AddressBookHierarchicalRootDepartment, AddressBookHierarchicalShowInDepartments, AddressBookHomeMessageDatabase, AddressBookIsMaster, AddressBookIsMemberOfDistributionList, AddressBookManageDistributionList, AddressBookManager, AddressBookManagerDistinguishedName, AddressBookMember, AddressBookMessageId, AddressBookModerationEnabled, AddressBookNetworkAddress, AddressBookObjectDistinguishedName, AddressBookObjectGuid, AddressBookOrganizationalUnitRootDistinguishedName, AddressBookOwner, AddressBookOwnerBackLink, AddressBookParentEntryId, AddressBookPhoneticCompanyName, AddressBookPhoneticDepartmentName, AddressBookPhoneticDisplayName, AddressBookPhoneticGivenName, AddressBookPhoneticSurname, AddressBookProxyAddresses, AddressBookPublicDelegates, AddressBookReports, AddressBookRoomCapacity, AddressBookRoomContainers, AddressBookRoomDescription, AddressBookSenderHintTranslations, AddressBookSeniorityIndex, AddressBookTargetAddress, AddressBookUnauthorizedSenders, AddressBookX509Certificate, AddressType, AlternateRecipientAllowed, Anr, ArchiveDate, ArchivePeriod, ArchiveTag, Assistant, AssistantTelephoneNumber, Associated, AttachAdditionalInformation, AttachContentBase, AttachContentId, AttachContentLocation, AttachDataBinary, AttachDataObject, AttachEncoding, AttachExtension, AttachFilename, AttachFlags, AttachLongFilename, AttachLongPathname, AttachmentContactPhoto, AttachmentFlags, AttachmentHidden, AttachmentLinkId, AttachMethod, AttachMimeTag, AttachNumber, AttachPathname, AttachPayloadClass, AttachPayloadProviderGuidString, AttachRendering, AttachSize, AttachTag, AttachTransportName, AttributeHidden, AttributeReadOnly, AutoForwardComment, AutoForwarded, AutoResponseSuppress, Birthday, BlockStatus, Body, BodyContentId, BodyContentLocation, BodyHtml, Business2TelephoneNumber, Business2TelephoneNumbers, BusinessFaxNumber, BusinessHomePage, BusinessTelephoneNumber, CallbackTelephoneNumber, CallId, CarTelephoneNumber, CdoRecurrenceid, ChangeKey, ChangeNumber, ChildrensNames, ClientActions, ClientSubmitTime, CodePageId, Comment, CompanyMainTelephoneNumber, CompanyName, ComputerNetworkName, ConflictEntryId, ContainerClass, ContainerContents, ContainerFlags, ContainerHierarchy, ContentCount, ContentFilterSpamConfidenceLevel, ContentUnreadCount, ConversationId, ConversationIndex, ConversationIndexTracking, ConversationTopic, Country, CreationTime, CreatorEntryId, CreatorName, CustomerId, DamBackPatched, DamOriginalEntryId, DefaultPostMessageClass, DeferredActionMessageOriginalEntryId, DeferredDeliveryTime, DeferredSendNumber, DeferredSendTime, DeferredSendUnits, DelegatedByRule, DelegateFlags, DeleteAfterSubmit, DeletedCountTotal, DeletedOn, DeliverTime, DepartmentName, Depth, DisplayBcc, DisplayCc, DisplayName, DisplayNamePrefix, DisplayTo, DisplayType, DisplayTypeEx, EmailAddress, EndDate, EntryId, ExceptionEndTime, TagExceptionReplaceTime, ExceptionStartTime, ExchangeNTSecurityDescriptor, ExpiryNumber, ExpiryTime, ExpiryUnits, ExtendedFolderFlags, ExtendedRuleMessageActions, ExtendedRuleMessageCondition, ExtendedRuleSizeLimit, FaxNumberOfPages, FlagCompleteTime, FlagStatus, FlatUrlName, FolderAssociatedContents, FolderId, FolderFlags, FolderType, FollowupIcon, FreeBusyCountMonths, FreeBusyEntryIds, FreeBusyMessageEmailAddress, FreeBusyPublishEnd, FreeBusyPublishStart, FreeBusyRangeTimestamp, FtpSite, GatewayNeedsToRefresh, Gender, Generation, GivenName, GovernmentIdNumber, HasAttachments, HasDeferredActionMessages, HasNamedProperties, HasRules, HierarchyChangeNumber, HierRev, Hobbies, Home2TelephoneNumber, Home2TelephoneNumbers, HomeAddressCity, HomeAddressCountry, HomeAddressPostalCode, HomeAddressPostOfficeBox, HomeAddressStateOrProvince, HomeAddressStreet, HomeFaxNumber, HomeTelephoneNumber, TagHtml, ICalendarEndTime, ICalendarReminderNextTime, ICalendarStartTime, IconIndex, Importance, InConflict, InitialDetailsPane, Initials, InReplyToId, InstanceKey, InstanceNum, InstID, InternetCodepage, InternetMailOverrideFormat, InternetMessageId, InternetReferences, IpmAppointmentEntryId, IpmContactEntryId, IpmDraftsEntryId, IpmJournalEntryId, IpmNoteEntryId, IpmTaskEntryId, IsdnNumber, JunkAddRecipientsToSafeSendersList, JunkIncludeContacts, JunkPermanentlyDelete, JunkPhishingEnableLinks, JunkThreshold, Keyword, Language, LastModificationTime, LastModifierEntryId, LastModifierName, LastVerbExecuted, LastVerbExecutionTime, ListHelp, ListSubscribe, ListUnsubscribe, LocalCommitTime, LocalCommitTimeMax, LocaleId, Locality, TagLocation, MailboxOwnerEntryId, MailboxOwnerName, ManagerName, MappingSignature, MaximumSubmitMessageSize, MemberId, MemberName, MemberRights, MessageAttachments, MessageCcMe, MessageClass, MessageCodepage, MessageDeliveryTime, MessageEditorFormat, MessageFlags, MessageHandlingSystemCommonName, MessageLocaleId, MessageRecipientMe, MessageRecipients, MessageSize, MessageSizeExtended, MessageStatus, MessageSubmissionId, MessageToMe, Mid, MiddleName, MimeSkeleton, MobileTelephoneNumber, NativeBody, NextSendAcct, Nickname, NonDeliveryReportDiagCode, NonDeliveryReportReasonCode, NonDeliveryReportStatusCode, NonReceiptNotificationRequested, NormalizedSubject, ObjectType, OfficeLocation, OfflineAddressBookContainerGuid, OfflineAddressBookDistinguishedName, OfflineAddressBookMessageClass, OfflineAddressBookName, OfflineAddressBookSequence, OfflineAddressBookTruncatedProperties, OrdinalMost, OrganizationalIdNumber, OriginalAuthorEntryId, OriginalAuthorName, OriginalDeliveryTime, OriginalDisplayBcc, OriginalDisplayCc, OriginalDisplayTo, OriginalEntryId, OriginalMessageClass, OriginalMessageId, OriginalSenderAddressType, OriginalSenderEmailAddress, OriginalSenderEntryId, OriginalSenderName, OriginalSenderSearchKey, OriginalSensitivity, OriginalSentRepresentingAddressType, OriginalSentRepresentingEmailAddress, OriginalSentRepresentingEntryId, OriginalSentRepresentingName, OriginalSentRepresentingSearchKey, OriginalSubject, OriginalSubmitTime, OriginatorDeliveryReportRequested, OriginatorNonDeliveryReportRequested, OscSyncEnabled, OtherAddressCity, OtherAddressCountry, OtherAddressPostalCode, OtherAddressPostOfficeBox, OtherAddressStateOrProvince, OtherAddressStreet, OtherTelephoneNumber, OutOfOfficeState, OwnerAppointmentId, PagerTelephoneNumber, ParentEntryId, ParentFolderId, ParentKey, ParentSourceKey, PersonalHomePage, PolicyTag, PostalAddress, PostalCode, PostOfficeBox, PredecessorChangeList, PrimaryFaxNumber, PrimarySendAccount, PrimaryTelephoneNumber, Priority, Processed, Profession, ProhibitReceiveQuota, ProhibitSendQuota, PurportedSenderDomain, RadioTelephoneNumber, Read, ReadReceiptAddressType, ReadReceiptEmailAddress, ReadReceiptEntryId, ReadReceiptName, ReadReceiptRequested, ReadReceiptSearchKey, ReadReceiptSmtpAddress, ReceiptTime, ReceivedByAddressType, ReceivedByEmailAddress, ReceivedByEntryId, ReceivedByName, ReceivedBySearchKey, ReceivedBySmtpAddress, ReceivedRepresentingAddressType, ReceivedRepresentingEmailAddress, ReceivedRepresentingEntryId, ReceivedRepresentingName, ReceivedRepresentingSearchKey, ReceivedRepresentingSmtpAddress, RecipientDisplayName, RecipientEntryId, RecipientFlags, RecipientOrder, RecipientProposed, RecipientProposedEndTime, RecipientProposedStartTime, RecipientReassignmentProhibited, RecipientTrackStatus, RecipientTrackStatusTime, RecipientType, RecordKey, ReferredByName, RemindersOnlineEntryId, RemoteMessageTransferAgent, RenderingPosition, ReplyRecipientEntries, ReplyRecipientNames, ReplyRequested, ReplyTemplateId, ReplyTime, ReportDisposition, ReportDispositionMode, ReportEntryId, ReportingMessageTransferAgent, ReportName, ReportSearchKey, ReportTag, ReportText, ReportTime, ResolveMethod, ResponseRequested, Responsibility, RetentionDate, RetentionFlags, RetentionPeriod, Rights, RoamingDatatypes, RoamingDictionary, RoamingXmlStream, Rowid, RowType, RtfCompressed, RtfInSync, RuleActionNumber, RuleActions, RuleActionType, RuleCondition, RuleError, RuleFolderEntryId, RuleId, RuleIds, RuleLevel, RuleMessageLevel, RuleMessageName, RuleMessageProvider, RuleMessageProviderData, RuleMessageSequence, RuleMessageState, RuleMessageUserFlags, RuleName, RuleProvider, RuleProviderData, RuleSequence, RuleState, RuleUserFlags, RwRulesStream, ScheduleInfoAppointmentTombstone, ScheduleInfoAutoAcceptAppointments, ScheduleInfoDelegateEntryIds, ScheduleInfoDelegateNames, ScheduleInfoDelegateNamesW, ScheduleInfoDelegatorWantsCopy, ScheduleInfoDelegatorWantsInfo, ScheduleInfoDisallowOverlappingAppts, ScheduleInfoDisallowRecurringAppts, ScheduleInfoDontMailDelegates, ScheduleInfoFreeBusy, ScheduleInfoFreeBusyAway, ScheduleInfoFreeBusyBusy, ScheduleInfoFreeBusyMerged, ScheduleInfoFreeBusyTentative, ScheduleInfoMonthsAway, ScheduleInfoMonthsBusy, ScheduleInfoMonthsMerged, ScheduleInfoMonthsTentative, ScheduleInfoResourceType, SchedulePlusFreeBusyEntryId, ScriptData, SearchFolderDefinition, SearchFolderEfpFlags, SearchFolderExpiration, SearchFolderId, SearchFolderLastUsed, SearchFolderRecreateInfo, SearchFolderStorageType, SearchFolderTag, SearchFolderTemplateId, SearchKey, SecurityDescriptorAsXml, Selectable, SenderAddressType, SenderEmailAddress, SenderEntryId, SenderIdStatus, SenderName, SenderSearchKey, SenderSmtpAddress, SenderTelephoneNumber, SendInternetEncoding, SendRichInfo, Sensitivity, SentMailSvrEID, SentRepresentingAddressType, SentRepresentingEmailAddress, SentRepresentingEntryId, SentRepresentingFlags, SentRepresentingName, SentRepresentingSearchKey, SentRepresentingSmtpAddress, SmtpAddress, SortLocaleId, SourceKey, SpokenName, SpouseName, StartDate, StartDateEtc, StateOrProvince, StoreEntryId, StoreState, StoreSupportMask, StreetAddress, Subfolders, TagSubject, SubjectPrefix, SupplementaryInfo, Surname, SwappedToDoData, SwappedToDoStore, TargetEntryId, TelecommunicationsDeviceForDeafTelephoneNumber, TelexNumber, TemplateData, Templateid, TextAttachmentCharset, ThumbnailPhoto, TagTitle, TnefCorrelationKey, ToDoItemFlags, TransmittableDisplayName, TransportMessageHeaders, TrustSender, UserCertificate, UserEntryId, UserX509Certificate, ViewDescriptorBinary, ViewDescriptorName, ViewDescriptorStrings, ViewDescriptorVersion, VoiceMessageAttachmentOrder, VoiceMessageDuration, VoiceMessageSenderName, WeddingAnniversary, WlinkAddressBookEID, WlinkAddressBookStoreEID, WlinkCalendarColor, WlinkClientID, WlinkEntryId, WlinkFlags, WlinkFolderType, WlinkGroupClsid, WlinkGroupHeaderID, WlinkGroupName, WlinkOrdinal, WlinkRecordKey, WlinkROGroupType, WlinkSaveStamp, WlinkSection, WlinkStoreEntryId, WlinkType, Abstract, ActiveUserEntryid, AddrbookForLocalSiteEntryid, AddressBookDisplayName, ArrivalTime, AssocMessageSize, AssocMessageSizeExtended, AssocMsgWAttachCount, AttachOnAssocMsgCount, AttachOnNormalMsgCount, AutoAddNewSubs, BilateralInfo, CachedColumnCount, CategCount, ChangeAdvisor, ChangeNotificationGuid, Collector, ContactCount, ContentSearchKey, ContentsSynchronizer, DeletedAssocMessageSizeExtended, DeletedAssocMsgCount, DeletedFolderCount, DeletedMessageSizeExtended, DeletedMsgCount, DeletedNormalMessageSizeExtended, DesignInProgress, DisableFullFidelity, DisableWinsock, DlReportFlags, EformsForLocaleEntryid, EformsLocaleId, EformsRegistryEntryid, EmsAbAccessCategory, EmsAbActivationSchedule, EmsAbActivationStyle, EmsAbAddressEntryDisplayTable, EmsAbAddressEntryDisplayTableMsdos, EmsAbAddressSyntax, EmsAbAddressType, EmsAbAdmd, EmsAbAdminDescription, EmsAbAdminDisplayName, EmsAbAdminExtensionDll, EmsAbAliasedObjectName, EmsAbAliasedObjectNameO, EmsAbAltRecipient, EmsAbAltRecipientBl, EmsAbAltRecipientBlO, EmsAbAltRecipientO, EmsAbAncestorId, EmsAbAnonymousAccess, EmsAbAnonymousAccount, EmsAbAssocNtAccount, EmsAbAssocProtocolCfgNntp, EmsAbAssocProtocolCfgNntpO, EmsAbAssocRemoteDxa, EmsAbAssocRemoteDxaO, EmsAbAssociationLifetime, EmsAbAttributeCertificate, EmsAbAuthOrigBl, EmsAbAuthOrigBlO, EmsAbAuthenticationToUse, EmsAbAuthorityRevocationList, EmsAbAuthorizedDomain, EmsAbAuthorizedPassword, EmsAbAuthorizedPasswordConfirm, EmsAbAuthorizedUser, EmsAbAutoreply, EmsAbAutoreplyMessage, EmsAbAutoreplySubject, EmsAbAvailableAuthorizationPackages, EmsAbAvailableDistributions, EmsAbBridgeheadServers, EmsAbBridgeheadServersO, EmsAbBusinessCategory, EmsAbBusinessRoles, EmsAbCaCertificate, EmsAbCanCreatePf, EmsAbCanCreatePfBl, EmsAbCanCreatePfBlO, EmsAbCanCreatePfDl, EmsAbCanCreatePfDlBl, EmsAbCanCreatePfDlBlO, EmsAbCanCreatePfDlO, EmsAbCanCreatePfO, EmsAbCanNotCreatePf, EmsAbCanNotCreatePfBl, EmsAbCanNotCreatePfBlO, EmsAbCanNotCreatePfDl, EmsAbCanNotCreatePfDlBl, EmsAbCanNotCreatePfDlBlO, EmsAbCanNotCreatePfDlO, EmsAbCanNotCreatePfO, EmsAbCanPreserveDns, EmsAbCertificateChainV3, EmsAbCertificateRevocationList, EmsAbCertificateRevocationListV1, EmsAbCertificateRevocationListV3, EmsAbCharacterSet, EmsAbCharacterSetList, EmsAbChildRdns, EmsAbClientAccessEnabled, EmsAbClockAlertOffset, EmsAbClockAlertRepair, EmsAbClockWarningOffset, EmsAbClockWarningRepair, EmsAbCompromisedKeyList, EmsAbComputerName, EmsAbConnectedDomains, EmsAbConnectionListFilter, EmsAbConnectionListFilterType, EmsAbConnectionType, EmsAbContainerInfo, EmsAbContentType, EmsAbControlMsgFolderId, EmsAbControlMsgRules, EmsAbCost, EmsAbCountryName, EmsAbCrossCertificateCrl, EmsAbCrossCertificatePair, EmsAbDefaultMessageFormat, EmsAbDelegateUser, EmsAbDelivEits, EmsAbDelivExtContTypes, EmsAbDeliverAndRedirect, EmsAbDeliveryMechanism, EmsAbDeltaRevocationList, EmsAbDescription, EmsAbDestinationIndicator, EmsAbDiagnosticRegKey, EmsAbDisableDeferredCommit, EmsAbDisabledGatewayProxy, EmsAbDisplayNameOverride, EmsAbDisplayNameSuffix, EmsAbDlMemRejectPermsBl, EmsAbDlMemRejectPermsBlO, EmsAbDlMemberRule, EmsAbDmdName, EmsAbDoOabVersion, EmsAbDomainDefAltRecip, EmsAbDomainDefAltRecipO, EmsAbDomainName, EmsAbDsaSignature, EmsAbDxaAdminCopy, EmsAbDxaAdminForward, EmsAbDxaAdminUpdate, EmsAbDxaAppendReqcn, EmsAbDxaConfContainerList, EmsAbDxaConfContainerListO, EmsAbDxaConfReqTime, EmsAbDxaConfSeq, EmsAbDxaConfSeqUsn, EmsAbDxaExchangeOptions, EmsAbDxaExportNow, EmsAbDxaFlags, EmsAbDxaImpSeq, EmsAbDxaImpSeqTime, EmsAbDxaImpSeqUsn, EmsAbDxaImportNow, EmsAbDxaInTemplateMap, EmsAbDxaLocalAdmin, EmsAbDxaLocalAdminO, EmsAbDxaLoggingLevel, EmsAbDxaNativeAddressType, EmsAbDxaOutTemplateMap, EmsAbDxaPassword, EmsAbDxaPrevExchangeOptions, EmsAbDxaPrevExportNativeOnly, EmsAbDxaPrevInExchangeSensitivity, EmsAbDxaPrevRemoteEntries, EmsAbDxaPrevRemoteEntriesO, EmsAbDxaPrevReplicationSensitivity, EmsAbDxaPrevTemplateOptions, EmsAbDxaPrevTypes, EmsAbDxaRecipientCp, EmsAbDxaRemoteClient, EmsAbDxaRemoteClientO, EmsAbDxaReqSeq, EmsAbDxaReqSeqTime, EmsAbDxaReqSeqUsn, EmsAbDxaReqname, EmsAbDxaSvrSeq, EmsAbDxaSvrSeqTime, EmsAbDxaSvrSeqUsn, EmsAbDxaTask, EmsAbDxaTemplateOptions, EmsAbDxaTemplateTimestamp, EmsAbDxaTypes, EmsAbDxaUnconfContainerList, EmsAbDxaUnconfContainerListO, EmsAbEmployeeNumber, EmsAbEmployeeType, EmsAbEnableCompatibility, EmsAbEnabled, EmsAbEnabledAuthorizationPackages, EmsAbEnabledProtocolCfg, EmsAbEnabledProtocols, EmsAbEncapsulationMethod, EmsAbEncrypt, EmsAbEncryptAlgListNa, EmsAbEncryptAlgListOther, EmsAbEncryptAlgSelectedNa, EmsAbEncryptAlgSelectedOther, EmsAbExpandDlsLocally, EmsAbExpirationTime, EmsAbExportContainers, EmsAbExportContainersO, EmsAbExportCustomRecipients, EmsAbExtendedCharsAllowed, EmsAbExtensionData, EmsAbExtensionName, EmsAbExtensionNameInherited, EmsAbFacsimileTelephoneNumber, EmsAbFileVersion, EmsAbFilterLocalAddresses, EmsAbFoldersContainer, EmsAbFoldersContainerO, EmsAbFormData, EmsAbForwardingAddress, EmsAbGarbageCollPeriod, EmsAbGatewayLocalCred, EmsAbGatewayLocalDesig, EmsAbGatewayProxy, EmsAbGatewayRoutingTree, EmsAbGenerationQualifier, EmsAbGroupByAttr1, EmsAbGroupByAttr2, EmsAbGroupByAttr3, EmsAbGroupByAttr4, EmsAbGroupByAttrValueDn, EmsAbGroupByAttrValueDnO, EmsAbGroupByAttrValueStr, EmsAbGwartLastModified, EmsAbHasFullReplicaNcs, EmsAbHasFullReplicaNcsO, EmsAbHasMasterNcs, EmsAbHasMasterNcsO, EmsAbHelpData16, EmsAbHelpData32, EmsAbHelpFileName, EmsAbHeuristics, EmsAbHideDlMembership, EmsAbHideFromAddressBook, EmsAbHierarchyPath, EmsAbHomeMdbBl, EmsAbHomeMdbBlO, EmsAbHomeMta, EmsAbHomeMtaO, EmsAbHomePublicServer, EmsAbHomePublicServerO, EmsAbHouseIdentifier, EmsAbHttpPubAbAttributes, EmsAbHttpPubGal, EmsAbHttpPubGalLimit, EmsAbHttpPubPf, EmsAbHttpServers, EmsAbImportContainer, EmsAbImportContainerO, EmsAbImportSensitivity, EmsAbImportedFrom, EmsAbInboundAcceptAll, EmsAbInboundDn, EmsAbInboundDnO, EmsAbInboundHost, EmsAbInboundNewsfeed, EmsAbInboundNewsfeedType, EmsAbInboundSites, EmsAbInboundSitesO, EmsAbIncomingMsgSizeLimit, EmsAbIncomingPassword, EmsAbInsadmin, EmsAbInsadminO, EmsAbInstanceType, EmsAbInternationalIsdnNumber, EmsAbInvocationId, EmsAbIsDeleted, EmsAbIsSingleValued, EmsAbKccStatus, EmsAbKmServer, EmsAbKmServerO, EmsAbKnowledgeInformation, EmsAbLabeleduri, EmsAbLanguage, EmsAbLanguageIso639, EmsAbLdapDisplayName, EmsAbLdapSearchCfg, EmsAbLineWrap, EmsAbLinkId, EmsAbListPublicFolders, EmsAbLocalBridgeHead, EmsAbLocalBridgeHeadAddress, EmsAbLocalInitialTurn, EmsAbLocalScope, EmsAbLocalScopeO, EmsAbLogFilename, EmsAbLogRolloverInterval, EmsAbMailDrop, EmsAbMaintainAutoreplyHistory, EmsAbMapiDisplayType, EmsAbMapiId, EmsAbMaximumObjectId, EmsAbMdbBackoffInterval, EmsAbMdbMsgTimeOutPeriod, EmsAbMdbOverQuotaLimit, EmsAbMdbStorageQuota, EmsAbMdbUnreadLimit, EmsAbMdbUseDefaults, EmsAbMessageTrackingEnabled, EmsAbMimeTypes, EmsAbModerated, EmsAbModerator, EmsAbMonitorClock, EmsAbMonitorServers, EmsAbMonitorServices, EmsAbMonitoredConfigurations, EmsAbMonitoredConfigurationsO, EmsAbMonitoredServers, EmsAbMonitoredServersO, EmsAbMonitoredServices, EmsAbMonitoringAlertDelay, EmsAbMonitoringAlertUnits, EmsAbMonitoringAvailabilityStyle, EmsAbMonitoringAvailabilityWindow, EmsAbMonitoringCachedViaMail, EmsAbMonitoringCachedViaMailO, EmsAbMonitoringCachedViaRpc, EmsAbMonitoringCachedViaRpcO, EmsAbMonitoringEscalationProcedure, EmsAbMonitoringHotsitePollInterval, EmsAbMonitoringHotsitePollUnits, EmsAbMonitoringMailUpdateInterval, EmsAbMonitoringMailUpdateUnits, EmsAbMonitoringNormalPollInterval, EmsAbMonitoringNormalPollUnits, EmsAbMonitoringRecipients, EmsAbMonitoringRecipientsNdr, EmsAbMonitoringRecipientsNdrO, EmsAbMonitoringRecipientsO, EmsAbMonitoringRpcUpdateInterval, EmsAbMonitoringRpcUpdateUnits, EmsAbMonitoringWarningDelay, EmsAbMonitoringWarningUnits, EmsAbMtaLocalCred, EmsAbMtaLocalDesig, EmsAbNAddress, EmsAbNAddressType, EmsAbNewsfeedType, EmsAbNewsgroup, EmsAbNewsgroupList, EmsAbNntpCharacterSet, EmsAbNntpContentFormat, EmsAbNntpDistributions, EmsAbNntpDistributionsFlag, EmsAbNntpNewsfeeds, EmsAbNntpNewsfeedsO, EmsAbNtMachineName, EmsAbNtSecurityDescriptor, EmsAbNumOfOpenRetries, EmsAbNumOfTransferRetries, EmsAbObjViewContainers, EmsAbObjViewContainersO, EmsAbObjectClassCategory, EmsAbObjectOid, EmsAbObjectVersion, EmsAbOffLineAbContainers, EmsAbOffLineAbContainersO, EmsAbOffLineAbSchedule, EmsAbOffLineAbServer, EmsAbOffLineAbServerO, EmsAbOffLineAbStyle, EmsAbOidType, EmsAbOmObjectClass, EmsAbOmSyntax, EmsAbOofReplyToOriginator, EmsAbOpenRetryInterval, EmsAbOrganizationName, EmsAbOrganizationalUnitName, EmsAbOriginalDisplayTable, EmsAbOriginalDisplayTableMsdos, EmsAbOtherRecips, EmsAbOutboundHost, EmsAbOutboundHostType, EmsAbOutboundNewsfeed, EmsAbOutboundSites, EmsAbOutboundSitesO, EmsAbOutgoingMsgSizeLimit, EmsAbOverrideNntpContentFormat, EmsAbOwaServer, EmsAbPSelector, EmsAbPSelectorInbound, EmsAbPerMsgDialogDisplayTable, EmsAbPerRecipDialogDisplayTable, EmsAbPeriodRepSyncTimes, EmsAbPeriodReplStagger, EmsAbPersonalTitle, EmsAbPfContacts, EmsAbPfContactsO, EmsAbPopCharacterSet, EmsAbPopContentFormat, EmsAbPortNumber, EmsAbPostalAddress, EmsAbPreferredDeliveryMethod, EmsAbPreserveInternetContent, EmsAbPrmd, EmsAbPromoExpiration, EmsAbProtocolSettings, EmsAbProxyGenerationEnabled, EmsAbProxyGeneratorDll, EmsAbPublicDelegatesBl, EmsAbPublicDelegatesBlO, EmsAbQuotaNotificationSchedule, EmsAbQuotaNotificationStyle, EmsAbRangeLower, EmsAbRangeUpper, EmsAbRasAccount, EmsAbRasCallbackNumber, EmsAbRasPassword, EmsAbRasPhoneNumber, EmsAbRasPhonebookEntryName, EmsAbRasRemoteSrvrName, EmsAbReferralList, EmsAbRegisteredAddress, EmsAbRemoteBridgeHead, EmsAbRemoteBridgeHeadAddress, EmsAbRemoteOutBhServer, EmsAbRemoteOutBhServerO, EmsAbRemoteSite, EmsAbRemoteSiteO, EmsAbReplicatedObjectVersion, EmsAbReplicationMailMsgSize, EmsAbReplicationSensitivity, EmsAbReplicationStagger, EmsAbReportToOriginator, EmsAbReportToOwner, EmsAbReqSeq, EmsAbRequireSsl, EmsAbResponsibleLocalDxa, EmsAbResponsibleLocalDxaO, EmsAbReturnExactMsgSize, EmsAbRidServer, EmsAbRidServerO, EmsAbRoleOccupant, EmsAbRoleOccupantO, EmsAbRootNewsgroupsFolderId, EmsAbRoutingList, EmsAbRtsCheckpointSize, EmsAbRtsRecoveryTimeout, EmsAbRtsWindowSize, EmsAbRunsOn, EmsAbRunsOnO, EmsAbSSelector, EmsAbSSelectorInbound, EmsAbSchemaFlags, EmsAbSchemaVersion, EmsAbSearchFlags, EmsAbSearchGuide, EmsAbSecurityPolicy, EmsAbSecurityProtocol, EmsAbSeeAlso, EmsAbSeeAlsoO, EmsAbSendEmailMessage, EmsAbSendTnef, EmsAbSerialNumber, EmsAbServer, EmsAbServiceActionFirst, EmsAbServiceActionOther, EmsAbServiceActionSecond, EmsAbServiceRestartDelay, EmsAbServiceRestartMessage, EmsAbSessionDisconnectTimer, EmsAbSiteAffinity, EmsAbSiteFolderGuid, EmsAbSiteFolderServer, EmsAbSiteFolderServerO, EmsAbSiteProxySpace, EmsAbSmimeAlgListNa, EmsAbSmimeAlgListOther, EmsAbSmimeAlgSelectedNa, EmsAbSmimeAlgSelectedOther, EmsAbSpaceLastComputed, EmsAbStreetAddress, EmsAbSubRefs, EmsAbSubRefsO, EmsAbSubSite, EmsAbSubmissionContLength, EmsAbSupportSmimeSignatures, EmsAbSupportedAlgorithms, EmsAbSupportedApplicationContext, EmsAbSupportingStack, EmsAbSupportingStackBl, EmsAbSupportingStackBlO, EmsAbSupportingStackO, EmsAbTSelector, EmsAbTSelectorInbound, EmsAbTargetMtas, EmsAbTelephoneNumber, EmsAbTelephonePersonalPager, EmsAbTeletexTerminalIdentifier, EmsAbTempAssocThreshold, EmsAbTombstoneLifetime, EmsAbTrackingLogPathName, EmsAbTransRetryMins, EmsAbTransTimeoutMins, EmsAbTransferRetryInterval, EmsAbTransferTimeoutNonUrgent, EmsAbTransferTimeoutNormal, EmsAbTransferTimeoutUrgent, EmsAbTranslationTableUsed, EmsAbTransportExpeditedData, EmsAbTrustLevel, EmsAbTurnRequestThreshold, EmsAbTwoWayAlternateFacility, EmsAbType, EmsAbUnauthOrigBl, EmsAbUnauthOrigBlO, EmsAbUseServerValues, EmsAbUseSiteValues, EmsAbUsenetSiteName, EmsAbUserPassword, EmsAbUsnChanged, EmsAbUsnCreated, EmsAbUsnDsaLastObjRemoved, EmsAbUsnIntersite, EmsAbUsnLastObjRem, EmsAbUsnSource, EmsAbViewContainer1, EmsAbViewContainer2, EmsAbViewContainer3, EmsAbViewDefinition, EmsAbViewFlags, EmsAbViewSite, EmsAbVoiceMailFlags, EmsAbVoiceMailGreetings, EmsAbVoiceMailPassword, EmsAbVoiceMailRecordedName, EmsAbVoiceMailRecordingLength, EmsAbVoiceMailSpeed, EmsAbVoiceMailSystemGuid, EmsAbVoiceMailUserId, EmsAbVoiceMailVolume, EmsAbWwwHomePage, EmsAbX121Address, EmsAbX25CallUserDataIncoming, EmsAbX25CallUserDataOutgoing, EmsAbX25FacilitiesDataIncoming, EmsAbX25FacilitiesDataOutgoing, EmsAbX25LeasedLinePort, EmsAbX25LeasedOrSwitched, EmsAbX25RemoteMtaPhone, EmsAbX400AttachmentType, EmsAbX400SelectorSyntax, EmsAbX500AccessControlList, EmsAbX500Nc, EmsAbX500Rdn, EmsAbXmitTimeoutNonUrgent, EmsAbXmitTimeoutNormal, EmsAbXmitTimeoutUrgent, EventsRootFolderEntryid, ExcessStorageUsed, ExtendedAclData, FastTransfer, FavoritesDefaultName, FolderChildCount, FolderDesignFlags, FolderPathname, ForeignId, ForeignReportId, ForeignSubjectId, FreeBusyForLocalSiteEntryid, GwAdminOperations, GwMtsinEntryid, GwMtsoutEntryid, HasModeratorRules, HierarchyServer, HierarchySynchronizer, ImapInternalDate, InTransit, InboundNewsfeedDn, InternetCharset, InternetNewsgroupName, IpmDafEntryid, IpmFavoritesEntryid, IpmPublicFoldersEntryid, IsNewsgroup, IsNewsgroupAnchor, LastAccessTime, LastFullBackup, LastLogoffTime, LastLogonTime, LongtermEntryidFromTable, MessageProcessed, MessageSiteName, MoveToFolderEntryid, MoveToStoreEntryid, MsgBodyId, MtsSubjectId, NewSubsGetAutoAdd, NewsfeedInfo, NewsgroupComponent, NewsgroupRootFolderEntryid, NntpArticleFolderEntryid, NntpControlFolderEntryid, NonIpmSubtreeEntryid, NormalMessageSize, NormalMessageSizeExtended, NormalMsgWAttachCount, NtUserName, OfflineAddrbookEntryid, OfflineFlags, OfflineMessageEntryid, OldestDeletedOn, OriginatorAddr, OriginatorAddrtype, OriginatorEntryid, OriginatorName, OstEncryption, OutboundNewsfeedDn, OverallAgeLimit, OverallMsgAgeLimit, OwaUrl, OwnerCount, P1Content, P1ContentType, PreventMsgCreate, Preview, PreviewUnread, ProfileAbFilesPath, ProfileAddrInfo, ProfileAllpubComment, ProfileAllpubDisplayName, ProfileBindingOrder, ProfileConfigFlags, ProfileConnectFlags, ProfileFavfldComment, ProfileFavfldDisplayName, ProfileHomeServer, ProfileHomeServerAddrs, ProfileHomeServerDn, ProfileMailbox, ProfileMaxRestrict, ProfileMoab, ProfileMoabGuid, ProfileMoabSeq, ProfileOfflineInfo, ProfileOfflineStorePath, ProfileOpenFlags, ProfileOptionsData, ProfileSecureMailbox, ProfileServer, ProfileServerDn, ProfileTransportFlags, ProfileType, ProfileUiState, ProfileUnresolvedName, ProfileUnresolvedServer, ProfileUser, ProfileVersion, PstEncryption, PstPath, PstPwSzOld, PstRememberPw, PublicFolderEntryid, PublishInAddressBook, RecipientNumber, RecipientOnAssocMsgCount, RecipientOnNormalMsgCount, ReplicaList, ReplicaServer, ReplicaVersion, ReplicationAlwaysInterval, ReplicationMessagePriority, ReplicationMsgSize, ReplicationSchedule, ReplicationStyle, ReplyRecipientSmtpProxies, ReportDestinationEntryid, ReportDestinationName, RestrictionCount, RetentionAgeLimit, RuleTriggerHistory, RulesData, RulesTable, ScheduleFolderEntryid, SecureInSite, SecureOrigination, StorageLimitInformation, StorageQuotaLimit, StoreOffline, StoreSlowlink, SubjectTraceInfo, SvrGeneratingQuotaMsg, SynchronizeFlags, SysConfigFolderEntryid, TestLineSpeed, TraceInfo, TransferEnabled, UserName, X400EnvelopeType, AbDefaultDir, AbDefaultPab, AbProviderId, AbProviders, AbSearchPath, AbSearchPathUpdate, AlternateRecipient, AssocContentCount, AttachmentX400Parameters, AuthorizingUsers, BodyCrc, CommonViewsEntryid, ContactAddrtypes, ContactDefaultAddressIndex, ContactEmailAddresses, ContactEntryids, ContactVersion, ContainerModifyVersion, ContentConfidentialityAlgorithmId, ContentCorrelator, ContentIdentifier, ContentIntegrityCheck, ContentLength, ContentReturnRequested, ContentsSortOrder, ControlFlags, ControlId, ControlStructure, ControlType, ConversationKey, ConversionEits, ConversionProhibited, ConversionWithLossProhibited, ConvertedEits, Correlate, CorrelateMtsid, CreateTemplates, CreationVersion, ExCurrentVersion, DefCreateDl, DefCreateMailuser, DefaultProfile, DefaultStore, DefaultViewEntryid, Delegation, DeliveryPoint, Deltax, Deltay, DetailsTable, DiscVal, DiscardReason, DiscloseRecipients, DisclosureOfRecipients, DiscreteValues, DlExpansionHistory, DlExpansionProhibited, ExplicitConversion, FilteringHooks, FinderEntryid, FormCategory, FormCategorySub, FormClsid, FormContactName, FormDesignerGuid, FormDesignerName, FormHidden, FormHostMap, FormMessageBehavior, FormVersion, HeaderFolderEntryid, Icon, IdentityDisplay, IdentityEntryid, IdentitySearchKey, ImplicitConversionProhibited, IncompleteCopy, InternetApproved, InternetArticleNumber, InternetControl, InternetDistribution, InternetFollowupTo, InternetLines, InternetNewsgroups, InternetNntpPath, InternetOrganization, InternetPrecedence, IpmId, IpmOutboxEntryid, IpmOutboxSearchKey, IpmReturnRequested, IpmSentmailEntryid, IpmSentmailSearchKey, IpmSubtreeEntryid, IpmSubtreeSearchKey, IpmWastebasketEntryid, IpmWastebasketSearchKey, Languages, LatestDeliveryTime, MailPermission, MdbProvider, MessageDeliveryId, MessageDownloadTime, MessageSecurityLabel, MessageToken, MiniIcon, ModifyVersion, NewsgroupName, NntpXref, NonReceiptReason, ObsoletedIpms, OriginCheck, OriginalAuthorAddrtype, OriginalAuthorEmailAddress, OriginalAuthorSearchKey, OriginalDisplayName, OriginalEits, OriginalSearchKey, OriginallyIntendedRecipAddrtype, OriginallyIntendedRecipEmailAddress, OriginallyIntendedRecipEntryid, OriginallyIntendedRecipientName, OriginatingMtaCertificate, OriginatorAndDlExpansionHistory, OriginatorCertificate, OriginatorRequestedAlternateRecipient, OriginatorReturnAddress, OwnStoreEntryid, ParentDisplay, PhysicalDeliveryBureauFaxDelivery, PhysicalDeliveryMode, PhysicalDeliveryReportRequest, PhysicalForwardingAddress, PhysicalForwardingAddressRequested, PhysicalForwardingProhibited, PhysicalRenditionAttributes, PostFolderEntries, PostFolderNames, PostReplyDenied, PostReplyFolderEntries, PostReplyFolderNames, Preprocess, PrimaryCapability, ProfileName, ProofOfDelivery, ProofOfDeliveryRequested, ProofOfSubmission, ProofOfSubmissionRequested, ProviderDisplay, ProviderDllName, ProviderOrdinal, ProviderSubmitTime, ProviderUid, ReceiveFolderSettings, RecipientCertificate, RecipientNumberForAdvice, RecipientStatus, RedirectionHistory, RegisteredMailType, RelatedIpms, RemoteProgress, RemoteProgressText, RemoteValidateOk, ReportingDlName, ReportingMtaCertificate, RequestedDeliveryMethod, ResourceFlags, ResourceMethods, ResourcePath, ResourceType, ReturnedIpm, RtfSyncBodyCount, RtfSyncBodyCrc, RtfSyncBodyTag, RtfSyncPrefixCount, RtfSyncTrailingCount, Search, ExSecurity, SentmailEntryid, ServiceDeleteFiles, ServiceDllName, ServiceEntryName, ServiceExtraUids, ServiceName, ServiceSupportFiles, ServiceUid, Services, SpoolerStatus, Status, StatusCode, StatusString, StoreProviders, StoreRecordKey, SubjectIpm, SubmitFlags, Supersedes, TransportKey, TransportProviders, TransportStatus, TypeOfMtsUser, ValidFolderMask, ViewsEntryid, X400ContentType, X400DeferredDeliveryCancel, Xpos, Ypos

        :param name: The name of this MapiKnownPropertyDescriptor.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        if name is not None and len(name) < 1:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")
        self._name = name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MapiKnownPropertyDescriptor):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
