# !!! DO NOT EDIT !!!  Generated by gen-phys-units.
#
#   Released under MIT license.
#   See file LICENSE for details.
#
# pylint: disable=too-many-lines
# pylint: disable=too-few-public-methods

METRIC = 0
IMPERIAL = 1

class UnitTableEntry:
    def __init__(self, fix_scale=None, rate_unit=None,
                 cumul_scale=None, cumul_unit=None,
                 name=None):
        self.fix_scale = fix_scale
        self.rate_unit = rate_unit
        self.cumul_scale = cumul_scale
        self.cumul_unit = cumul_unit
        self.name = name

class ConversionTableEntry:
    def __init__(self, unit=None, time_dependent=False,
                 calc=None, inverse=None):
        self.unit = unit
        self.time_dependent = time_dependent
        self.calc = calc
        self.inverse = inverse

class Units:

    # Preferred units for METRIC and IMPERIAL systems:
    preferred = [
        ['kW', 'kWh', 'kVA', 'kVAh', 'kvar', 'kvahr', 'kg', 'kg/s',
         'kWh/m^2', 'km/h', 'hPa', 'Ah', 'Vh', 'L/m', 'L', '°C',
         '°C·d'],
        ['kW', 'kWh', 'kVA', 'kVAh', 'kvar', 'kvahr', 'lbs', 'lbs/s',
         'kWh/m^2', 'mph', 'inHg', 'Ah', 'Vh', 'ft', '°F', '°F·d',
         'lbs·s', 'inHg·s', 'ft·s', 'gpm', 'gal']
    ]

    table = {
        'P': UnitTableEntry(fix_scale=1, rate_unit='W',
                            cumul_scale=1 / 3600000, cumul_unit='kWh',
                            name='Power'),
        'S': UnitTableEntry(fix_scale=1, rate_unit='VA',
                            cumul_scale=1 / 3600000, cumul_unit='kVAh',
                            name='Apparent Power'),
        'V': UnitTableEntry(fix_scale=1000, rate_unit='V',
                            cumul_scale=1 / 3600000, cumul_unit='Vh',
                            name='Voltage'),
        'I': UnitTableEntry(fix_scale=1000, rate_unit='A',
                            cumul_scale=1 / 3600000, cumul_unit='Ah',
                            name='Current'),
        'F': UnitTableEntry(fix_scale=1000, rate_unit='Hz',
                            cumul_scale=1 / 1000, cumul_unit='Hz·s',
                            name='Frequency'),
        'THD': UnitTableEntry(fix_scale=1000, rate_unit='%',
                              cumul_scale=1 / 1000, cumul_unit='%·s',
                              name='THD'),
        'T': UnitTableEntry(fix_scale=1000, rate_unit='°C',
                            cumul_scale=1 / 1000, cumul_unit='°C·s',
                            name='Temperature'),
        'Q': UnitTableEntry(fix_scale=1, rate_unit='g/s',
                            cumul_scale=1 / 1000, cumul_unit='kg',
                            name='Mass flow'),
        'v': UnitTableEntry(fix_scale=1000, rate_unit='m/s',
                            cumul_scale=1 / 1000, cumul_unit='m',
                            name='Speed'),
        '#': UnitTableEntry(fix_scale=1, rate_unit='',
                            cumul_scale=1, cumul_unit='s',
                            name='Whole number'),
        'R': UnitTableEntry(fix_scale=1, rate_unit='Ω',
                            cumul_scale=1, cumul_unit='Ω·s',
                            name='Resistance'),
        'Ee': UnitTableEntry(fix_scale=1, rate_unit='W/m^2',
                             cumul_scale=1 / 3600000, cumul_unit='kWh/m^2',
                             name='Irradiance'),
        'PQ': UnitTableEntry(fix_scale=1, rate_unit='var',
                             cumul_scale=1 / 3600000, cumul_unit='kvahr',
                             name='Reactive Power'),
        '$': UnitTableEntry(fix_scale=536870912, rate_unit='${currency}/s',
                            cumul_scale=1 / 536870912, cumul_unit='${currency}',
                            name='Monetary'),
        'a': UnitTableEntry(fix_scale=1000, rate_unit='°',
                            cumul_scale=1 / 1000, cumul_unit='°·s',
                            name='Angle'),
        'h': UnitTableEntry(fix_scale=1000, rate_unit='%',
                            cumul_scale=1 / 1000, cumul_unit='%·s',
                            name='Humidity'),
        'Qv': UnitTableEntry(fix_scale=1000000000, rate_unit='m^3/s',
                             cumul_scale=1 / 1000000, cumul_unit='L',
                             name='Volumetric flow'),
        'Pa': UnitTableEntry(fix_scale=1, rate_unit='Pa',
                             cumul_scale=1, cumul_unit='Pa·s',
                             name='Pressure'),
        'Qe': UnitTableEntry(fix_scale=1000, rate_unit='Ah',
                             cumul_scale=1 / 1000, cumul_unit='Ah·s',
                             name='Charge'),
        'Vdc': UnitTableEntry(fix_scale=1000, rate_unit='V',
                              cumul_scale=1 / 3600000, cumul_unit='Vh',
                              name='Voltage (mean)'),
        'Idc': UnitTableEntry(fix_scale=1000, rate_unit='A',
                              cumul_scale=1 / 3600000, cumul_unit='Ah',
                              name='Current (mean)'),
        'm': UnitTableEntry(fix_scale=1000, rate_unit='g',
                            cumul_scale=1 / 1000, cumul_unit='g·s',
                            name='Mass'),
        '#3': UnitTableEntry(fix_scale=1000, rate_unit='',
                             cumul_scale=1 / 1000, cumul_unit='s',
                             name='Number with 3 decimals'),
        'aq': UnitTableEntry(fix_scale=1000, rate_unit='',
                             cumul_scale=1 / 1000, cumul_unit='s',
                             name='Air Quality Index (0=good, 500=bad)'),
        '%': UnitTableEntry(fix_scale=1000, rate_unit='%',
                            cumul_scale=1 / 1000, cumul_unit='%·s',
                            name='Percentage'),
        'ppm': UnitTableEntry(fix_scale=1000, rate_unit='ppm',
                              cumul_scale=1 / 1000, cumul_unit='ppm·s',
                              name='Parts per million'),
        'd': UnitTableEntry(fix_scale=1, rate_unit='',
                            cumul_scale=1, cumul_unit='',
                            name='Discrete number'),
        'dT': UnitTableEntry(fix_scale=1000, rate_unit='°C',
                             cumul_scale=1 / 1000, cumul_unit='°C·s',
                             name='Temperature difference'),
    }

    alternates = {
        'A·s': [
            ConversionTableEntry(
                unit='Ah', time_dependent=False,
                calc=lambda x, t=None: (1/3600)*x,
                inverse=lambda x, t=None: 3600*x),
        ],
        'Pa': [
            ConversionTableEntry(
                unit='hPa', time_dependent=False,
                calc=lambda x, t=None: (1/100)*x,
                inverse=lambda x, t=None: 100*x),
            ConversionTableEntry(
                unit='bar', time_dependent=False,
                calc=lambda x, t=None: 1.0e-5*x,
                inverse=lambda x, t=None: 100000.0*x),
            ConversionTableEntry(
                unit='psi', time_dependent=False,
                calc=lambda x, t=None: 0.00014503773773*x,
                inverse=lambda x, t=None: 6894.7572931783*x),
            ConversionTableEntry(
                unit='inHg', time_dependent=False,
                calc=lambda x, t=None: 0.000295300999981497*x,
                inverse=lambda x, t=None: 3386.375258*x),
        ],
        'Pa·s': [
            ConversionTableEntry(
                unit='psi·s', time_dependent=False,
                calc=lambda x, t=None: 0.00014503773773*x,
                inverse=lambda x, t=None: 6894.7572931783*x),
            ConversionTableEntry(
                unit='inHg·s', time_dependent=False,
                calc=lambda x, t=None: 0.000295300999981497*x,
                inverse=lambda x, t=None: 3386.375258*x),
        ],
        'VA·s': [
            ConversionTableEntry(
                unit='VAh', time_dependent=False,
                calc=lambda x, t=None: (1/3600)*x,
                inverse=lambda x, t=None: 3600*x),
        ],
        'V·s': [
            ConversionTableEntry(
                unit='Vh', time_dependent=False,
                calc=lambda x, t=None: (1/3600)*x,
                inverse=lambda x, t=None: 3600*x),
        ],
        'W': [
            ConversionTableEntry(
                unit='hp', time_dependent=False,
                calc=lambda x, t=None: 0.00135962115516133*x,
                inverse=lambda x, t=None: 735.499*x),
            ConversionTableEntry(
                unit='Btu/h', time_dependent=False,
                calc=lambda x, t=None: 3.412141633*x,
                inverse=lambda x, t=None: 0.293071070183211*x),
        ],
        'W·s': [
            ConversionTableEntry(
                unit='Wh', time_dependent=False,
                calc=lambda x, t=None: (1/3600)*x,
                inverse=lambda x, t=None: 3600*x),
            ConversionTableEntry(
                unit='J', time_dependent=False,
                calc=lambda x, t=None: x,
                inverse=lambda x, t=None: x),
            ConversionTableEntry(
                unit='Btu', time_dependent=False,
                calc=lambda x, t=None: 0.000947817077749151*x,
                inverse=lambda x, t=None: 1055.0559*x),
        ],
        'W·s/m^2': [
            ConversionTableEntry(
                unit='Wh/m^2', time_dependent=False,
                calc=lambda x, t=None: (1/3600)*x,
                inverse=lambda x, t=None: 3600*x),
        ],
        'g': [
            ConversionTableEntry(
                unit='lbs', time_dependent=False,
                calc=lambda x, t=None: 0.00220462*x,
                inverse=lambda x, t=None: 453.59290943564*x),
            ConversionTableEntry(
                unit='T', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
        ],
        'g/s': [
            ConversionTableEntry(
                unit='lbs/s', time_dependent=False,
                calc=lambda x, t=None: 0.00220462*x,
                inverse=lambda x, t=None: 453.59290943564*x),
        ],
        'g·s': [
            ConversionTableEntry(
                unit='lbs·s', time_dependent=False,
                calc=lambda x, t=None: 0.00220462*x,
                inverse=lambda x, t=None: 453.59290943564*x),
        ],
        'm': [
            ConversionTableEntry(
                unit='yd', time_dependent=False,
                calc=lambda x, t=None: 1.09361329833771*x,
                inverse=lambda x, t=None: 0.9144*x),
            ConversionTableEntry(
                unit='ft', time_dependent=False,
                calc=lambda x, t=None: 3.28083989501312*x,
                inverse=lambda x, t=None: 0.3048*x),
            ConversionTableEntry(
                unit='mi', time_dependent=False,
                calc=lambda x, t=None: 0.000621371192237334*x,
                inverse=lambda x, t=None: 1609.344*x),
        ],
        'm/s': [
            ConversionTableEntry(
                unit='m/h', time_dependent=False,
                calc=lambda x, t=None: 3600*x,
                inverse=lambda x, t=None: (1/3600)*x),
            ConversionTableEntry(
                unit='mph', time_dependent=False,
                calc=lambda x, t=None: 2.2369362920544*x,
                inverse=lambda x, t=None: 0.44704*x),
        ],
        'm^3': [
            ConversionTableEntry(
                unit='L', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='gal', time_dependent=False,
                calc=lambda x, t=None: 264.200792602378*x,
                inverse=lambda x, t=None: 0.003785*x),
        ],
        'm^3/s': [
            ConversionTableEntry(
                unit='L/s', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='L/m', time_dependent=False,
                calc=lambda x, t=None: 60000.0*x,
                inverse=lambda x, t=None: 1.66666666666667e-5*x),
            ConversionTableEntry(
                unit='L/h', time_dependent=False,
                calc=lambda x, t=None: 3600000.0*x,
                inverse=lambda x, t=None: 2.77777777777778e-7*x),
            ConversionTableEntry(
                unit='gal/s', time_dependent=False,
                calc=lambda x, t=None: 264.200792602378*x,
                inverse=lambda x, t=None: 0.003785*x),
            ConversionTableEntry(
                unit='gpm', time_dependent=False,
                calc=lambda x, t=None: 15852.0475561427*x,
                inverse=lambda x, t=None: 6.30833333333334e-5*x),
            ConversionTableEntry(
                unit='gph', time_dependent=False,
                calc=lambda x, t=None: 951122.85336856*x,
                inverse=lambda x, t=None: 1.05138888888889e-6*x),
        ],
        'm·s': [
            ConversionTableEntry(
                unit='ft·s', time_dependent=False,
                calc=lambda x, t=None: 3.28083989501312*x,
                inverse=lambda x, t=None: 0.3048*x),
        ],
        'var·s': [
            ConversionTableEntry(
                unit='vahr', time_dependent=False,
                calc=lambda x, t=None: (1/3600)*x,
                inverse=lambda x, t=None: 3600*x),
        ],
        '°C': [
            ConversionTableEntry(
                unit='°F', time_dependent=False,
                calc=lambda x, t=None: (9/5)*x + 32,
                inverse=lambda x, t=None: (5/9)*x - 160/9),
            ConversionTableEntry(
                unit='°K', time_dependent=False,
                calc=lambda x, t=None: x + 273.15,
                inverse=lambda x, t=None: x - 273.15),
        ],
        '°C·s': [
            ConversionTableEntry(
                unit='°K·s', time_dependent=True,
                calc=lambda x, t=None: 273.15*t + x,
                inverse=lambda x, t=None: -273.15*t + x),
            ConversionTableEntry(
                unit='°F·s', time_dependent=True,
                calc=lambda x, t=None: 32*t + (9/5)*x,
                inverse=lambda x, t=None: -160/9*t + (5/9)*x),
        ]
    }

    scaled = {
        'A': [
            ConversionTableEntry(
                unit='yA', time_dependent=False,
                calc=lambda x, t=None: 1.0e+24*x,
                inverse=lambda x, t=None: 1.0e-24*x),
            ConversionTableEntry(
                unit='zA', time_dependent=False,
                calc=lambda x, t=None: 1.0e+21*x,
                inverse=lambda x, t=None: 1.0e-21*x),
            ConversionTableEntry(
                unit='aA', time_dependent=False,
                calc=lambda x, t=None: 1.0e+18*x,
                inverse=lambda x, t=None: 1.0e-18*x),
            ConversionTableEntry(
                unit='fA', time_dependent=False,
                calc=lambda x, t=None: 1.0e+15*x,
                inverse=lambda x, t=None: 1.0e-15*x),
            ConversionTableEntry(
                unit='pA', time_dependent=False,
                calc=lambda x, t=None: 1000000000000.0*x,
                inverse=lambda x, t=None: 1.0e-12*x),
            ConversionTableEntry(
                unit='nA', time_dependent=False,
                calc=lambda x, t=None: 1000000000.0*x,
                inverse=lambda x, t=None: 1.0e-9*x),
            ConversionTableEntry(
                unit='μA', time_dependent=False,
                calc=lambda x, t=None: 1000000.0*x,
                inverse=lambda x, t=None: 1.0e-6*x),
            ConversionTableEntry(
                unit='mA', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='kA', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
            ConversionTableEntry(
                unit='MA', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
            ConversionTableEntry(
                unit='GA', time_dependent=False,
                calc=lambda x, t=None: 1.0e-9*x,
                inverse=lambda x, t=None: 1000000000.0*x),
            ConversionTableEntry(
                unit='TA', time_dependent=False,
                calc=lambda x, t=None: 1.0e-12*x,
                inverse=lambda x, t=None: 1000000000000.0*x),
            ConversionTableEntry(
                unit='PA', time_dependent=False,
                calc=lambda x, t=None: 1.0e-15*x,
                inverse=lambda x, t=None: 1.0e+15*x),
            ConversionTableEntry(
                unit='EA', time_dependent=False,
                calc=lambda x, t=None: 1.0e-18*x,
                inverse=lambda x, t=None: 1.0e+18*x),
            ConversionTableEntry(
                unit='ZA', time_dependent=False,
                calc=lambda x, t=None: 1.0e-21*x,
                inverse=lambda x, t=None: 1.0e+21*x),
            ConversionTableEntry(
                unit='YA', time_dependent=False,
                calc=lambda x, t=None: 1.0e-24*x,
                inverse=lambda x, t=None: 1.0e+24*x),
        ],
        'Ah': [
            ConversionTableEntry(
                unit='yAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e+24*x,
                inverse=lambda x, t=None: 1.0e-24*x),
            ConversionTableEntry(
                unit='zAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e+21*x,
                inverse=lambda x, t=None: 1.0e-21*x),
            ConversionTableEntry(
                unit='aAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e+18*x,
                inverse=lambda x, t=None: 1.0e-18*x),
            ConversionTableEntry(
                unit='fAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e+15*x,
                inverse=lambda x, t=None: 1.0e-15*x),
            ConversionTableEntry(
                unit='pAh', time_dependent=False,
                calc=lambda x, t=None: 1000000000000.0*x,
                inverse=lambda x, t=None: 1.0e-12*x),
            ConversionTableEntry(
                unit='nAh', time_dependent=False,
                calc=lambda x, t=None: 1000000000.0*x,
                inverse=lambda x, t=None: 1.0e-9*x),
            ConversionTableEntry(
                unit='μAh', time_dependent=False,
                calc=lambda x, t=None: 1000000.0*x,
                inverse=lambda x, t=None: 1.0e-6*x),
            ConversionTableEntry(
                unit='mAh', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='kAh', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
            ConversionTableEntry(
                unit='MAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
            ConversionTableEntry(
                unit='GAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-9*x,
                inverse=lambda x, t=None: 1000000000.0*x),
            ConversionTableEntry(
                unit='TAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-12*x,
                inverse=lambda x, t=None: 1000000000000.0*x),
            ConversionTableEntry(
                unit='PAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-15*x,
                inverse=lambda x, t=None: 1.0e+15*x),
            ConversionTableEntry(
                unit='EAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-18*x,
                inverse=lambda x, t=None: 1.0e+18*x),
            ConversionTableEntry(
                unit='ZAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-21*x,
                inverse=lambda x, t=None: 1.0e+21*x),
            ConversionTableEntry(
                unit='YAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-24*x,
                inverse=lambda x, t=None: 1.0e+24*x),
        ],
        'Btu/h': [
            ConversionTableEntry(
                unit='MBH', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
        ],
        'Hz': [
            ConversionTableEntry(
                unit='yHz', time_dependent=False,
                calc=lambda x, t=None: 1.0e+24*x,
                inverse=lambda x, t=None: 1.0e-24*x),
            ConversionTableEntry(
                unit='zHz', time_dependent=False,
                calc=lambda x, t=None: 1.0e+21*x,
                inverse=lambda x, t=None: 1.0e-21*x),
            ConversionTableEntry(
                unit='aHz', time_dependent=False,
                calc=lambda x, t=None: 1.0e+18*x,
                inverse=lambda x, t=None: 1.0e-18*x),
            ConversionTableEntry(
                unit='fHz', time_dependent=False,
                calc=lambda x, t=None: 1.0e+15*x,
                inverse=lambda x, t=None: 1.0e-15*x),
            ConversionTableEntry(
                unit='pHz', time_dependent=False,
                calc=lambda x, t=None: 1000000000000.0*x,
                inverse=lambda x, t=None: 1.0e-12*x),
            ConversionTableEntry(
                unit='nHz', time_dependent=False,
                calc=lambda x, t=None: 1000000000.0*x,
                inverse=lambda x, t=None: 1.0e-9*x),
            ConversionTableEntry(
                unit='μHz', time_dependent=False,
                calc=lambda x, t=None: 1000000.0*x,
                inverse=lambda x, t=None: 1.0e-6*x),
            ConversionTableEntry(
                unit='mHz', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='kHz', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
            ConversionTableEntry(
                unit='MHz', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
            ConversionTableEntry(
                unit='GHz', time_dependent=False,
                calc=lambda x, t=None: 1.0e-9*x,
                inverse=lambda x, t=None: 1000000000.0*x),
            ConversionTableEntry(
                unit='THz', time_dependent=False,
                calc=lambda x, t=None: 1.0e-12*x,
                inverse=lambda x, t=None: 1000000000000.0*x),
            ConversionTableEntry(
                unit='PHz', time_dependent=False,
                calc=lambda x, t=None: 1.0e-15*x,
                inverse=lambda x, t=None: 1.0e+15*x),
            ConversionTableEntry(
                unit='EHz', time_dependent=False,
                calc=lambda x, t=None: 1.0e-18*x,
                inverse=lambda x, t=None: 1.0e+18*x),
            ConversionTableEntry(
                unit='ZHz', time_dependent=False,
                calc=lambda x, t=None: 1.0e-21*x,
                inverse=lambda x, t=None: 1.0e+21*x),
            ConversionTableEntry(
                unit='YHz', time_dependent=False,
                calc=lambda x, t=None: 1.0e-24*x,
                inverse=lambda x, t=None: 1.0e+24*x),
        ],
        'T': [
            ConversionTableEntry(
                unit='kT', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
            ConversionTableEntry(
                unit='MT', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
            ConversionTableEntry(
                unit='GT', time_dependent=False,
                calc=lambda x, t=None: 1.0e-9*x,
                inverse=lambda x, t=None: 1000000000.0*x),
            ConversionTableEntry(
                unit='TT', time_dependent=False,
                calc=lambda x, t=None: 1.0e-12*x,
                inverse=lambda x, t=None: 1000000000000.0*x),
            ConversionTableEntry(
                unit='PT', time_dependent=False,
                calc=lambda x, t=None: 1.0e-15*x,
                inverse=lambda x, t=None: 1.0e+15*x),
        ],
        'V': [
            ConversionTableEntry(
                unit='yV', time_dependent=False,
                calc=lambda x, t=None: 1.0e+24*x,
                inverse=lambda x, t=None: 1.0e-24*x),
            ConversionTableEntry(
                unit='zV', time_dependent=False,
                calc=lambda x, t=None: 1.0e+21*x,
                inverse=lambda x, t=None: 1.0e-21*x),
            ConversionTableEntry(
                unit='aV', time_dependent=False,
                calc=lambda x, t=None: 1.0e+18*x,
                inverse=lambda x, t=None: 1.0e-18*x),
            ConversionTableEntry(
                unit='fV', time_dependent=False,
                calc=lambda x, t=None: 1.0e+15*x,
                inverse=lambda x, t=None: 1.0e-15*x),
            ConversionTableEntry(
                unit='pV', time_dependent=False,
                calc=lambda x, t=None: 1000000000000.0*x,
                inverse=lambda x, t=None: 1.0e-12*x),
            ConversionTableEntry(
                unit='nV', time_dependent=False,
                calc=lambda x, t=None: 1000000000.0*x,
                inverse=lambda x, t=None: 1.0e-9*x),
            ConversionTableEntry(
                unit='μV', time_dependent=False,
                calc=lambda x, t=None: 1000000.0*x,
                inverse=lambda x, t=None: 1.0e-6*x),
            ConversionTableEntry(
                unit='mV', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='kV', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
            ConversionTableEntry(
                unit='MV', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
            ConversionTableEntry(
                unit='GV', time_dependent=False,
                calc=lambda x, t=None: 1.0e-9*x,
                inverse=lambda x, t=None: 1000000000.0*x),
            ConversionTableEntry(
                unit='TV', time_dependent=False,
                calc=lambda x, t=None: 1.0e-12*x,
                inverse=lambda x, t=None: 1000000000000.0*x),
            ConversionTableEntry(
                unit='PV', time_dependent=False,
                calc=lambda x, t=None: 1.0e-15*x,
                inverse=lambda x, t=None: 1.0e+15*x),
            ConversionTableEntry(
                unit='EV', time_dependent=False,
                calc=lambda x, t=None: 1.0e-18*x,
                inverse=lambda x, t=None: 1.0e+18*x),
            ConversionTableEntry(
                unit='ZV', time_dependent=False,
                calc=lambda x, t=None: 1.0e-21*x,
                inverse=lambda x, t=None: 1.0e+21*x),
            ConversionTableEntry(
                unit='YV', time_dependent=False,
                calc=lambda x, t=None: 1.0e-24*x,
                inverse=lambda x, t=None: 1.0e+24*x),
        ],
        'VA': [
            ConversionTableEntry(
                unit='yVA', time_dependent=False,
                calc=lambda x, t=None: 1.0e+24*x,
                inverse=lambda x, t=None: 1.0e-24*x),
            ConversionTableEntry(
                unit='zVA', time_dependent=False,
                calc=lambda x, t=None: 1.0e+21*x,
                inverse=lambda x, t=None: 1.0e-21*x),
            ConversionTableEntry(
                unit='aVA', time_dependent=False,
                calc=lambda x, t=None: 1.0e+18*x,
                inverse=lambda x, t=None: 1.0e-18*x),
            ConversionTableEntry(
                unit='fVA', time_dependent=False,
                calc=lambda x, t=None: 1.0e+15*x,
                inverse=lambda x, t=None: 1.0e-15*x),
            ConversionTableEntry(
                unit='pVA', time_dependent=False,
                calc=lambda x, t=None: 1000000000000.0*x,
                inverse=lambda x, t=None: 1.0e-12*x),
            ConversionTableEntry(
                unit='nVA', time_dependent=False,
                calc=lambda x, t=None: 1000000000.0*x,
                inverse=lambda x, t=None: 1.0e-9*x),
            ConversionTableEntry(
                unit='μVA', time_dependent=False,
                calc=lambda x, t=None: 1000000.0*x,
                inverse=lambda x, t=None: 1.0e-6*x),
            ConversionTableEntry(
                unit='mVA', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='kVA', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
            ConversionTableEntry(
                unit='MVA', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
            ConversionTableEntry(
                unit='GVA', time_dependent=False,
                calc=lambda x, t=None: 1.0e-9*x,
                inverse=lambda x, t=None: 1000000000.0*x),
            ConversionTableEntry(
                unit='TVA', time_dependent=False,
                calc=lambda x, t=None: 1.0e-12*x,
                inverse=lambda x, t=None: 1000000000000.0*x),
            ConversionTableEntry(
                unit='PVA', time_dependent=False,
                calc=lambda x, t=None: 1.0e-15*x,
                inverse=lambda x, t=None: 1.0e+15*x),
            ConversionTableEntry(
                unit='EVA', time_dependent=False,
                calc=lambda x, t=None: 1.0e-18*x,
                inverse=lambda x, t=None: 1.0e+18*x),
            ConversionTableEntry(
                unit='ZVA', time_dependent=False,
                calc=lambda x, t=None: 1.0e-21*x,
                inverse=lambda x, t=None: 1.0e+21*x),
            ConversionTableEntry(
                unit='YVA', time_dependent=False,
                calc=lambda x, t=None: 1.0e-24*x,
                inverse=lambda x, t=None: 1.0e+24*x),
        ],
        'VAh': [
            ConversionTableEntry(
                unit='yVAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e+24*x,
                inverse=lambda x, t=None: 1.0e-24*x),
            ConversionTableEntry(
                unit='zVAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e+21*x,
                inverse=lambda x, t=None: 1.0e-21*x),
            ConversionTableEntry(
                unit='aVAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e+18*x,
                inverse=lambda x, t=None: 1.0e-18*x),
            ConversionTableEntry(
                unit='fVAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e+15*x,
                inverse=lambda x, t=None: 1.0e-15*x),
            ConversionTableEntry(
                unit='pVAh', time_dependent=False,
                calc=lambda x, t=None: 1000000000000.0*x,
                inverse=lambda x, t=None: 1.0e-12*x),
            ConversionTableEntry(
                unit='nVAh', time_dependent=False,
                calc=lambda x, t=None: 1000000000.0*x,
                inverse=lambda x, t=None: 1.0e-9*x),
            ConversionTableEntry(
                unit='μVAh', time_dependent=False,
                calc=lambda x, t=None: 1000000.0*x,
                inverse=lambda x, t=None: 1.0e-6*x),
            ConversionTableEntry(
                unit='mVAh', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='kVAh', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
            ConversionTableEntry(
                unit='MVAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
            ConversionTableEntry(
                unit='GVAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-9*x,
                inverse=lambda x, t=None: 1000000000.0*x),
            ConversionTableEntry(
                unit='TVAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-12*x,
                inverse=lambda x, t=None: 1000000000000.0*x),
            ConversionTableEntry(
                unit='PVAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-15*x,
                inverse=lambda x, t=None: 1.0e+15*x),
            ConversionTableEntry(
                unit='EVAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-18*x,
                inverse=lambda x, t=None: 1.0e+18*x),
            ConversionTableEntry(
                unit='ZVAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-21*x,
                inverse=lambda x, t=None: 1.0e+21*x),
            ConversionTableEntry(
                unit='YVAh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-24*x,
                inverse=lambda x, t=None: 1.0e+24*x),
        ],
        'Vh': [
            ConversionTableEntry(
                unit='yVh', time_dependent=False,
                calc=lambda x, t=None: 1.0e+24*x,
                inverse=lambda x, t=None: 1.0e-24*x),
            ConversionTableEntry(
                unit='zVh', time_dependent=False,
                calc=lambda x, t=None: 1.0e+21*x,
                inverse=lambda x, t=None: 1.0e-21*x),
            ConversionTableEntry(
                unit='aVh', time_dependent=False,
                calc=lambda x, t=None: 1.0e+18*x,
                inverse=lambda x, t=None: 1.0e-18*x),
            ConversionTableEntry(
                unit='fVh', time_dependent=False,
                calc=lambda x, t=None: 1.0e+15*x,
                inverse=lambda x, t=None: 1.0e-15*x),
            ConversionTableEntry(
                unit='pVh', time_dependent=False,
                calc=lambda x, t=None: 1000000000000.0*x,
                inverse=lambda x, t=None: 1.0e-12*x),
            ConversionTableEntry(
                unit='nVh', time_dependent=False,
                calc=lambda x, t=None: 1000000000.0*x,
                inverse=lambda x, t=None: 1.0e-9*x),
            ConversionTableEntry(
                unit='μVh', time_dependent=False,
                calc=lambda x, t=None: 1000000.0*x,
                inverse=lambda x, t=None: 1.0e-6*x),
            ConversionTableEntry(
                unit='mVh', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='kVh', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
            ConversionTableEntry(
                unit='MVh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
            ConversionTableEntry(
                unit='GVh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-9*x,
                inverse=lambda x, t=None: 1000000000.0*x),
            ConversionTableEntry(
                unit='TVh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-12*x,
                inverse=lambda x, t=None: 1000000000000.0*x),
            ConversionTableEntry(
                unit='PVh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-15*x,
                inverse=lambda x, t=None: 1.0e+15*x),
            ConversionTableEntry(
                unit='EVh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-18*x,
                inverse=lambda x, t=None: 1.0e+18*x),
            ConversionTableEntry(
                unit='ZVh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-21*x,
                inverse=lambda x, t=None: 1.0e+21*x),
            ConversionTableEntry(
                unit='YVh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-24*x,
                inverse=lambda x, t=None: 1.0e+24*x),
        ],
        'W': [
            ConversionTableEntry(
                unit='yW', time_dependent=False,
                calc=lambda x, t=None: 1.0e+24*x,
                inverse=lambda x, t=None: 1.0e-24*x),
            ConversionTableEntry(
                unit='zW', time_dependent=False,
                calc=lambda x, t=None: 1.0e+21*x,
                inverse=lambda x, t=None: 1.0e-21*x),
            ConversionTableEntry(
                unit='aW', time_dependent=False,
                calc=lambda x, t=None: 1.0e+18*x,
                inverse=lambda x, t=None: 1.0e-18*x),
            ConversionTableEntry(
                unit='fW', time_dependent=False,
                calc=lambda x, t=None: 1.0e+15*x,
                inverse=lambda x, t=None: 1.0e-15*x),
            ConversionTableEntry(
                unit='pW', time_dependent=False,
                calc=lambda x, t=None: 1000000000000.0*x,
                inverse=lambda x, t=None: 1.0e-12*x),
            ConversionTableEntry(
                unit='nW', time_dependent=False,
                calc=lambda x, t=None: 1000000000.0*x,
                inverse=lambda x, t=None: 1.0e-9*x),
            ConversionTableEntry(
                unit='μW', time_dependent=False,
                calc=lambda x, t=None: 1000000.0*x,
                inverse=lambda x, t=None: 1.0e-6*x),
            ConversionTableEntry(
                unit='mW', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='kW', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
            ConversionTableEntry(
                unit='MW', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
            ConversionTableEntry(
                unit='GW', time_dependent=False,
                calc=lambda x, t=None: 1.0e-9*x,
                inverse=lambda x, t=None: 1000000000.0*x),
            ConversionTableEntry(
                unit='TW', time_dependent=False,
                calc=lambda x, t=None: 1.0e-12*x,
                inverse=lambda x, t=None: 1000000000000.0*x),
            ConversionTableEntry(
                unit='PW', time_dependent=False,
                calc=lambda x, t=None: 1.0e-15*x,
                inverse=lambda x, t=None: 1.0e+15*x),
            ConversionTableEntry(
                unit='EW', time_dependent=False,
                calc=lambda x, t=None: 1.0e-18*x,
                inverse=lambda x, t=None: 1.0e+18*x),
            ConversionTableEntry(
                unit='ZW', time_dependent=False,
                calc=lambda x, t=None: 1.0e-21*x,
                inverse=lambda x, t=None: 1.0e+21*x),
            ConversionTableEntry(
                unit='YW', time_dependent=False,
                calc=lambda x, t=None: 1.0e-24*x,
                inverse=lambda x, t=None: 1.0e+24*x),
        ],
        'W/m^2': [
            ConversionTableEntry(
                unit='yW/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e+24*x,
                inverse=lambda x, t=None: 1.0e-24*x),
            ConversionTableEntry(
                unit='zW/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e+21*x,
                inverse=lambda x, t=None: 1.0e-21*x),
            ConversionTableEntry(
                unit='aW/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e+18*x,
                inverse=lambda x, t=None: 1.0e-18*x),
            ConversionTableEntry(
                unit='fW/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e+15*x,
                inverse=lambda x, t=None: 1.0e-15*x),
            ConversionTableEntry(
                unit='pW/m^2', time_dependent=False,
                calc=lambda x, t=None: 1000000000000.0*x,
                inverse=lambda x, t=None: 1.0e-12*x),
            ConversionTableEntry(
                unit='nW/m^2', time_dependent=False,
                calc=lambda x, t=None: 1000000000.0*x,
                inverse=lambda x, t=None: 1.0e-9*x),
            ConversionTableEntry(
                unit='μW/m^2', time_dependent=False,
                calc=lambda x, t=None: 1000000.0*x,
                inverse=lambda x, t=None: 1.0e-6*x),
            ConversionTableEntry(
                unit='mW/m^2', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='kW/m^2', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
            ConversionTableEntry(
                unit='MW/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
            ConversionTableEntry(
                unit='GW/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e-9*x,
                inverse=lambda x, t=None: 1000000000.0*x),
            ConversionTableEntry(
                unit='TW/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e-12*x,
                inverse=lambda x, t=None: 1000000000000.0*x),
            ConversionTableEntry(
                unit='PW/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e-15*x,
                inverse=lambda x, t=None: 1.0e+15*x),
            ConversionTableEntry(
                unit='EW/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e-18*x,
                inverse=lambda x, t=None: 1.0e+18*x),
            ConversionTableEntry(
                unit='ZW/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e-21*x,
                inverse=lambda x, t=None: 1.0e+21*x),
            ConversionTableEntry(
                unit='YW/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e-24*x,
                inverse=lambda x, t=None: 1.0e+24*x),
        ],
        'Wh': [
            ConversionTableEntry(
                unit='yWh', time_dependent=False,
                calc=lambda x, t=None: 1.0e+24*x,
                inverse=lambda x, t=None: 1.0e-24*x),
            ConversionTableEntry(
                unit='zWh', time_dependent=False,
                calc=lambda x, t=None: 1.0e+21*x,
                inverse=lambda x, t=None: 1.0e-21*x),
            ConversionTableEntry(
                unit='aWh', time_dependent=False,
                calc=lambda x, t=None: 1.0e+18*x,
                inverse=lambda x, t=None: 1.0e-18*x),
            ConversionTableEntry(
                unit='fWh', time_dependent=False,
                calc=lambda x, t=None: 1.0e+15*x,
                inverse=lambda x, t=None: 1.0e-15*x),
            ConversionTableEntry(
                unit='pWh', time_dependent=False,
                calc=lambda x, t=None: 1000000000000.0*x,
                inverse=lambda x, t=None: 1.0e-12*x),
            ConversionTableEntry(
                unit='nWh', time_dependent=False,
                calc=lambda x, t=None: 1000000000.0*x,
                inverse=lambda x, t=None: 1.0e-9*x),
            ConversionTableEntry(
                unit='μWh', time_dependent=False,
                calc=lambda x, t=None: 1000000.0*x,
                inverse=lambda x, t=None: 1.0e-6*x),
            ConversionTableEntry(
                unit='mWh', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='kWh', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
            ConversionTableEntry(
                unit='MWh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
            ConversionTableEntry(
                unit='GWh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-9*x,
                inverse=lambda x, t=None: 1000000000.0*x),
            ConversionTableEntry(
                unit='TWh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-12*x,
                inverse=lambda x, t=None: 1000000000000.0*x),
            ConversionTableEntry(
                unit='PWh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-15*x,
                inverse=lambda x, t=None: 1.0e+15*x),
            ConversionTableEntry(
                unit='EWh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-18*x,
                inverse=lambda x, t=None: 1.0e+18*x),
            ConversionTableEntry(
                unit='ZWh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-21*x,
                inverse=lambda x, t=None: 1.0e+21*x),
            ConversionTableEntry(
                unit='YWh', time_dependent=False,
                calc=lambda x, t=None: 1.0e-24*x,
                inverse=lambda x, t=None: 1.0e+24*x),
        ],
        'Wh/m^2': [
            ConversionTableEntry(
                unit='yWh/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e+24*x,
                inverse=lambda x, t=None: 1.0e-24*x),
            ConversionTableEntry(
                unit='zWh/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e+21*x,
                inverse=lambda x, t=None: 1.0e-21*x),
            ConversionTableEntry(
                unit='aWh/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e+18*x,
                inverse=lambda x, t=None: 1.0e-18*x),
            ConversionTableEntry(
                unit='fWh/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e+15*x,
                inverse=lambda x, t=None: 1.0e-15*x),
            ConversionTableEntry(
                unit='pWh/m^2', time_dependent=False,
                calc=lambda x, t=None: 1000000000000.0*x,
                inverse=lambda x, t=None: 1.0e-12*x),
            ConversionTableEntry(
                unit='nWh/m^2', time_dependent=False,
                calc=lambda x, t=None: 1000000000.0*x,
                inverse=lambda x, t=None: 1.0e-9*x),
            ConversionTableEntry(
                unit='μWh/m^2', time_dependent=False,
                calc=lambda x, t=None: 1000000.0*x,
                inverse=lambda x, t=None: 1.0e-6*x),
            ConversionTableEntry(
                unit='mWh/m^2', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='kWh/m^2', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
            ConversionTableEntry(
                unit='MWh/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
            ConversionTableEntry(
                unit='GWh/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e-9*x,
                inverse=lambda x, t=None: 1000000000.0*x),
            ConversionTableEntry(
                unit='TWh/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e-12*x,
                inverse=lambda x, t=None: 1000000000000.0*x),
            ConversionTableEntry(
                unit='PWh/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e-15*x,
                inverse=lambda x, t=None: 1.0e+15*x),
            ConversionTableEntry(
                unit='EWh/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e-18*x,
                inverse=lambda x, t=None: 1.0e+18*x),
            ConversionTableEntry(
                unit='ZWh/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e-21*x,
                inverse=lambda x, t=None: 1.0e+21*x),
            ConversionTableEntry(
                unit='YWh/m^2', time_dependent=False,
                calc=lambda x, t=None: 1.0e-24*x,
                inverse=lambda x, t=None: 1.0e+24*x),
        ],
        'g': [
            ConversionTableEntry(
                unit='μg', time_dependent=False,
                calc=lambda x, t=None: 1000000.0*x,
                inverse=lambda x, t=None: 1.0e-6*x),
            ConversionTableEntry(
                unit='mg', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='kg', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
        ],
        'g/s': [
            ConversionTableEntry(
                unit='μg/s', time_dependent=False,
                calc=lambda x, t=None: 1000000.0*x,
                inverse=lambda x, t=None: 1.0e-6*x),
            ConversionTableEntry(
                unit='mg/s', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='kg/s', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
            ConversionTableEntry(
                unit='T/s', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
            ConversionTableEntry(
                unit='kT/s', time_dependent=False,
                calc=lambda x, t=None: 1.0e-9*x,
                inverse=lambda x, t=None: 1000000000.0*x),
            ConversionTableEntry(
                unit='MT/s', time_dependent=False,
                calc=lambda x, t=None: 1.0e-12*x,
                inverse=lambda x, t=None: 1000000000000.0*x),
            ConversionTableEntry(
                unit='GT/s', time_dependent=False,
                calc=lambda x, t=None: 1.0e-15*x,
                inverse=lambda x, t=None: 1.0e+15*x),
            ConversionTableEntry(
                unit='TT/s', time_dependent=False,
                calc=lambda x, t=None: 1.0e-18*x,
                inverse=lambda x, t=None: 1.0e+18*x),
            ConversionTableEntry(
                unit='PT/s', time_dependent=False,
                calc=lambda x, t=None: 1.0e-21*x,
                inverse=lambda x, t=None: 1.0e+21*x),
        ],
        'g·s': [
            ConversionTableEntry(
                unit='μg·s', time_dependent=False,
                calc=lambda x, t=None: 1000000.0*x,
                inverse=lambda x, t=None: 1.0e-6*x),
            ConversionTableEntry(
                unit='mg·s', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='kg·s', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
            ConversionTableEntry(
                unit='T·s', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
            ConversionTableEntry(
                unit='kT·s', time_dependent=False,
                calc=lambda x, t=None: 1.0e-9*x,
                inverse=lambda x, t=None: 1000000000.0*x),
            ConversionTableEntry(
                unit='MT·s', time_dependent=False,
                calc=lambda x, t=None: 1.0e-12*x,
                inverse=lambda x, t=None: 1000000000000.0*x),
            ConversionTableEntry(
                unit='GT·s', time_dependent=False,
                calc=lambda x, t=None: 1.0e-15*x,
                inverse=lambda x, t=None: 1.0e+15*x),
            ConversionTableEntry(
                unit='TT·s', time_dependent=False,
                calc=lambda x, t=None: 1.0e-18*x,
                inverse=lambda x, t=None: 1.0e+18*x),
            ConversionTableEntry(
                unit='PT·s', time_dependent=False,
                calc=lambda x, t=None: 1.0e-21*x,
                inverse=lambda x, t=None: 1.0e+21*x),
        ],
        'm': [
            ConversionTableEntry(
                unit='ym', time_dependent=False,
                calc=lambda x, t=None: 1.0e+24*x,
                inverse=lambda x, t=None: 1.0e-24*x),
            ConversionTableEntry(
                unit='zm', time_dependent=False,
                calc=lambda x, t=None: 1.0e+21*x,
                inverse=lambda x, t=None: 1.0e-21*x),
            ConversionTableEntry(
                unit='am', time_dependent=False,
                calc=lambda x, t=None: 1.0e+18*x,
                inverse=lambda x, t=None: 1.0e-18*x),
            ConversionTableEntry(
                unit='fm', time_dependent=False,
                calc=lambda x, t=None: 1.0e+15*x,
                inverse=lambda x, t=None: 1.0e-15*x),
            ConversionTableEntry(
                unit='pm', time_dependent=False,
                calc=lambda x, t=None: 1000000000000.0*x,
                inverse=lambda x, t=None: 1.0e-12*x),
            ConversionTableEntry(
                unit='nm', time_dependent=False,
                calc=lambda x, t=None: 1000000000.0*x,
                inverse=lambda x, t=None: 1.0e-9*x),
            ConversionTableEntry(
                unit='μm', time_dependent=False,
                calc=lambda x, t=None: 1000000.0*x,
                inverse=lambda x, t=None: 1.0e-6*x),
            ConversionTableEntry(
                unit='mm', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='km', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
            ConversionTableEntry(
                unit='Mm', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
            ConversionTableEntry(
                unit='Gm', time_dependent=False,
                calc=lambda x, t=None: 1.0e-9*x,
                inverse=lambda x, t=None: 1000000000.0*x),
            ConversionTableEntry(
                unit='Tm', time_dependent=False,
                calc=lambda x, t=None: 1.0e-12*x,
                inverse=lambda x, t=None: 1000000000000.0*x),
            ConversionTableEntry(
                unit='Pm', time_dependent=False,
                calc=lambda x, t=None: 1.0e-15*x,
                inverse=lambda x, t=None: 1.0e+15*x),
            ConversionTableEntry(
                unit='Em', time_dependent=False,
                calc=lambda x, t=None: 1.0e-18*x,
                inverse=lambda x, t=None: 1.0e+18*x),
            ConversionTableEntry(
                unit='Zm', time_dependent=False,
                calc=lambda x, t=None: 1.0e-21*x,
                inverse=lambda x, t=None: 1.0e+21*x),
            ConversionTableEntry(
                unit='Ym', time_dependent=False,
                calc=lambda x, t=None: 1.0e-24*x,
                inverse=lambda x, t=None: 1.0e+24*x),
        ],
        'm/h': [
            ConversionTableEntry(
                unit='ym/h', time_dependent=False,
                calc=lambda x, t=None: 1.0e+24*x,
                inverse=lambda x, t=None: 1.0e-24*x),
            ConversionTableEntry(
                unit='zm/h', time_dependent=False,
                calc=lambda x, t=None: 1.0e+21*x,
                inverse=lambda x, t=None: 1.0e-21*x),
            ConversionTableEntry(
                unit='am/h', time_dependent=False,
                calc=lambda x, t=None: 1.0e+18*x,
                inverse=lambda x, t=None: 1.0e-18*x),
            ConversionTableEntry(
                unit='fm/h', time_dependent=False,
                calc=lambda x, t=None: 1.0e+15*x,
                inverse=lambda x, t=None: 1.0e-15*x),
            ConversionTableEntry(
                unit='pm/h', time_dependent=False,
                calc=lambda x, t=None: 1000000000000.0*x,
                inverse=lambda x, t=None: 1.0e-12*x),
            ConversionTableEntry(
                unit='nm/h', time_dependent=False,
                calc=lambda x, t=None: 1000000000.0*x,
                inverse=lambda x, t=None: 1.0e-9*x),
            ConversionTableEntry(
                unit='μm/h', time_dependent=False,
                calc=lambda x, t=None: 1000000.0*x,
                inverse=lambda x, t=None: 1.0e-6*x),
            ConversionTableEntry(
                unit='mm/h', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='km/h', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
            ConversionTableEntry(
                unit='Mm/h', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
            ConversionTableEntry(
                unit='Gm/h', time_dependent=False,
                calc=lambda x, t=None: 1.0e-9*x,
                inverse=lambda x, t=None: 1000000000.0*x),
            ConversionTableEntry(
                unit='Tm/h', time_dependent=False,
                calc=lambda x, t=None: 1.0e-12*x,
                inverse=lambda x, t=None: 1000000000000.0*x),
            ConversionTableEntry(
                unit='Pm/h', time_dependent=False,
                calc=lambda x, t=None: 1.0e-15*x,
                inverse=lambda x, t=None: 1.0e+15*x),
            ConversionTableEntry(
                unit='Em/h', time_dependent=False,
                calc=lambda x, t=None: 1.0e-18*x,
                inverse=lambda x, t=None: 1.0e+18*x),
            ConversionTableEntry(
                unit='Zm/h', time_dependent=False,
                calc=lambda x, t=None: 1.0e-21*x,
                inverse=lambda x, t=None: 1.0e+21*x),
            ConversionTableEntry(
                unit='Ym/h', time_dependent=False,
                calc=lambda x, t=None: 1.0e-24*x,
                inverse=lambda x, t=None: 1.0e+24*x),
        ],
        'm/s': [
            ConversionTableEntry(
                unit='ym/s', time_dependent=False,
                calc=lambda x, t=None: 1.0e+24*x,
                inverse=lambda x, t=None: 1.0e-24*x),
            ConversionTableEntry(
                unit='zm/s', time_dependent=False,
                calc=lambda x, t=None: 1.0e+21*x,
                inverse=lambda x, t=None: 1.0e-21*x),
            ConversionTableEntry(
                unit='am/s', time_dependent=False,
                calc=lambda x, t=None: 1.0e+18*x,
                inverse=lambda x, t=None: 1.0e-18*x),
            ConversionTableEntry(
                unit='fm/s', time_dependent=False,
                calc=lambda x, t=None: 1.0e+15*x,
                inverse=lambda x, t=None: 1.0e-15*x),
            ConversionTableEntry(
                unit='pm/s', time_dependent=False,
                calc=lambda x, t=None: 1000000000000.0*x,
                inverse=lambda x, t=None: 1.0e-12*x),
            ConversionTableEntry(
                unit='nm/s', time_dependent=False,
                calc=lambda x, t=None: 1000000000.0*x,
                inverse=lambda x, t=None: 1.0e-9*x),
            ConversionTableEntry(
                unit='μm/s', time_dependent=False,
                calc=lambda x, t=None: 1000000.0*x,
                inverse=lambda x, t=None: 1.0e-6*x),
            ConversionTableEntry(
                unit='mm/s', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='km/s', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
            ConversionTableEntry(
                unit='Mm/s', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
            ConversionTableEntry(
                unit='Gm/s', time_dependent=False,
                calc=lambda x, t=None: 1.0e-9*x,
                inverse=lambda x, t=None: 1000000000.0*x),
            ConversionTableEntry(
                unit='Tm/s', time_dependent=False,
                calc=lambda x, t=None: 1.0e-12*x,
                inverse=lambda x, t=None: 1000000000000.0*x),
            ConversionTableEntry(
                unit='Pm/s', time_dependent=False,
                calc=lambda x, t=None: 1.0e-15*x,
                inverse=lambda x, t=None: 1.0e+15*x),
            ConversionTableEntry(
                unit='Em/s', time_dependent=False,
                calc=lambda x, t=None: 1.0e-18*x,
                inverse=lambda x, t=None: 1.0e+18*x),
            ConversionTableEntry(
                unit='Zm/s', time_dependent=False,
                calc=lambda x, t=None: 1.0e-21*x,
                inverse=lambda x, t=None: 1.0e+21*x),
            ConversionTableEntry(
                unit='Ym/s', time_dependent=False,
                calc=lambda x, t=None: 1.0e-24*x,
                inverse=lambda x, t=None: 1.0e+24*x),
        ],
        'vahr': [
            ConversionTableEntry(
                unit='yvahr', time_dependent=False,
                calc=lambda x, t=None: 1.0e+24*x,
                inverse=lambda x, t=None: 1.0e-24*x),
            ConversionTableEntry(
                unit='zvahr', time_dependent=False,
                calc=lambda x, t=None: 1.0e+21*x,
                inverse=lambda x, t=None: 1.0e-21*x),
            ConversionTableEntry(
                unit='avahr', time_dependent=False,
                calc=lambda x, t=None: 1.0e+18*x,
                inverse=lambda x, t=None: 1.0e-18*x),
            ConversionTableEntry(
                unit='fvahr', time_dependent=False,
                calc=lambda x, t=None: 1.0e+15*x,
                inverse=lambda x, t=None: 1.0e-15*x),
            ConversionTableEntry(
                unit='pvahr', time_dependent=False,
                calc=lambda x, t=None: 1000000000000.0*x,
                inverse=lambda x, t=None: 1.0e-12*x),
            ConversionTableEntry(
                unit='nvahr', time_dependent=False,
                calc=lambda x, t=None: 1000000000.0*x,
                inverse=lambda x, t=None: 1.0e-9*x),
            ConversionTableEntry(
                unit='μvahr', time_dependent=False,
                calc=lambda x, t=None: 1000000.0*x,
                inverse=lambda x, t=None: 1.0e-6*x),
            ConversionTableEntry(
                unit='mvahr', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='kvahr', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
            ConversionTableEntry(
                unit='Mvahr', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
            ConversionTableEntry(
                unit='Gvahr', time_dependent=False,
                calc=lambda x, t=None: 1.0e-9*x,
                inverse=lambda x, t=None: 1000000000.0*x),
            ConversionTableEntry(
                unit='Tvahr', time_dependent=False,
                calc=lambda x, t=None: 1.0e-12*x,
                inverse=lambda x, t=None: 1000000000000.0*x),
            ConversionTableEntry(
                unit='Pvahr', time_dependent=False,
                calc=lambda x, t=None: 1.0e-15*x,
                inverse=lambda x, t=None: 1.0e+15*x),
            ConversionTableEntry(
                unit='Evahr', time_dependent=False,
                calc=lambda x, t=None: 1.0e-18*x,
                inverse=lambda x, t=None: 1.0e+18*x),
            ConversionTableEntry(
                unit='Zvahr', time_dependent=False,
                calc=lambda x, t=None: 1.0e-21*x,
                inverse=lambda x, t=None: 1.0e+21*x),
            ConversionTableEntry(
                unit='Yvahr', time_dependent=False,
                calc=lambda x, t=None: 1.0e-24*x,
                inverse=lambda x, t=None: 1.0e+24*x),
        ],
        'var': [
            ConversionTableEntry(
                unit='yvar', time_dependent=False,
                calc=lambda x, t=None: 1.0e+24*x,
                inverse=lambda x, t=None: 1.0e-24*x),
            ConversionTableEntry(
                unit='zvar', time_dependent=False,
                calc=lambda x, t=None: 1.0e+21*x,
                inverse=lambda x, t=None: 1.0e-21*x),
            ConversionTableEntry(
                unit='avar', time_dependent=False,
                calc=lambda x, t=None: 1.0e+18*x,
                inverse=lambda x, t=None: 1.0e-18*x),
            ConversionTableEntry(
                unit='fvar', time_dependent=False,
                calc=lambda x, t=None: 1.0e+15*x,
                inverse=lambda x, t=None: 1.0e-15*x),
            ConversionTableEntry(
                unit='pvar', time_dependent=False,
                calc=lambda x, t=None: 1000000000000.0*x,
                inverse=lambda x, t=None: 1.0e-12*x),
            ConversionTableEntry(
                unit='nvar', time_dependent=False,
                calc=lambda x, t=None: 1000000000.0*x,
                inverse=lambda x, t=None: 1.0e-9*x),
            ConversionTableEntry(
                unit='μvar', time_dependent=False,
                calc=lambda x, t=None: 1000000.0*x,
                inverse=lambda x, t=None: 1.0e-6*x),
            ConversionTableEntry(
                unit='mvar', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='kvar', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
            ConversionTableEntry(
                unit='Mvar', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
            ConversionTableEntry(
                unit='Gvar', time_dependent=False,
                calc=lambda x, t=None: 1.0e-9*x,
                inverse=lambda x, t=None: 1000000000.0*x),
            ConversionTableEntry(
                unit='Tvar', time_dependent=False,
                calc=lambda x, t=None: 1.0e-12*x,
                inverse=lambda x, t=None: 1000000000000.0*x),
            ConversionTableEntry(
                unit='Pvar', time_dependent=False,
                calc=lambda x, t=None: 1.0e-15*x,
                inverse=lambda x, t=None: 1.0e+15*x),
            ConversionTableEntry(
                unit='Evar', time_dependent=False,
                calc=lambda x, t=None: 1.0e-18*x,
                inverse=lambda x, t=None: 1.0e+18*x),
            ConversionTableEntry(
                unit='Zvar', time_dependent=False,
                calc=lambda x, t=None: 1.0e-21*x,
                inverse=lambda x, t=None: 1.0e+21*x),
            ConversionTableEntry(
                unit='Yvar', time_dependent=False,
                calc=lambda x, t=None: 1.0e-24*x,
                inverse=lambda x, t=None: 1.0e+24*x),
        ],
        '°C·s': [
            ConversionTableEntry(
                unit='°C·h', time_dependent=False,
                calc=lambda x, t=None: 0.000277777777777778*x,
                inverse=lambda x, t=None: 3600.0*x),
            ConversionTableEntry(
                unit='°C·d', time_dependent=False,
                calc=lambda x, t=None: 1.15740740740741e-5*x,
                inverse=lambda x, t=None: 86399.9999999998*x),
        ],
        '°F·s': [
            ConversionTableEntry(
                unit='°F·h', time_dependent=False,
                calc=lambda x, t=None: 0.000277777777777778*x,
                inverse=lambda x, t=None: 3600.0*x),
            ConversionTableEntry(
                unit='°F·d', time_dependent=False,
                calc=lambda x, t=None: 1.15740740740741e-5*x,
                inverse=lambda x, t=None: 86399.9999999998*x),
        ],
        '°K·s': [
            ConversionTableEntry(
                unit='°K·h', time_dependent=False,
                calc=lambda x, t=None: 0.000277777777777778*x,
                inverse=lambda x, t=None: 3600.0*x),
            ConversionTableEntry(
                unit='°K·d', time_dependent=False,
                calc=lambda x, t=None: 1.15740740740741e-5*x,
                inverse=lambda x, t=None: 86399.9999999998*x),
        ],
        'Ω': [
            ConversionTableEntry(
                unit='yΩ', time_dependent=False,
                calc=lambda x, t=None: 1.0e+24*x,
                inverse=lambda x, t=None: 1.0e-24*x),
            ConversionTableEntry(
                unit='zΩ', time_dependent=False,
                calc=lambda x, t=None: 1.0e+21*x,
                inverse=lambda x, t=None: 1.0e-21*x),
            ConversionTableEntry(
                unit='aΩ', time_dependent=False,
                calc=lambda x, t=None: 1.0e+18*x,
                inverse=lambda x, t=None: 1.0e-18*x),
            ConversionTableEntry(
                unit='fΩ', time_dependent=False,
                calc=lambda x, t=None: 1.0e+15*x,
                inverse=lambda x, t=None: 1.0e-15*x),
            ConversionTableEntry(
                unit='pΩ', time_dependent=False,
                calc=lambda x, t=None: 1000000000000.0*x,
                inverse=lambda x, t=None: 1.0e-12*x),
            ConversionTableEntry(
                unit='nΩ', time_dependent=False,
                calc=lambda x, t=None: 1000000000.0*x,
                inverse=lambda x, t=None: 1.0e-9*x),
            ConversionTableEntry(
                unit='μΩ', time_dependent=False,
                calc=lambda x, t=None: 1000000.0*x,
                inverse=lambda x, t=None: 1.0e-6*x),
            ConversionTableEntry(
                unit='mΩ', time_dependent=False,
                calc=lambda x, t=None: 1000.0*x,
                inverse=lambda x, t=None: 0.001*x),
            ConversionTableEntry(
                unit='kΩ', time_dependent=False,
                calc=lambda x, t=None: 0.001*x,
                inverse=lambda x, t=None: 1000.0*x),
            ConversionTableEntry(
                unit='MΩ', time_dependent=False,
                calc=lambda x, t=None: 1.0e-6*x,
                inverse=lambda x, t=None: 1000000.0*x),
            ConversionTableEntry(
                unit='GΩ', time_dependent=False,
                calc=lambda x, t=None: 1.0e-9*x,
                inverse=lambda x, t=None: 1000000000.0*x),
            ConversionTableEntry(
                unit='TΩ', time_dependent=False,
                calc=lambda x, t=None: 1.0e-12*x,
                inverse=lambda x, t=None: 1000000000000.0*x),
            ConversionTableEntry(
                unit='PΩ', time_dependent=False,
                calc=lambda x, t=None: 1.0e-15*x,
                inverse=lambda x, t=None: 1.0e+15*x),
            ConversionTableEntry(
                unit='EΩ', time_dependent=False,
                calc=lambda x, t=None: 1.0e-18*x,
                inverse=lambda x, t=None: 1.0e+18*x),
            ConversionTableEntry(
                unit='ZΩ', time_dependent=False,
                calc=lambda x, t=None: 1.0e-21*x,
                inverse=lambda x, t=None: 1.0e+21*x),
            ConversionTableEntry(
                unit='YΩ', time_dependent=False,
                calc=lambda x, t=None: 1.0e-24*x,
                inverse=lambda x, t=None: 1.0e+24*x),
        ]
    }

    @classmethod
    def set_currency(cls, currency):
        Units.table['$'].rate_unit = f'{currency}/s'
        Units.table['$'].cumul_unit = f'{currency}'
